/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.BiologicalProductInput;
import fr.inra.agrosyst.api.entities.action.PesticideProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import java.util.Arrays;
import java.util.regex.Pattern;

public abstract class Indicator {
    protected static final Double[] NOT_APPLICABLE = new Double[0];
    protected static final String[] MONTHS = new String[]{"Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre"};
    protected static final Pattern PRACTICED_DATE_PATTERN = Pattern.compile("(\\d\\d?)/(\\d\\d?)");

    public abstract String getIndicatorCategory();

    public abstract String getIndicatorLabel(int var1);

    public abstract void computePracticed(IndicatorWriter var1, GrowingSystem var2);

    public abstract void computePracticed(IndicatorWriter var1, Domain var2);

    public abstract void resetPracticed(Domain var1);

    public abstract void computeEffective(IndicatorWriter var1, Domain var2, GrowingSystem var3, Plot var4, Zone var5);

    public abstract void computeEffective(IndicatorWriter var1, Domain var2, GrowingSystem var3, Plot var4);

    public abstract void resetEffective(Domain var1, GrowingSystem var2, Plot var3);

    public abstract void computeEffective(IndicatorWriter var1, Domain var2, GrowingSystem var3);

    public abstract void resetEffective(Domain var1, GrowingSystem var2);

    public abstract void computeEffective(IndicatorWriter var1, Domain var2);

    public abstract void resetEffective(Domain var1);

    protected double getToolPSCi(PracticedIntervention intervention) {
        double result = intervention.getTemporalFrequency() * intervention.getSpatialFrequency();
        return result;
    }

    protected double getInputPSCi(PracticedIntervention intervention, PhytoProductInput input) {
        double result = this.getToolPSCi(intervention);
        if (input instanceof PesticideProductInput) {
            PesticideProductInput pesticideProductInput = (PesticideProductInput)input;
            result *= pesticideProductInput.getPesticidesSpreadingAction().getProportionOfTreatedSurface() / 100.0;
        } else if (input instanceof BiologicalProductInput) {
            BiologicalProductInput biologicalProductInput = (BiologicalProductInput)input;
            result *= biologicalProductInput.getBiologicalControlAction().getProportionOfTreatedSurface() / 100.0;
        }
        return result;
    }

    protected double getToolPSCi(EffectiveIntervention intervention) {
        double result = (double)intervention.getTransitCount() * intervention.getSpatialFrequency();
        return result;
    }

    protected double getInputPSCi(EffectiveIntervention intervention, PhytoProductInput input) {
        double result = this.getToolPSCi(intervention);
        if (input instanceof PesticideProductInput) {
            PesticideProductInput pesticideProductInput = (PesticideProductInput)input;
            result *= pesticideProductInput.getPesticidesSpreadingAction().getProportionOfTreatedSurface() / 100.0;
        } else if (input instanceof BiologicalProductInput) {
            BiologicalProductInput biologicalProductInput = (BiologicalProductInput)input;
            result *= biologicalProductInput.getBiologicalControlAction().getProportionOfTreatedSurface() / 100.0;
        }
        return result;
    }

    protected Double[] newArray(int length, double defaultValue) {
        Object[] array = new Double[length];
        Arrays.fill(array, (Object)defaultValue);
        return array;
    }

    protected Double[] sum(Double[] arr1, Double[] arr2) {
        Double[] arr3 = new Double[arr1.length];
        for (int i = 0; i < Math.min(arr1.length, arr2.length); ++i) {
            arr3[i] = arr1[i] + arr2[i];
        }
        return arr3;
    }

    protected Double[] mults(Double[] arr1, double s) {
        Double[] array = new Double[arr1.length];
        for (int i = 0; i < arr1.length; ++i) {
            array[i] = arr1[i] * s;
        }
        return array;
    }

    protected Double[] divs(Double[] arr1, double s) {
        Double[] array = new Double[arr1.length];
        for (int i = 0; i < arr1.length; ++i) {
            array[i] = arr1[i] / s;
        }
        return array;
    }

    protected Double[] newResult(Double ... val) {
        return val;
    }
}

