/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.AbstractInputTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import fr.inra.agrosyst.services.performance.indicators.Indicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractIndicator
extends Indicator {
    private static final Log log = LogFactory.getLog(AbstractIndicator.class);
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected ToolsCouplingTopiaDao toolsCouplingDAO;
    protected AbstractActionTopiaDao abstractActionTopiaDao;
    protected AbstractInputTopiaDao abstractInputTopiaDao;
    protected PracticedSystemTopiaDao practicedSystemDao;
    protected PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleDao;
    protected PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleDao;
    protected PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionDao;
    protected PracticedInterventionTopiaDao practicedInterventionDAO;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao;
    protected EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao;
    protected EffectiveInterventionTopiaDao effectiveInterventionTopiaDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionTopiaDao;
    protected EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeTopiaDao;
    protected MultiKeyMap<Object, Double[]> practicedSystemValues = new MultiKeyMap();
    protected MultiKeyMap<Object, Double[]> practicedSystemCycleValues = new MultiKeyMap();
    protected MultiKeyMap<Object, Double[]> effectiveCroppingValues = new MultiKeyMap();
    protected Map<Zone, Double[]> effectiveZoneValues = Maps.newHashMap();
    protected Map<Plot, Double[]> effectivePlotValues = Maps.newHashMap();
    protected Map<GrowingSystem, Double[]> effectiveGrowingSystemValues = Maps.newHashMap();

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setToolsCouplingDAO(ToolsCouplingTopiaDao toolsCouplingDAO) {
        this.toolsCouplingDAO = toolsCouplingDAO;
    }

    public void setAbstractActionTopiaDao(AbstractActionTopiaDao abstractActionTopiaDao) {
        this.abstractActionTopiaDao = abstractActionTopiaDao;
    }

    public void setAbstractInputTopiaDao(AbstractInputTopiaDao abstractInputTopiaDao) {
        this.abstractInputTopiaDao = abstractInputTopiaDao;
    }

    public void setPracticedSystemDao(PracticedSystemTopiaDao practicedSystemDao) {
        this.practicedSystemDao = practicedSystemDao;
    }

    public void setPracticedSeasonalCropCycleDao(PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleDao) {
        this.practicedSeasonalCropCycleDao = practicedSeasonalCropCycleDao;
    }

    public void setPracticedPerennialCropCycleDao(PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleDao) {
        this.practicedPerennialCropCycleDao = practicedPerennialCropCycleDao;
    }

    public void setPracticedCropCycleConnectionDao(PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionDao) {
        this.practicedCropCycleConnectionDao = practicedCropCycleConnectionDao;
    }

    public void setPracticedInterventionDAO(PracticedInterventionTopiaDao practicedInterventionDAO) {
        this.practicedInterventionDAO = practicedInterventionDAO;
    }

    public void setEffectivePerennialCropCycleTopiaDao(EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao) {
        this.effectivePerennialCropCycleTopiaDao = effectivePerennialCropCycleTopiaDao;
    }

    public void setEffectiveInterventionTopiaDao(EffectiveInterventionTopiaDao effectiveInterventionTopiaDao) {
        this.effectiveInterventionTopiaDao = effectiveInterventionTopiaDao;
    }

    public void setEffectiveCropCycleConnectionTopiaDao(EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionTopiaDao) {
        this.effectiveCropCycleConnectionTopiaDao = effectiveCropCycleConnectionTopiaDao;
    }

    public EffectiveCropCycleConnectionTopiaDao getEffectiveCropCycleConnectionTopiaDao() {
        return this.effectiveCropCycleConnectionTopiaDao;
    }

    public void setEffectiveSeasonalCropCycleTopiaDao(EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao) {
        this.effectiveSeasonalCropCycleTopiaDao = effectiveSeasonalCropCycleTopiaDao;
    }

    public void setEffectiveCropCycleNodeTopiaDao(EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeTopiaDao) {
        this.effectiveCropCycleNodeTopiaDao = effectiveCropCycleNodeTopiaDao;
    }

    @Override
    public void computePracticed(IndicatorWriter writer, GrowingSystem growingSystem) {
        MultiKeyMap practicedCroppingValues = new MultiKeyMap();
        List practicedSystems = this.practicedSystemDao.forGrowingSystemEquals(growingSystem).findAll();
        for (PracticedSystem practicedSystem : practicedSystems) {
            List interventions;
            String campaigns = practicedSystem.getCampaigns();
            List practicedSeasonalCropCycles = this.practicedSeasonalCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
            for (PracticedSeasonalCropCycle cycle : practicedSeasonalCropCycles) {
                HashMap cycleValues = Maps.newHashMap();
                Collection nodes = cycle.getCropCycleNodes();
                if (CollectionUtils.isEmpty((Collection)nodes)) continue;
                List cropCycleConnections = this.practicedCropCycleConnectionDao.forTargetIn(nodes).findAll();
                interventions = this.practicedInterventionDAO.forPracticedCropCycleConnectionIn(cropCycleConnections).findAll();
                Map<PracticedCropCycleConnection, Double> cumulativeFrequencies = this.computeCumulativeFrequencies(cropCycleConnections);
                for (PracticedIntervention intervention : interventions) {
                    String previousPlanEntryCode;
                    PracticedCropCycleConnection connection = intervention.getPracticedCropCycleConnection();
                    String croppingPlanEntryCode = intervention.isIntermediateCrop() && !Strings.isNullOrEmpty((String)connection.getIntermediateCroppingPlanEntryCode()) ? connection.getIntermediateCroppingPlanEntryCode() : connection.getTarget().getCroppingPlanEntryCode();
                    Double[] interValues = this.manageIntervention(intervention, growingSystem, campaigns, croppingPlanEntryCode, previousPlanEntryCode = connection.getSource().getCroppingPlanEntryCode(), null);
                    if (interValues == null) continue;
                    CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
                    CroppingPlanEntry previousPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(previousPlanEntryCode).findAny();
                    List actions = this.abstractActionTopiaDao.forPracticedInterventionEquals(intervention).findAll();
                    List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByPracticedIntervention(intervention);
                    for (int i = 0; i < interValues.length; ++i) {
                        writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), campaigns, growingSystem.getGrowingPlan().getDomain(), growingSystem, practicedSystem, croppingPlanEntry, previousPlanEntry, intervention, (Collection<AbstractAction>)actions, inputs, interValues[i]);
                    }
                    Double[] previous = (Double[])practicedCroppingValues.get((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)previousPlanEntryCode);
                    if (previous == null) {
                        practicedCroppingValues.put((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)previousPlanEntryCode, (Object)interValues);
                    } else {
                        Double[] sum = this.sum(previous, interValues);
                        practicedCroppingValues.put((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)previousPlanEntryCode, (Object)sum);
                    }
                    Double[] previousValue = (Double[])cycleValues.get(connection);
                    if (previousValue == null) {
                        cycleValues.put(connection, interValues);
                        continue;
                    }
                    Double[] sum = this.sum(previousValue, interValues);
                    cycleValues.put(connection, sum);
                }
                int campaignCount = this.getCampaignsCount(cropCycleConnections);
                Double[] result = null;
                for (Map.Entry entry : cycleValues.entrySet()) {
                    Double[] values = (Double[])entry.getValue();
                    values = this.mults(values, cumulativeFrequencies.get(entry.getKey()));
                    result = result == null ? values : this.sum(result, values);
                }
                if (result == null || campaignCount <= 0) continue;
                result = this.divs(result, campaignCount);
                Double[] pspreviousValue = (Double[])this.practicedSystemValues.get((Object)campaigns, (Object)growingSystem, (Object)practicedSystem);
                if (pspreviousValue == null) {
                    this.practicedSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)practicedSystem, (Object)result);
                    continue;
                }
                Double[] sum = this.sum(pspreviousValue, result);
                this.practicedSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)practicedSystem, (Object)sum);
            }
            List practicedPerennialCropCycles = this.practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
            if (practicedPerennialCropCycles.isEmpty()) continue;
            Double totalSolOccupationPercent = 0.0;
            for (PracticedPerennialCropCycle cycle : practicedPerennialCropCycles) {
                totalSolOccupationPercent = totalSolOccupationPercent + cycle.getSolOccupationPercent();
            }
            totalSolOccupationPercent = totalSolOccupationPercent > 0.0 ? totalSolOccupationPercent : null;
            for (PracticedPerennialCropCycle cycle : practicedPerennialCropCycles) {
                Collection phases = cycle.getCropCyclePhases();
                interventions = this.practicedInterventionDAO.forPracticedCropCyclePhaseIn(phases).findAll();
                for (PracticedIntervention intervention : interventions) {
                    PracticedCropCyclePhase phase;
                    String croppingPlanEntryCode;
                    Double[] interValues = this.manageIntervention(intervention, growingSystem, campaigns, croppingPlanEntryCode = cycle.getCroppingPlanEntryCode(), null, phase = intervention.getPracticedCropCyclePhase());
                    if (interValues == null) continue;
                    CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
                    List actions = this.abstractActionTopiaDao.forPracticedInterventionEquals(intervention).findAll();
                    List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByPracticedIntervention(intervention);
                    for (int i = 0; i < interValues.length; ++i) {
                        writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), campaigns, growingSystem.getGrowingPlan().getDomain(), growingSystem, practicedSystem, croppingPlanEntry, phase, intervention, (Collection<AbstractAction>)actions, inputs, interValues[i]);
                    }
                    Double[] previous = (Double[])practicedCroppingValues.get((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)phase);
                    if (previous == null) {
                        practicedCroppingValues.put((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)phase, (Object)interValues);
                    } else {
                        Double[] sum = this.sum(previous, interValues);
                        practicedCroppingValues.put((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)phase, (Object)sum);
                    }
                    Double[] pspreviousValue = (Double[])this.practicedSystemCycleValues.get((Object)practicedSystem, (Object)cycle);
                    if (pspreviousValue == null) {
                        this.practicedSystemCycleValues.put((Object)practicedSystem, (Object)cycle, (Object)interValues);
                        continue;
                    }
                    Double[] sum = this.sum(pspreviousValue, interValues);
                    this.practicedSystemCycleValues.put((Object)practicedSystem, (Object)cycle, (Object)sum);
                }
            }
            for (Map.Entry entry : this.practicedSystemCycleValues.entrySet()) {
                PracticedSystem ps = (PracticedSystem)((MultiKey)entry.getKey()).getKey(0);
                PracticedPerennialCropCycle cycle = (PracticedPerennialCropCycle)((MultiKey)entry.getKey()).getKey(1);
                Double[] psValues = (Double[])this.practicedSystemCycleValues.get((Object)ps, (Object)cycle);
                Double[] psPartValues = this.addPerennialCropPart(cycle.getSolOccupationPercent(), totalSolOccupationPercent, psValues);
                Double[] pspreviousValue = (Double[])this.practicedSystemValues.get((Object)campaigns, (Object)growingSystem, (Object)practicedSystem);
                if (pspreviousValue == null) {
                    this.practicedSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)practicedSystem, (Object)psPartValues);
                    continue;
                }
                Double[] sum = this.sum(pspreviousValue, psPartValues);
                this.practicedSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)practicedSystem, (Object)sum);
            }
        }
        for (Map.Entry entry : practicedCroppingValues.entrySet()) {
            PracticedSystem practicedSystem = (PracticedSystem)((MultiKey)entry.getKey()).getKey(0);
            String croppingPlanEntryCode = (String)((MultiKey)entry.getKey()).getKey(1);
            Object previousPlanEntryCodeOrPhase = ((MultiKey)entry.getKey()).getKey(2);
            Double[] values = (Double[])entry.getValue();
            CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
            if (previousPlanEntryCodeOrPhase instanceof String) {
                CroppingPlanEntry previousPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals((String)previousPlanEntryCodeOrPhase).findAny();
                for (int i = 0; i < values.length; ++i) {
                    writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), practicedSystem.getCampaigns(), growingSystem.getGrowingPlan().getDomain(), growingSystem, practicedSystem, croppingPlanEntry, previousPlanEntry, values[i]);
                }
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), practicedSystem.getCampaigns(), growingSystem.getGrowingPlan().getDomain(), growingSystem, practicedSystem, croppingPlanEntry, (PracticedCropCyclePhase)previousPlanEntryCodeOrPhase, values[i]);
            }
        }
    }

    public Double[] addPerennialCropPart(Double solOccupationPercent, Double totalSolOccupationPercent, Double[] result) {
        double sumPart;
        Double[] r = new Double[result.length];
        double part = solOccupationPercent == null ? 1.0 : solOccupationPercent / 100.0;
        double d = sumPart = totalSolOccupationPercent == null ? 1.0 : totalSolOccupationPercent / 100.0;
        if (sumPart == 0.0) {
            sumPart = 1.0;
            part = 1.0;
        }
        for (int i = 0; i < r.length; ++i) {
            Double aDouble = r[i];
            r[i] = result[i] * part / sumPart;
        }
        return r;
    }

    protected Map<PracticedCropCycleConnection, Double> computeCumulativeFrequencies(List<PracticedCropCycleConnection> cropCycleConnections) {
        ArrayList localConnections = Lists.newArrayList(cropCycleConnections);
        MultiValueMap precedenceMap = new MultiValueMap();
        for (PracticedCropCycleConnection conn : localConnections) {
            precedenceMap.put((Object)conn.getTarget(), (Object)conn);
        }
        HashMap result = Maps.newHashMap();
        for (PracticedCropCycleConnection conn : localConnections) {
            double frequency = this.getCumulativeFrequencies((MultiValueMap<PracticedCropCycleNode, PracticedCropCycleConnection>)precedenceMap, conn);
            result.put(conn, frequency);
        }
        return result;
    }

    protected double getCumulativeFrequencies(MultiValueMap<PracticedCropCycleNode, PracticedCropCycleConnection> precedenceMap, PracticedCropCycleConnection conn) {
        double result;
        Collection precedences = precedenceMap.getCollection((Object)conn.getSource());
        if (CollectionUtils.isEmpty((Collection)precedences)) {
            result = 1.0;
        } else {
            result = 0.0;
            for (PracticedCropCycleConnection precedence : precedences) {
                if (precedence.getSource().isEndCycle() && precedence.getSource().getRank() > precedence.getTarget().getRank()) {
                    result = precedence.getTarget().getInitNodeFrequency() != null ? precedence.getTarget().getInitNodeFrequency() / 100.0 : 0.0;
                    continue;
                }
                if (precedence.getSource().getRank() >= precedence.getTarget().getRank()) continue;
                result += this.getCumulativeFrequencies(precedenceMap, precedence);
            }
        }
        if (conn.getSource().getRank() < conn.getTarget().getRank()) {
            result *= conn.getCroppingPlanEntryFrequency() / 100.0;
        } else {
            double initialFreq = conn.getTarget().getInitNodeFrequency() != null ? conn.getTarget().getInitNodeFrequency() / 100.0 : 1.0;
            result *= initialFreq;
        }
        return result;
    }

    protected int getCampaignsCount(List<PracticedCropCycleConnection> cropCycleConnections) {
        HashSet foundRanks = Sets.newHashSet();
        HashSet sameCampaignRanks = Sets.newHashSet();
        for (PracticedCropCycleConnection cropCycleConnection : cropCycleConnections) {
            PracticedCropCycleNode sourceNode = cropCycleConnection.getSource();
            PracticedCropCycleNode targetNode = cropCycleConnection.getTarget();
            foundRanks.add(sourceNode.getRank());
            foundRanks.add(targetNode.getRank());
            if (!targetNode.isSameCampaignAsPreviousNode()) continue;
            sameCampaignRanks.add(targetNode.getRank());
        }
        foundRanks.removeAll(sameCampaignRanks);
        return foundRanks.size();
    }

    @Override
    public void computePracticed(IndicatorWriter writer, Domain domain) {
        String campaigns;
        LinkedHashMap weightedValueSum = Maps.newLinkedHashMap();
        LinkedHashMap weightSum = Maps.newLinkedHashMap();
        for (Map.Entry entry : this.practicedSystemValues.entrySet()) {
            int n;
            Double[] doubleArray;
            int i;
            campaigns = (String)((MultiKey)entry.getKey()).getKey(0);
            GrowingSystem growingSystem = (GrowingSystem)((MultiKey)entry.getKey()).getKey(1);
            PracticedSystem practicedSystem = (PracticedSystem)((MultiKey)entry.getKey()).getKey(2);
            Double[] values = (Double[])entry.getValue();
            for (i = 0; i < values.length; ++i) {
                writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), campaigns, domain, growingSystem, practicedSystem, values[i]);
            }
            if (domain.getUsedAgriculturalArea() == null || growingSystem.getAffectedAreaRate() == null) continue;
            if (!weightedValueSum.containsKey(campaigns)) {
                weightedValueSum.put(campaigns, this.newArray(values.length, 0.0));
            }
            for (i = 0; i < values.length; ++i) {
                doubleArray = (Double[])weightedValueSum.get(campaigns);
                n = i;
                Double.valueOf(doubleArray[n] + values[i] * domain.getUsedAgriculturalArea() * growingSystem.getAffectedAreaRate());
            }
            if (!weightSum.containsKey(campaigns)) {
                weightSum.put(campaigns, this.newArray(values.length, 0.0));
            }
            i = 0;
            while (i < values.length) {
                doubleArray = (Double[])weightSum.get(campaigns);
                n = i++;
                Double.valueOf(doubleArray[n] + domain.getUsedAgriculturalArea() * growingSystem.getAffectedAreaRate());
            }
        }
        for (Map.Entry entry : weightedValueSum.entrySet()) {
            campaigns = (String)entry.getKey();
            Double[] values = (Double[])entry.getValue();
            Double[] weightValues = (Double[])weightSum.get(campaigns);
            for (int i = 0; i < values.length; ++i) {
                if (weightValues[i] != 0.0) {
                    double weightedAverage = values[i] / weightValues[i];
                    writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), campaigns, domain, weightedAverage);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Can't compute growing system scale with 0 weigth");
            }
        }
    }

    @Override
    public void resetPracticed(Domain domain) {
        this.practicedSystemCycleValues.clear();
        this.practicedSystemValues.clear();
    }

    public abstract Double[] manageIntervention(PracticedIntervention var1, GrowingSystem var2, String var3, String var4, String var5, PracticedCropCyclePhase var6);

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone) {
        List perennialCycles = this.effectivePerennialCropCycleTopiaDao.forZoneEquals(zone).findAll();
        for (EffectivePerennialCropCycle perennialCycle : perennialCycles) {
            EffectiveCropCyclePhase phase = perennialCycle.getPhase();
            List interventions = this.effectiveInterventionTopiaDao.forEffectiveCropCyclePhaseEquals(phase).findAll();
            for (EffectiveIntervention intervention : interventions) {
                Double[] interValues = this.manageIntervention(intervention, zone, perennialCycle.getCroppingPlanEntry(), null, phase);
                if (interValues == null) continue;
                List actions = this.abstractActionTopiaDao.forEffectiveInterventionEquals(intervention).findAll();
                List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByEffectiveIntervention(intervention);
                for (int i = 0; i < interValues.length; ++i) {
                    writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, zone.getPlot().getGrowingSystem(), zone.getPlot(), zone, perennialCycle.getCroppingPlanEntry(), phase, intervention, (Collection<AbstractAction>)actions, inputs, interValues[i]);
                }
                Double[] previous = (Double[])this.effectiveCroppingValues.get((Object)perennialCycle.getCroppingPlanEntry(), (Object)phase);
                if (previous == null) {
                    this.effectiveCroppingValues.put((Object)perennialCycle.getCroppingPlanEntry(), (Object)phase, (Object)interValues);
                } else {
                    Double[] sum = this.sum(previous, interValues);
                    this.effectiveCroppingValues.put((Object)perennialCycle.getCroppingPlanEntry(), (Object)phase, (Object)sum);
                }
                Double[] previousValue = this.effectiveZoneValues.get(zone);
                if (previousValue == null) {
                    this.effectiveZoneValues.put(zone, interValues);
                    continue;
                }
                Double[] sum = this.sum(previousValue, interValues);
                this.effectiveZoneValues.put(zone, sum);
            }
        }
        List seasonalCycles = this.effectiveSeasonalCropCycleTopiaDao.forZoneEquals(zone).findAll();
        for (EffectiveSeasonalCropCycle seasonalCycle : seasonalCycles) {
            Collection nodes = seasonalCycle.getNodes();
            if (CollectionUtils.isEmpty((Collection)nodes)) continue;
            for (EffectiveCropCycleNode node : nodes) {
                EffectiveCropCycleConnection connection = (EffectiveCropCycleConnection)this.effectiveCropCycleConnectionTopiaDao.forTargetEquals(node).findUniqueOrNull();
                List interventions = this.effectiveInterventionTopiaDao.forEffectiveCropCycleNodeEquals(node).findAll();
                for (EffectiveIntervention intervention : interventions) {
                    EffectiveCropCycleNode lastNode;
                    CroppingPlanEntry croppingPlanEntry;
                    if (connection == null) {
                        croppingPlanEntry = node.getCroppingPlanEntry();
                        this.computeEffectiveInterventionSheet(writer, domain, zone, node, intervention, croppingPlanEntry, null);
                        continue;
                    }
                    croppingPlanEntry = intervention.isIntermediateCrop() && connection.getIntermediateCroppingPlanEntry() != null ? connection.getIntermediateCroppingPlanEntry() : node.getCroppingPlanEntry();
                    Object previousPlanEntry = connection.getSource() == null ? ((lastNode = this.effectiveCropCycleNodeTopiaDao.findLastNodeForPreviousCampaign(zone)) == null ? null : lastNode.getCroppingPlanEntry()) : connection.getSource().getCroppingPlanEntry();
                    if (previousPlanEntry == null && log.isWarnEnabled()) {
                        log.warn((Object)"Can't get previous cropping plan entry");
                    }
                    this.computeEffectiveInterventionSheet(writer, domain, zone, node, intervention, croppingPlanEntry, (CroppingPlanEntry)previousPlanEntry);
                }
            }
        }
        Double[] values = this.effectiveZoneValues.get(zone);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), zone.getPlot().getDomain().getCampaign(), zone.getPlot().getDomain(), growingSystem, zone.getPlot(), zone, values[i]);
            }
        }
    }

    protected void computeEffectiveInterventionSheet(IndicatorWriter writer, Domain domain, Zone zone, EffectiveCropCycleNode node, EffectiveIntervention intervention, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry) {
        Double[] interValues = this.manageIntervention(intervention, zone, node.getCroppingPlanEntry(), previousPlanEntry, null);
        if (interValues != null) {
            List actions = this.abstractActionTopiaDao.forEffectiveInterventionEquals(intervention).findAll();
            List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByEffectiveIntervention(intervention);
            for (int i = 0; i < interValues.length; ++i) {
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, zone.getPlot().getGrowingSystem(), zone.getPlot(), zone, croppingPlanEntry, previousPlanEntry, intervention, (Collection<AbstractAction>)actions, inputs, interValues[i]);
            }
            Double[] previous = (Double[])this.effectiveCroppingValues.get((Object)croppingPlanEntry, (Object)previousPlanEntry);
            if (previous == null) {
                this.effectiveCroppingValues.put((Object)croppingPlanEntry, (Object)previousPlanEntry, (Object)interValues);
            } else {
                Double[] sum = this.sum(previous, interValues);
                this.effectiveCroppingValues.put((Object)croppingPlanEntry, (Object)previousPlanEntry, (Object)sum);
            }
            Double[] previousValue = this.effectiveZoneValues.get(zone);
            if (previousValue == null) {
                this.effectiveZoneValues.put(zone, interValues);
            } else {
                Double[] sum = this.sum(previousValue, interValues);
                this.effectiveZoneValues.put(zone, sum);
            }
        }
    }

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain, GrowingSystem growingSystem, Plot plot) {
        Double[] weightedValueSum = null;
        Double[] weightSum = null;
        for (Map.Entry<Zone, Double[]> entry : this.effectiveZoneValues.entrySet()) {
            Zone zone = entry.getKey();
            Double[] values = entry.getValue();
            if (weightedValueSum == null) {
                weightedValueSum = this.newArray(values.length, 0.0);
                weightSum = this.newArray(values.length, 0.0);
            }
            int i = 0;
            while (i < values.length) {
                Double[] doubleArray = weightedValueSum;
                int n = i;
                Double.valueOf(doubleArray[n] + values[i] * zone.getArea());
                doubleArray = weightSum;
                n = i++;
                Double.valueOf(doubleArray[n] + zone.getArea());
            }
        }
        if (weightSum != null) {
            this.effectivePlotValues.put(plot, this.newArray(weightedValueSum.length, 0.0));
            for (int i = 0; i < weightedValueSum.length; ++i) {
                double plotValue = weightedValueSum[i] / weightSum[i].doubleValue();
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), plot.getDomain().getCampaign(), plot.getDomain(), growingSystem, plot, plotValue);
                this.effectivePlotValues.get((Object)plot)[i] = plotValue;
            }
        }
    }

    @Override
    public void resetEffective(Domain domain, GrowingSystem growingSystem, Plot plot) {
        this.effectiveZoneValues.clear();
    }

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain, GrowingSystem growingSystem) {
        for (Map.Entry entry : this.effectiveCroppingValues.entrySet()) {
            Double[] values = (Double[])entry.getValue();
            CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)((MultiKey)entry.getKey()).getKey(0);
            Object previousPlanEntryOrPhase = ((MultiKey)entry.getKey()).getKey(1);
            if (previousPlanEntryOrPhase == null) continue;
            for (int i = 0; i < values.length; ++i) {
                if (previousPlanEntryOrPhase instanceof CroppingPlanEntry) {
                    writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, growingSystem, croppingPlanEntry, (CroppingPlanEntry)previousPlanEntryOrPhase, values[i]);
                    continue;
                }
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, growingSystem, croppingPlanEntry, (EffectiveCropCyclePhase)previousPlanEntryOrPhase, values[i]);
            }
        }
        Double[] weightedValueSum = null;
        Double[] weightSum = null;
        for (Map.Entry<Plot, Double[]> entry : this.effectivePlotValues.entrySet()) {
            Plot plot = entry.getKey();
            Double[] values = entry.getValue();
            if (weightedValueSum == null) {
                weightedValueSum = this.newArray(values.length, 0.0);
                weightSum = this.newArray(values.length, 0.0);
            }
            int i = 0;
            while (i < values.length) {
                Double[] doubleArray = weightedValueSum;
                int n = i;
                Double.valueOf(doubleArray[n] + values[i] * plot.getArea());
                doubleArray = weightSum;
                n = i++;
                Double.valueOf(doubleArray[n] + plot.getArea());
            }
        }
        if (weightSum != null) {
            this.effectiveGrowingSystemValues.put(growingSystem, this.newArray(weightedValueSum.length, 0.0));
            for (int i = 0; i < weightedValueSum.length; ++i) {
                double plotValue = weightedValueSum[i] / weightSum[i].doubleValue();
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, growingSystem, plotValue);
                this.effectiveGrowingSystemValues.get((Object)growingSystem)[i] = plotValue;
            }
        }
    }

    @Override
    public void resetEffective(Domain domain, GrowingSystem growingSystem) {
        this.effectiveCroppingValues.clear();
        this.effectivePlotValues.clear();
    }

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain) {
        Double[] weightedValueSum = null;
        Double[] weightSum = null;
        for (Map.Entry<GrowingSystem, Double[]> entry : this.effectiveGrowingSystemValues.entrySet()) {
            GrowingSystem growingSystem = entry.getKey();
            Double[] values = entry.getValue();
            if (growingSystem.getAffectedAreaRate() == null) continue;
            if (weightedValueSum == null) {
                weightedValueSum = this.newArray(values.length, 0.0);
                weightSum = this.newArray(values.length, 0.0);
            }
            int i = 0;
            while (i < values.length) {
                Double[] doubleArray = weightedValueSum;
                int n = i;
                Double.valueOf(doubleArray[n] + values[i] * growingSystem.getAffectedAreaRate());
                doubleArray = weightSum;
                n = i++;
                Double.valueOf(doubleArray[n] + growingSystem.getAffectedAreaRate());
            }
        }
        if (weightSum != null) {
            for (int i = 0; i < weightedValueSum.length; ++i) {
                if (weightSum[i].doubleValue() != 0.0) {
                    double domainValue = weightedValueSum[i].doubleValue() / weightSum[i].doubleValue();
                    writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, domainValue);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Can't compute growing system scale with 0 weigth");
            }
        }
    }

    @Override
    public void resetEffective(Domain domain) {
        this.effectiveGrowingSystemValues.clear();
    }

    public abstract Double[] manageIntervention(EffectiveIntervention var1, Zone var2, CroppingPlanEntry var3, CroppingPlanEntry var4, EffectiveCropCyclePhase var5);
}

