/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance;

import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.services.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceThread
extends Thread {
    private static final Log log = LogFactory.getLog(PerformanceThread.class);
    protected ServiceContext serviceContext;
    protected String performanceId;

    public PerformanceThread(ServiceContext serviceContext, String performanceId) {
        super("PerformanceThread-" + performanceId);
        this.serviceContext = serviceContext;
        this.performanceId = performanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting performance thread for performance " + this.performanceId));
        }
        try {
            PerformanceService performanceService = this.serviceContext.newService(PerformanceService.class);
            performanceService.generatePerformanceFile(this.performanceId);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't generate performance file", (Throwable)ex);
            }
        }
        finally {
            this.serviceContext.close();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Performance thread finished for " + this.performanceId));
        }
    }
}

