/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceFile;
import fr.inra.agrosyst.api.entities.performance.PerformanceFileTopiaDao;
import fr.inra.agrosyst.api.entities.performance.PerformanceState;
import fr.inra.agrosyst.api.entities.performance.PerformanceTopiaDao;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.PlotDto;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.performance.PerformanceDto;
import fr.inra.agrosyst.api.services.performance.PerformanceFilter;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.performance.HssfIndicatorWriter;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import fr.inra.agrosyst.services.performance.PerformanceThread;
import fr.inra.agrosyst.services.performance.indicators.Indicator;
import fr.inra.agrosyst.services.performance.indicators.IndicatorIFT;
import fr.inra.agrosyst.services.performance.indicators.IndicatorSurfaceUTH;
import fr.inra.agrosyst.services.performance.indicators.IndicatorTransitCount;
import fr.inra.agrosyst.services.performance.indicators.IndicatorWorkTime;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaEntity;

public class PerformanceServiceImpl
extends AbstractAgrosystService
implements PerformanceService {
    protected BusinessAuthorizationService authorizationService;
    protected AnonymizeService anonymizeService;
    protected DomainService domainService;
    protected PerformanceTopiaDao performanceDao;
    protected PerformanceFileTopiaDao performanceFileTopiaDao;
    protected GrowingSystemTopiaDao growingSystemDao;
    protected DomainTopiaDao domainDao;
    protected GrowingSystemTopiaDao growingSystemTopiaDao;
    protected PlotTopiaDao plotTopiaDao;
    protected ZoneTopiaDao zoneTopiaDao;
    protected AgrosystUserTopiaDao userDao;

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setPerformanceDao(PerformanceTopiaDao performanceDao) {
        this.performanceDao = performanceDao;
    }

    public void setPerformanceFileTopiaDao(PerformanceFileTopiaDao performanceFileTopiaDao) {
        this.performanceFileTopiaDao = performanceFileTopiaDao;
    }

    public void setGrowingSystemDao(GrowingSystemTopiaDao growingSystemDao) {
        this.growingSystemDao = growingSystemDao;
    }

    public void setDomainDao(DomainTopiaDao domainDao) {
        this.domainDao = domainDao;
    }

    public void setGrowingSystemTopiaDao(GrowingSystemTopiaDao growingSystemTopiaDao) {
        this.growingSystemTopiaDao = growingSystemTopiaDao;
    }

    public void setZoneTopiaDao(ZoneTopiaDao zoneTopiaDao) {
        this.zoneTopiaDao = zoneTopiaDao;
    }

    public void setPlotTopiaDao(PlotTopiaDao plotTopiaDao) {
        this.plotTopiaDao = plotTopiaDao;
    }

    public void setUserDao(AgrosystUserTopiaDao userDao) {
        this.userDao = userDao;
    }

    public ResultList<PerformanceDto> getFilteredPerformances(PerformanceFilter performanceFilter) {
        ResultList<Performance> performances = this.performanceDao.getFilteredPerformances(performanceFilter, this.getSecurityContext());
        ResultList result = ResultList.transform(performances, (Function)this.anonymizeService.getPerformanceToDtoFunction());
        return result;
    }

    public Performance getPerformance(String performanceTopiaId) {
        Performance result;
        if (StringUtils.isBlank((CharSequence)performanceTopiaId)) {
            result = (Performance)this.performanceDao.newInstance();
        } else {
            this.authorizationService.checkPerformanceReadable(performanceTopiaId);
            result = (Performance)this.performanceDao.forTopiaIdEquals(performanceTopiaId).findUnique();
        }
        return result;
    }

    public List<PlotDto> getPlots(List<String> domainIds) {
        List plots = this.plotTopiaDao.newQueryBuilder().addTopiaIdIn("domain", domainIds).setOrderByArguments(new String[]{"name"}).findAll();
        List result = Lists.transform((List)plots, (Function)this.anonymizeService.getPlotToDtoFunction());
        return result;
    }

    public List<ZoneDto> getZones(List<String> plotIds) {
        List zones = this.zoneTopiaDao.newQueryBuilder().addTopiaIdIn("plot", plotIds).setOrderByArguments(new String[]{"name"}).findAll();
        ArrayList result = Lists.newArrayList((Iterable)Iterables.transform((Iterable)zones, (Function)this.anonymizeService.getZoneToDtoFunction(false)));
        return result;
    }

    public Performance createOrUpdatePerformance(Performance performance, List<String> domainIds, List<String> growingSystemIds, List<String> plotIds, List<String> zoneIds) {
        return this.createOrUpdatePerformance(performance, domainIds, growingSystemIds, plotIds, zoneIds, true);
    }

    public Performance createOrUpdatePerformance(Performance performance, List<String> domainIds, List<String> growingSystemIds, List<String> plotIds, List<String> zoneIds, boolean runComputeThread) {
        this.authorizationService.checkCreateOrUpdatePerformance(performance.getTopiaId());
        List domains = CollectionUtils.isNotEmpty(domainIds) ? this.domainDao.forTopiaIdIn(domainIds).findAll() : null;
        performance.setDomains(domains);
        List growingSystems = CollectionUtils.isNotEmpty(growingSystemIds) ? this.growingSystemDao.forTopiaIdIn(growingSystemIds).findAll() : null;
        performance.setGrowingSystems(growingSystems);
        List plots = CollectionUtils.isNotEmpty(plotIds) ? this.plotTopiaDao.forTopiaIdIn(plotIds).findAll() : null;
        performance.setPlots(plots);
        List zones = CollectionUtils.isNotEmpty(zoneIds) ? this.zoneTopiaDao.forTopiaIdIn(zoneIds).findAll() : null;
        performance.setZones(zones);
        performance.setUpdateDate(this.context.getCurrentDate());
        performance.setComputeStatus(PerformanceState.GENERATING);
        if (performance.isPersisted()) {
            performance = (Performance)this.performanceDao.update((TopiaEntity)performance);
        } else {
            String userId = this.getSecurityContext().getUserId();
            AgrosystUser user = (AgrosystUser)this.userDao.forTopiaIdEquals(userId).findUnique();
            performance.setAuthor(user);
            performance = (Performance)this.performanceDao.create((TopiaEntity)performance);
        }
        this.getTransaction().commit();
        if (runComputeThread) {
            ServiceContext threadServiceContext = this.context.newServiceContext();
            PerformanceThread thread = new PerformanceThread(threadServiceContext, performance.getTopiaId());
            thread.start();
        }
        return performance;
    }

    public void generatePerformanceFile(String performanceId) {
        Performance performance = (Performance)this.performanceDao.forTopiaIdEquals(performanceId).findUnique();
        ByteArrayOutputStream writerStream = new ByteArrayOutputStream(4096);
        HssfIndicatorWriter writer = new HssfIndicatorWriter(performance, writerStream);
        writer.init();
        this.convertToWriter(performance, writer);
        try {
            writer.finish();
            writerStream.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(writerStream.toByteArray());
            PerformanceFile performanceFile = (PerformanceFile)this.performanceFileTopiaDao.forPerformanceEquals(performance).findUniqueOrNull();
            if (performanceFile == null) {
                performanceFile = (PerformanceFile)this.performanceFileTopiaDao.newInstance();
                performanceFile.setPerformance(performance);
            }
            Session hibernateSession = this.getPersistenceContext().getHibernateSupport().getHibernateSession();
            Blob blob = Hibernate.getLobCreator((Session)hibernateSession).createBlob((InputStream)inputStream, (long)((InputStream)inputStream).available());
            performanceFile.setContent(blob);
            if (performanceFile.isPersisted()) {
                this.performanceFileTopiaDao.update((TopiaEntity)performanceFile);
            } else {
                this.performanceFileTopiaDao.create((TopiaEntity)performanceFile);
            }
            performance.setComputeStatus(PerformanceState.SUCCESS);
            this.performanceDao.update((TopiaEntity)performance);
            this.getTransaction().commit();
        }
        catch (IOException ex) {
            performance.setComputeStatus(PerformanceState.FAILED);
            this.performanceDao.update((TopiaEntity)performance);
            this.getTransaction().commit();
            throw new AgrosystTechnicalException("Can't convert workbook to stream", (Throwable)ex);
        }
    }

    public InputStream downloadPerformances(String performanceId) {
        InputStream inputStream;
        Performance performance = (Performance)this.performanceDao.forTopiaIdEquals(performanceId).findUnique();
        PerformanceFile performanceFile = (PerformanceFile)this.performanceFileTopiaDao.forPerformanceEquals(performance).findUniqueOrNull();
        try {
            inputStream = performanceFile.getContent().getBinaryStream();
        }
        catch (SQLException ex) {
            throw new AgrosystTechnicalException("Can't get performance file stream", (Throwable)ex);
        }
        return inputStream;
    }

    protected void convertToWriter(Performance performance, IndicatorWriter writer) {
        ArrayList indicators = Lists.newArrayList();
        indicators.add(this.newInstance(IndicatorWorkTime.class));
        indicators.add(this.newInstance(IndicatorSurfaceUTH.class));
        indicators.add(this.newInstance(IndicatorTransitCount.class));
        indicators.add(this.newInstance(IndicatorIFT.class));
        this.convertToWriter(performance, writer, indicators.toArray(new Indicator[indicators.size()]));
    }

    public void convertToWriter(Performance performance, IndicatorWriter writer, Indicator ... indicators) {
        block22: {
            Collection domains;
            SecurityContext securityContext;
            block21: {
                securityContext = this.getSecurityContextAsUser(performance.getAuthor().getTopiaId());
                domains = performance.getDomains();
                domains = this.anonymizeService.checkForDomainsAnonymization(domains);
                if (!performance.isPracticed()) break block21;
                if (!CollectionUtils.isNotEmpty((Collection)domains)) break block22;
                GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
                growingSystemFilter.setActive(Boolean.valueOf(true));
                growingSystemFilter.setAllPageSize();
                for (Domain domain : performance.getDomains()) {
                    NavigationContext navigationContext = new NavigationContext();
                    navigationContext.setDomains(Collections.singleton(domain.getTopiaId()));
                    growingSystemFilter.setNavigationContext(navigationContext);
                    List growingSystems = this.growingSystemTopiaDao.getFilteredGrowingSystems(growingSystemFilter, securityContext).getElements();
                    Collection askedGrowingSystems = CollectionUtils.retainAll((Collection)growingSystems, (Collection)CollectionUtils.emptyIfNull((Collection)performance.getGrowingSystems()));
                    Collection computedGrowingSystems = CollectionUtils.isNotEmpty((Collection)askedGrowingSystems) ? askedGrowingSystems : growingSystems;
                    for (GrowingSystem growingSystem : computedGrowingSystems) {
                        GrowingSystem anonGrowingSystem = this.anonymizeService.checkForGrowingSystemAnonymization(growingSystem);
                        for (Indicator indicator : indicators) {
                            indicator.computePracticed(writer, anonGrowingSystem);
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)askedGrowingSystems)) {
                        for (Indicator indicator : indicators) {
                            indicator.computePracticed(writer, domain);
                        }
                    }
                    for (Indicator indicator : indicators) {
                        indicator.resetPracticed(domain);
                    }
                }
                break block22;
            }
            if (CollectionUtils.isNotEmpty((Collection)domains)) {
                GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
                growingSystemFilter.setActive(Boolean.valueOf(true));
                growingSystemFilter.setAllPageSize();
                for (Domain domain : domains) {
                    NavigationContext navigationContext = new NavigationContext();
                    navigationContext.setDomains(Collections.singleton(domain.getTopiaId()));
                    growingSystemFilter.setNavigationContext(navigationContext);
                    List growingSystems = this.growingSystemTopiaDao.getFilteredGrowingSystems(growingSystemFilter, securityContext).getElements();
                    Collection askedGrowingSystems = CollectionUtils.retainAll((Collection)growingSystems, (Collection)CollectionUtils.emptyIfNull((Collection)performance.getGrowingSystems()));
                    Collection computedGrowingSystems = CollectionUtils.isNotEmpty((Collection)askedGrowingSystems) ? askedGrowingSystems : growingSystems;
                    for (GrowingSystem growingSystem : computedGrowingSystems) {
                        GrowingSystem anonGrowingSystem = this.anonymizeService.checkForGrowingSystemAnonymization(growingSystem);
                        List plots = this.plotTopiaDao.forProperties("growingSystem", growingSystem, new Object[]{"active", true}).findAll();
                        Collection askedPlots = CollectionUtils.retainAll((Collection)plots, (Collection)CollectionUtils.emptyIfNull((Collection)performance.getPlots()));
                        Collection computedPlots = CollectionUtils.isNotEmpty((Collection)askedPlots) ? askedPlots : plots;
                        for (Plot plot : computedPlots) {
                            Plot anonPlot = this.anonymizeService.checkForPlotAnonymization(plot);
                            List zones = this.zoneTopiaDao.forProperties("plot", plot, new Object[]{"active", true}).findAll();
                            Collection askedZones = CollectionUtils.retainAll((Collection)zones, (Collection)CollectionUtils.emptyIfNull((Collection)performance.getZones()));
                            Collection computedZones = CollectionUtils.isNotEmpty((Collection)askedZones) ? askedZones : zones;
                            for (Zone zone : computedZones) {
                                Zone anonZone = this.anonymizeService.checkForZoneAnonymization(zone);
                                for (Indicator indicator : indicators) {
                                    indicator.computeEffective(writer, domain, anonGrowingSystem, anonPlot, anonZone);
                                }
                            }
                            if (CollectionUtils.isEmpty((Collection)askedZones)) {
                                for (Indicator indicator : indicators) {
                                    indicator.computeEffective(writer, domain, anonGrowingSystem, anonPlot);
                                }
                            }
                            for (Indicator indicator : indicators) {
                                indicator.resetEffective(domain, anonGrowingSystem, anonPlot);
                            }
                        }
                        if (CollectionUtils.isEmpty((Collection)askedPlots)) {
                            for (Indicator indicator : indicators) {
                                indicator.computeEffective(writer, domain, anonGrowingSystem);
                            }
                        }
                        for (Indicator indicator : indicators) {
                            indicator.resetEffective(domain, anonGrowingSystem);
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)askedGrowingSystems)) {
                        for (Indicator indicator : indicators) {
                            indicator.computeEffective(writer, domain);
                        }
                    }
                    for (Indicator indicator : indicators) {
                        indicator.resetEffective(domain);
                    }
                }
            }
        }
    }

    public void deletePerformance(List<String> performanceTopiaIds) {
        List performance = this.performanceDao.forTopiaIdIn(performanceTopiaIds).findAll();
        List performanceFiles = this.performanceFileTopiaDao.forPerformanceIn(performance).findAll();
        this.performanceFileTopiaDao.deleteAll(performanceFiles);
        this.performanceDao.deleteAll(performance);
        this.getTransaction().commit();
    }
}

