/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.OrganicProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;

public class HssfIndicatorWriter
implements IndicatorWriter {
    protected Performance performance;
    protected OutputStream output;
    protected HSSFWorkbook workbook;
    protected HSSFSheet domainSheet;
    protected HSSFSheet growingSystemSheet;
    protected HSSFSheet practicedSystemSheet;
    protected HSSFSheet plotSystemSheet;
    protected HSSFSheet zoneSystemSheet;
    protected HSSFSheet croppingPlanSheet;
    protected HSSFSheet interventionSheet;
    protected static final Map<AgrosystInterventionType, String> INTERVENTION_TYPE_I18N = Maps.newHashMap();
    protected static final Map<CropCyclePhaseType, String> CROP_CYCLE_PHASE_TYPE_I18N = Maps.newHashMap();

    public HssfIndicatorWriter(Performance performance, OutputStream output) {
        this.performance = performance;
        this.output = output;
        this.workbook = new HSSFWorkbook();
    }

    @Override
    public void init() {
        if (this.performance.isPracticed()) {
            this.initPracticed();
        } else {
            this.initEffective();
        }
    }

    protected void initEffective() {
        this.domainSheet = this.workbook.createSheet("Domaine_Exploitation");
        this.addHeaders(this.workbook, this.domainSheet, "Domaine_Exploitation", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
        this.growingSystemSheet = this.workbook.createSheet("Syst\u00e8mes de cultures");
        this.addHeaders(this.workbook, this.growingSystemSheet, "Domaine_Exploitation", "Syst\u00e8mes de culture", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
        this.croppingPlanSheet = this.workbook.createSheet("Culture & pr\u00e9c\u00e9dent-phase");
        this.addHeaders(this.workbook, this.croppingPlanSheet, "Domaine_Exploitation", "Syst\u00e8mes de culture", "Culture", "Pr\u00e9c\u00e9dent/Phase", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
        this.plotSystemSheet = this.workbook.createSheet("Parcelles");
        this.addHeaders(this.workbook, this.plotSystemSheet, "Domaine_Exploitation", "Syst\u00e8mes de culture", "Parcelle", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
        this.zoneSystemSheet = this.workbook.createSheet("Zones");
        this.addHeaders(this.workbook, this.zoneSystemSheet, "Domaine_Exploitation", "Syst\u00e8mes de culture", "Parcelle", "Zone", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
        this.interventionSheet = this.workbook.createSheet("Interventions");
        this.addHeaders(this.workbook, this.interventionSheet, "Domaine_Exploitation", "Syst\u00e8mes de culture", "Parcelle", "Zone", "Culture", "Pr\u00e9c\u00e9dent/Phase", "Type d'intervention", "Intervention", "Action(s)", "Intrant(s)", "Cible(s) de traitement", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
    }

    protected void initPracticed() {
        this.domainSheet = this.workbook.createSheet("Domaine_Exploitation");
        this.addHeaders(this.workbook, this.domainSheet, "Domaine_Exploitation", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
        this.practicedSystemSheet = this.workbook.createSheet("Syst\u00e8me synth\u00e9tis\u00e9");
        this.addHeaders(this.workbook, this.practicedSystemSheet, "Domaine_Exploitation", "Syst\u00e8mes de culture", "Syst\u00e8me synth\u00e9tis\u00e9", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
        this.croppingPlanSheet = this.workbook.createSheet("Culture & pr\u00e9c\u00e9dent-phase");
        this.addHeaders(this.workbook, this.croppingPlanSheet, "Domaine_Exploitation", "Syst\u00e8mes de culture", "Syst\u00e8me synth\u00e9tis\u00e9", "Culture", "Pr\u00e9c\u00e9dent/Phase", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
        this.interventionSheet = this.workbook.createSheet("Interventions");
        this.addHeaders(this.workbook, this.interventionSheet, "Domaine_Exploitation", "Syst\u00e8mes de culture", "Syst\u00e8me synth\u00e9tis\u00e9", "Culture", "Pr\u00e9c\u00e9dent/Phase", "Type d'intervention", "Intervention", "Action(s)", "Intrant(s)", "Cible(s) de traitement", "Ann\u00e9e(s)", "Approche de calcul", "Cat\u00e9gorie d'indicateur", "Indicateur", "Valeur", "Remarque");
    }

    protected void addHeaders(HSSFWorkbook workbook, HSSFSheet sheet, String ... headers) {
        HSSFRow row0 = sheet.createRow(0);
        HSSFCellStyle style = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setBoldweight((short)700);
        style.setFont((Font)font);
        int header = 0;
        for (String displayName : headers) {
            Cell cell0 = row0.createCell(header++);
            cell0.setCellValue(displayName);
            cell0.setCellStyle((CellStyle)style);
        }
    }

    @Override
    public void finish() {
        for (int s = 0; s < this.workbook.getNumberOfSheets(); ++s) {
            HSSFSheet sheet = this.workbook.getSheetAt(s);
            HSSFRow row = sheet.getRow(0);
            for (int column = 0; column < row.getPhysicalNumberOfCells(); ++column) {
                sheet.autoSizeColumn(column);
            }
        }
        try {
            this.workbook.write(this.output);
        }
        catch (IOException ex) {
            throw new AgrosystTechnicalException("Can't write to output stream", (Throwable)ex);
        }
    }

    @Override
    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, Double value) {
        this.writeToSheet(this.domainSheet, indicatorCategory, indicatorName, value, "", domain.getName(), campaigns);
    }

    @Override
    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, Double value) {
        this.writeToSheet(this.domainSheet, indicatorCategory, indicatorName, value, "", domain.getName(), String.valueOf(campaign));
    }

    @Override
    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, Double value) {
        this.writeToSheet(this.practicedSystemSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), practicedSystem.getName(), campaigns);
    }

    @Override
    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Double value) {
        this.writeToSheet(this.growingSystemSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), String.valueOf(campaign));
    }

    @Override
    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Double value) {
        this.writeToSheet(this.plotSystemSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), plot.getName(), String.valueOf(campaign));
    }

    @Override
    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone, Double value) {
        this.writeToSheet(this.zoneSystemSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), plot.getName(), zone.getName(), String.valueOf(campaign));
    }

    @Override
    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, Double value) {
        this.writeToSheet(this.croppingPlanSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), practicedSystem.getName(), croppingPlanEntry.getName(), previousPlanEntry != null ? previousPlanEntry.getName() : "", campaigns);
    }

    @Override
    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, CroppingPlanEntry croppingPlanEntry, PracticedCropCyclePhase phase, Double value) {
        this.writeToSheet(this.croppingPlanSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), practicedSystem.getName(), croppingPlanEntry.getName(), CROP_CYCLE_PHASE_TYPE_I18N.get(phase.getType()), campaigns);
    }

    @Override
    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, Double value) {
        this.writeToSheet(this.croppingPlanSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), croppingPlanEntry != null ? croppingPlanEntry.getName() : "", previousPlanEntry.getName(), String.valueOf(campaign));
    }

    @Override
    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, CroppingPlanEntry croppingPlanEntry, EffectiveCropCyclePhase phase, Double value) {
        this.writeToSheet(this.croppingPlanSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), croppingPlanEntry != null ? croppingPlanEntry.getName() : "", phase != null ? CROP_CYCLE_PHASE_TYPE_I18N.get(phase.getType()) : "", String.valueOf(campaign));
    }

    @Override
    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, PracticedIntervention intervention, Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value) {
        this.writeToSheet(this.interventionSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), practicedSystem.getName(), croppingPlanEntry.getName(), previousPlanEntry.getName(), INTERVENTION_TYPE_I18N.get(intervention.getType()), intervention.getName(), this.getActionsToString(actions), this.getInputsToString(inputs), this.getTargetsToString(inputs), campaigns);
    }

    @Override
    public void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, CroppingPlanEntry croppingPlanEntry, PracticedCropCyclePhase phase, PracticedIntervention intervention, Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value) {
        this.writeToSheet(this.interventionSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), practicedSystem.getName(), croppingPlanEntry.getName(), CROP_CYCLE_PHASE_TYPE_I18N.get(phase.getType()), INTERVENTION_TYPE_I18N.get(intervention.getType()), intervention.getName(), this.getActionsToString(actions), this.getInputsToString(inputs), this.getTargetsToString(inputs), campaigns);
    }

    @Override
    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveIntervention intervention, Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value) {
        this.writeToSheet(this.interventionSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), plot.getName(), zone.getName(), croppingPlanEntry != null ? croppingPlanEntry.getName() : "", previousPlanEntry != null ? previousPlanEntry.getName() : "", INTERVENTION_TYPE_I18N.get(intervention.getType()), intervention.getName(), this.getActionsToString(actions), this.getInputsToString(inputs), this.getTargetsToString(inputs), String.valueOf(campaign));
    }

    @Override
    public void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone, CroppingPlanEntry croppingPlanEntry, EffectiveCropCyclePhase phase, EffectiveIntervention intervention, Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value) {
        this.writeToSheet(this.interventionSheet, indicatorCategory, indicatorName, value, "", domain.getName(), growingSystem.getName(), plot.getName(), zone.getName(), croppingPlanEntry != null ? croppingPlanEntry.getName() : "", phase != null ? CROP_CYCLE_PHASE_TYPE_I18N.get(phase.getType()) : "", INTERVENTION_TYPE_I18N.get(intervention.getType()), intervention.getName(), this.getActionsToString(actions), this.getInputsToString(inputs), this.getTargetsToString(inputs), String.valueOf(campaign));
    }

    protected void writeToSheet(HSSFSheet sheet, String indicatorCategory, String indicatorName, double value, String remarque, String ... columns) {
        Cell cell0;
        int line = sheet.getPhysicalNumberOfRows();
        HSSFRow row = sheet.createRow(line);
        int column = 0;
        for (String dynColumn : columns) {
            Cell cellx = row.createCell(column++);
            cellx.setCellValue(dynColumn);
        }
        if (this.performance.isPracticed()) {
            cell0 = row.createCell(column++);
            cell0.setCellValue("Synth\u00e9tis\u00e9");
        } else {
            cell0 = row.createCell(column++);
            cell0.setCellValue("R\u00e9alis\u00e9");
        }
        Cell cell1 = row.createCell(column++);
        cell1.setCellValue(indicatorCategory);
        Cell cell2 = row.createCell(column++);
        cell2.setCellValue(indicatorName);
        Cell cellLast = row.createCell(column++);
        cellLast.setCellValue(value);
        Cell remCell = row.createCell(column);
        remCell.setCellValue(remarque);
    }

    protected String getActionsToString(Collection<AbstractAction> actions) {
        String result = actions != null ? Joiner.on((String)", ").join(Iterables.transform(actions, (Function)new Function<AbstractAction, String>(){

            public String apply(AbstractAction input) {
                return INTERVENTION_TYPE_I18N.get(input.getMainAction().getIntervention_agrosyst());
            }
        })) : "";
        return result;
    }

    protected String getInputsToString(Collection<AbstractInput> inputs) {
        String result = inputs != null ? Joiner.on((String)", ").join(Iterables.transform(inputs, (Function)new Function<AbstractInput, String>(){

            public String apply(AbstractInput input) {
                return HssfIndicatorWriter.this.getInputProductName(input);
            }
        })) : "";
        return result;
    }

    protected String getInputProductName(AbstractInput input) {
        String result = input.getProductName();
        if (Strings.isNullOrEmpty((String)result)) {
            switch (input.getInputType()) {
                case SEMIS: 
                case LUTTE_BIOLOGIQUE: 
                case APPLICATION_DE_PRODUITS_PHYTOSANITAIRES: {
                    PhytoProductInput phytoProductInput = (PhytoProductInput)input;
                    if (phytoProductInput.getPhytoProduct() == null) break;
                    result = phytoProductInput.getPhytoProduct().getNom_produit();
                    break;
                }
                case EPANDAGES_ORGANIQUES: {
                    OrganicProductInput organicProductInput = (OrganicProductInput)input;
                    result = "N:" + organicProductInput.getN() + ",P2O5:" + organicProductInput.getP2O5() + ",K2O:" + organicProductInput.getK2O();
                    break;
                }
            }
        }
        if (Strings.isNullOrEmpty((String)result)) {
            result = "N/A";
        }
        return result;
    }

    protected String getTargetsToString(Collection<AbstractInput> inputs) {
        HashSet aggregates = Sets.newHashSet();
        if (inputs != null) {
            for (AbstractInput input : inputs) {
                PhytoProductInput phytoProductInput;
                if (!(input instanceof PhytoProductInput) || (phytoProductInput = (PhytoProductInput)input).getTargets() == null) continue;
                aggregates.addAll(phytoProductInput.getTargets());
            }
        }
        String result = Joiner.on((String)", ").join(Iterables.transform((Iterable)aggregates, (Function)new Function<RefBioAgressor, String>(){

            public String apply(RefBioAgressor bioAgressor) {
                String result = bioAgressor.getLabel();
                return result;
            }
        }));
        return result;
    }

    static {
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.RECOLTE, "R\u00e9colte");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.SEMIS, "Semis");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES, "Application de produits phytosanitaires");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX, "Application de produits min\u00e9raux");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.EPANDAGES_ORGANIQUES, "\u00c9pandage organique");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.IRRIGATION, "Irrigation");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.LUTTE_BIOLOGIQUE, "Lutte biologique");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.TRAVAIL_DU_SOL, "Travail du sol");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.ENTRETIEN_TAILLE_VIGNE_ET_VERGER, "Entretien/Taille de vigne et verger");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.AUTRE, "Autre");
        INTERVENTION_TYPE_I18N.put(AgrosystInterventionType.TRANSPORT, "Transport");
        CROP_CYCLE_PHASE_TYPE_I18N.put(CropCyclePhaseType.INSTALLATION, "Installation");
        CROP_CYCLE_PHASE_TYPE_I18N.put(CropCyclePhaseType.MONTEE_EN_PRODUCTION, "Mont\u00e9e en production");
        CROP_CYCLE_PHASE_TYPE_I18N.put(CropCyclePhaseType.PLEINE_PRODUCTION, "Pleine production");
        CROP_CYCLE_PHASE_TYPE_I18N.put(CropCyclePhaseType.DECLIN_DE_PRODUCTION, "D\u00e9clin de production");
    }
}

