/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.network;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkManager;
import fr.inra.agrosyst.api.entities.NetworkManagerTopiaDao;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserImpl;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.common.GrowingSystemsIndicator;
import fr.inra.agrosyst.api.services.network.NetworkConnectionDto;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.services.network.NetworkGraph;
import fr.inra.agrosyst.api.services.network.NetworkIndicators;
import fr.inra.agrosyst.api.services.network.NetworkManagerDto;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.network.SmallNetworkDto;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.network.NetworkImportDto;
import fr.inra.agrosyst.services.network.NetworkImportModel;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.topia.persistence.TopiaEntity;

public class NetworkServiceImpl
extends AbstractAgrosystService
implements NetworkService {
    private static final Log log = LogFactory.getLog(NetworkServiceImpl.class);
    protected static final Comparator<SmallNetworkDto> ALPHABETICAL_NETWORK_COMPARATOR = new Comparator<SmallNetworkDto>(){

        @Override
        public int compare(SmallNetworkDto o1, SmallNetworkDto o2) {
            String label1 = Strings.nullToEmpty((String)o1.getLabel());
            String label2 = Strings.nullToEmpty((String)o2.getLabel());
            return label1.toLowerCase().compareTo(label2.toLowerCase());
        }
    };
    protected static final Predicate<Network> ACTIVE_NETWORK = new Predicate<Network>(){

        public boolean apply(Network input) {
            return input.isActive();
        }
    };
    protected BusinessAuthorizationService authorizationService;
    protected NetworkTopiaDao networkDao;
    protected NetworkManagerTopiaDao networkManagerDao;
    protected AgrosystUserTopiaDao userDao;
    protected GrowingSystemTopiaDao growingSystemTopiaDao;

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setNetworkDao(NetworkTopiaDao networkDao) {
        this.networkDao = networkDao;
    }

    public void setNetworkManagerDao(NetworkManagerTopiaDao networkManagerDao) {
        this.networkManagerDao = networkManagerDao;
    }

    public void setUserDao(AgrosystUserTopiaDao userDao) {
        this.userDao = userDao;
    }

    public void setGrowingSystemTopiaDao(GrowingSystemTopiaDao growingSystemTopiaDao) {
        this.growingSystemTopiaDao = growingSystemTopiaDao;
    }

    public ResultList<Network> getFilteredNetworks(NetworkFilter filter) {
        String networkManagerName;
        List<NetworkManager> managers = null;
        if (filter != null && !Strings.isNullOrEmpty((String)(networkManagerName = filter.getNetworkManager()))) {
            managers = this.networkManagerDao.getNameFilteredNetworkManager(networkManagerName);
        }
        ResultList<Network> result = this.networkDao.getFilteredNetworks(filter, managers);
        this.getTransaction().commit();
        return result;
    }

    public Network getNetwork(String networkTopiaId) {
        Network result = (Network)this.networkDao.forTopiaIdEquals(networkTopiaId).findUnique();
        return result;
    }

    public Network newNetwork() {
        Network result = (Network)this.networkDao.newInstance();
        result.setActive(true);
        NetworkManager manager = (NetworkManager)this.networkManagerDao.newInstance();
        manager.setFromDate(this.getContext().getCurrentDate());
        manager.setActive(true);
        String userId = this.getSecurityContext().getUserId();
        AgrosystUserImpl agrosystUser = new AgrosystUserImpl();
        agrosystUser.setTopiaId(userId);
        manager.setAgrosystUser((AgrosystUser)agrosystUser);
        result.addManagers(manager);
        return result;
    }

    public Network createOrUpdateNetwork(Network network, Collection<NetworkManagerDto> networkManagerDtos, List<String> parentsIds) {
        Network result;
        Collection<NetworkManager> networkManagers;
        this.authorizationService.checkCreateOrUpdateNetwork(network.getTopiaId());
        if (parentsIds != null) {
            Collection<Network> parents;
            if (StringUtils.isBlank((CharSequence)network.getTopiaId())) {
                parents = Lists.newArrayList();
                for (String parentTopiaId : parentsIds) {
                    parents.add((Network)this.networkDao.forTopiaIdEquals(parentTopiaId).findUnique());
                }
                network.setParents((Collection)parents);
            } else {
                parents = network.getParents();
                ArrayList parentsToKeep = Lists.newArrayList();
                if (parents == null) {
                    parents = Lists.newArrayList();
                    network.setParents((Collection)parents);
                }
                ImmutableMap indexedNetworkParents = Maps.uniqueIndex((Iterable)parents, (Function)Entities.GET_TOPIA_ID);
                for (String parentTopiaId : parentsIds) {
                    Network parent = (Network)indexedNetworkParents.get(parentTopiaId);
                    if (parent == null) {
                        parent = (Network)this.networkDao.forTopiaIdEquals(parentTopiaId).findUnique();
                        parents.add(parent);
                    }
                    parentsToKeep.add(parent);
                }
                parents.retainAll(parentsToKeep);
            }
        }
        if (network.isPersisted()) {
            networkManagers = network.getManagers();
            if (networkManagers == null) {
                networkManagers = Lists.newArrayList();
                network.setManagers((Collection)networkManagers);
            }
        } else {
            networkManagers = Lists.newArrayList();
            network.setManagers((Collection)networkManagers);
        }
        ImmutableMap indexedNetworkManagers = Maps.uniqueIndex((Iterable)networkManagers, (Function)Entities.GET_TOPIA_ID);
        ArrayList networkManagerToKeep = Lists.newArrayList();
        for (NetworkManagerDto networkManagerDto : networkManagerDtos) {
            NetworkManager persistedNetworkManager;
            UserDto userDto = networkManagerDto.getUser();
            AgrosystUser user = (AgrosystUser)this.userDao.forTopiaIdEquals(userDto.getTopiaId()).findUnique();
            String networkManagerTopiaId = networkManagerDto.getTopiaId();
            NetworkManager networkManager = StringUtils.isBlank((CharSequence)networkManagerTopiaId) ? (NetworkManager)this.networkManagerDao.newInstance() : (NetworkManager)indexedNetworkManagers.get(networkManagerTopiaId);
            networkManager.setAgrosystUser(user);
            networkManager.setFromDate(networkManagerDto.getFromDate());
            networkManager.setToDate(networkManagerDto.getToDate());
            networkManager.setActive(networkManagerDto.isActive().booleanValue());
            if (StringUtils.isBlank((CharSequence)networkManager.getTopiaId())) {
                persistedNetworkManager = (NetworkManager)this.networkManagerDao.create((TopiaEntity)networkManager);
                networkManagers.add(persistedNetworkManager);
            } else {
                persistedNetworkManager = (NetworkManager)this.networkManagerDao.update((TopiaEntity)networkManager);
            }
            networkManagerToKeep.add(persistedNetworkManager);
        }
        networkManagers.retainAll(networkManagerToKeep);
        if (StringUtils.isBlank((CharSequence)network.getTopiaId())) {
            network.setActive(true);
            result = (Network)this.networkDao.create((TopiaEntity)network);
            this.authorizationService.networkCreated(result);
        } else {
            result = (Network)this.networkDao.update((TopiaEntity)network);
            this.authorizationService.networkUpdated(network);
        }
        this.getTransaction().commit();
        return result;
    }

    public NetworkManager newNetworkManager() {
        NetworkManager networkManager = (NetworkManager)this.networkManagerDao.newInstance();
        return networkManager;
    }

    public LinkedHashMap<String, String> searchNameFilteredActiveNetworks(String research, Integer nbResult, Set<String> exclusions, String selfNetworkId, boolean onNetworkEdition) {
        if (!onNetworkEdition) {
            Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)selfNetworkId));
        }
        LinkedHashMap<String, String> networks = this.networkDao.getNameFilteredNetworks(research, nbResult, exclusions, selfNetworkId, onNetworkEdition);
        return networks;
    }

    public Set<String> findNetworksByName(String name, String excludeNetworkId) {
        Iterable<Network> networks = this.networkDao.findAllByNameWithoutCase(name);
        Iterable networkIds = Iterables.transform(networks, (Function)Entities.GET_TOPIA_ID);
        if (!Strings.isNullOrEmpty((String)excludeNetworkId)) {
            Iterables.removeIf((Iterable)networkIds, (Predicate)Predicates.equalTo((Object)excludeNetworkId));
        }
        HashSet result = Sets.newHashSet((Iterable)networkIds);
        return result;
    }

    public NetworkGraph buildFullNetworkGraph() {
        NetworkGraph graph = new NetworkGraph();
        if (this.getConfig().isDemoModeEnabled()) {
            List allNetworks = this.networkDao.forActiveEquals(true).findAll();
            for (Network network : allNetworks) {
                graph.addNetwork(network);
            }
            this.escapeTopiaIds(graph);
            this.sortLevels(graph);
        }
        return graph;
    }

    protected void sortLevels(NetworkGraph graph) {
        for (List smallNetworkDtos : graph.getNetworks()) {
            Collections.sort(smallNetworkDtos, ALPHABETICAL_NETWORK_COMPARATOR);
        }
    }

    protected void escapeTopiaIds(NetworkGraph graph) {
        for (List smallNetworkDtos : graph.getNetworks()) {
            for (SmallNetworkDto smallNetworkDto : smallNetworkDtos) {
                smallNetworkDto.setId((String)Entities.ESCAPE_TOPIA_ID.apply((Object)smallNetworkDto.getId()));
            }
        }
        for (NetworkConnectionDto networkConnectionDto : graph.getConnections()) {
            networkConnectionDto.setSourceId((String)Entities.ESCAPE_TOPIA_ID.apply((Object)networkConnectionDto.getSourceId()));
            networkConnectionDto.setTargetId((String)Entities.ESCAPE_TOPIA_ID.apply((Object)networkConnectionDto.getTargetId()));
        }
    }

    public NetworkGraph buildNetworkGraph(String fromNetworkId) {
        NetworkGraph graph = new NetworkGraph();
        Network network = this.getNetwork(fromNetworkId);
        graph.addNetwork(network);
        this.escapeTopiaIds(graph);
        this.sortLevels(graph);
        return graph;
    }

    protected void findAllParents(Set<Network> result, Iterable<Network> networks) {
        for (Network network : networks) {
            result.add(network);
            Collection parents = network.getParents();
            this.findAllParents(result, parents);
        }
    }

    public NetworkGraph buildGrowingSystemAndNetworkGraph(String growingSystemName, Set<String> parentNetworkIds) {
        NetworkGraph graph = new NetworkGraph();
        HashSet parents = Sets.newHashSet();
        for (String networkId : parentNetworkIds) {
            Network network = (Network)this.networkDao.forTopiaIdEquals(networkId).findUnique();
            parents.add(network);
        }
        graph.addGrowingSystem(growingSystemName, (Set)parents);
        HashSet parentsOfParents = Sets.newHashSet();
        this.findAllParents(parentsOfParents, parents);
        for (Network parentsOfParent : parentsOfParents) {
            graph.addNetwork(parentsOfParent);
        }
        this.escapeTopiaIds(graph);
        this.sortLevels(graph);
        return graph;
    }

    public void unactivateNetworks(List<String> networkIds, boolean activate) {
        if (CollectionUtils.isNotEmpty(networkIds)) {
            for (String networkId : networkIds) {
                Network network = (Network)this.networkDao.forTopiaIdEquals(networkId).findUnique();
                network.setActive(activate);
                this.networkDao.update((TopiaEntity)network);
            }
            this.getTransaction().commit();
        }
    }

    public long getNetworksCount(Boolean active) {
        if (active == null) {
            return this.networkDao.count();
        }
        return this.networkDao.forActiveEquals(active).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult importNetworks(InputStream networkStream) {
        Import importer = null;
        ImportResult result = new ImportResult();
        try {
            NetworkImportModel model = new NetworkImportModel();
            importer = Import.newImport((ImportModel)model, (InputStream)networkStream);
            HashMap networkCache = Maps.newHashMap();
            for (NetworkImportDto dto : importer) {
                Network network = (Network)this.networkDao.forNameEquals(dto.getName()).findAnyOrNull();
                if (network != null) {
                    result.incIgnored();
                    continue;
                }
                AgrosystUser agrosystUser = (AgrosystUser)this.userDao.forEmailEquals(dto.getResponsible()).findUniqueOrNull();
                if (agrosystUser == null) {
                    String errorMessage = "Pas d'utilisateur trouv\u00e9 avec l'email : " + dto.getResponsible();
                    result.addError(errorMessage);
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)errorMessage);
                    continue;
                }
                network = (Network)this.networkDao.newInstance();
                network.setName(dto.getName());
                network.setActive(true);
                NetworkManager manager = (NetworkManager)this.networkManagerDao.create("agrosystUser", agrosystUser, new Object[]{"active", true});
                network.addManagers(manager);
                String parents = dto.getParentNetworks();
                if (parents != null) {
                    Iterable parentNames = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)parents);
                    for (String parentName : parentNames) {
                        Network parent = (Network)networkCache.get(parentName);
                        if (parent == null) {
                            parent = (Network)this.networkDao.forNameEquals(parentName).findAnyOrNull();
                        }
                        if (parent == null) continue;
                        network.addParents(parent);
                    }
                }
                network = (Network)this.networkDao.create((TopiaEntity)network);
                networkCache.put(network.getName(), network);
                this.authorizationService.networkCreated(network);
                result.incCreated();
            }
            this.getTransaction().commit();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(importer);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)importer);
        return result;
    }

    public NetworkIndicators getIndicators(String networkId) {
        NetworkIndicators result = new NetworkIndicators();
        if (!Strings.isNullOrEmpty((String)networkId)) {
            ImmutableSet set = ImmutableSet.of((Object)networkId);
            result.setDomainsCount((long)this.networkDao.getProjectionHelper().networksToDomains((Set<String>)set).size());
            result.setActiveDomainsCount((long)this.networkDao.getProjectionHelper().networksToDomains((Set<String>)set, true).size());
            result.setGrowingPlansCount((long)this.networkDao.getProjectionHelper().networksToGrowingPlans((Set<String>)set).size());
            result.setActiveGrowingPlansCount((long)this.networkDao.getProjectionHelper().networksToGrowingPlans((Set<String>)set, true).size());
            List<GrowingSystemsIndicator> gsIndicators = this.growingSystemTopiaDao.networksToGrowingSystemIndicators((Set<String>)set);
            result.setGrowingSystems(gsIndicators);
            Set<Network> subNetworks = this.networkDao.loadNetworksWithDescendantHierarchy((Set<String>)set);
            Iterables.removeIf(subNetworks, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)networkId), (Function)Entities.GET_TOPIA_ID));
            result.setSubNetworksCount((long)subNetworks.size());
            long activeSubNetworksCount = Iterables.size((Iterable)Iterables.filter(subNetworks, ACTIVE_NETWORK));
            result.setActiveSubNetworksCount(activeSubNetworksCount);
        }
        return result;
    }

    public List<Network> getNteworkWithName(String networkName) {
        Preconditions.checkNotNull((Object)networkName);
        List result = this.networkDao.forNameEquals(networkName).findAll();
        return result;
    }
}

