/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.measurement.export;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.measure.HorizonType;
import fr.inra.agrosyst.api.entities.measure.Measure;
import fr.inra.agrosyst.api.entities.measure.MeasureType;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.measure.NitrogenMolecule;
import fr.inra.agrosyst.api.entities.measure.Observation;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActiveTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefAdventiceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMesureTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.common.export.UniqueDualLinkedHashMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

public class MeasurementExportMetadata {

    public static class MeasurementMeteoInfo
    extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;

        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "M\u00e9t\u00e9o";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"measurementType", (Object)"Cat\u00e9gorie de mesure");
            columns.put((Object)"measuringProtocol", (Object)"Protocole de mesure");
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"sampling", (Object)"Echantillonnage");
            columns.put((Object)"variable_mesuree", (Object)"Variable mesur\u00e9e");
            columns.put((Object)"measureType", (Object)"Type de mesure");
            columns.put((Object)"measureValue", (Object)"Valeur de mesure");
            columns.put((Object)"measureUnit", (Object)"Unit\u00e9 de mesure");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("variable_mesuree", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    String result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getRefMesure() != null) {
                        result = measure.getRefMesure().getVariable_mesuree();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("variable_mesuree", this.refMesureTopiaDao.findPropertyDistinctValues("variable_mesuree"));
            return result;
        }
    }

    public static class MeasurementGesInfo
    extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;

        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Gaz \u00e0 effet de serre";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"measurementType", (Object)"Cat\u00e9gorie de mesure");
            columns.put((Object)"measuringProtocol", (Object)"Protocole de mesure");
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"sampling", (Object)"Echantillonnage");
            columns.put((Object)"variable_mesuree", (Object)"Variable mesur\u00e9e");
            columns.put((Object)"measureType", (Object)"Type de mesure");
            columns.put((Object)"measureValue", (Object)"Valeur de mesure");
            columns.put((Object)"measureUnit", (Object)"Unit\u00e9 de mesure");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("variable_mesuree", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    String result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getRefMesure() != null) {
                        result = measure.getRefMesure().getVariable_mesuree();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("variable_mesuree", this.refMesureTopiaDao.findPropertyDistinctValues("variable_mesuree"));
            return result;
        }
    }

    public static class MeasurementTransferDeSolutesInfo
    extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;
        protected RefActaSubstanceActiveTopiaDao refActaSubstanceActiveTopiaDao;

        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }

        public void setRefActaSubstanceActiveTopiaDao(RefActaSubstanceActiveTopiaDao refActaSubstanceActiveTopiaDao) {
            this.refActaSubstanceActiveTopiaDao = refActaSubstanceActiveTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Transfer de solut\u00e9s";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"measurementType", (Object)"Cat\u00e9gorie de mesure");
            columns.put((Object)"measuringProtocol", (Object)"Protocole de mesure");
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"sampling", (Object)"Echantillonnage");
            columns.put((Object)"variable_mesuree", (Object)"Variable mesur\u00e9e");
            columns.put((Object)"activeSubstance", (Object)"Mol\u00e9cule phytosanitaire mesur\u00e9e");
            columns.put((Object)"nitrogenMolecule", (Object)"Mol\u00e9cule azot\u00e9e mesur\u00e9e");
            columns.put((Object)"measureType", (Object)"Type de mesure");
            columns.put((Object)"measureValue", (Object)"Valeur de mesure");
            columns.put((Object)"measureUnit", (Object)"Unit\u00e9 de mesure");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("variable_mesuree", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    String result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getRefMesure() != null) {
                        result = measure.getRefMesure().getVariable_mesuree();
                    }
                    return result;
                }
            });
            result.put("activeSubstance", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    String result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getActiveSubstance() != null) {
                        result = measure.getActiveSubstance().getNom_produit();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("nitrogenMolecule", ExportUtils.allStringOf(NitrogenMolecule.class));
            result.put("variable_mesuree", this.refMesureTopiaDao.findPropertyDistinctValues("variable_mesuree"));
            result.put("activeSubstance", this.refActaSubstanceActiveTopiaDao.findPropertyDistinctValues("nom_produit"));
            return result;
        }
    }

    public static class MeasurementSolInfo
    extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;

        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Sol";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"measurementType", (Object)"Cat\u00e9gorie de mesure");
            columns.put((Object)"measuringProtocol", (Object)"Protocole de mesure");
            columns.put((Object)"horizonType", (Object)"Horizon mesur\u00e9");
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"sampling", (Object)"Echantillonnage");
            columns.put((Object)"type_variable_mesuree", (Object)"Type de variable mesur\u00e9e");
            columns.put((Object)"variable_mesuree", (Object)"Variable mesur\u00e9e");
            columns.put((Object)"measureType", (Object)"Type de mesure");
            columns.put((Object)"measureValue", (Object)"Valeur de mesure");
            columns.put((Object)"measureUnit", (Object)"Unit\u00e9 de mesure");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("croppingPlanSpecies", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    String result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getCroppingPlanSpecies() != null) {
                        result = measure.getCroppingPlanSpecies().getSpecies().getEspece();
                    }
                    return result;
                }
            });
            result.put("type_variable_mesuree", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    VariableType result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getRefMesure() != null) {
                        result = measure.getRefMesure().getType_variable_mesuree();
                    }
                    return result;
                }
            });
            result.put("variable_mesuree", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    String result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getRefMesure() != null) {
                        result = measure.getRefMesure().getVariable_mesuree();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("horizonType", ExportUtils.allStringOf(HorizonType.class));
            result.put("variable_mesuree", this.refMesureTopiaDao.findPropertyDistinctValues("variable_mesuree"));
            return result;
        }
    }

    public static class MeasurementPlanteInfo
    extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;

        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Plantes";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"measurementType", (Object)"Cat\u00e9gorie de mesure");
            columns.put((Object)"croppingPlanSpecies", (Object)"Esp\u00e8ce");
            columns.put((Object)"measuringProtocol", (Object)"Protocole de mesure");
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"effectiveOrAreaTaken", (Object)"Effectif ou surface pr\u00e9lev\u00e9e");
            columns.put((Object)"type_variable_mesuree", (Object)"Type de variable mesur\u00e9e");
            columns.put((Object)"variable_mesuree", (Object)"Variable mesur\u00e9e");
            columns.put((Object)"measureType", (Object)"Type de mesure");
            columns.put((Object)"measureValue", (Object)"Valeur de mesure");
            columns.put((Object)"measureUnit", (Object)"Unit\u00e9 de mesure");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("croppingPlanSpecies", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    String result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getCroppingPlanSpecies() != null) {
                        result = measure.getCroppingPlanSpecies().getSpecies().getEspece();
                    }
                    return result;
                }
            });
            result.put("type_variable_mesuree", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    VariableType result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getRefMesure() != null) {
                        result = measure.getRefMesure().getType_variable_mesuree();
                    }
                    return result;
                }
            });
            result.put("variable_mesuree", new Function<K, Object>(){

                public Object apply(K input) {
                    Measure measure;
                    String result = null;
                    if (input instanceof Measure && (measure = (Measure)input).getRefMesure() != null) {
                        result = measure.getRefMesure().getVariable_mesuree();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("variable_mesuree", this.refMesureTopiaDao.findPropertyDistinctValues("variable_mesuree"));
            return result;
        }
    }

    public static class MeasurementNuisibleMaladiesPhysiologiquesAuxBeanInfo
    extends MeasurementCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Nuisibles-Maladies-Auxiliaires";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"measurementType", (Object)"Type d\u2019observation");
            columns.put((Object)"protocol", (Object)"Protocole VgObs");
            columns.put((Object)"measuringProtocol", (Object)"Autre protocole");
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"cropNumberObserved", (Object)"Nombre de plantes observ\u00e9es");
            columns.put((Object)"pest", (Object)"Nuisible");
            columns.put((Object)"cropOrganismStage", (Object)"Stade organisme observ\u00e9");
            columns.put((Object)"cropOrganSupport", (Object)"Support organe observ\u00e9");
            columns.put((Object)"cropNotationType", (Object)"Type de notation");
            columns.put((Object)"cropQualititiveValue", (Object)"Valeur qualitative");
            columns.put((Object)"quantitativeValue", (Object)"Valeur quantitative");
            columns.put((Object)"unitEDI", (Object)"Unite EDI");
            columns.put((Object)"cropUnitQualifier", (Object)"Qualifiant EDI");
            columns.put((Object)"unitOther", (Object)"Unite autre");
            columns.put((Object)"otherQualifier", (Object)"Qualifiant autre");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("protocol", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getProtocol() != null) {
                        result = observation.getProtocol().getProtocole_libelle();
                    }
                    return result;
                }
            });
            result.put("pest", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getPest() != null) {
                        result = observation.getPest().getReference_label();
                    }
                    return result;
                }
            });
            result.put("cropOrganismStage", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCropOrganismStage() != null) {
                        result = observation.getCropOrganismStage().getReference_label();
                    }
                    return result;
                }
            });
            result.put("cropOrganSupport", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCropOrganSupport() != null) {
                        result = observation.getCropOrganSupport().getReference_label();
                    }
                    return result;
                }
            });
            result.put("cropNotationType", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCropNotationType() != null) {
                        result = observation.getCropNotationType().getReference_label();
                    }
                    return result;
                }
            });
            result.put("cropQualititiveValue", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCropQualititiveValue() != null) {
                        result = observation.getCropQualititiveValue().getReference_label();
                    }
                    return result;
                }
            });
            result.put("cropUnitQualifier", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCropUnitQualifier() != null) {
                        result = observation.getCropUnitQualifier().getReference_label();
                    }
                    return result;
                }
            });
            return result;
        }
    }

    public static class MeasurementAdventicesBeanInfo
    extends MeasurementCommonBeanInfo {
        protected RefStadeEDITopiaDao refStadeEDITopiaDao;
        protected RefAdventiceTopiaDao refAdventiceTopiaDao;

        public void setRefAdventiceTopiaDao(RefAdventiceTopiaDao refAdventiceTopiaDao) {
            this.refAdventiceTopiaDao = refAdventiceTopiaDao;
        }

        public void setRefStadeEDITopiaDao(RefStadeEDITopiaDao refStadeEDITopiaDao) {
            this.refStadeEDITopiaDao = refStadeEDITopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Adventices";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"measurementType", (Object)"Type d\u2019observation");
            columns.put((Object)"measuringProtocol", (Object)"Protocole de mesure");
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"measuredAdventice", (Object)"Adventice mesur\u00e9e");
            columns.put((Object)"adventiceStage", (Object)"Stade adventice");
            columns.put((Object)"adventiceMin", (Object)"Nombre mini/m\u00b2");
            columns.put((Object)"adventiceAverage", (Object)"Nombre moyen/m\u00b2");
            columns.put((Object)"adventiceMax", (Object)"Nombre maxi/m\u00b2");
            columns.put((Object)"adventiceMedian", (Object)"Nombre median/m\u00b2");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("measuredAdventice", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getMeasuredAdventice() != null) {
                        result = observation.getMeasuredAdventice().getAdventice();
                    }
                    return result;
                }
            });
            result.put("adventiceStage", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getAdventiceStage() != null) {
                        result = observation.getAdventiceStage().getColonne2();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("measuredAdventice", this.refAdventiceTopiaDao.findPropertyDistinctValues("adventice"));
            result.put("adventiceStage", this.refStadeEDITopiaDao.findPropertyDistinctValues("colonne2"));
            return result;
        }
    }

    public static class MeasurementStadeCultureBeanInfo
    extends MeasurementCommonBeanInfo {
        protected RefEspeceTopiaDao refEspeceTopiaDao;
        protected RefStadeEDITopiaDao refStadeEDITopiaDao;

        public void setRefEspeceTopiaDao(RefEspeceTopiaDao refEspeceTopiaDao) {
            this.refEspeceTopiaDao = refEspeceTopiaDao;
        }

        public void setRefStadeEDITopiaDao(RefStadeEDITopiaDao refStadeEDITopiaDao) {
            this.refStadeEDITopiaDao = refStadeEDITopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Stade de culture";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"measurementType", (Object)"Type d\u2019observation");
            columns.put((Object)"libelle_espece_botanique", (Object)"Esp\u00e8ce");
            columns.put((Object)"libelle_qualifiant_AEE", (Object)"Qualifiant");
            columns.put((Object)"libelle_type_saisonnier_AEE", (Object)"Type saisonnier");
            columns.put((Object)"libelle_destination_AEE", (Object)"Destination");
            columns.put((Object)"measuringProtocol", (Object)"Protocole de mesure");
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"cropNumberObserved", (Object)"Nombre de plantes observ\u00e9es");
            columns.put((Object)"cropStageMin", (Object)"Stade mini");
            columns.put((Object)"cropStageAverage", (Object)"Stade moyen");
            columns.put((Object)"cropStageMedium", (Object)"Stade median");
            columns.put((Object)"cropStageMax", (Object)"Stade maxi");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("libelle_espece_botanique", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCroppingPlanSpecies() != null) {
                        result = observation.getCroppingPlanSpecies().getSpecies().getLibelle_espece_botanique();
                    }
                    return result;
                }
            });
            result.put("libelle_qualifiant_AEE", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCroppingPlanSpecies() != null) {
                        result = observation.getCroppingPlanSpecies().getSpecies().getLibelle_qualifiant_AEE();
                    }
                    return result;
                }
            });
            result.put("libelle_type_saisonnier_AEE", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCroppingPlanSpecies() != null) {
                        result = observation.getCroppingPlanSpecies().getSpecies().getLibelle_type_saisonnier_AEE();
                    }
                    return result;
                }
            });
            result.put("libelle_destination_AEE", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCroppingPlanSpecies() != null) {
                        result = observation.getCroppingPlanSpecies().getSpecies().getLibelle_destination_AEE();
                    }
                    return result;
                }
            });
            result.put("cropStageMin", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCropStageMin() != null) {
                        result = observation.getCropStageMin().getColonne2();
                    }
                    return result;
                }
            });
            result.put("cropStageAverage", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCropStageMin() != null) {
                        result = observation.getCropStageAverage().getColonne2();
                    }
                    return result;
                }
            });
            result.put("cropStageMax", new Function<K, Object>(){

                public Object apply(K input) {
                    Observation observation;
                    String result = null;
                    if (input instanceof Observation && (observation = (Observation)input).getCropStageMin() != null) {
                        result = observation.getCropStageMax().getColonne2();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("type", ExportUtils.allStringOf(CroppingEntryType.class));
            result.put("libelle_espece_botanique", this.refEspeceTopiaDao.findPropertyDistinctValues("libelle_espece_botanique"));
            result.put("libelle_qualifiant_AEE", this.refEspeceTopiaDao.findPropertyDistinctValues("libelle_qualifiant_AEE"));
            result.put("libelle_type_saisonnier_AEE", this.refEspeceTopiaDao.findPropertyDistinctValues("libelle_type_saisonnier_AEE"));
            result.put("libelle_destination_AEE", this.refEspeceTopiaDao.findPropertyDistinctValues("libelle_destination_AEE"));
            result.put("cropStageMin", this.refStadeEDITopiaDao.findPropertyDistinctValues("colonne2"));
            result.put("cropStageMax", this.refStadeEDITopiaDao.findPropertyDistinctValues("colonne2"));
            result.put("cropStageAverage", this.refStadeEDITopiaDao.findPropertyDistinctValues("colonne2"));
            result.put("cropStageMedium", this.refStadeEDITopiaDao.findPropertyDistinctValues("colonne2"));
            return result;
        }
    }

    public static class MeasurementMainBeanInfo
    extends MeasurementCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Synth\u00e8se";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap columns = new DualLinkedHashBidiMap();
            columns.put((Object)"repetitionNumber", (Object)"Num\u00e9ro de r\u00e9p\u00e9tition");
            columns.put((Object)"measurementType", (Object)"Type d\u2019observation");
            columns.put((Object)"variable", (Object)"Variable");
            columns.put((Object)"value", (Object)"Valeur");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("variable", new Function<K, Object>(){

                public Object apply(K input) {
                    String variable = "";
                    if (input != null) {
                        if (input instanceof Measure) {
                            Measure measure = (Measure)input;
                            if (measure.getRefMesure() != null) {
                                variable = variable + measure.getRefMesure().getVariable_mesuree();
                            }
                        } else if (input instanceof Observation) {
                            Observation observation = (Observation)input;
                            if (observation.getMeasurementType() == MeasurementType.ADVENTICES && observation.getMeasuredAdventice() != null && !Strings.isNullOrEmpty((String)observation.getMeasuredAdventice().getAdventice())) {
                                variable = variable + observation.getMeasuredAdventice().getAdventice();
                            }
                            if (observation.getMeasurementType() == MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES) {
                                if (observation.getPest() != null && !Strings.isNullOrEmpty((String)observation.getPest().getReference_label())) {
                                    variable = variable + observation.getPest().getReference_label();
                                } else if (observation.getProtocol() != null && !Strings.isNullOrEmpty((String)observation.getProtocol().getProtocole_libelle())) {
                                    variable = variable + observation.getProtocol().getProtocole_libelle();
                                }
                            }
                        }
                    }
                    return variable;
                }
            });
            result.put("value", new Function<K, Object>(){

                public Object apply(K input) {
                    String value = "";
                    if (input instanceof Measure) {
                        Measure measure = (Measure)input;
                        if (!Strings.isNullOrEmpty((String)measure.getMeasureValue())) {
                            value = value + measure.getMeasureValue() + " ";
                        }
                        if (!Strings.isNullOrEmpty((String)measure.getMeasureUnit())) {
                            value = value + measure.getMeasureUnit() + " ";
                        }
                    } else if (input instanceof Observation) {
                        Observation observation = (Observation)input;
                        if (observation.getMeasurementType() == MeasurementType.ADVENTICES && observation.getAdventiceStage() != null) {
                            value = value + observation.getAdventiceStage().getColonne2() + " ";
                        }
                        if (observation.getMeasurementType() == MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES) {
                            value = value + (observation.getQuantitativeValue() != null ? String.valueOf(observation.getQuantitativeValue()) : "");
                        }
                        if (observation.getMeasurementType() == MeasurementType.STADE_CULTURE && observation.getCropNumberObserved() != null) {
                            value = value + observation.getCropNumberObserved() + " ";
                        }
                        if (observation.getMeasurementType() == MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES) {
                            if (observation.isProtocolVgObs()) {
                                if (observation.getProtocol() != null && !Strings.isNullOrEmpty((String)observation.getProtocol().getReleve_qualifiant_unite_mesure())) {
                                    value = value + observation.getProtocol().getReleve_qualifiant_unite_mesure();
                                }
                            } else if (observation.getCropUnitQualifier() != null && !Strings.isNullOrEmpty((String)observation.getCropUnitQualifier().getReference_label())) {
                                value = value + observation.getCropUnitQualifier().getReference_label();
                            } else if (!Strings.isNullOrEmpty((String)observation.getUnitEDI())) {
                                value = value + observation.getUnitEDI();
                            }
                        }
                    }
                    return value;
                }
            });
            return result;
        }
    }

    public static abstract class MeasurementCommonBeanInfo
    implements EntityExportTabInfo {
        @Override
        public BidiMap<String, String> getCommonColumns() {
            UniqueDualLinkedHashMap result = new UniqueDualLinkedHashMap();
            result.put("zoneName", "Zone");
            result.put("plotName", "Parcelle");
            result.put("growingSystemName", "Syst\u00e8me De Culture");
            result.put("growingPlanName", "Dispositif");
            result.put("domainName", "Domaine");
            result.put("campaign", "Campagne");
            result.put("startDate", "Date de d\u00e9but");
            result.put("endDate", "Date de fin");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            UniqueDualLinkedHashMap result = new UniqueDualLinkedHashMap();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            LinkedHashMap result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            HashMap result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            result.put("measurementType", ExportUtils.allStringOf(MeasurementType.class));
            result.put("measureType", ExportUtils.allStringOf(MeasureType.class));
            return result;
        }
    }
}

