/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.measurement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.measure.HorizonType;
import fr.inra.agrosyst.api.entities.measure.MeasureImpl;
import fr.inra.agrosyst.api.entities.measure.MeasureType;
import fr.inra.agrosyst.api.entities.measure.Measurement;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.MeasurementSessionImpl;
import fr.inra.agrosyst.api.entities.measure.MeasurementSessionTopiaDao;
import fr.inra.agrosyst.api.entities.measure.MeasurementTopiaDao;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.measure.NitrogenMolecule;
import fr.inra.agrosyst.api.entities.measure.Observation;
import fr.inra.agrosyst.api.entities.measure.ObservationImpl;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActiveTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefAdventiceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefMesureTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObs;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObsTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDI;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDI;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDI;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDITopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.api.services.measurement.ProtocoleVgObsFilter;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.EntityImporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.measurement.export.MeasurementExportEntity;
import fr.inra.agrosyst.services.measurement.export.MeasurementExportMetadata;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class MeasurementServiceImpl
extends AbstractAgrosystService
implements MeasurementService {
    protected static final Predicate<Measurement> IS_PLANTE = new Predicate<Measurement>(){

        public boolean apply(Measurement input) {
            Boolean result = input.getMeasurementType() == MeasurementType.PLANTE;
            return result;
        }
    };
    protected static final Predicate<Measurement> IS_SOL = new Predicate<Measurement>(){

        public boolean apply(Measurement input) {
            Boolean result = input.getMeasurementType() == MeasurementType.SOL;
            return result;
        }
    };
    protected static final Predicate<Measurement> IS_TRANSFERT_SOLUTES = new Predicate<Measurement>(){

        public boolean apply(Measurement input) {
            Boolean result = input.getMeasurementType() == MeasurementType.TRANSFERT_DE_SOLUTES;
            return result;
        }
    };
    protected static final Predicate<Measurement> IS_GES = new Predicate<Measurement>(){

        public boolean apply(Measurement input) {
            Boolean result = input.getMeasurementType() == MeasurementType.GES;
            return result;
        }
    };
    protected static final Predicate<Measurement> IS_METEO = new Predicate<Measurement>(){

        public boolean apply(Measurement input) {
            Boolean result = input.getMeasurementType() == MeasurementType.METEO;
            return result;
        }
    };
    protected static final Predicate<Measurement> IS_STADE_CULTURE = new Predicate<Measurement>(){

        public boolean apply(Measurement input) {
            Boolean result = input.getMeasurementType() == MeasurementType.STADE_CULTURE;
            return result;
        }
    };
    protected static final Predicate<Measurement> IS_NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES = new Predicate<Measurement>(){

        public boolean apply(Measurement input) {
            Boolean result = input.getMeasurementType() == MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES;
            return result;
        }
    };
    protected static final Predicate<Measurement> IS_ADVENTICES = new Predicate<Measurement>(){

        public boolean apply(Measurement input) {
            Boolean result = input.getMeasurementType() == MeasurementType.ADVENTICES;
            return result;
        }
    };
    protected AnonymizeService anonymizeService;
    protected MeasurementSessionTopiaDao measurementSessionDao;
    protected ZoneTopiaDao zoneDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesTopiaDao;
    protected RefMesureTopiaDao refMesureDao;
    protected MeasurementTopiaDao measurementDao;
    protected RefSupportOrganeEDITopiaDao refSupportOrganeEDIDao;
    protected RefActaSubstanceActiveTopiaDao refSubstanceActiveDao;
    protected RefAdventiceTopiaDao refAdventiceDao;
    protected RefStadeEDITopiaDao refStadeEDIDao;
    protected EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleDao;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleDao;
    protected RefProtocoleVgObsTopiaDao refProtocoleVgObsDao;
    protected RefNuisibleEDITopiaDao refNuisiblesEdiDao;
    protected RefStadeNuisibleEDITopiaDao refStadeNuisibleEDIDao;
    protected RefTypeNotationEDITopiaDao refTypeNotationEDIDao;
    protected RefUnitesQualifiantEDITopiaDao refUnitesQualifiantEDIDao;
    protected RefValeurQualitativeEDITopiaDao refValeurQualitativeEDIDao;
    protected RefEspeceTopiaDao refEspeceTopiaDao;
    protected RefAdventiceTopiaDao refAdventiceTopiaDao;

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setMeasurementSessionDao(MeasurementSessionTopiaDao measurementSessionDao) {
        this.measurementSessionDao = measurementSessionDao;
    }

    public void setZoneDao(ZoneTopiaDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setCroppingPlanSpeciesTopiaDao(CroppingPlanSpeciesTopiaDao croppingPlanSpeciesTopiaDao) {
        this.croppingPlanSpeciesTopiaDao = croppingPlanSpeciesTopiaDao;
    }

    public void setRefMesureDao(RefMesureTopiaDao refMesureDao) {
        this.refMesureDao = refMesureDao;
    }

    public void setMeasurementDao(MeasurementTopiaDao measurementDao) {
        this.measurementDao = measurementDao;
    }

    public void setRefSupportOrganeEDIDao(RefSupportOrganeEDITopiaDao refSupportOrganeEDIDao) {
        this.refSupportOrganeEDIDao = refSupportOrganeEDIDao;
    }

    public void setRefSubstanceActiveDao(RefActaSubstanceActiveTopiaDao refSubstanceActiveDao) {
        this.refSubstanceActiveDao = refSubstanceActiveDao;
    }

    public void setRefAdventiceDao(RefAdventiceTopiaDao refAdventiceDao) {
        this.refAdventiceDao = refAdventiceDao;
    }

    public void setRefStadeEDIDao(RefStadeEDITopiaDao refStadeEDIDao) {
        this.refStadeEDIDao = refStadeEDIDao;
    }

    public void setEffectiveSeasonalCropCycleDao(EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleDao) {
        this.effectiveSeasonalCropCycleDao = effectiveSeasonalCropCycleDao;
    }

    public void setRefAdventiceTopiaDao(RefAdventiceTopiaDao refAdventiceTopiaDao) {
        this.refAdventiceTopiaDao = refAdventiceTopiaDao;
    }

    public void setEffectivePerennialCropCycleDao(EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleDao) {
        this.effectivePerennialCropCycleDao = effectivePerennialCropCycleDao;
    }

    public void setRefProtocoleVgObsDao(RefProtocoleVgObsTopiaDao refProtocoleVgObsDao) {
        this.refProtocoleVgObsDao = refProtocoleVgObsDao;
    }

    public void setRefNuisiblesEdiDao(RefNuisibleEDITopiaDao refNuisiblesEdiDao) {
        this.refNuisiblesEdiDao = refNuisiblesEdiDao;
    }

    public void setRefStadeNuisibleEDIDao(RefStadeNuisibleEDITopiaDao refStadeNuisibleEDIDao) {
        this.refStadeNuisibleEDIDao = refStadeNuisibleEDIDao;
    }

    public void setRefTypeNotationEDIDao(RefTypeNotationEDITopiaDao refTypeNotationEDIDao) {
        this.refTypeNotationEDIDao = refTypeNotationEDIDao;
    }

    public void setRefUnitesQualifiantEDIDao(RefUnitesQualifiantEDITopiaDao refUnitesQualifiantEDIDao) {
        this.refUnitesQualifiantEDIDao = refUnitesQualifiantEDIDao;
    }

    public void setRefValeurQualitativeEDIDao(RefValeurQualitativeEDITopiaDao refValeurQualitativeEDIDao) {
        this.refValeurQualitativeEDIDao = refValeurQualitativeEDIDao;
    }

    public void setRefEspeceTopiaDao(RefEspeceTopiaDao refEspeceTopiaDao) {
        this.refEspeceTopiaDao = refEspeceTopiaDao;
    }

    public List<MeasurementSession> getZoneMeasurementSessions(Zone zone) {
        return this.measurementSessionDao.forZoneEquals(zone).setOrderByArguments(new String[]{"startDate"}).findAll();
    }

    public void updateMeasurementSessions(Zone zone, Collection<MeasurementSession> inputSessions) {
        Binder sessionBinder = BinderFactory.newBinder(MeasurementSession.class);
        List currentSessions = this.measurementSessionDao.forZoneEquals(zone).findAll();
        ArrayList toDeleteSessions = Lists.newArrayList((Iterable)currentSessions);
        ImmutableMap idToSession = Maps.uniqueIndex((Iterable)currentSessions, (Function)TopiaEntities.getTopiaIdFunction());
        for (MeasurementSession inputSession : inputSessions) {
            MeasurementSession currentSession;
            Preconditions.checkNotNull((Object)inputSession.getStartDate());
            if (StringUtils.isEmpty((CharSequence)inputSession.getTopiaId())) {
                currentSession = (MeasurementSession)this.measurementSessionDao.newInstance();
                currentSession.setZone(zone);
            } else {
                currentSession = (MeasurementSession)idToSession.get(inputSession.getTopiaId());
                toDeleteSessions.remove(currentSession);
            }
            sessionBinder.copyExcluding((Object)inputSession, (Object)currentSession, new String[]{"zone", "measurements"});
            currentSession = currentSession.isPersisted() ? (MeasurementSession)this.measurementSessionDao.update((TopiaEntity)currentSession) : (MeasurementSession)this.measurementSessionDao.create((TopiaEntity)currentSession);
            Collection currentMeasurements = currentSession.getMeasurements();
            if (currentMeasurements == null) {
                currentMeasurements = Lists.newArrayList();
            }
            if (inputSession.getMeasurements() == null) continue;
            ArrayList toDeleteMeasurements = Lists.newArrayList((Iterable)currentMeasurements);
            ImmutableMap idToMeasurement = Maps.uniqueIndex((Iterable)currentMeasurements, (Function)TopiaEntities.getTopiaIdFunction());
            for (Measurement inputMeasurement : inputSession.getMeasurements()) {
                Measurement currentMeasurement;
                if (inputMeasurement == null) continue;
                Preconditions.checkNotNull((Object)inputMeasurement.getMeasurementType());
                if (StringUtils.isEmpty((CharSequence)inputMeasurement.getTopiaId())) {
                    currentSession.addMeasurements(inputMeasurement);
                    currentMeasurement = (Measurement)this.measurementDao.create((TopiaEntity)inputMeasurement);
                } else {
                    currentMeasurement = (Measurement)idToMeasurement.get(inputMeasurement.getTopiaId());
                    toDeleteMeasurements.remove(currentMeasurement);
                }
                Binder measurementBinder = BinderFactory.newBinder(currentMeasurement.getClass());
                measurementBinder.copyExcluding((Object)inputMeasurement, (Object)currentMeasurement, new String[]{"measurementSession"});
                if (currentMeasurement.isPersisted()) {
                    this.measurementDao.update((TopiaEntity)currentMeasurement);
                    continue;
                }
                this.measurementDao.create((TopiaEntity)currentMeasurement);
            }
            currentMeasurements.removeAll(toDeleteMeasurements);
            this.measurementDao.deleteAll(toDeleteMeasurements);
        }
        this.measurementSessionDao.deleteAll(toDeleteSessions);
        this.getTransaction().commit();
    }

    public Zone getZone(String zoneTopiaId) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        Zone result = this.anonymizeService.checkForZoneAnonymization(zone);
        return result;
    }

    public Set<CroppingPlanEntry> getZoneCroppingPlanEntries(Zone zone) {
        HashSet result = Sets.newHashSet();
        List cycleS = this.effectiveSeasonalCropCycleDao.forZoneEquals(zone).findAll();
        List cycleP = this.effectivePerennialCropCycleDao.forZoneEquals(zone).findAll();
        for (EffectiveSeasonalCropCycle cycle : cycleS) {
            if (cycle.getNodes() == null) continue;
            for (EffectiveCropCycleNode node : cycle.getNodes()) {
                result.add(node.getCroppingPlanEntry());
            }
        }
        for (EffectiveSeasonalCropCycle cycle : cycleP) {
            result.add(cycle.getCroppingPlanEntry());
        }
        return result;
    }

    public List<VariableType> findAllVariableTypes(MeasurementType measurementType) {
        return this.refMesureDao.findTypeVariableValues(measurementType);
    }

    public List<RefMesure> findAllVariables(MeasurementType measurementType, VariableType variableType) {
        return this.refMesureDao.findVariables(measurementType, variableType);
    }

    public List<RefSupportOrganeEDI> findAllSupportOrganeEDI() {
        List result = this.refSupportOrganeEDIDao.forActiveEquals(true).setOrderByArguments(new String[]{"reference_label"}).findAll();
        return result;
    }

    public List<RefActaSubstanceActive> findDistinctSubstanceActives() {
        List<RefActaSubstanceActive> result = this.refSubstanceActiveDao.findDistinctSubtanceActive();
        return result;
    }

    public List<RefAdventice> findAllAdventices() {
        List result = this.refAdventiceDao.forActiveEquals(true).setOrderByArguments(new String[]{"adventice"}).findAll();
        return result;
    }

    public List<RefStadeEDI> findAllStadeEdi(String cropFamily, String vegetativeProfile) {
        List result;
        if (StringUtils.isNotEmpty((CharSequence)cropFamily)) {
            result = this.refStadeEDIDao.forFamille_de_cultureEquals(cropFamily).setOrderByArguments(new String[]{"colonne2"}).findAll();
        } else if (StringUtils.isNumeric((CharSequence)vegetativeProfile)) {
            Integer pv = Integer.valueOf(vegetativeProfile);
            result = this.refStadeEDIDao.forProfil_vegetatifEquals(pv).setOrderByArguments(new String[]{"colonne2"}).findAll();
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<String> findAllProtocoleVgObsLabels() {
        List<String> result = this.refProtocoleVgObsDao.findAllProperties("protocole_libelle", null);
        return result;
    }

    public List<String> findAllProtocoleVgObsPests(ProtocoleVgObsFilter filter) {
        List<String> result = this.refProtocoleVgObsDao.findAllProperties("ligne_organisme_vivant", filter);
        return result;
    }

    public List<String> findAllProtocoleVgObsStades(ProtocoleVgObsFilter filter) {
        List<String> result = this.refProtocoleVgObsDao.findAllProperties("ligne_stades_developpement", filter);
        return result;
    }

    public List<String> findAllProtocoleVgObsSupports(ProtocoleVgObsFilter filter) {
        List<String> result = this.refProtocoleVgObsDao.findAllProperties("ligne_supports_organes", filter);
        return result;
    }

    public List<String> findAllProtocoleVgObsObservations(ProtocoleVgObsFilter filter) {
        List<String> result = this.refProtocoleVgObsDao.findAllProperties("ligne_type_observation", filter);
        return result;
    }

    public List<String> findAllProtocoleVgObsQualitatives(ProtocoleVgObsFilter filter) {
        List<String> result = this.refProtocoleVgObsDao.findAllProperties("classe_valeur_qualitative", filter);
        return result;
    }

    public List<String> findAllProtocoleVgObsUnits(ProtocoleVgObsFilter filter) {
        List<String> result = this.refProtocoleVgObsDao.findAllProperties("releve_unite", filter);
        return result;
    }

    public List<RefProtocoleVgObs> findAllProtocoleVgObsQualifiers(ProtocoleVgObsFilter filter) {
        List<RefProtocoleVgObs> result = this.refProtocoleVgObsDao.findAllProperties(null, filter);
        return result;
    }

    public List<BioAgressorType> findAllEdiPestTypes() {
        List<BioAgressorType> result = this.refNuisiblesEdiDao.findAllActiveParam();
        return result;
    }

    public List<RefNuisibleEDI> findAllEdiPests(BioAgressorType pestType) {
        List result = this.refNuisiblesEdiDao.forReference_paramEquals(pestType).setOrderByArguments(new String[]{"reference_label"}).findAll();
        return result;
    }

    public List<RefStadeNuisibleEDI> findAllEdiPestStades() {
        List result = this.refStadeNuisibleEDIDao.newQueryBuilder().setOrderByArguments(new String[]{"reference_label"}).findAll();
        return result;
    }

    public List<String> findAllVgObsUnits() {
        List<String> result = this.refProtocoleVgObsDao.findAllProperties("releve_qualifiant_unite_mesure", null);
        return result;
    }

    public List<RefTypeNotationEDI> findAllEdiNotations() {
        List result = this.refTypeNotationEDIDao.newQueryBuilder().setOrderByArguments(new String[]{"reference_label"}).findAll();
        return result;
    }

    public List<RefValeurQualitativeEDI> findAllEdiQualitatives() {
        List result = this.refValeurQualitativeEDIDao.newQueryBuilder().setOrderByArguments(new String[]{"reference_label"}).findAll();
        return result;
    }

    public List<RefUnitesQualifiantEDI> findAllEdiQualifiantUnits() {
        List result = this.refUnitesQualifiantEDIDao.newQueryBuilder().setOrderByArguments(new String[]{"reference_label"}).findAll();
        return result;
    }

    public InputStream exportEffectiveMeasurementsAsXlsStream(List<String> zoneIds) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        MeasurementExportMetadata.MeasurementMainBeanInfo measurementMainBeanInfo = this.newInstance(MeasurementExportMetadata.MeasurementMainBeanInfo.class);
        MeasurementExportMetadata.MeasurementStadeCultureBeanInfo measurementStadeCultureBeanInfo = this.newInstance(MeasurementExportMetadata.MeasurementStadeCultureBeanInfo.class);
        MeasurementExportMetadata.MeasurementAdventicesBeanInfo measurementAdventicesBeanInfo = this.newInstance(MeasurementExportMetadata.MeasurementAdventicesBeanInfo.class);
        MeasurementExportMetadata.MeasurementNuisibleMaladiesPhysiologiquesAuxBeanInfo measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo = this.newInstance(MeasurementExportMetadata.MeasurementNuisibleMaladiesPhysiologiquesAuxBeanInfo.class);
        MeasurementExportMetadata.MeasurementPlanteInfo measurementPlanteInfo = this.newInstance(MeasurementExportMetadata.MeasurementPlanteInfo.class);
        MeasurementExportMetadata.MeasurementSolInfo measurementSolInfo = this.newInstance(MeasurementExportMetadata.MeasurementSolInfo.class);
        MeasurementExportMetadata.MeasurementTransferDeSolutesInfo measurementTransferDeSolutesInfo = this.newInstance(MeasurementExportMetadata.MeasurementTransferDeSolutesInfo.class);
        MeasurementExportMetadata.MeasurementGesInfo measurementGesInfo = this.newInstance(MeasurementExportMetadata.MeasurementGesInfo.class);
        MeasurementExportMetadata.MeasurementMeteoInfo measurementMeteoInfo = this.newInstance(MeasurementExportMetadata.MeasurementMeteoInfo.class);
        ExportUtils.addAllBeanInfo(sheet, measurementMainBeanInfo, measurementStadeCultureBeanInfo, measurementAdventicesBeanInfo, measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo, measurementPlanteInfo, measurementSolInfo, measurementTransferDeSolutesInfo, measurementGesInfo, measurementMeteoInfo);
        List nuisibleEntities = (List)sheet.get(measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo);
        try {
            if (CollectionUtils.isNotEmpty(zoneIds)) {
                List zones = this.zoneDao.forTopiaIdIn(zoneIds).findAll();
                for (Zone zone : zones) {
                    Iterable measurementSessions = this.measurementSessionDao.forZoneEquals(zone).findAllLazy(100);
                    zone = this.anonymizeService.checkForZoneAnonymization(zone);
                    for (MeasurementSession measurementSession : measurementSessions) {
                        MeasurementExportEntity model = new MeasurementExportEntity();
                        model.setZoneName(zone.getName());
                        model.setPlotName(zone.getPlot().getName());
                        if (zone.getPlot().getGrowingSystem() != null) {
                            model.setGrowingSystemName(zone.getPlot().getGrowingSystem().getName());
                            model.setGrowingPlanName(zone.getPlot().getGrowingSystem().getGrowingPlan().getName());
                        }
                        model.setDomainName(zone.getPlot().getDomain().getName());
                        model.setCampaign(zone.getPlot().getDomain().getCampaign());
                        model.setStartDate(measurementSession.getStartDate());
                        model.setEndDate(measurementSession.getEndDate());
                        Collection measurements = measurementSession.getMeasurements();
                        ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, measurements, (EntityExportTabInfo)measurementMainBeanInfo);
                        ArrayList tmp = Lists.newArrayList((Iterable)measurements);
                        ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, Iterables.filter((Iterable)tmp, IS_STADE_CULTURE), (EntityExportTabInfo)measurementStadeCultureBeanInfo);
                        tmp = Lists.newArrayList((Iterable)measurements);
                        ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, Iterables.filter((Iterable)tmp, IS_ADVENTICES), (EntityExportTabInfo)measurementAdventicesBeanInfo);
                        tmp = Lists.newArrayList((Iterable)measurements);
                        Iterable nuisibles = Iterables.filter((Iterable)tmp, IS_NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES);
                        for (Measurement nuisible : nuisibles) {
                            Observation observation = (Observation)nuisible;
                            MeasurementExportEntity export = (MeasurementExportEntity)model.clone();
                            ExportUtils.copyFields(model, (EntityExportExtra)export, measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo.getCustomFormatters(), measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo.getCommonColumns().keySet());
                            if (observation.isProtocolVgObs()) {
                                ExportUtils.setExtraField(export, "repetitionNumber", observation.getRepetitionNumber());
                                ExportUtils.setExtraField(export, "comment", observation.getComment());
                                ExportUtils.setExtraField(export, "protocol", observation.getProtocol().getProtocole_libelle());
                                ExportUtils.setExtraField(export, "cropNumberObserved", observation.getCropNumberObserved());
                                ExportUtils.setExtraField(export, "pest", observation.getProtocol().getLigne_organisme_vivant());
                                ExportUtils.setExtraField(export, "cropOrganismStage", observation.getProtocol().getLigne_stades_developpement());
                                ExportUtils.setExtraField(export, "cropOrganSupport", observation.getProtocol().getLigne_supports_organes());
                                ExportUtils.setExtraField(export, "cropNotationType", observation.getProtocol().getLigne_type_observation());
                                ExportUtils.setExtraField(export, "cropQualititiveValue", observation.getProtocol().getClasse_valeur_qualitative());
                                ExportUtils.setExtraField(export, "quantitativeValue", observation.getQuantitativeValue());
                                ExportUtils.setExtraField(export, "unitEDI", observation.getProtocol().getReleve_unite());
                                ExportUtils.setExtraField(export, "cropUnitQualifier", observation.getProtocol().getReleve_qualifiant_unite_mesure());
                                ExportUtils.setExtraField(export, "unitOther", observation.getUnitOther());
                                ExportUtils.setExtraField(export, "otherQualifier", observation.getOtherQualifier());
                            } else {
                                ExportUtils.copyFields(observation, (EntityExportExtra)export, measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo.getCustomFormatters(), measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo.getExtraColumns().keySet());
                            }
                            nuisibleEntities.add(export);
                        }
                        tmp = Lists.newArrayList((Iterable)measurements);
                        ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, Iterables.filter((Iterable)tmp, IS_PLANTE), (EntityExportTabInfo)measurementPlanteInfo);
                        tmp = Lists.newArrayList((Iterable)measurements);
                        ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, Iterables.filter((Iterable)tmp, IS_SOL), (EntityExportTabInfo)measurementSolInfo);
                        tmp = Lists.newArrayList((Iterable)measurements);
                        ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, Iterables.filter((Iterable)tmp, IS_TRANSFERT_SOLUTES), (EntityExportTabInfo)measurementTransferDeSolutesInfo);
                        tmp = Lists.newArrayList((Iterable)measurements);
                        ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, Iterables.filter((Iterable)tmp, IS_GES), (EntityExportTabInfo)measurementGesInfo);
                        tmp = Lists.newArrayList((Iterable)measurements);
                        ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, Iterables.filter((Iterable)tmp, IS_METEO), (EntityExportTabInfo)measurementMeteoInfo);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }

    public void importEffectiveMeasurementsForXlsStream(InputStream is) {
        String mesureValue;
        String measureType;
        RefMesure refMesure;
        String variableMesuree;
        RefStadeEDI refStadeEDI;
        MeasurementExportMetadata.MeasurementStadeCultureBeanInfo measurementStadeCultureBeanInfo = this.newInstance(MeasurementExportMetadata.MeasurementStadeCultureBeanInfo.class);
        MeasurementExportMetadata.MeasurementAdventicesBeanInfo measurementAdventicesBeanInfo = this.newInstance(MeasurementExportMetadata.MeasurementAdventicesBeanInfo.class);
        MeasurementExportMetadata.MeasurementNuisibleMaladiesPhysiologiquesAuxBeanInfo measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo = this.newInstance(MeasurementExportMetadata.MeasurementNuisibleMaladiesPhysiologiquesAuxBeanInfo.class);
        MeasurementExportMetadata.MeasurementPlanteInfo measurementPlanteInfo = this.newInstance(MeasurementExportMetadata.MeasurementPlanteInfo.class);
        MeasurementExportMetadata.MeasurementSolInfo measurementSolInfo = this.newInstance(MeasurementExportMetadata.MeasurementSolInfo.class);
        MeasurementExportMetadata.MeasurementTransferDeSolutesInfo measurementTransferDeSolutesInfo = this.newInstance(MeasurementExportMetadata.MeasurementTransferDeSolutesInfo.class);
        MeasurementExportMetadata.MeasurementGesInfo measurementGesInfo = this.newInstance(MeasurementExportMetadata.MeasurementGesInfo.class);
        MeasurementExportMetadata.MeasurementMeteoInfo measurementMeteoInfo = this.newInstance(MeasurementExportMetadata.MeasurementMeteoInfo.class);
        EntityImporter importer = new EntityImporter();
        Map<EntityExportTabInfo, List<MeasurementExportEntity>> datas = importer.importFromStream(is, MeasurementExportEntity.class, measurementStadeCultureBeanInfo, measurementAdventicesBeanInfo, measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo, measurementPlanteInfo, measurementSolInfo, measurementTransferDeSolutesInfo, measurementGesInfo, measurementMeteoInfo);
        MultiKeyMap sessionCache = new MultiKeyMap();
        List<MeasurementExportEntity> stadeBeanInfo = datas.get(measurementStadeCultureBeanInfo);
        for (MeasurementExportEntity beanInfo : stadeBeanInfo) {
            String cropNumberObserved;
            MeasurementSession session = this.getMeasurementSession((MultiKeyMap<Object, MeasurementSession>)sessionCache, beanInfo);
            ObservationImpl observation = new ObservationImpl();
            observation.setMeasurementType(MeasurementType.STADE_CULTURE);
            observation.setMeasuringProtocol(beanInfo.getExtraAsString("measuringProtocol"));
            String repetitionNumber = beanInfo.getExtraAsString("repetitionNumber");
            if (StringUtils.isNotBlank((CharSequence)repetitionNumber)) {
                observation.setRepetitionNumber(Integer.valueOf(Integer.parseInt(repetitionNumber)));
            }
            observation.setComment(beanInfo.getExtraAsString("comment"));
            String espece = beanInfo.getExtraAsString("libelle_espece_botanique");
            if (StringUtils.isNotBlank((CharSequence)espece)) {
                RefEspece refEspece = (RefEspece)this.refEspeceTopiaDao.forProperties("libelle_espece_botanique", espece, new Object[]{"libelle_qualifiant_AEE", Strings.nullToEmpty((String)beanInfo.getExtraAsString("libelle_qualifiant_AEE")), "libelle_type_saisonnier_AEE", Strings.nullToEmpty((String)beanInfo.getExtraAsString("libelle_type_saisonnier_AEE")), "libelle_destination_AEE", Strings.nullToEmpty((String)beanInfo.getExtraAsString("libelle_destination_AEE"))}).findUnique();
                CroppingPlanSpecies croppingPlanSpecies = (CroppingPlanSpecies)this.croppingPlanSpeciesTopiaDao.forProperties("species", refEspece, new Object[]{"croppingPlanEntry.domain", session.getZone().getPlot().getDomain()}).findUnique();
                observation.setCroppingPlanSpecies(croppingPlanSpecies);
            }
            String stadeMin = beanInfo.getExtraAsString("cropStageMin");
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{stadeMin})) {
                RefStadeEDI refStadeEDI2 = (RefStadeEDI)this.refStadeEDIDao.forColonne2Equals(stadeMin).findUnique();
                observation.setCropStageMin(refStadeEDI2);
            }
            String stadeMax = beanInfo.getExtraAsString("cropStageMax");
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{stadeMax})) {
                refStadeEDI = (RefStadeEDI)this.refStadeEDIDao.forColonne2Equals(stadeMax).findUnique();
                observation.setCropStageMax(refStadeEDI);
            }
            String stadeMedium = beanInfo.getExtraAsString("cropStageMedium");
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{stadeMedium})) {
                RefStadeEDI refStadeEDI3 = (RefStadeEDI)this.refStadeEDIDao.forColonne2Equals(stadeMedium).findUnique();
                observation.setCropStageMedium(refStadeEDI3);
            }
            String stadeAvg = beanInfo.getExtraAsString("cropStageAverage");
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{stadeAvg})) {
                RefStadeEDI refStadeEDI4 = (RefStadeEDI)this.refStadeEDIDao.forColonne2Equals(stadeAvg).findUnique();
                observation.setCropStageAverage(refStadeEDI4);
            }
            if (StringUtils.isNotBlank((CharSequence)(cropNumberObserved = beanInfo.getExtraAsString("cropNumberObserved")))) {
                observation.setCropNumberObserved(Integer.valueOf(Integer.parseInt(cropNumberObserved)));
            }
            session.addMeasurements((Measurement)observation);
        }
        List<MeasurementExportEntity> adventiceBeanInfo = datas.get(measurementAdventicesBeanInfo);
        for (MeasurementExportEntity beanInfo : adventiceBeanInfo) {
            MeasurementSession session = this.getMeasurementSession((MultiKeyMap<Object, MeasurementSession>)sessionCache, beanInfo);
            ObservationImpl observation = new ObservationImpl();
            observation.setMeasurementType(MeasurementType.ADVENTICES);
            observation.setMeasuringProtocol(beanInfo.getExtraAsString("measuringProtocol"));
            String repetitionNumber = beanInfo.getExtraAsString("repetitionNumber");
            if (StringUtils.isNotBlank((CharSequence)repetitionNumber)) {
                observation.setRepetitionNumber(Integer.valueOf(Integer.parseInt(repetitionNumber)));
            }
            observation.setComment(beanInfo.getExtraAsString("comment"));
            String adventice = beanInfo.getExtraAsString("measuredAdventice");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{adventice})) {
                RefAdventice refAdventice = (RefAdventice)this.refAdventiceTopiaDao.forAdventiceEquals(adventice).findUnique();
                observation.setMeasuredAdventice(refAdventice);
            }
            String adventiceStade = beanInfo.getExtraAsString("adventiceStage");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{adventiceStade})) {
                refStadeEDI = (RefStadeEDI)this.refStadeEDIDao.forColonne2Equals(adventiceStade).findUnique();
                observation.setAdventiceStage(refStadeEDI);
            }
            try {
                ExportUtils.copyFields(beanInfo, observation, "adventiceAverage", "adventiceMin", "adventiceMax", "adventiceMedian");
            }
            catch (Exception ex) {
                throw new AgrosystTechnicalException("Can't copy fields", (Throwable)ex);
            }
            session.addMeasurements((Measurement)observation);
        }
        List<MeasurementExportEntity> nuisibleBeanInfo = datas.get(measurementNuisibleMaladiesPhysiologiquesAuxBeanInfo);
        for (MeasurementExportEntity beanInfo : nuisibleBeanInfo) {
            MeasurementSession session = this.getMeasurementSession((MultiKeyMap<Object, MeasurementSession>)sessionCache, beanInfo);
            ObservationImpl measure = new ObservationImpl();
            measure.setMeasurementType(MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES);
            measure.setMeasuringProtocol(beanInfo.getExtraAsString("measuringProtocol"));
            String repetitionNumber = beanInfo.getExtraAsString("repetitionNumber");
            if (StringUtils.isNotBlank((CharSequence)repetitionNumber)) {
                measure.setRepetitionNumber(Integer.valueOf(Integer.parseInt(repetitionNumber)));
            }
            measure.setComment(beanInfo.getExtraAsString("comment"));
            session.addMeasurements((Measurement)measure);
        }
        List<MeasurementExportEntity> planteBeanInfo = datas.get(measurementPlanteInfo);
        for (MeasurementExportEntity beanInfo : planteBeanInfo) {
            String mesureValue2;
            String measureType2;
            MeasurementSession session = this.getMeasurementSession((MultiKeyMap<Object, MeasurementSession>)sessionCache, beanInfo);
            MeasureImpl measure = new MeasureImpl();
            measure.setMeasurementType(MeasurementType.PLANTE);
            measure.setMeasuringProtocol(beanInfo.getExtraAsString("measuringProtocol"));
            String repetitionNumber = beanInfo.getExtraAsString("repetitionNumber");
            if (StringUtils.isNotBlank((CharSequence)repetitionNumber)) {
                measure.setRepetitionNumber(Integer.valueOf(Integer.parseInt(repetitionNumber)));
            }
            measure.setComment(beanInfo.getExtraAsString("sampling"));
            measure.setEffectiveOrAreaTaken(beanInfo.getExtraAsString("effectiveOrAreaTaken"));
            String variableMesuree2 = beanInfo.getExtraAsString("variable_mesuree");
            if (StringUtils.isNotBlank((CharSequence)variableMesuree2)) {
                RefMesure refMesure2 = (RefMesure)this.refMesureDao.forProperties("variable_mesuree", variableMesuree2, new Object[0]).findUnique();
                measure.setRefMesure(refMesure2);
            }
            if (StringUtils.isNotEmpty((CharSequence)(measureType2 = beanInfo.getExtraAsString("measureType")))) {
                measure.setMeasureType(MeasureType.valueOf((String)measureType2));
            }
            if (StringUtils.isNotBlank((CharSequence)(mesureValue2 = beanInfo.getExtraAsString("measureValue")))) {
                measure.setMeasureValue(mesureValue2);
            }
            measure.setMeasureUnit(beanInfo.getExtraAsString("measureUnit"));
            session.addMeasurements((Measurement)measure);
        }
        List<MeasurementExportEntity> solBeanInfo = datas.get(measurementSolInfo);
        for (MeasurementExportEntity beanInfo : solBeanInfo) {
            String mesureValue3;
            String measureType3;
            MeasurementSession session = this.getMeasurementSession((MultiKeyMap<Object, MeasurementSession>)sessionCache, beanInfo);
            MeasureImpl measure = new MeasureImpl();
            measure.setMeasurementType(MeasurementType.SOL);
            measure.setMeasuringProtocol(beanInfo.getExtraAsString("measuringProtocol"));
            String repetitionNumber = beanInfo.getExtraAsString("repetitionNumber");
            if (StringUtils.isNotBlank((CharSequence)repetitionNumber)) {
                measure.setRepetitionNumber(Integer.valueOf(Integer.parseInt(repetitionNumber)));
            }
            measure.setComment(beanInfo.getExtraAsString("sampling"));
            String measureHorizon = beanInfo.getExtraAsString("horizonType");
            if (StringUtils.isNotEmpty((CharSequence)measureHorizon)) {
                measure.setHorizonType(HorizonType.valueOf((String)measureHorizon));
            }
            measure.setSampling(beanInfo.getExtraAsString("comment"));
            variableMesuree = beanInfo.getExtraAsString("variable_mesuree");
            if (StringUtils.isNotBlank((CharSequence)variableMesuree)) {
                refMesure = (RefMesure)this.refMesureDao.forProperties("variable_mesuree", variableMesuree, new Object[0]).findUnique();
                measure.setRefMesure(refMesure);
            }
            if (StringUtils.isNotEmpty((CharSequence)(measureType3 = beanInfo.getExtraAsString("measureType")))) {
                measure.setMeasureType(MeasureType.valueOf((String)measureType3));
            }
            if (StringUtils.isNotBlank((CharSequence)(mesureValue3 = beanInfo.getExtraAsString("measureValue")))) {
                measure.setMeasureValue(mesureValue3);
            }
            measure.setMeasureUnit(beanInfo.getExtraAsString("measureUnit"));
            session.addMeasurements((Measurement)measure);
        }
        List<MeasurementExportEntity> tranferBeanInfo = datas.get(measurementTransferDeSolutesInfo);
        for (MeasurementExportEntity beanInfo : tranferBeanInfo) {
            String nitrogenMolecule;
            String activeSubtance;
            MeasurementSession session = this.getMeasurementSession((MultiKeyMap<Object, MeasurementSession>)sessionCache, beanInfo);
            MeasureImpl measure = new MeasureImpl();
            measure.setMeasurementType(MeasurementType.TRANSFERT_DE_SOLUTES);
            measure.setMeasuringProtocol(beanInfo.getExtraAsString("measuringProtocol"));
            String repetitionNumber = beanInfo.getExtraAsString("repetitionNumber");
            if (StringUtils.isNotBlank((CharSequence)repetitionNumber)) {
                measure.setRepetitionNumber(Integer.valueOf(Integer.parseInt(repetitionNumber)));
            }
            measure.setComment(beanInfo.getExtraAsString("comment"));
            measure.setSampling(beanInfo.getExtraAsString("sampling"));
            variableMesuree = beanInfo.getExtraAsString("variable_mesuree");
            if (StringUtils.isNotBlank((CharSequence)variableMesuree)) {
                refMesure = (RefMesure)this.refMesureDao.forProperties("variable_mesuree", variableMesuree, new Object[0]).findUnique();
                measure.setRefMesure(refMesure);
            }
            if (StringUtils.isNotBlank((CharSequence)(activeSubtance = beanInfo.getExtraAsString("activeSubstance")))) {
                RefActaSubstanceActive refActaSubstanceActive = (RefActaSubstanceActive)this.refSubstanceActiveDao.forProperties("nom_produit", activeSubtance, new Object[0]).findUnique();
                measure.setActiveSubstance(refActaSubstanceActive);
            }
            if (StringUtils.isNotEmpty((CharSequence)(nitrogenMolecule = beanInfo.getExtraAsString("nitrogenMolecule")))) {
                measure.setNitrogenMolecule(NitrogenMolecule.valueOf((String)nitrogenMolecule));
            }
            if (StringUtils.isNotEmpty((CharSequence)(measureType = beanInfo.getExtraAsString("measureType")))) {
                measure.setMeasureType(MeasureType.valueOf((String)measureType));
            }
            if (StringUtils.isNotBlank((CharSequence)(mesureValue = beanInfo.getExtraAsString("measureValue")))) {
                measure.setMeasureValue(mesureValue);
            }
            measure.setMeasureUnit(beanInfo.getExtraAsString("measureUnit"));
            session.addMeasurements((Measurement)measure);
        }
        List<MeasurementExportEntity> gesBeanInfo = datas.get(measurementGesInfo);
        for (MeasurementExportEntity beanInfo : gesBeanInfo) {
            String mesureValue4;
            String measureType4;
            MeasurementSession session = this.getMeasurementSession((MultiKeyMap<Object, MeasurementSession>)sessionCache, beanInfo);
            MeasureImpl measure = new MeasureImpl();
            measure.setMeasurementType(MeasurementType.GES);
            measure.setMeasuringProtocol(beanInfo.getExtraAsString("measuringProtocol"));
            String repetitionNumber = beanInfo.getExtraAsString("repetitionNumber");
            if (StringUtils.isNotBlank((CharSequence)repetitionNumber)) {
                measure.setRepetitionNumber(Integer.valueOf(Integer.parseInt(repetitionNumber)));
            }
            measure.setComment(beanInfo.getExtraAsString("comment"));
            measure.setSampling(beanInfo.getExtraAsString("sampling"));
            String variableMesuree3 = beanInfo.getExtraAsString("variable_mesuree");
            if (StringUtils.isNotBlank((CharSequence)variableMesuree3)) {
                RefMesure refMesure3 = (RefMesure)this.refMesureDao.forProperties("variable_mesuree", variableMesuree3, new Object[0]).findUnique();
                measure.setRefMesure(refMesure3);
            }
            if (StringUtils.isNotEmpty((CharSequence)(measureType4 = beanInfo.getExtraAsString("measureType")))) {
                measure.setMeasureType(MeasureType.valueOf((String)measureType4));
            }
            if (StringUtils.isNotBlank((CharSequence)(mesureValue4 = beanInfo.getExtraAsString("measureValue")))) {
                measure.setMeasureValue(mesureValue4);
            }
            measure.setMeasureUnit(beanInfo.getExtraAsString("measureUnit"));
            session.addMeasurements((Measurement)measure);
        }
        List<MeasurementExportEntity> meteoBeanInfo = datas.get(measurementMeteoInfo);
        for (MeasurementExportEntity beanInfo : meteoBeanInfo) {
            MeasurementSession session = this.getMeasurementSession((MultiKeyMap<Object, MeasurementSession>)sessionCache, beanInfo);
            MeasureImpl measure = new MeasureImpl();
            measure.setMeasurementType(MeasurementType.METEO);
            measure.setMeasuringProtocol(beanInfo.getExtraAsString("measuringProtocol"));
            String repetitionNumber = beanInfo.getExtraAsString("repetitionNumber");
            if (StringUtils.isNotBlank((CharSequence)repetitionNumber)) {
                measure.setRepetitionNumber(Integer.valueOf(Integer.parseInt(repetitionNumber)));
            }
            measure.setComment(beanInfo.getExtraAsString("comment"));
            measure.setSampling(beanInfo.getExtraAsString("sampling"));
            String variableMesuree4 = beanInfo.getExtraAsString("variable_mesuree");
            if (StringUtils.isNotBlank((CharSequence)variableMesuree4)) {
                RefMesure refMesure4 = (RefMesure)this.refMesureDao.forProperties("variable_mesuree", variableMesuree4, new Object[0]).findUnique();
                measure.setRefMesure(refMesure4);
            }
            if (StringUtils.isNotEmpty((CharSequence)(measureType = beanInfo.getExtraAsString("measureType")))) {
                measure.setMeasureType(MeasureType.valueOf((String)measureType));
            }
            if (StringUtils.isNotBlank((CharSequence)(mesureValue = beanInfo.getExtraAsString("measureValue")))) {
                measure.setMeasureValue(mesureValue);
            }
            measure.setMeasureUnit(beanInfo.getExtraAsString("measureUnit"));
            session.addMeasurements((Measurement)measure);
        }
        for (MeasurementSession session : sessionCache.values()) {
            if (session.isPersisted()) {
                this.measurementSessionDao.update((TopiaEntity)session);
                continue;
            }
            this.measurementSessionDao.create((TopiaEntity)session);
        }
        this.getTransaction().commit();
    }

    protected MeasurementSession getMeasurementSession(MultiKeyMap<Object, MeasurementSession> sessionCache, final MeasurementExportEntity beanInfo) {
        MeasurementSession result;
        MultiKey key = new MultiKey(new Object[]{beanInfo.getZoneName(), beanInfo.getPlotName(), beanInfo.getDomainName(), beanInfo.getCampaign(), beanInfo.getStartDate(), beanInfo.getEndDate()});
        if (sessionCache.containsKey((Object)key)) {
            result = (MeasurementSession)sessionCache.get((Object)key);
        } else {
            Zone zone = (Zone)this.zoneDao.forProperties("name", beanInfo.getZoneName(), new Object[]{"plot.name", beanInfo.getPlotName(), "plot.domain.name", beanInfo.getDomainName(), "plot.domain.campaign", beanInfo.getCampaign()}).findUnique();
            List sessions = this.measurementSessionDao.forZoneEquals(zone).findAll();
            Optional session = Iterables.tryFind((Iterable)sessions, (Predicate)new Predicate<MeasurementSession>(){

                public boolean apply(MeasurementSession input) {
                    Date startDate = DateUtils.truncate((Date)input.getStartDate(), (int)5);
                    Date endDate = DateUtils.truncate((Date)input.getEndDate(), (int)5);
                    return startDate.equals(beanInfo.getStartDate()) && endDate.equals(beanInfo.getEndDate());
                }
            });
            if (session.isPresent()) {
                result = (MeasurementSession)session.get();
            } else {
                result = new MeasurementSessionImpl();
                result.setStartDate(beanInfo.getStartDate());
                result.setEndDate(beanInfo.getEndDate());
                result.setZone(zone);
            }
            sessionCache.put(key, (Object)result);
        }
        return result;
    }
}

