/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.managementmode.export;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.managementmode.Section;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

public class ManagementModeExportMetadata {

    public static class ManagementModeSectionBeanInfo
    extends ManagementModeCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Rubriques";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap columns = new DualLinkedHashBidiMap();
            columns.put((Object)"sectionType", (Object)"Type de rubrique");
            columns.put((Object)"agronomicObjective", (Object)"Objectifs agronomiques");
            columns.put((Object)"categoryObjective", (Object)"Cat\u00e9gorie d'objectif");
            columns.put((Object)"expectedResult", (Object)"R\u00e9sultats attendus");
            columns.put((Object)"bioAgressorType", (Object)"Type de bio-agresseur");
            columns.put((Object)"bioAgressor", (Object)"Bio-agresseur consid\u00e9r\u00e9");
            columns.put((Object)"categoryStrategy", (Object)"Cat\u00e9gorie de strat\u00e9gie globale");
            columns.put((Object)"StrategyMultiannual", (Object)"Type de strat\u00e9gie");
            columns.put((Object)"StrategyExplanation", (Object)"Explication");
            columns.put((Object)"StrategyCroppingPlanEntry", (Object)"Culture");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("bioAgressor", new Function<K, Object>(){

                public Object apply(K input) {
                    Preconditions.checkArgument((boolean)(input instanceof Section));
                    Section section = (Section)input;
                    RefBioAgressor bioAgressor = section.getBioAgressor();
                    String result = null;
                    if (bioAgressor != null) {
                        result = bioAgressor.getLabel();
                    }
                    return result;
                }
            });
            return result;
        }
    }

    public static class ManagementModeMainBeanInfo
    extends ManagementModeCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "G\u00e9n\u00e9ralit\u00e9s";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap columns = new DualLinkedHashBidiMap();
            columns.put((Object)"mainChanges", (Object)"Principaux changements");
            columns.put((Object)"changeReason", (Object)"Motifs de changement");
            columns.put((Object)"changeReasonFromPlanned", (Object)"Principaux changements depuis le pr\u00e9vu");
            columns.put((Object)"mainChangesFromPlanned", (Object)"Motifs de changement depuis le pr\u00e9vu");
            return columns;
        }
    }

    public static abstract class ManagementModeCommonBeanInfo
    extends AbstractAgrosystService
    implements EntityExportTabInfo {
        @Override
        public BidiMap<String, String> getCommonColumns() {
            DualLinkedHashBidiMap result = new DualLinkedHashBidiMap();
            result.put((Object)"category", (Object)"Modes de gestion");
            result.put((Object)"growingSystemName", (Object)"Syst\u00e8me de culture");
            result.put((Object)"growingPlanName", (Object)"Dispositif");
            result.put((Object)"domainName", (Object)"Domaine");
            result.put((Object)"campaign", (Object)"campagne");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap result = new DualLinkedHashBidiMap();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            LinkedHashMap result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            HashMap result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            return result;
        }
    }
}

