/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.managementmode.export;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class DecisionRuleExportMetadata {

    public static class DecisionRuleMainBeanInfo
    extends DecisionRuleCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "G\u00e9n\u00e9ralit\u00e9s";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap columns = new DualLinkedHashBidiMap();
            columns.put((Object)"name", (Object)"Nom");
            columns.put((Object)"interventionType", (Object)"Type d'intervention");
            columns.put((Object)"croppingPlanEntry", (Object)"Culture concern\u00e9e");
            columns.put((Object)"bioAgressorType", (Object)"Type de bio-agresseur");
            columns.put((Object)"bioAgressor", (Object)"Bio-agresseur concern\u00e9");
            columns.put((Object)"versionNumber", (Object)"Version");
            columns.put((Object)"domainValidity", (Object)"Domaine de validit\u00e9");
            columns.put((Object)"decisionObject", (Object)"Objet de la d\u00e9cision");
            columns.put((Object)"usageComment", (Object)"Commentaire sur l'utilisation de la r\u00e8gle de d\u00e9cision");
            columns.put((Object)"objective", (Object)"Objectif");
            columns.put((Object)"expectedResult", (Object)"R\u00e9sultat attendu ");
            columns.put((Object)"solution", (Object)"Solution");
            columns.put((Object)"decisionCriteria", (Object)"Crit\u00e8re de d\u00e9cision ou seuil");
            columns.put((Object)"observation", (Object)"Observation ou outil");
            columns.put((Object)"resultCriteria", (Object)"Crit\u00e8re d'\u00e9valuation du r\u00e9sultat attendu");
            columns.put((Object)"solutionComment", (Object)"Commentaire sur la solution");
            columns.put((Object)"versionReason", (Object)"Motif de changement de version");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("bioAgressor", new Function<K, Object>(){

                public Object apply(K input) {
                    DecisionRule decisionRule = (DecisionRule)input;
                    RefBioAgressor bioAgressor = decisionRule.getBioAgressor();
                    String result = null;
                    if (bioAgressor != null) {
                        result = bioAgressor.getLabel();
                    }
                    return result;
                }
            });
            result.put("croppingPlanEntry", new Function<K, Object>(){

                public Object apply(K input) {
                    DecisionRule decisionRule = (DecisionRule)input;
                    String croppingPlanEntryCode = decisionRule.getCroppingPlanEntryCode();
                    String result = null;
                    if (StringUtils.isNotBlank((CharSequence)croppingPlanEntryCode)) {
                        CroppingPlanEntry crop = (CroppingPlanEntry)DecisionRuleMainBeanInfo.this.croppingPlanEntryTopiaDao.forCodeEquals(croppingPlanEntryCode).findAny();
                        result = crop.getName();
                    }
                    return result;
                }
            });
            result.put("solution", new Function<K, Object>(){

                public Object apply(K input) {
                    DecisionRule decisionRule = (DecisionRule)input;
                    String solution = decisionRule.getSolution();
                    String result = null;
                    if (StringUtils.isNotBlank((CharSequence)solution)) {
                        solution = solution.replaceAll("\\<[^>]*>", "");
                        result = StringEscapeUtils.unescapeHtml4((String)solution);
                    }
                    return result;
                }
            });
            return result;
        }
    }

    public static abstract class DecisionRuleCommonBeanInfo
    extends AbstractAgrosystService
    implements EntityExportTabInfo {
        protected CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao;

        @Override
        public BidiMap<String, String> getCommonColumns() {
            DualLinkedHashBidiMap result = new DualLinkedHashBidiMap();
            result.put((Object)"domainName", (Object)"Domaine");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap result = new DualLinkedHashBidiMap();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            LinkedHashMap result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            HashMap result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            return result;
        }

        public void setCroppingPlanEntryTopiaDao(CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao) {
            this.croppingPlanEntryTopiaDao = croppingPlanEntryTopiaDao;
        }
    }
}

