/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.managementmode;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRuleTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.Section;
import fr.inra.agrosyst.api.entities.managementmode.SectionTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.SectionType;
import fr.inra.agrosyst.api.entities.managementmode.Strategy;
import fr.inra.agrosyst.api.entities.managementmode.StrategyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefAdventiceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressorTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDITopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.common.HistoryItem;
import fr.inra.agrosyst.api.services.common.HistoryType;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.ExtendContext;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.managementmode.DecisionRuleFilter;
import fr.inra.agrosyst.api.services.managementmode.DecisionRulesDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeFilter;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.managementmode.SectionDto;
import fr.inra.agrosyst.api.services.managementmode.StrategyDto;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.managementmode.export.DecisionRuleExportEntity;
import fr.inra.agrosyst.services.managementmode.export.DecisionRuleExportMetadata;
import fr.inra.agrosyst.services.managementmode.export.ManagementModeExportEntity;
import fr.inra.agrosyst.services.managementmode.export.ManagementModeExportMetadata;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.PagerBean;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ManagementModeServiceImpl
extends AbstractAgrosystService
implements ManagementModeService {
    protected BusinessAuthorizationService authorizationService;
    protected AnonymizeService anonymizeService;
    protected DecisionRuleTopiaDao decisionRuleTopiaDao;
    protected RefNuisibleEDITopiaDao refNuisibleEDITopiaDao;
    protected RefAdventiceTopiaDao refAdventiceTopiaDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao;
    protected GrowingSystemTopiaDao growingSystemTopiaDao;
    protected DomainTopiaDao domainTopiaDao;
    protected ManagementModeTopiaDao managementModeTopiaDao;
    protected RefBioAgressorTopiaDao refBioAgressorTopiaDao;
    protected SectionTopiaDao sectionTopiaDao;
    protected StrategyTopiaDao strategyTopiaDao;

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setDecisionRuleTopiaDao(DecisionRuleTopiaDao decisionRuleTopiaDao) {
        this.decisionRuleTopiaDao = decisionRuleTopiaDao;
    }

    public void setRefNuisibleEDITopiaDao(RefNuisibleEDITopiaDao refNuisibleEDITopiaDao) {
        this.refNuisibleEDITopiaDao = refNuisibleEDITopiaDao;
    }

    public void setRefAdventiceTopiaDao(RefAdventiceTopiaDao refAdventiceTopiaDao) {
        this.refAdventiceTopiaDao = refAdventiceTopiaDao;
    }

    public void setCroppingPlanEntryTopiaDao(CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao) {
        this.croppingPlanEntryTopiaDao = croppingPlanEntryTopiaDao;
    }

    public void setDomainTopiaDao(DomainTopiaDao domainTopiaDao) {
        this.domainTopiaDao = domainTopiaDao;
    }

    public void setGrowingSystemTopiaDao(GrowingSystemTopiaDao growingSystemTopiaDao) {
        this.growingSystemTopiaDao = growingSystemTopiaDao;
    }

    public void setManagementModeTopiaDao(ManagementModeTopiaDao managementModeTopiaDao) {
        this.managementModeTopiaDao = managementModeTopiaDao;
    }

    public void setRefBioAgressorTopiaDao(RefBioAgressorTopiaDao refBioAgressorTopiaDao) {
        this.refBioAgressorTopiaDao = refBioAgressorTopiaDao;
    }

    public void setSectionTopiaDao(SectionTopiaDao sectionTopiaDao) {
        this.sectionTopiaDao = sectionTopiaDao;
    }

    public void setStrategyTopiaDao(StrategyTopiaDao strategyTopiaDao) {
        this.strategyTopiaDao = strategyTopiaDao;
    }

    public ResultList<DecisionRulesDto> getFilteredDecisionRules(DecisionRuleFilter filter) {
        ResultList<DecisionRule> decisionRules = this.decisionRuleTopiaDao.getFilteredDecisionRules(filter, this.getSecurityContext());
        PagerBean pager = decisionRules.getPager();
        ArrayList decisionRulesDtos = Lists.newArrayListWithCapacity((int)decisionRules.getElements().size());
        Binder binder = BinderFactory.newBinder(DecisionRule.class, DecisionRulesDto.class);
        Function domainToDtoFunction = this.anonymizeService.getDomainToDtoFunction(false);
        for (DecisionRule decisionRule : decisionRules) {
            DecisionRulesDto decisionRulesDto = new DecisionRulesDto();
            DecisionRule maxVersionRule = (DecisionRule)this.decisionRuleTopiaDao.forProperties("active", decisionRule.isActive(), new Object[]{"code", decisionRule.getCode()}).setOrderByArguments(new String[]{"versionNumber DESC"}).findFirst();
            binder.copy((Object)maxVersionRule, (Object)decisionRulesDto, new String[0]);
            Domain relatedRulesDomain = (Domain)this.domainTopiaDao.forProperties("active", true, new Object[]{"code", decisionRule.getDomainCode()}).findAnyOrNull();
            if (relatedRulesDomain == null) continue;
            decisionRulesDto.setDomain((DomainDto)domainToDtoFunction.apply((Object)relatedRulesDomain));
            decisionRulesDtos.add(decisionRulesDto);
        }
        ResultList result = ResultList.of((List)decisionRulesDtos, (PagerBean)pager);
        return result;
    }

    public DecisionRule newDecisionRule() {
        DecisionRule decisionRule = (DecisionRule)this.decisionRuleTopiaDao.newInstance();
        decisionRule.setActive(true);
        decisionRule.setSolution("<p><strong>si</strong>&nbsp;</p><p><strong>alors</strong>&nbsp;</p><p><strong>sinon</strong>&nbsp;</p>");
        decisionRule.setCode(UUID.randomUUID().toString());
        decisionRule.setVersionNumber(1);
        return decisionRule;
    }

    public DecisionRule getDecisionRule(String decisionRuleTopiaId) {
        DecisionRule result = (DecisionRule)this.decisionRuleTopiaDao.forTopiaIdEquals(decisionRuleTopiaId).findUnique();
        return result;
    }

    public DecisionRule getLastDecisionRuleVersion(String decisionRuleCode) {
        DecisionRule result = this.decisionRuleTopiaDao.getLastRuleVersion(decisionRuleCode);
        return result;
    }

    public List<BioAgressorType> getBioAgressorTypes() {
        ArrayList result = Lists.newArrayList();
        result.add(BioAgressorType.ADVENTICE);
        result.addAll(this.refNuisibleEDITopiaDao.findAllActiveParam());
        return result;
    }

    public <E extends RefBioAgressor> List<E> getBioAgressors(BioAgressorType bioAgressorType) {
        List result = bioAgressorType == BioAgressorType.ADVENTICE ? this.refAdventiceTopiaDao.forActiveEquals(true).findAll() : this.refNuisibleEDITopiaDao.forReference_paramEquals(bioAgressorType).findAll();
        return result;
    }

    @Deprecated
    protected List<CroppingPlanEntry> getCroppingPlan0(String domainId) {
        String propertyDomainId = "domain.topiaId";
        return this.croppingPlanEntryTopiaDao.forProperties(propertyDomainId, domainId, new Object[0]).findAll();
    }

    public List<CroppingPlanEntry> getDomainCodeCroppingPlanEntries(String domainCode) {
        List<CroppingPlanEntry> result = this.managementModeTopiaDao.getCroppingPlanEntryWithDomainCode(domainCode);
        return result;
    }

    public List<CroppingPlanEntry> getGrowingSystemCroppingPlanEntries(String growingSystemTopiaId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)growingSystemTopiaId) ? 1 : 0) != 0);
        GrowingSystem growingSystem = (GrowingSystem)this.growingSystemTopiaDao.forTopiaIdEquals(growingSystemTopiaId).findUnique();
        List<CroppingPlanEntry> result = this.getCroppingPlan0(growingSystem.getGrowingPlan().getDomain().getTopiaId());
        return result;
    }

    public CroppingPlanEntry getCroppingPlanEntries(String croppingPlanEntryTopiaId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)croppingPlanEntryTopiaId) ? 1 : 0) != 0);
        CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryTopiaDao.forTopiaIdEquals(croppingPlanEntryTopiaId).findUnique();
        return croppingPlanEntry;
    }

    public Collection<DecisionRule> getGrowingSystemDecisionRules(String growingSystemTopiaId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)growingSystemTopiaId) ? 1 : 0) != 0);
        GrowingSystem growingSystem = (GrowingSystem)this.growingSystemTopiaDao.forTopiaIdEquals(growingSystemTopiaId).findUnique();
        List decisionRules = this.decisionRuleTopiaDao.forActiveEquals(true).addEquals("domainCode", (Object)growingSystem.getGrowingPlan().getDomain().getCode()).setOrderByArguments(new String[]{"code", "versionNumber DESC"}).findAll();
        HashMap lastVersionDecisionRules = Maps.newHashMap();
        for (DecisionRule decisionRule : decisionRules) {
            if (lastVersionDecisionRules.get(decisionRule.getCode()) != null) continue;
            lastVersionDecisionRules.put(decisionRule.getCode(), decisionRule);
        }
        return lastVersionDecisionRules.values();
    }

    public DecisionRule createOrUpdateDecisionRule(DecisionRule decisionRule, String domainCode, String croppingPlanEntryCode, String bioAgressorTopiaId) {
        DecisionRule result;
        this.authorizationService.checkCreateOrUpdateDecisionRule(decisionRule.getTopiaId());
        DecisionRule originalDecisionRule = null;
        if (decisionRule.getTopiaId() == null) {
            if (StringUtils.isBlank((CharSequence)domainCode)) {
                throw new AgrosystTechnicalException("Domain can't be null");
            }
            Preconditions.checkState((this.domainTopiaDao.forCodeEquals(domainCode).count() > 0L ? 1 : 0) != 0);
            decisionRule.setDomainCode(domainCode);
        } else {
            originalDecisionRule = (DecisionRule)this.decisionRuleTopiaDao.forTopiaIdEquals(decisionRule.getTopiaId()).findUnique();
        }
        decisionRule.setCroppingPlanEntryCode(croppingPlanEntryCode);
        RefBioAgressor bioAgressor = null;
        if (StringUtils.isNotBlank((CharSequence)bioAgressorTopiaId)) {
            bioAgressor = (RefBioAgressor)this.refBioAgressorTopiaDao.forTopiaIdEquals(bioAgressorTopiaId).findUnique();
        }
        decisionRule.setBioAgressor(bioAgressor);
        if (originalDecisionRule != null) {
            Binder binder = BinderFactory.newBinder(DecisionRule.class);
            binder.copyExcluding((Object)decisionRule, (Object)originalDecisionRule, new String[]{"topiaId"});
            result = (DecisionRule)this.decisionRuleTopiaDao.update((TopiaEntity)originalDecisionRule);
        } else {
            result = (DecisionRule)this.decisionRuleTopiaDao.create((TopiaEntity)decisionRule);
        }
        final String newName = result.getName();
        List<DecisionRule> relatedDecisionRules = this.getRelatedDecisionRules(result.getCode());
        Iterable rulesWithDifferentName = Iterables.filter(relatedDecisionRules, (Predicate)new Predicate<DecisionRule>(){

            public boolean apply(DecisionRule related) {
                return !newName.equals(related.getName());
            }
        });
        for (DecisionRule related : rulesWithDifferentName) {
            related.setName(newName);
            this.decisionRuleTopiaDao.update((TopiaEntity)related);
        }
        this.getTransaction().commit();
        return result;
    }

    public DecisionRule createNewDecisionRule(AgrosystInterventionType interventionType, String growingSystemTopiaId, BioAgressorType bioAgressorType, String bioAgressorTopiaId, String croppingPlanEntryId, String name) {
        Preconditions.checkNotNull((Object)growingSystemTopiaId);
        Preconditions.checkNotNull((Object)interventionType);
        Preconditions.checkNotNull((Object)name);
        GrowingSystem growingSystem = (GrowingSystem)this.growingSystemTopiaDao.forTopiaIdEquals(growingSystemTopiaId).findUnique();
        RefBioAgressor bioAgressor = null;
        if (!Strings.isNullOrEmpty((String)bioAgressorTopiaId)) {
            bioAgressor = (RefBioAgressor)this.refBioAgressorTopiaDao.forTopiaIdEquals(bioAgressorTopiaId).findUnique();
        }
        String croppingPlanEntryCode = null;
        if (!Strings.isNullOrEmpty((String)croppingPlanEntryId)) {
            croppingPlanEntryCode = ((CroppingPlanEntry)this.croppingPlanEntryTopiaDao.forTopiaIdEquals(croppingPlanEntryId).findUnique()).getCode();
        }
        DecisionRule decisionRule = this.newDecisionRule();
        decisionRule.setDomainCode(growingSystem.getGrowingPlan().getDomain().getCode());
        decisionRule.setBioAgressorType(bioAgressorType);
        decisionRule.setBioAgressor(bioAgressor);
        decisionRule.setName(name);
        decisionRule.setInterventionType(interventionType);
        decisionRule.setCroppingPlanEntryCode(croppingPlanEntryCode);
        DecisionRule result = (DecisionRule)this.decisionRuleTopiaDao.create((TopiaEntity)decisionRule);
        this.getTransaction().commit();
        return result;
    }

    public ResultList<ManagementModeDto> getFilteredManagementModeDtos(ManagementModeFilter managementModeFilter) {
        Pair<Map<GrowingSystem, ManagementModeDto>, PagerBean> mmList = this.managementModeTopiaDao.getFilteredManagementModeDtos(managementModeFilter, this.getSecurityContext());
        Set entries = ((Map)mmList.getLeft()).entrySet();
        final Function growingSystemToDtoFunction = this.anonymizeService.getGrowingSystemToDtoFunction();
        Iterable list = Iterables.transform(entries, (Function)new Function<Map.Entry<GrowingSystem, ManagementModeDto>, ManagementModeDto>(){

            public ManagementModeDto apply(Map.Entry<GrowingSystem, ManagementModeDto> input) {
                GrowingSystemDto growingSystemDto = (GrowingSystemDto)growingSystemToDtoFunction.apply((Object)input.getKey());
                ManagementModeDto result = input.getValue();
                result.setGrowingSystem(growingSystemDto);
                return result;
            }
        });
        ResultList result = ResultList.of((List)Lists.newArrayList((Iterable)list), (PagerBean)((PagerBean)mmList.getRight()));
        return result;
    }

    public ManagementMode newManagementMode() {
        ManagementMode managementMode = (ManagementMode)this.managementModeTopiaDao.newInstance();
        managementMode.setActive(true);
        return managementMode;
    }

    public ManagementMode getManagementMode(String managementModeTopiaId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)managementModeTopiaId) ? 1 : 0) != 0);
        ManagementMode managementMode = (ManagementMode)this.managementModeTopiaDao.forTopiaIdEquals(managementModeTopiaId).findUnique();
        ManagementMode result = this.anonymizeService.checkForManagementModeAnonymization(managementMode);
        return result;
    }

    public ManagementMode createOrUpdateManagementMode(ManagementMode managementMode, String growingSystemTopiaId, Collection<SectionDto> sections) {
        this.authorizationService.checkCreateOrUpdateManagementMode(managementMode.getTopiaId());
        Preconditions.checkNotNull((Object)managementMode.getCategory());
        if (!managementMode.isPersisted()) {
            if (StringUtils.isBlank((CharSequence)growingSystemTopiaId)) {
                throw new AgrosystTechnicalException("Growing system can't be null");
            }
            GrowingSystem growingSystem = (GrowingSystem)this.growingSystemTopiaDao.forTopiaIdEquals(growingSystemTopiaId).findUnique();
            managementMode.setGrowingSystem(growingSystem);
        }
        this.updateManagementModeSections(managementMode, sections);
        if (managementMode.isPersisted()) {
            managementMode = (ManagementMode)this.managementModeTopiaDao.update((TopiaEntity)managementMode);
        } else {
            ArrayList histories = Lists.newArrayList();
            Gson gson = this.context.getGson();
            histories.add(this.createNewManagementModeHistory(managementMode));
            managementMode.setHistorical(gson.toJson((Object)histories));
            managementMode = (ManagementMode)this.managementModeTopiaDao.create((TopiaEntity)managementMode);
        }
        this.getTransaction().commit();
        return managementMode;
    }

    protected void updateManagementModeSections(ManagementMode managementMode, Collection<SectionDto> sections) {
        if (sections != null) {
            Date transactionDate = this.context.getCurrentDate();
            String previousHistory = managementMode.getHistorical();
            Gson gson = this.context.getGson();
            Type type = new TypeToken<List<HistoryItem>>(){}.getType();
            List histories = previousHistory != null ? (List)gson.fromJson(previousHistory, type) : Lists.newArrayList();
            Collection currentSections = managementMode.getSections();
            ArrayList nonDeletedSection = Lists.newArrayList();
            if (currentSections == null) {
                currentSections = Lists.newArrayList();
                managementMode.setSections(currentSections);
            }
            ImmutableMap sectionsIndex = Maps.uniqueIndex((Iterable)currentSections, (Function)Entities.GET_TOPIA_ID);
            for (SectionDto sectionDto : sections) {
                Section section;
                String topiaId = sectionDto.getTopiaId();
                RefBioAgressor bioAgressor = null;
                if (StringUtils.isNotBlank((CharSequence)sectionDto.getBioAgressorTopiaId())) {
                    bioAgressor = (RefBioAgressor)this.refBioAgressorTopiaDao.forTopiaIdEquals(sectionDto.getBioAgressorTopiaId()).findUnique();
                }
                if (StringUtils.isBlank((CharSequence)topiaId)) {
                    section = (Section)this.sectionTopiaDao.newInstance();
                    HistoryItem historyItem = this.createHistoryItemSectionAdd(sectionDto, bioAgressor, transactionDate);
                    histories.add(historyItem);
                } else {
                    section = (Section)sectionsIndex.get(topiaId);
                }
                section.setAgronomicObjective(sectionDto.getAgronomicObjective());
                section.setBioAgressorType(sectionDto.getBioAgressorType());
                section.setExpectedResult(sectionDto.getExpectedResult());
                section.setSectionType(sectionDto.getSectionType());
                section.setCategoryObjective(sectionDto.getCategoryObjective());
                section.setCategoryStrategy(sectionDto.getCategoryStrategy());
                section.setBioAgressor(bioAgressor);
                if (StringUtils.isBlank((CharSequence)topiaId)) {
                    currentSections.add(section);
                }
                nonDeletedSection.add(section);
                List<HistoryItem> strategiesHistories = this.updateSectionStrategies(section, sectionDto.getStrategiesDto());
                histories.addAll(strategiesHistories);
            }
            Collection removedSections = CollectionUtils.subtract((Iterable)currentSections, (Iterable)nonDeletedSection);
            if (removedSections != null) {
                for (Section section : removedSections) {
                    HistoryItem historyItem = this.createHistoryItemSectionRemove(section, section.getBioAgressor(), transactionDate);
                    histories.add(historyItem);
                }
            }
            managementMode.setHistorical(gson.toJson((Object)histories));
            currentSections.retainAll(nonDeletedSection);
        }
    }

    protected HistoryItem createHistoryItemSectionAdd(SectionDto sectionDto, RefBioAgressor bioAgressor, Date transactionDate) {
        HistoryItem historyItem = this.createHistoryItemSection(sectionDto.getSectionType(), sectionDto.getBioAgressorType(), bioAgressor, transactionDate, HistoryType.SECTION_ADD);
        return historyItem;
    }

    protected HistoryItem createHistoryItemSectionRemove(Section section, RefBioAgressor bioAgressor, Date transactionDate) {
        HistoryItem historyItem = this.createHistoryItemSection(section.getSectionType(), section.getBioAgressorType(), bioAgressor, transactionDate, HistoryType.SECTION_REMOVE);
        return historyItem;
    }

    protected HistoryItem createHistoryItemSection(SectionType sectionType, BioAgressorType bioAgressorType, RefBioAgressor bioAgressor, Date transactionDate, HistoryType type) {
        HistoryItem historyItem = new HistoryItem();
        historyItem.setDate(transactionDate);
        historyItem.setType(type);
        List args = historyItem.getArgs();
        args.add(sectionType.name());
        if (bioAgressorType != null) {
            args.add(bioAgressorType.name());
        } else {
            args.add(null);
        }
        if (bioAgressor != null) {
            args.add(bioAgressor.getTopiaId());
        } else {
            args.add(null);
        }
        return historyItem;
    }

    protected List<HistoryItem> updateSectionStrategies(Section section, List<StrategyDto> strategies) {
        ArrayList historiesItems = Lists.newArrayList();
        if (strategies != null) {
            List currentStrategies = section.getStrategies();
            ArrayList nonDeletedStrategies = Lists.newArrayList();
            if (currentStrategies == null) {
                currentStrategies = Lists.newArrayList();
                section.setStrategies(currentStrategies);
            }
            ImmutableMap strategiesIndex = Maps.uniqueIndex((Iterable)currentStrategies, (Function)Entities.GET_TOPIA_ID);
            for (StrategyDto strategyDto : strategies) {
                Strategy strategy;
                String topiaId = strategyDto.getTopiaId();
                if (StringUtils.isBlank((CharSequence)topiaId)) {
                    strategy = (Strategy)this.strategyTopiaDao.newInstance();
                    historiesItems.add(this.createStrategyHistoryAdd(strategyDto));
                } else {
                    strategy = (Strategy)strategiesIndex.get(topiaId);
                }
                strategy.setStrategyType(strategyDto.getStrategyType());
                strategy.setExplanation(strategyDto.getExplanation());
                strategy.setCroppingPlanManagmentName(strategyDto.getCroppingPlanManagmentName());
                strategy.setMultiannual(strategyDto.isMultiannual());
                CroppingPlanEntry croppingPlanEntry = null;
                if (StringUtils.isNotBlank((CharSequence)strategyDto.getCroppingPlanEntryId())) {
                    croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryTopiaDao.forTopiaIdEquals(strategyDto.getCroppingPlanEntryId()).findUnique();
                }
                strategy.setCroppingPlanEntry(croppingPlanEntry);
                Collection currentRules = strategy.getRules();
                if (currentRules == null) {
                    currentRules = Lists.newArrayList();
                    strategy.setRules(currentRules);
                }
                HashMap indexedRules = Maps.newHashMap((Map)Maps.uniqueIndex((Iterable)currentRules, (Function)Entities.GET_TOPIA_ID));
                currentRules.clear();
                if (strategyDto.getDecisionRuleIds() != null) {
                    for (String decisionRuleId : strategyDto.getDecisionRuleIds()) {
                        DecisionRule decisionRule = (DecisionRule)indexedRules.remove(decisionRuleId);
                        if (decisionRule == null) {
                            decisionRule = (DecisionRule)this.decisionRuleTopiaDao.forTopiaIdEquals(decisionRuleId).findUnique();
                        }
                        currentRules.add(decisionRule);
                    }
                }
                historiesItems.addAll(this.createRulesHistoryAdd(currentRules));
                historiesItems.addAll(this.createRulesHistoryRemove(indexedRules.values()));
                if (StringUtils.isBlank((CharSequence)topiaId)) {
                    currentStrategies.add(strategy);
                }
                nonDeletedStrategies.add(strategy);
            }
            List removedStrategies = ListUtils.subtract((List)currentStrategies, (List)nonDeletedStrategies);
            historiesItems.addAll(this.createStrategyHistoryRemove(removedStrategies));
            currentStrategies.retainAll(nonDeletedStrategies);
        }
        return historiesItems;
    }

    protected HistoryItem createStrategyHistoryAdd(StrategyDto strategyDto) {
        HistoryItem item = this.createStrategyHistory(strategyDto.isMultiannual(), strategyDto.getExplanation(), strategyDto.getCroppingPlanEntryId(), HistoryType.STRATEGY_ADD);
        return item;
    }

    protected List<HistoryItem> createStrategyHistoryRemove(List<Strategy> strategies) {
        ArrayList result = Lists.newArrayListWithCapacity((int)strategies.size());
        for (Strategy strategy : strategies) {
            String croppingPanEntryId = strategy.getCroppingPlanEntry() == null ? null : strategy.getCroppingPlanEntry().getTopiaId();
            result.add(this.createStrategyHistory(strategy.isMultiannual(), strategy.getExplanation(), croppingPanEntryId, HistoryType.STRATEGY_REMOVE));
        }
        return result;
    }

    protected List<HistoryItem> createRulesHistoryAdd(Collection<DecisionRule> rules) {
        ArrayList result = Lists.newArrayListWithCapacity((int)rules.size());
        for (DecisionRule decisionRule : rules) {
            result.add(this.createRuleHistory(decisionRule, HistoryType.RULE_ADD));
        }
        return result;
    }

    protected List<HistoryItem> createRulesHistoryRemove(Collection<DecisionRule> rules) {
        ArrayList result = Lists.newArrayListWithCapacity((int)rules.size());
        for (DecisionRule decisionRule : rules) {
            result.add(this.createRuleHistory(decisionRule, HistoryType.RULE_REMOVE));
        }
        return result;
    }

    protected HistoryItem createRuleHistory(DecisionRule decisionRule, HistoryType type) {
        HistoryItem item = new HistoryItem();
        item.setDate(this.context.getCurrentDate());
        item.setType(type);
        ArrayList args = Lists.newArrayList((Object[])new String[]{decisionRule.getTopiaId(), String.valueOf(decisionRule.getVersionNumber())});
        item.setArgs((List)args);
        return item;
    }

    protected HistoryItem createStrategyHistory(Boolean isMultiannual, String explanation, String croppingPlanEntryId, HistoryType type) {
        HistoryItem item = new HistoryItem();
        item.setDate(this.context.getCurrentDate());
        item.setType(type);
        String multiannual = isMultiannual != false ? "true" : "false";
        ArrayList args = Lists.newArrayList((Object[])new String[]{multiannual, explanation, croppingPlanEntryId});
        item.setArgs((List)args);
        return item;
    }

    public ManagementMode getManagementModeByGrowingSystem(GrowingSystem growingSystem) {
        ManagementMode managementMode = (ManagementMode)this.managementModeTopiaDao.forGrowingSystemEquals(growingSystem).findAnyOrNull();
        return managementMode;
    }

    public ManagementMode extendManagementMode(ExtendContext extendContext, ManagementMode managementMode, GrowingSystem clonedGrowingSystem) {
        Preconditions.checkNotNull((Object)managementMode);
        Binder managementModeBinder = BinderFactory.newBinder(ManagementMode.class);
        ManagementMode clonedManagementMode = (ManagementMode)this.managementModeTopiaDao.newInstance();
        managementModeBinder.copyExcluding((Object)managementMode, (Object)clonedManagementMode, new String[]{"topiaId", "topiaCreateDate", "sections", "category", "growingSystem", "historical"});
        clonedManagementMode.setCategory(ManagementModeCategory.PLANNED);
        clonedManagementMode.setGrowingSystem(clonedGrowingSystem);
        ArrayList histories = Lists.newArrayList();
        Gson gson = this.context.getGson();
        histories.add(this.createManagementModeExtendHistory(managementMode, clonedManagementMode));
        clonedManagementMode.setHistorical(gson.toJson((Object)histories));
        this.cloneSections(managementMode, clonedManagementMode);
        ManagementMode result = (ManagementMode)this.managementModeTopiaDao.create((TopiaEntity)clonedManagementMode);
        return result;
    }

    protected HistoryItem createNewManagementModeHistory(ManagementMode managementMode) {
        HistoryItem result = this.createManagementModeHistory(HistoryType.MANAGEMENT_MODE_ADD, null, managementMode.getCategory().name());
        return result;
    }

    protected HistoryItem createManagementModeCopyHistory(ManagementMode fromManagementMode, ManagementMode toManagementMode) {
        HistoryItem result = this.createManagementModeHistory(HistoryType.MANAGEMENT_MODE_COPY, fromManagementMode.getCategory().name(), toManagementMode.getCategory().name());
        return result;
    }

    protected HistoryItem createManagementModeExtendHistory(ManagementMode fromManagementMode, ManagementMode toManagementMode) {
        HistoryItem result = this.createManagementModeHistory(HistoryType.MANAGEMENT_MODE_EXTEND, fromManagementMode.getCategory().name(), toManagementMode.getCategory().name());
        return result;
    }

    protected HistoryItem createManagementModeHistory(HistoryType type, String fromManagementModeCategoryName, String toManagementModeCategoryName) {
        HistoryItem item = new HistoryItem();
        item.setDate(this.context.getCurrentDate());
        item.setType(type);
        ArrayList args = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)fromManagementModeCategoryName)) {
            args.add(fromManagementModeCategoryName);
        }
        args.add(toManagementModeCategoryName);
        item.setArgs((List)args);
        return item;
    }

    protected void cloneSections(ManagementMode managementMode, ManagementMode clonedManagementMode) {
        if (managementMode != null && managementMode.getSections() != null) {
            for (Section section : managementMode.getSections()) {
                Binder sectionModeBinder = BinderFactory.newBinder(Section.class);
                Section clonedSection = (Section)this.sectionTopiaDao.newInstance();
                sectionModeBinder.copyExcluding((Object)section, (Object)clonedSection, new String[]{"topiaId", "strategies"});
                clonedManagementMode.addSections(clonedSection);
                if (section.getStrategies() == null) continue;
                for (Strategy strategy : section.getStrategies()) {
                    Binder strategyModeBinder = BinderFactory.newBinder(Strategy.class);
                    Strategy clonedStrategy = (Strategy)this.strategyTopiaDao.newInstance();
                    strategyModeBinder.copyExcluding((Object)strategy, (Object)clonedStrategy, new String[]{"topiaId", "rules"});
                    clonedSection.addStrategies(clonedStrategy);
                    if (strategy.getRules() == null) continue;
                    clonedStrategy.setRules((Collection)Lists.newArrayList((Iterable)strategy.getRules()));
                }
            }
        }
    }

    public List<DecisionRule> getRelatedDecisionRules(String code) {
        List<DecisionRule> result = this.decisionRuleTopiaDao.findAllRelatedDecisionRules(code);
        return result;
    }

    public DecisionRule createNewDecisonRuleVersion(String decisionRuleCode, String comment) {
        DecisionRule decisionRule = this.decisionRuleTopiaDao.getLastRuleVersion(decisionRuleCode);
        this.authorizationService.checkCreateOrUpdateDecisionRule(decisionRule.getTopiaId());
        Binder binder = BinderFactory.newBinder(DecisionRule.class);
        DecisionRule newDecisionRuleVersion = (DecisionRule)this.decisionRuleTopiaDao.newInstance();
        binder.copyExcluding((Object)decisionRule, (Object)newDecisionRuleVersion, new String[]{"topiaId", "topiaCreateDate", "versionNumber", "versionReason"});
        newDecisionRuleVersion.setVersionReason(comment);
        newDecisionRuleVersion.setVersionNumber(decisionRule.getVersionNumber() + 1);
        DecisionRule created = (DecisionRule)this.decisionRuleTopiaDao.create((TopiaEntity)newDecisionRuleVersion);
        this.getTransaction().commit();
        return created;
    }

    public List<ManagementModeCategory> getAvailableManagementModeCategories(String growingSystemId) {
        List<Object> usedManagementMode = !Strings.isNullOrEmpty((String)growingSystemId) ? this.managementModeTopiaDao.findManagementModeCategories(growingSystemId) : Lists.newArrayListWithCapacity((int)0);
        List result = ListUtils.subtract(Arrays.asList(ManagementModeCategory.values()), (List)usedManagementMode);
        return result;
    }

    public List<ManagementMode> getRelatedManagementModes(GrowingSystem growingSystem) {
        List result = this.managementModeTopiaDao.forGrowingSystemEquals(growingSystem).setOrderByArguments(new String[]{"category DESC"}).findAll();
        return result;
    }

    public ManagementMode copyManagementMode(String growingSystemId, ManagementModeCategory category, String mainChangesFromPlanned, String changeReasonFromPlanned) {
        Preconditions.checkNotNull((Object)growingSystemId);
        Preconditions.checkNotNull((Object)category);
        GrowingSystem growingSystem = (GrowingSystem)this.growingSystemTopiaDao.forTopiaIdEquals(growingSystemId).findUnique();
        ManagementMode newManagementMode = (ManagementMode)this.managementModeTopiaDao.newInstance();
        ArrayList histories = Lists.newArrayList();
        Gson gson = this.context.getGson();
        ManagementMode plannedManagementMode = (ManagementMode)this.managementModeTopiaDao.forGrowingSystemEquals(growingSystem).findUniqueOrNull();
        if (plannedManagementMode != null) {
            Binder binder = BinderFactory.newBinder(ManagementMode.class);
            binder.copyExcluding((Object)plannedManagementMode, (Object)newManagementMode, new String[]{"topiaId", "topiaCreateDate", "category", "sections", "historical"});
            newManagementMode.setCategory(ManagementModeCategory.OBSERVED);
            newManagementMode.setChangeReasonFromPlanned(changeReasonFromPlanned);
            newManagementMode.setMainChangesFromPlanned(mainChangesFromPlanned);
            histories.add(this.createManagementModeCopyHistory(plannedManagementMode, newManagementMode));
            newManagementMode.setHistorical(gson.toJson((Object)histories));
        }
        this.cloneSections(plannedManagementMode, newManagementMode);
        ManagementMode created = (ManagementMode)this.managementModeTopiaDao.create((TopiaEntity)newManagementMode);
        this.getTransaction().commit();
        return created;
    }

    public List<GrowingSystem> getGrowingSystemsForManagementMode(NavigationContext navigationContext) {
        List<GrowingSystem> result = this.growingSystemTopiaDao.getGrowingSystemsForManagementMode(navigationContext, this.getSecurityContext());
        return result;
    }

    public List<GrowingSystem> getAvailableGsForDuplication(String growingSystemId, NavigationContext navigationContext) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)growingSystemId) ? 1 : 0) != 0);
        GrowingSystem managementModeGrowingSystem = (GrowingSystem)this.growingSystemTopiaDao.forTopiaIdEquals(growingSystemId).findUnique();
        GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
        growingSystemFilter.setPageSize(-1);
        growingSystemFilter.setNavigationContext(navigationContext);
        ResultList<GrowingSystem> growingSystems = this.growingSystemTopiaDao.getFilteredGrowingSystems(growingSystemFilter, this.getSecurityContext());
        List<GrowingSystem> result = this.growingSystemTopiaDao.findAllAvailableForManagementModeDuplication(growingSystems.getElements(), managementModeGrowingSystem);
        return result;
    }

    public void unactivateDecisionRules(List<String> decisionRuleIds, boolean activate) {
        if (CollectionUtils.isNotEmpty(decisionRuleIds)) {
            for (String decisionRuleId : decisionRuleIds) {
                DecisionRule decisionRule = (DecisionRule)this.decisionRuleTopiaDao.forTopiaIdEquals(decisionRuleId).findUnique();
                List decisionRules = this.decisionRuleTopiaDao.forCodeEquals(decisionRule.getCode()).findAll();
                for (DecisionRule decisionRule2 : decisionRules) {
                    decisionRule2.setActive(activate);
                    this.decisionRuleTopiaDao.update((TopiaEntity)decisionRule2);
                }
            }
            this.getTransaction().commit();
        }
    }

    public DecisionRule duplicateDecisionRule(String decisionRuleId) {
        DecisionRule decisionRule = (DecisionRule)this.decisionRuleTopiaDao.forTopiaIdEquals(decisionRuleId).findUnique();
        DecisionRule duplicatedDecisionRule = this.duplicateDecisionRule(new ExtendContext(true), decisionRule);
        this.getTransaction().commit();
        return duplicatedDecisionRule;
    }

    public ManagementMode duplicateManagementModes(String plannedManagementModeId, String observedManagementModeId, String duplicateManagementModeGrowingSystemId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)duplicateManagementModeGrowingSystemId) ? 1 : 0) != 0);
        ManagementMode result = null;
        if (!Strings.isNullOrEmpty((String)observedManagementModeId)) {
            result = this.duplicateManagementMode(observedManagementModeId, duplicateManagementModeGrowingSystemId);
        }
        if (!Strings.isNullOrEmpty((String)plannedManagementModeId)) {
            result = this.duplicateManagementMode(plannedManagementModeId, duplicateManagementModeGrowingSystemId);
        }
        this.getTransaction().commit();
        return result;
    }

    public List<DecisionRule> getAllDecisionRules(List<String> decisionRulesIds) {
        List result = this.decisionRuleTopiaDao.forIn("topiaId", decisionRulesIds).findAll();
        return result;
    }

    protected ManagementMode duplicateManagementMode(String managementModeId, String growingSystemId) {
        ManagementMode originalManagementMode = (ManagementMode)this.managementModeTopiaDao.forTopiaIdEquals(managementModeId).findUnique();
        ManagementMode duplicatedManagementMode = (ManagementMode)this.managementModeTopiaDao.newInstance();
        Binder managementModeManagementModeBinder = BinderFactory.newBinder(ManagementMode.class);
        managementModeManagementModeBinder.copyExcluding((Object)originalManagementMode, (Object)duplicatedManagementMode, new String[]{"topiaCreateDate", "topiaId", "topiaVersion", "growingSystem", "sections", "historical"});
        GrowingSystem growingSystem = (GrowingSystem)this.growingSystemTopiaDao.forTopiaIdEquals(growingSystemId).findUnique();
        duplicatedManagementMode.setGrowingSystem(growingSystem);
        this.cloneSections(originalManagementMode, duplicatedManagementMode);
        ManagementMode result = (ManagementMode)this.managementModeTopiaDao.create((TopiaEntity)duplicatedManagementMode);
        return result;
    }

    protected DecisionRule duplicateDecisionRule(ExtendContext extendContext, DecisionRule decisionRule) {
        Binder decisionRuleBinder = BinderFactory.newBinder(DecisionRule.class);
        DecisionRule clonedDecisionRule = (DecisionRule)this.decisionRuleTopiaDao.newInstance();
        decisionRuleBinder.copyExcluding((Object)decisionRule, (Object)clonedDecisionRule, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        if (extendContext.isDuplicateOnly()) {
            clonedDecisionRule.setCode(UUID.randomUUID().toString());
            clonedDecisionRule.setVersionNumber(1);
        }
        clonedDecisionRule = (DecisionRule)this.decisionRuleTopiaDao.create((TopiaEntity)clonedDecisionRule);
        return clonedDecisionRule;
    }

    private ManagementMode getLastManagementModeVersion(GrowingSystem growingSystem) {
        ManagementMode managementMode = (ManagementMode)this.managementModeTopiaDao.forGrowingSystemEquals(growingSystem).setOrderByArguments(new String[]{"versionNumber DESC"}).findFirst();
        return managementMode;
    }

    public InputStream exportManagementModesAsXlsStream(Collection<ManagementModeDto> managementModeDtos) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        ManagementModeExportMetadata.ManagementModeMainBeanInfo mainTab = new ManagementModeExportMetadata.ManagementModeMainBeanInfo();
        ManagementModeExportMetadata.ManagementModeSectionBeanInfo sectionTab = new ManagementModeExportMetadata.ManagementModeSectionBeanInfo();
        ExportUtils.addAllBeanInfo(sheet, mainTab, sectionTab);
        List sectionEntities = (List)sheet.get(sectionTab);
        try {
            if (CollectionUtils.isNotEmpty(managementModeDtos)) {
                for (ManagementModeDto managementModeDto : managementModeDtos) {
                    if (StringUtils.isNotBlank((CharSequence)managementModeDto.getPlannedManagementModeId())) {
                        ManagementMode plannedManagementMode = (ManagementMode)this.managementModeTopiaDao.forTopiaIdEquals(managementModeDto.getPlannedManagementModeId()).findUnique();
                        plannedManagementMode = this.anonymizeService.checkForManagementModeAnonymization(plannedManagementMode);
                        this.exportManagementMode(sheet, mainTab, sectionEntities, plannedManagementMode);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)managementModeDto.getObservedManagementModeId())) continue;
                    ManagementMode observedManagementMode = (ManagementMode)this.managementModeTopiaDao.forTopiaIdEquals(managementModeDto.getObservedManagementModeId()).findUnique();
                    observedManagementMode = this.anonymizeService.checkForManagementModeAnonymization(observedManagementMode);
                    this.exportManagementMode(sheet, mainTab, sectionEntities, observedManagementMode);
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }

    protected void exportManagementMode(Map<EntityExportTabInfo, List<? extends EntityExportExtra>> sheet, ManagementModeExportMetadata.ManagementModeMainBeanInfo mainTab, List<ManagementModeExportEntity> sectionEntities, ManagementMode managementMode) throws CloneNotSupportedException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ManagementModeExportEntity model = new ManagementModeExportEntity();
        model.setCategory(managementMode.getCategory());
        model.setGrowingSystemName(managementMode.getGrowingSystem().getName());
        model.setGrowingPlanName(managementMode.getGrowingSystem().getGrowingPlan().getName());
        model.setDomainName(managementMode.getGrowingSystem().getGrowingPlan().getDomain().getName());
        model.setCampaign(managementMode.getGrowingSystem().getGrowingPlan().getDomain().getCampaign());
        ExportUtils.export(sheet, model, managementMode, (EntityExportTabInfo)mainTab);
        Collection sections = managementMode.getSections();
        if (sections != null && !sections.isEmpty()) {
            for (Section section : sections) {
                List strategies = section.getStrategies();
                if (strategies != null && !strategies.isEmpty()) {
                    for (Strategy strategy : strategies) {
                        ManagementModeExportEntity export = (ManagementModeExportEntity)model.clone();
                        ExportUtils.copyFields(section, (EntityExportExtra)model, null, "sectionType", "agronomicObjective", "categoryObjective", "expectedResult", "bioAgressor", "categoryStrategy");
                        RefBioAgressor bioAgressor = section.getBioAgressor();
                        String bioagrssorLabel = null;
                        if (bioAgressor != null) {
                            bioagrssorLabel = bioAgressor.getLabel();
                        }
                        ExportUtils.setExtraField(export, "bioAgressorType", bioagrssorLabel);
                        ExportUtils.setExtraField(export, "StrategyMultiannual", strategy.getStrategyType());
                        ExportUtils.setExtraField(export, "StrategyExplanation", strategy.getExplanation());
                        String cropName = null;
                        CroppingPlanEntry crop = strategy.getCroppingPlanEntry();
                        if (crop != null) {
                            cropName = crop.getName();
                        }
                        ExportUtils.setExtraField(export, "StrategyCroppingPlanEntry", cropName);
                        sectionEntities.add(export);
                    }
                    continue;
                }
                ManagementModeExportEntity export = (ManagementModeExportEntity)model.clone();
                ExportUtils.copyFields(section, (EntityExportExtra)model, null, "sectionType", "agronomicObjective", "categoryObjective", "expectedResult", "bioAgressor", "categoryStrategy");
                RefBioAgressor bioAgressor = section.getBioAgressor();
                String bioagrssorLabel = null;
                if (bioAgressor != null) {
                    bioagrssorLabel = bioAgressor.getLabel();
                }
                ExportUtils.setExtraField(export, "bioAgressorType", bioagrssorLabel);
                sectionEntities.add(export);
            }
        }
    }

    public InputStream exportDecisionRulesAsXlsStream(Collection<String> decisionRuleIds) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        DecisionRuleExportMetadata.DecisionRuleMainBeanInfo decisionRuleMainBeanInfo = this.newInstance(DecisionRuleExportMetadata.DecisionRuleMainBeanInfo.class);
        ExportUtils.addAllBeanInfo(sheet, decisionRuleMainBeanInfo);
        try {
            if (decisionRuleIds != null && !decisionRuleIds.isEmpty()) {
                Iterable decisionRules = this.decisionRuleTopiaDao.forTopiaIdIn(decisionRuleIds).findAllLazy(100);
                for (DecisionRule decisionRule : decisionRules) {
                    DecisionRuleExportEntity model = new DecisionRuleExportEntity();
                    Domain domain = (Domain)this.domainTopiaDao.forCodeEquals(decisionRule.getDomainCode()).findAny();
                    domain = this.anonymizeService.checkForDomainAnonymization(domain);
                    model.setDomainName(domain.getName());
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, decisionRule, (EntityExportTabInfo)decisionRuleMainBeanInfo);
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }
}

