/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.input;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.AbstractInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.BiologicalControlAction;
import fr.inra.agrosyst.api.entities.action.BiologicalProductInput;
import fr.inra.agrosyst.api.entities.action.BiologicalProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.IrrigationAction;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesAction;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.MineralProductInput;
import fr.inra.agrosyst.api.entities.action.MineralProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.OrganicProductInput;
import fr.inra.agrosyst.api.entities.action.OrganicProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.OtherAction;
import fr.inra.agrosyst.api.entities.action.OtherProductInput;
import fr.inra.agrosyst.api.entities.action.OtherProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.PesticideProductInput;
import fr.inra.agrosyst.api.entities.action.PesticideProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingAction;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.entities.action.SeedingProductInput;
import fr.inra.agrosyst.api.entities.action.SeedingProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.api.services.input.InputService;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.commons.gson.InputAdapter;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class InputServiceImpl
extends AbstractAgrosystService
implements InputService {
    protected PricesService pricesService;
    protected ReferentialService referentialService;
    protected AbstractInputTopiaDao inputDao;
    protected MineralProductInputTopiaDao mineralProductInputDao;
    protected OrganicProductInputTopiaDao organicProductInputDao;
    protected SeedingProductInputTopiaDao seedingProductInputDao;
    protected BiologicalProductInputTopiaDao biologicalProductInputDao;
    protected PesticideProductInputTopiaDao pesticideProductInputDao;
    protected OtherProductInputTopiaDao otherProductInputDao;
    protected Map<AgrosystInterventionType, List<String>> actaTreatmentProductTypes;

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    protected Map<AgrosystInterventionType, List<String>> getActaTreatmentProductTypes() {
        if (this.actaTreatmentProductTypes == null || this.actaTreatmentProductTypes.isEmpty()) {
            this.actaTreatmentProductTypes = this.referentialService.getAllActiveActaTreatmentProductTypes();
        }
        return this.actaTreatmentProductTypes;
    }

    public void setAbstractInputTopiaDao(AbstractInputTopiaDao inputTopiaDao) {
        this.inputDao = inputTopiaDao;
    }

    public void setMineralProductInputDao(MineralProductInputTopiaDao mineralProductInputDao) {
        this.mineralProductInputDao = mineralProductInputDao;
    }

    public void setOrganicProductInputDao(OrganicProductInputTopiaDao organicProductInputDao) {
        this.organicProductInputDao = organicProductInputDao;
    }

    public void setSeedingProductInputDao(SeedingProductInputTopiaDao seedingProductInputDao) {
        this.seedingProductInputDao = seedingProductInputDao;
    }

    public void setBiologicalProductInputDao(BiologicalProductInputTopiaDao biologicalProductInputDao) {
        this.biologicalProductInputDao = biologicalProductInputDao;
    }

    public void setPesticideProductInputDao(PesticideProductInputTopiaDao pesticideProductInputDao) {
        this.pesticideProductInputDao = pesticideProductInputDao;
    }

    public void setOtherProductInputDao(OtherProductInputTopiaDao otherProductInputDao) {
        this.otherProductInputDao = otherProductInputDao;
    }

    public void setInputDao(AbstractInputTopiaDao inputDao) {
        this.inputDao = inputDao;
    }

    public void updateInterventionInputs(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention, List<AbstractInput> inputs, Map<String, AbstractAction> actions) {
        List<AbstractInput> originalInputs;
        if (practicedIntervention != null) {
            originalInputs = this.inputDao.findAllByPracticedIntervention(practicedIntervention);
        } else if (effectiveIntervention != null) {
            originalInputs = this.inputDao.findAllByEffectiveIntervention(effectiveIntervention);
        } else {
            throw new UnsupportedOperationException("At least a practiced of effective intervention must be provided");
        }
        this.createOrUpdateInterventionInputs(originalInputs, inputs, actions);
    }

    public void createInterventionInputs(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention, List<AbstractInput> inputs, Map<String, AbstractAction> actions) {
        this.createOrUpdateInterventionInputs(null, inputs, actions);
    }

    protected void createOrUpdateInterventionInputs(Collection<AbstractInput> originalInputs, List<AbstractInput> inputs, Map<String, AbstractAction> actions) {
        if (originalInputs == null) {
            originalInputs = Lists.newArrayList();
        }
        ImmutableMap inputsIndex = Maps.uniqueIndex((Iterable)originalInputs, (Function)Entities.GET_TOPIA_ID);
        HashMap indexedOriginalInputs = Maps.newHashMap((Map)inputsIndex);
        if (inputs != null) {
            try {
                for (AbstractInput input : inputs) {
                    BiologicalProductInput phytoProductInput;
                    AbstractAction action;
                    AgrosystInterventionType inputType = (AgrosystInterventionType)InputAdapter.GET_INPUT_TYPE.apply((Object)input);
                    input.setInputType(inputType);
                    if (input instanceof MineralProductInput) {
                        MineralProductInput mineralProductInput = (MineralProductInput)input;
                        RefFertiMinUNIFA product = mineralProductInput.getMineralProduct();
                        Preconditions.checkState((product != null ? 1 : 0) != 0, (Object)"A mineralProduct is required for 'MineralProductInput'");
                        mineralProductInput.setMineralProduct(this.referentialService.createOrUpdateRefMineralProductToInput(product));
                        Preconditions.checkState((mineralProductInput.getMineralFertilizersSpreadingAction() != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX'");
                        action = actions.get(mineralProductInput.getMineralFertilizersSpreadingAction().getTopiaId());
                        Preconditions.checkState((action != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX'");
                        mineralProductInput.setMineralFertilizersSpreadingAction((MineralFertilizersSpreadingAction)action);
                        if (mineralProductInput.isPersisted()) {
                            MineralProductInput modifiedMineralProductInput = this.bindMineralProductInputToPersistedOne(indexedOriginalInputs, mineralProductInput);
                            this.mineralProductInputDao.update((TopiaEntity)modifiedMineralProductInput);
                            continue;
                        }
                        this.mineralProductInputDao.create((TopiaEntity)mineralProductInput);
                        continue;
                    }
                    if (input instanceof OrganicProductInput) {
                        OrganicProductInput organicProductInput = (OrganicProductInput)input;
                        Preconditions.checkState((organicProductInput.getOrganicFertilizersSpreadingAction() != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'EPANDAGES_ORGANIQUES'");
                        AbstractAction action2 = actions.get(organicProductInput.getOrganicFertilizersSpreadingAction().getTopiaId());
                        Preconditions.checkState((action2 != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'EPANDAGES_ORGANIQUES'");
                        organicProductInput.setOrganicFertilizersSpreadingAction((OrganicFertilizersSpreadingAction)action2);
                        if (organicProductInput.isPersisted()) {
                            OrganicProductInput modifiedOrganicProductInput = this.bindOrganicProductInputToPersitedOne(indexedOriginalInputs, organicProductInput);
                            this.organicProductInputDao.update((TopiaEntity)modifiedOrganicProductInput);
                            continue;
                        }
                        this.organicProductInputDao.create((TopiaEntity)organicProductInput);
                        continue;
                    }
                    if (AgrosystInterventionType.SEMIS.equals((Object)inputType) && input instanceof SeedingProductInput) {
                        SeedingProductInput currentSeedingProductInput = (SeedingProductInput)input;
                        Preconditions.checkState((currentSeedingProductInput.getSeedingAction() != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'SEMIS'");
                        SeedingAction seedingAction = (SeedingAction)actions.get(currentSeedingProductInput.getSeedingAction().getTopiaId());
                        Preconditions.checkState((seedingAction != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'SEMIS'");
                        this.validSeedingInputSeedingAction(currentSeedingProductInput, seedingAction);
                        SeedingProductInput seedingProductInput = this.bindSeedingProductInput(currentSeedingProductInput, indexedOriginalInputs, seedingAction);
                        if (seedingProductInput.isPersisted()) {
                            this.seedingProductInputDao.update((TopiaEntity)seedingProductInput);
                            continue;
                        }
                        this.seedingProductInputDao.create((TopiaEntity)seedingProductInput);
                        continue;
                    }
                    if (AgrosystInterventionType.LUTTE_BIOLOGIQUE.equals((Object)inputType) && input instanceof BiologicalProductInput) {
                        phytoProductInput = (BiologicalProductInput)input;
                        Preconditions.checkState((phytoProductInput.getBiologicalControlAction() != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'LUTTE_BIOLOGIQUE'");
                        AbstractAction action3 = actions.get(phytoProductInput.getBiologicalControlAction().getTopiaId());
                        Preconditions.checkState((action3 != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'LUTTE_BIOLOGIQUE'");
                        if (phytoProductInput.isPersisted()) {
                            BiologicalProductInput biologicalProductInput = this.getPersistedBiologicalProductInput(indexedOriginalInputs, (PhytoProductInput)phytoProductInput);
                            this.bindBiologicalProductInput((BiologicalControlAction)action3, phytoProductInput, biologicalProductInput);
                            this.biologicalProductInputDao.update((TopiaEntity)biologicalProductInput);
                            continue;
                        }
                        phytoProductInput.setBiologicalControlAction((BiologicalControlAction)action3);
                        this.biologicalProductInputDao.create((TopiaEntity)phytoProductInput);
                        continue;
                    }
                    if (AgrosystInterventionType.APPLICATION_DE_PRODUITS_PHYTOSANITAIRES.equals((Object)inputType) && input instanceof PesticideProductInput) {
                        phytoProductInput = (PesticideProductInput)input;
                        Preconditions.checkState((phytoProductInput.getPesticidesSpreadingAction() != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'APPLICATION_DE_PRODUITS_PHYTOSANITAIRES'");
                        AbstractAction action4 = actions.get(phytoProductInput.getPesticidesSpreadingAction().getTopiaId());
                        Preconditions.checkState((action4 != null ? 1 : 0) != 0, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'APPLICATION_DE_PRODUITS_PHYTOSANITAIRES'");
                        if (phytoProductInput.isPersisted()) {
                            PesticideProductInput pesticideProductInput = this.getPersistedPesticideProductInput(indexedOriginalInputs, (PhytoProductInput)phytoProductInput);
                            this.bindToPesticideProductInput((PesticidesSpreadingAction)action4, (PesticideProductInput)phytoProductInput, pesticideProductInput);
                            this.pesticideProductInputDao.update((TopiaEntity)pesticideProductInput);
                            continue;
                        }
                        phytoProductInput.setPesticidesSpreadingAction((PesticidesSpreadingAction)action4);
                        this.pesticideProductInputDao.create((TopiaEntity)phytoProductInput);
                        continue;
                    }
                    if (input instanceof OtherProductInput) {
                        OtherProductInput otherProductInput = (OtherProductInput)input;
                        boolean isAction = false;
                        if (otherProductInput.getOtherAction() != null) {
                            action = actions.get(otherProductInput.getOtherAction().getTopiaId());
                            otherProductInput.setOtherAction((OtherAction)action);
                            isAction = true;
                        } else if (otherProductInput.getHarvestingAction() != null) {
                            action = actions.get(otherProductInput.getHarvestingAction().getTopiaId());
                            otherProductInput.setHarvestingAction((HarvestingAction)action);
                            isAction = true;
                        } else if (otherProductInput.getMaintenancePruningVinesAction() != null) {
                            action = actions.get(otherProductInput.getMaintenancePruningVinesAction().getTopiaId());
                            otherProductInput.setMaintenancePruningVinesAction((MaintenancePruningVinesAction)action);
                            isAction = true;
                        } else if (otherProductInput.getIrrigationAction() != null) {
                            action = actions.get(otherProductInput.getIrrigationAction().getTopiaId());
                            otherProductInput.setIrrigationAction((IrrigationAction)action);
                            isAction = true;
                        } else if (otherProductInput.getMineralFertilizersSpreadingAction() != null) {
                            action = actions.get(otherProductInput.getMineralFertilizersSpreadingAction().getTopiaId());
                            otherProductInput.setMineralFertilizersSpreadingAction((MineralFertilizersSpreadingAction)action);
                            isAction = true;
                        } else if (otherProductInput.getOrganicFertilizersSpreadingAction() != null) {
                            action = actions.get(otherProductInput.getOrganicFertilizersSpreadingAction().getTopiaId());
                            otherProductInput.setOrganicFertilizersSpreadingAction((OrganicFertilizersSpreadingAction)action);
                            isAction = true;
                        } else if (otherProductInput.getPesticidesSpreadingAction() != null) {
                            action = actions.get(otherProductInput.getPesticidesSpreadingAction().getTopiaId());
                            otherProductInput.setPesticidesSpreadingAction((PesticidesSpreadingAction)action);
                            isAction = true;
                        } else if (otherProductInput.getBiologicalControlAction() != null) {
                            action = actions.get(otherProductInput.getBiologicalControlAction().getTopiaId());
                            otherProductInput.setBiologicalControlAction((BiologicalControlAction)action);
                            isAction = true;
                        } else if (otherProductInput.getSeedingAction() != null) {
                            action = actions.get(otherProductInput.getSeedingAction().getTopiaId());
                            otherProductInput.setSeedingAction((SeedingAction)action);
                            isAction = true;
                        }
                        Preconditions.checkState((boolean)isAction, (Object)"Aucune action associ\u00e9e \u00e0 l'intrant de type 'Autre'");
                        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)otherProductInput.getProductName()), (Object)"Aucun nom de produit n'est d\u00e9finit pour l'intrant de type 'AUTRE'");
                        if (otherProductInput.isPersisted()) {
                            OtherProductInput modifiedOtherProductInput = this.bindToPersistedOtherProductInput(indexedOriginalInputs, otherProductInput);
                            this.otherProductInputDao.update((TopiaEntity)modifiedOtherProductInput);
                            continue;
                        }
                        this.otherProductInputDao.create((TopiaEntity)otherProductInput);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unsupported input type: " + input.getClass());
                }
            }
            catch (Exception e) {
                throw new AgrosystTechnicalException("Echec de sauvegarde des intrants", (Throwable)e);
            }
        }
        this.inputDao.deleteAll(indexedOriginalInputs.values());
    }

    protected OtherProductInput bindToPersistedOtherProductInput(Map<String, AbstractInput> indexedOriginalInputs, OtherProductInput otherProductInput) {
        OtherProductInput modifiedOtherProductInput = (OtherProductInput)indexedOriginalInputs.remove(otherProductInput.getTopiaId());
        if (modifiedOtherProductInput == null) {
            modifiedOtherProductInput = (OtherProductInput)this.otherProductInputDao.forTopiaIdEquals(otherProductInput.getTopiaId()).findUnique();
        }
        Binder binder = BinderFactory.newBinder(OtherProductInput.class);
        binder.copyExcluding((Object)otherProductInput, (Object)modifiedOtherProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        return modifiedOtherProductInput;
    }

    protected void bindToPesticideProductInput(PesticidesSpreadingAction action, PesticideProductInput phytoProductInput, PesticideProductInput pesticideProductInput) {
        Binder binder = BinderFactory.newBinder(PesticideProductInput.class, PesticideProductInput.class);
        binder.copyExcluding((Object)phytoProductInput, (Object)pesticideProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        pesticideProductInput.setPesticidesSpreadingAction(action);
    }

    protected PesticideProductInput getPersistedPesticideProductInput(Map<String, AbstractInput> indexedOriginalInputs, PhytoProductInput phytoProductInput) {
        PesticideProductInput pesticideProductInput = (PesticideProductInput)indexedOriginalInputs.remove(phytoProductInput.getTopiaId());
        if (pesticideProductInput == null) {
            pesticideProductInput = (PesticideProductInput)this.pesticideProductInputDao.forTopiaIdEquals(phytoProductInput.getTopiaId()).findUnique();
        }
        return pesticideProductInput;
    }

    protected void bindBiologicalProductInput(BiologicalControlAction action, BiologicalProductInput phytoProductInput, BiologicalProductInput biologicalProductInput) {
        Binder binder = BinderFactory.newBinder(BiologicalProductInput.class, BiologicalProductInput.class);
        binder.copyExcluding((Object)phytoProductInput, (Object)biologicalProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        biologicalProductInput.setBiologicalControlAction(action);
    }

    protected BiologicalProductInput getPersistedBiologicalProductInput(Map<String, AbstractInput> indexedOriginalInputs, PhytoProductInput phytoProductInput) {
        BiologicalProductInput biologicalProductInput = (BiologicalProductInput)indexedOriginalInputs.remove(phytoProductInput.getTopiaId());
        if (biologicalProductInput == null) {
            biologicalProductInput = (BiologicalProductInput)this.biologicalProductInputDao.forTopiaIdEquals(phytoProductInput.getTopiaId()).findUnique();
        }
        return biologicalProductInput;
    }

    protected OrganicProductInput bindOrganicProductInputToPersitedOne(Map<String, AbstractInput> indexedOriginalInputs, OrganicProductInput organicProductInput) {
        OrganicProductInput modifiedOrganicProductInput = (OrganicProductInput)indexedOriginalInputs.remove(organicProductInput.getTopiaId());
        if (modifiedOrganicProductInput == null) {
            modifiedOrganicProductInput = (OrganicProductInput)this.organicProductInputDao.forTopiaIdEquals(organicProductInput.getTopiaId()).findUnique();
        }
        Binder binder = BinderFactory.newBinder(OrganicProductInput.class);
        binder.copyExcluding((Object)organicProductInput, (Object)modifiedOrganicProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        return modifiedOrganicProductInput;
    }

    protected MineralProductInput bindMineralProductInputToPersistedOne(Map<String, AbstractInput> indexedOriginalInputs, MineralProductInput mineralProductInput) {
        MineralProductInput modifiedMineralProductInput = (MineralProductInput)indexedOriginalInputs.remove(mineralProductInput.getTopiaId());
        if (modifiedMineralProductInput == null) {
            modifiedMineralProductInput = (MineralProductInput)this.mineralProductInputDao.forTopiaIdEquals(mineralProductInput.getTopiaId()).findUnique();
        }
        Binder binder = BinderFactory.newBinder(MineralProductInput.class);
        binder.copyExcluding((Object)mineralProductInput, (Object)modifiedMineralProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        return modifiedMineralProductInput;
    }

    protected SeedingProductInput bindSeedingProductInput(SeedingProductInput seedingProductInput, Map<String, AbstractInput> indexedOriginalInputs, SeedingAction seedingAction) {
        SeedingProductInput inputToSave;
        if (seedingProductInput.isPersisted()) {
            inputToSave = (SeedingProductInput)indexedOriginalInputs.remove(seedingProductInput.getTopiaId());
            if (inputToSave == null) {
                inputToSave = (SeedingProductInput)this.seedingProductInputDao.forTopiaIdEquals(seedingProductInput.getTopiaId()).findUnique();
            }
        } else {
            inputToSave = (SeedingProductInput)this.seedingProductInputDao.newInstance();
        }
        Binder binder = BinderFactory.newBinder(SeedingProductInput.class, SeedingProductInput.class);
        binder.copyExcluding((Object)seedingProductInput, (Object)inputToSave, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        inputToSave.setSeedingAction(seedingAction);
        return inputToSave;
    }

    protected void validSeedingInputSeedingAction(SeedingProductInput input, SeedingAction seedingAction) {
        Collection specieses = seedingAction.getSeedingSpecies();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)specieses), (Object)String.format("Aucune esp\u00e8ce de l'action 'Semis' n'a de traitement s\u00e9lectionn\u00e9 pour ce type d'intrant '%s' !", input.getProductType()));
        if (StringUtils.isNotBlank((CharSequence)input.getProductType())) {
            List<String> productTypes = this.getActaTreatmentProductTypes().get(AgrosystInterventionType.SEMIS);
            HashSet allowedProductTypes = Sets.newHashSet();
            for (SeedingActionSpecies species : specieses) {
                if (species.isTreatment()) {
                    allowedProductTypes.add(productTypes.get(0));
                    allowedProductTypes.add(productTypes.get(2));
                }
                if (!species.isBiologicalSeedInoculation()) continue;
                allowedProductTypes.add(productTypes.get(1));
            }
            Preconditions.checkState((boolean)allowedProductTypes.contains(input.getProductType()), (Object)String.format("Aucune esp\u00e8ce de l'action 'Semis' n'a de traitement s\u00e9lectionn\u00e9 pour ce type d'intrant '%s' !", input.getProductType()));
        }
    }

    public void deleteInputForActions(Collection<AbstractAction> actions) {
        if (actions != null) {
            for (AbstractAction action : actions) {
                List otherProductInputs;
                List otherProductInputs2;
                if (action instanceof SeedingAction) {
                    List seedingProductInputs = this.seedingProductInputDao.forSeedingActionEquals((SeedingAction)action).findAll();
                    this.seedingProductInputDao.deleteAll(seedingProductInputs);
                    otherProductInputs2 = this.otherProductInputDao.forSeedingActionEquals((SeedingAction)action).findAll();
                    this.otherProductInputDao.deleteAll(otherProductInputs2);
                    continue;
                }
                if (action instanceof MineralFertilizersSpreadingAction) {
                    List mineralProductInputs = this.mineralProductInputDao.forMineralFertilizersSpreadingActionEquals((MineralFertilizersSpreadingAction)action).findAll();
                    this.mineralProductInputDao.deleteAll(mineralProductInputs);
                    otherProductInputs2 = this.otherProductInputDao.forMineralFertilizersSpreadingActionEquals((MineralFertilizersSpreadingAction)action).findAll();
                    this.otherProductInputDao.deleteAll(otherProductInputs2);
                    continue;
                }
                if (action instanceof OrganicFertilizersSpreadingAction) {
                    List organicProductInputs = this.organicProductInputDao.forOrganicFertilizersSpreadingActionEquals((OrganicFertilizersSpreadingAction)action).findAll();
                    this.organicProductInputDao.deleteAll(organicProductInputs);
                    otherProductInputs2 = this.otherProductInputDao.forOrganicFertilizersSpreadingActionEquals((OrganicFertilizersSpreadingAction)action).findAll();
                    this.otherProductInputDao.deleteAll(otherProductInputs2);
                    continue;
                }
                if (action instanceof BiologicalControlAction) {
                    List biologicalProductInputs = this.biologicalProductInputDao.forBiologicalControlActionEquals((BiologicalControlAction)action).findAll();
                    this.biologicalProductInputDao.deleteAll(biologicalProductInputs);
                    otherProductInputs2 = this.otherProductInputDao.forBiologicalControlActionEquals((BiologicalControlAction)action).findAll();
                    this.otherProductInputDao.deleteAll(otherProductInputs2);
                    continue;
                }
                if (action instanceof PesticidesSpreadingAction) {
                    List pesticideProductInputs = this.pesticideProductInputDao.forPesticidesSpreadingActionEquals((PesticidesSpreadingAction)action).findAll();
                    this.pesticideProductInputDao.deleteAll(pesticideProductInputs);
                    otherProductInputs2 = this.otherProductInputDao.forPesticidesSpreadingActionEquals((PesticidesSpreadingAction)action).findAll();
                    this.otherProductInputDao.deleteAll(otherProductInputs2);
                    continue;
                }
                if (action instanceof OtherAction) {
                    otherProductInputs = this.otherProductInputDao.forOtherActionEquals((OtherAction)action).findAll();
                    this.otherProductInputDao.deleteAll(otherProductInputs);
                    continue;
                }
                if (action instanceof IrrigationAction) {
                    otherProductInputs = this.otherProductInputDao.forIrrigationActionEquals((IrrigationAction)action).findAll();
                    this.otherProductInputDao.deleteAll(otherProductInputs);
                    continue;
                }
                if (action instanceof MaintenancePruningVinesAction) {
                    otherProductInputs = this.otherProductInputDao.forMaintenancePruningVinesActionEquals((MaintenancePruningVinesAction)action).findAll();
                    this.otherProductInputDao.deleteAll(otherProductInputs);
                    continue;
                }
                if (!(action instanceof HarvestingAction)) continue;
                otherProductInputs = this.otherProductInputDao.forHarvestingActionEquals((HarvestingAction)action).findAll();
                this.otherProductInputDao.deleteAll(otherProductInputs);
            }
        }
    }

    public void duplicateInputs(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        Preconditions.checkArgument((boolean)(practicedIntervention != null ^ effectiveIntervention != null));
        List<AbstractInput> inputs = effectiveIntervention != null ? this.inputDao.findAllByEffectiveIntervention(effectiveIntervention) : this.inputDao.findAllByPracticedIntervention(practicedIntervention);
        HashMap inputCache = Maps.newHashMap();
        for (AbstractInput input : inputs) {
            Map actionsToDuplicatedActions = duplicateContext.getActionCache();
            AbstractInput inputClone = this.getDuplicatedAbstractInput(actionsToDuplicatedActions, input);
            inputClone = (AbstractInput)this.inputDao.create((TopiaEntity)inputClone);
            inputCache.put(input, inputClone);
            duplicateContext.getInputCache().put(input, inputClone);
        }
    }

    public void migrateInputSpeciesToTargetedSpecies(EffectiveInterventionDto interventionDto) {
        ArrayList newInputs = Lists.newArrayList();
        List inputs = interventionDto.getInputs();
        if (inputs != null) {
            for (AbstractInput input : inputs) {
                if (input instanceof SeedingProductInput) {
                    SeedingAction inputAction = ((SeedingProductInput)input).getSeedingAction();
                    if (inputAction.getSeedingSpecies() == null || inputAction.getSeedingSpecies().isEmpty()) continue;
                    newInputs.add(input);
                    continue;
                }
                newInputs.add(input);
            }
        }
        interventionDto.setInputs((List)newInputs);
    }

    public AbstractInput getDuplicatedAbstractInput(Map<AbstractAction, AbstractAction> actionsToDuplicatedActions, AbstractInput input) {
        MineralProductInput inputClone;
        if (input instanceof MineralProductInput) {
            MineralProductInput mineralProductInput = (MineralProductInput)input;
            MineralProductInput duplicateMineralProductInput = (MineralProductInput)this.mineralProductInputDao.newInstance();
            Binder binder = BinderFactory.newBinder(MineralProductInput.class);
            binder.copyExcluding((Object)mineralProductInput, (Object)duplicateMineralProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "mineralFertilizersSpreadingAction"});
            duplicateMineralProductInput.setMineralFertilizersSpreadingAction((MineralFertilizersSpreadingAction)actionsToDuplicatedActions.get(mineralProductInput.getMineralFertilizersSpreadingAction()));
            inputClone = duplicateMineralProductInput;
        } else if (input instanceof OrganicProductInput) {
            OrganicProductInput organicProductInput = (OrganicProductInput)input;
            OrganicProductInput newOrganicProductInput = (OrganicProductInput)this.organicProductInputDao.newInstance();
            Binder binder = BinderFactory.newBinder(OrganicProductInput.class);
            binder.copyExcluding((Object)organicProductInput, (Object)newOrganicProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "organicFertilizersSpreadingAction"});
            newOrganicProductInput.setOrganicFertilizersSpreadingAction((OrganicFertilizersSpreadingAction)actionsToDuplicatedActions.get(organicProductInput.getOrganicFertilizersSpreadingAction()));
            inputClone = newOrganicProductInput;
        } else if (input instanceof SeedingProductInput) {
            SeedingProductInput phytoProductInput = (SeedingProductInput)input;
            SeedingProductInput newPhytoProductInput = (SeedingProductInput)this.seedingProductInputDao.newInstance();
            Binder binder = BinderFactory.newBinder(SeedingProductInput.class);
            binder.copyExcluding((Object)phytoProductInput, (Object)newPhytoProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "seedingAction", "targets"});
            newPhytoProductInput.setSeedingAction((SeedingAction)actionsToDuplicatedActions.get(phytoProductInput.getSeedingAction()));
            if (phytoProductInput.getTargets() != null) {
                newPhytoProductInput.setTargets(new ArrayList(phytoProductInput.getTargets()));
            }
            inputClone = newPhytoProductInput;
        } else if (input instanceof BiologicalProductInput) {
            BiologicalProductInput phytoProductInput = (BiologicalProductInput)input;
            BiologicalProductInput newPhytoProductInput = (BiologicalProductInput)this.biologicalProductInputDao.newInstance();
            Binder binder = BinderFactory.newBinder(BiologicalProductInput.class);
            binder.copyExcluding((Object)phytoProductInput, (Object)newPhytoProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "biologicalControlAction", "targets"});
            newPhytoProductInput.setBiologicalControlAction((BiologicalControlAction)actionsToDuplicatedActions.get(phytoProductInput.getBiologicalControlAction()));
            if (phytoProductInput.getTargets() != null) {
                newPhytoProductInput.setTargets(new ArrayList(phytoProductInput.getTargets()));
            }
            inputClone = newPhytoProductInput;
        } else if (input instanceof PesticideProductInput) {
            PesticideProductInput phytoProductInput = (PesticideProductInput)input;
            PesticideProductInput newPhytoProductInput = (PesticideProductInput)this.pesticideProductInputDao.newInstance();
            Binder binder = BinderFactory.newBinder(PesticideProductInput.class);
            binder.copyExcluding((Object)phytoProductInput, (Object)newPhytoProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "pesticidesSpreadingAction", "targets"});
            newPhytoProductInput.setPesticidesSpreadingAction((PesticidesSpreadingAction)actionsToDuplicatedActions.get(phytoProductInput.getPesticidesSpreadingAction()));
            if (phytoProductInput.getTargets() != null) {
                newPhytoProductInput.setTargets(new ArrayList(phytoProductInput.getTargets()));
            }
            inputClone = newPhytoProductInput;
        } else if (input instanceof OtherProductInput) {
            OtherProductInput otherProductInput = (OtherProductInput)input;
            OtherProductInput newOtherProductInput = (OtherProductInput)this.otherProductInputDao.newInstance();
            Binder binder = BinderFactory.newBinder(OtherProductInput.class);
            binder.copyExcluding((Object)otherProductInput, (Object)newOtherProductInput, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "otherAction", "harvestingAction", "maintenancePruningVinesAction", "irrigationAction", "mineralFertilizersSpreadingAction", "organicFertilizersSpreadingAction", "pesticidesSpreadingAction", "biologicalControlAction", "seedingAction"});
            newOtherProductInput.setOtherAction((OtherAction)actionsToDuplicatedActions.get(otherProductInput.getOtherAction()));
            newOtherProductInput.setHarvestingAction((HarvestingAction)actionsToDuplicatedActions.get(otherProductInput.getHarvestingAction()));
            newOtherProductInput.setMaintenancePruningVinesAction((MaintenancePruningVinesAction)actionsToDuplicatedActions.get(otherProductInput.getMaintenancePruningVinesAction()));
            newOtherProductInput.setIrrigationAction((IrrigationAction)actionsToDuplicatedActions.get(otherProductInput.getIrrigationAction()));
            newOtherProductInput.setMineralFertilizersSpreadingAction((MineralFertilizersSpreadingAction)actionsToDuplicatedActions.get(otherProductInput.getMineralFertilizersSpreadingAction()));
            newOtherProductInput.setOrganicFertilizersSpreadingAction((OrganicFertilizersSpreadingAction)actionsToDuplicatedActions.get(otherProductInput.getOrganicFertilizersSpreadingAction()));
            newOtherProductInput.setPesticidesSpreadingAction((PesticidesSpreadingAction)actionsToDuplicatedActions.get(otherProductInput.getPesticidesSpreadingAction()));
            newOtherProductInput.setBiologicalControlAction((BiologicalControlAction)actionsToDuplicatedActions.get(otherProductInput.getBiologicalControlAction()));
            newOtherProductInput.setSeedingAction((SeedingAction)actionsToDuplicatedActions.get(otherProductInput.getSeedingAction()));
            inputClone = newOtherProductInput;
        } else {
            throw new UnsupportedOperationException("Unsupported input type: " + input.getClass());
        }
        return inputClone;
    }
}

