/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.history;

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.entities.history.MessageTopiaDao;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.history.MessageFilter;
import fr.inra.agrosyst.api.services.history.MessageService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public class MessageServiceImpl
extends AbstractAgrosystService
implements MessageService {
    MessageTopiaDao messageTopiaDao;

    public void setMessageTopiaDao(MessageTopiaDao messageTopiaDao) {
        this.messageTopiaDao = messageTopiaDao;
    }

    public void publishMessage(String title, String content) {
        Preconditions.checkNotNull((Object)title);
        Message message = (Message)this.messageTopiaDao.newInstance();
        message.setTitle(title);
        message.setContent(content == null ? "" : content);
        message.setMessageDate(new Date());
        this.messageTopiaDao.create((TopiaEntity)message);
        this.getTransaction().commit();
    }

    public ResultList<Message> getFilteredMessages(MessageFilter filter) {
        ResultList<Message> result = this.messageTopiaDao.getAllMessageByPage(filter);
        return result;
    }

    public List<Message> getMessagesFromDate(Date fromDate) {
        List<Message> result = fromDate == null ? this.messageTopiaDao.geAllMessages() : this.messageTopiaDao.geMessageFromDate(fromDate);
        return result;
    }

    public Date getLastMessageDate() {
        Date result = this.messageTopiaDao.getLastMassageDate();
        return result;
    }
}

