/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.growingsystem.export;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

public class ExportGrowingSystemMetadata {

    public static class GrowingSystemPlotsBeanInfo
    extends GrowingSystemCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Parcelles";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap columns = new DualLinkedHashBidiMap();
            columns.put((Object)"name", (Object)"Nom de la parcelle");
            columns.put((Object)"pacIlotNumber", (Object)"Num\u00e9ro d'il\u00f4t PAC");
            columns.put((Object)"plotOutComment", (Object)"Commentaires");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map result = super.getCustomFormatters();
            return result;
        }
    }

    public static class GrowingSystemCaracteristicsBeanInfo
    extends GrowingSystemCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Principaux traits";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap columns = new DualLinkedHashBidiMap();
            columns.put((Object)"typeAgriculture", (Object)"Type de conduite");
            columns.put((Object)"categoryStrategy", (Object)"Cat\u00e9gorie de strat\u00e9gie globale");
            columns.put((Object)"type_trait_sdc", (Object)"Type de charact\u00e9ristiques");
            columns.put((Object)"nom_trait", (Object)"Charact\u00e9ristiques");
            columns.put((Object)"characteristicComment", (Object)"Commentaires");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map result = super.getCustomFormatters();
            return result;
        }
    }

    public static class GrowingSystemMainBeanInfo
    extends GrowingSystemCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "G\u00e9n\u00e9ralit\u00e9s";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap columns = new DualLinkedHashBidiMap();
            columns.put((Object)"dephyNumber", (Object)"Num\u00e9ro DEPHY");
            columns.put((Object)"allNetworks", (Object)"R\u00e9seau(x) de rattachement");
            columns.put((Object)"description", (Object)"Description");
            columns.put((Object)"endingDate", (Object)"Date de fin d'utilisation");
            columns.put((Object)"endActivityComment", (Object)"Motif de fin d'utilisation");
            columns.put((Object)"affectedAreaRate", (Object)"Pourcentage de surface du domaine affect\u00e9e");
            columns.put((Object)"affectedWorkForceRate", (Object)"Pourcentage de la main d\u2019oeuvre affect\u00e9e");
            columns.put((Object)"domainsToolsUsageRate", (Object)"Taux d'utilisation des outils et installations du domaine");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("allNetworks", new Function<K, Object>(){

                public Object apply(K input) {
                    GrowingSystem gs = (GrowingSystem)input;
                    String result = "";
                    if (gs.getNetworks() != null && !gs.getNetworks().isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        for (Network network : gs.getNetworks()) {
                            sb.append(network.getName());
                            sb.append(", ");
                        }
                        result = sb.toString();
                        result = result.substring(0, result.length() - 2);
                    }
                    return result;
                }
            });
            return result;
        }
    }

    public static abstract class GrowingSystemCommonBeanInfo
    extends AbstractAgrosystService
    implements EntityExportTabInfo {
        @Override
        public BidiMap<String, String> getCommonColumns() {
            DualLinkedHashBidiMap result = new DualLinkedHashBidiMap();
            result.put((Object)"growingSystemName", (Object)"Syst\u00e8me De Culture");
            result.put((Object)"sector", (Object)"Fili\u00e8re");
            result.put((Object)"startingDate", (Object)"Date de d\u00e9but d'utilisation");
            result.put((Object)"growingPlanName", (Object)"Dispositif");
            result.put((Object)"domainName", (Object)"Domaine");
            result.put((Object)"campaign", (Object)"Campagne");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            DualLinkedHashBidiMap result = new DualLinkedHashBidiMap();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            LinkedHashMap result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            HashMap result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            return result;
        }
    }
}

