/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.growingsystem;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRuleTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdCTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgricultureTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.ExtendContext;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.growingSystem.GrowingSystemAndDependencies;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.CacheService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.growingsystem.export.ExportGrowingSystemEntity;
import fr.inra.agrosyst.services.growingsystem.export.ExportGrowingSystemMetadata;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class GrowingSystemServiceImpl
extends AbstractAgrosystService
implements GrowingSystemService {
    private static final Log log = LogFactory.getLog(GrowingSystemServiceImpl.class);
    protected PlotService plotService;
    protected ManagementModeService managementModeService;
    protected AnonymizeService anonymizeService;
    protected BusinessAuthorizationService authorizationService;
    protected CacheService cacheService;
    protected GrowingSystemTopiaDao growingSystemDao;
    protected NetworkTopiaDao networkDao;
    protected DecisionRuleTopiaDao decisionRuleDao;
    protected ManagementModeTopiaDao managementModeDao;
    protected RefTypeAgricultureTopiaDao refTypeAgricultureDao;
    protected PracticedSystemTopiaDao practicedSystemDao;
    protected RefTraitSdCTopiaDao refTraitSdCDao;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setGrowingSystemDao(GrowingSystemTopiaDao growingSystemDao) {
        this.growingSystemDao = growingSystemDao;
    }

    public void setNetworkDao(NetworkTopiaDao networkDao) {
        this.networkDao = networkDao;
    }

    public void setDecisionRuleDao(DecisionRuleTopiaDao decisionRuleDao) {
        this.decisionRuleDao = decisionRuleDao;
    }

    public void setManagementModeDao(ManagementModeTopiaDao managementModeDao) {
        this.managementModeDao = managementModeDao;
    }

    public void setRefTypeAgricultureDao(RefTypeAgricultureTopiaDao refTypeAgricultureDao) {
        this.refTypeAgricultureDao = refTypeAgricultureDao;
    }

    public void setPracticedSystemDao(PracticedSystemTopiaDao practicedSystemDao) {
        this.practicedSystemDao = practicedSystemDao;
    }

    public void setRefTraitSdCDao(RefTraitSdCTopiaDao refTraitSdCDao) {
        this.refTraitSdCDao = refTraitSdCDao;
    }

    public ResultList<GrowingSystem> getFilteredGrowingSystems(GrowingSystemFilter filter) {
        ResultList<GrowingSystem> result = this.growingSystemDao.getFilteredGrowingSystems(filter, this.getSecurityContext());
        return result;
    }

    public ResultList<GrowingSystemDto> getFilteredGrowingSystemsDto(GrowingSystemFilter filter) {
        ResultList<GrowingSystem> growingSystems = this.getFilteredGrowingSystems(filter);
        ResultList result = ResultList.transform(growingSystems, (Function)this.anonymizeService.getGrowingSystemToDtoFunction());
        for (GrowingSystemDto gs : result.getElements()) {
            boolean canValidate = this.authorizationService.isGrowingSystemValidable(gs.getTopiaId());
            gs.setUserCanValidate(canValidate);
        }
        return result;
    }

    public List<GrowingSystemDto> getGrowingSystems(Collection<String> growingSystemIds) {
        List growingSystems = this.growingSystemDao.forTopiaIdIn(growingSystemIds).findAll();
        List result = Lists.transform((List)growingSystems, (Function)this.anonymizeService.getGrowingSystemToDtoFunction());
        return result;
    }

    public GrowingSystem getGrowingSystem(String growingSystemId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)growingSystemId) ? 1 : 0) != 0);
        GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();
        GrowingSystem result = this.anonymizeService.checkForGrowingSystemAnonymization(growingSystem);
        return result;
    }

    public GrowingSystem newGrowingSystem() {
        GrowingSystem result = (GrowingSystem)this.growingSystemDao.newInstance();
        return result;
    }

    public GrowingSystem createOrUpdateGrowingSystem(GrowingSystem growingSystem, List<String> growingSystemNetworkIds, Collection<String> selectedPlotsIds, String typeAgricultureTopiaId, List<String> growingSystemCharacteristicIds) {
        String growingSystemId = growingSystem.getTopiaId();
        this.authorizationService.checkCreateOrUpdateGrowingSystem(growingSystemId);
        GrowingSystem result = this.createOrUpdateGrowingSystemWithoutCommit(growingSystem, growingSystemNetworkIds, selectedPlotsIds, typeAgricultureTopiaId, growingSystemCharacteristicIds);
        this.addUserAuthorization(growingSystemId, result);
        this.getTransaction().commit();
        return result;
    }

    protected void addUserAuthorization(String growingSystemId, GrowingSystem result) {
        if (StringUtils.isBlank((CharSequence)growingSystemId)) {
            this.authorizationService.growingSystemCreated(result);
        }
    }

    protected GrowingSystem createOrUpdateGrowingSystemWithoutCommit(GrowingSystem growingSystem, List<String> growingSystemNetworkIds, Collection<String> selectedPlotsIds, String typeAgricultureId, List<String> growingSystemCharacteristicIds) {
        GrowingSystem result;
        if (growingSystemNetworkIds != null) {
            List networks = this.networkDao.forTopiaIdIn(growingSystemNetworkIds).findAll();
            Preconditions.checkArgument((networks.size() == growingSystemNetworkIds.size() ? 1 : 0) != 0, (Object)"R\u00e9seau non retrouv\u00e9 !");
            growingSystem.setNetworks((Collection)networks);
        } else {
            growingSystem.clearNetworks();
        }
        this.cacheService.clear();
        if (growingSystemCharacteristicIds != null) {
            List growingSystemCharacteristics = this.refTraitSdCDao.forTopiaIdIn(growingSystemCharacteristicIds).findAll();
            Preconditions.checkArgument((growingSystemCharacteristics.size() == growingSystemCharacteristicIds.size() ? 1 : 0) != 0, (Object)"Charact\u00e9ristiques non trouv\u00e9es !");
            growingSystem.setCharacteristics((Collection)growingSystemCharacteristics);
        }
        growingSystem.setUpdateDate(this.context.getCurrentDate());
        if (StringUtils.isBlank((CharSequence)growingSystem.getTopiaId())) {
            growingSystem.setActive(true);
            this.setGrowingSystemCode(growingSystem);
            result = (GrowingSystem)this.growingSystemDao.create((TopiaEntity)growingSystem);
        } else {
            result = (GrowingSystem)this.growingSystemDao.update((TopiaEntity)growingSystem);
        }
        RefTypeAgriculture typeAgriculture = null;
        if (StringUtils.isNotBlank((CharSequence)typeAgricultureId)) {
            typeAgriculture = (RefTypeAgriculture)this.refTypeAgricultureDao.forTopiaIdEquals(typeAgricultureId).findUnique();
        }
        growingSystem.setTypeAgriculture(typeAgriculture);
        this.plotService.updatePlotsGrowingSystemRelationship(growingSystem, selectedPlotsIds);
        return result;
    }

    private void setGrowingSystemCode(GrowingSystem growingSystem) {
        if (StringUtils.isBlank((CharSequence)growingSystem.getCode())) {
            growingSystem.setCode(UUID.randomUUID().toString());
        }
    }

    public List<GrowingSystem> findAllByGrowingPlan(GrowingPlan growingPlan) {
        List result = this.growingSystemDao.forGrowingPlanEquals(growingPlan).findAll();
        return result;
    }

    public GrowingSystem duplicateGrowingSystem(ExtendContext extendContext, GrowingPlan clonedGrowingPlan, GrowingSystem growingSystem) {
        Binder binder = BinderFactory.newBinder(GrowingSystem.class);
        GrowingSystem clonedGrowingSystem = (GrowingSystem)this.growingSystemDao.newInstance();
        binder.copyExcluding((Object)growingSystem, (Object)clonedGrowingSystem, new String[]{"topiaId", "growingPlan", "networks", "updateDate", "validationDate"});
        clonedGrowingSystem.setGrowingPlan(clonedGrowingPlan);
        clonedGrowingSystem.setValidated(false);
        if (extendContext.isDuplicateOnly()) {
            clonedGrowingSystem.setCode(UUID.randomUUID().toString());
        }
        if (growingSystem.getNetworks() != null) {
            clonedGrowingSystem.setNetworks((Collection)Lists.newArrayList((Iterable)growingSystem.getNetworks()));
        }
        if (growingSystem.getCharacteristics() != null) {
            clonedGrowingSystem.setCharacteristics((Collection)Lists.newArrayList((Iterable)growingSystem.getCharacteristics()));
        }
        clonedGrowingSystem.setUpdateDate(this.context.getCurrentDate());
        GrowingSystem clonedGrowingSystemResult = (GrowingSystem)this.growingSystemDao.create((TopiaEntity)clonedGrowingSystem);
        ManagementMode managementMode = (ManagementMode)this.managementModeDao.forGrowingSystemEquals(growingSystem).addEquals("active", (Object)true).addEquals("category", (Object)ManagementModeCategory.OBSERVED).findUniqueOrNull();
        if (managementMode == null) {
            managementMode = (ManagementMode)this.managementModeDao.forGrowingSystemEquals(growingSystem).addEquals("active", (Object)true).addEquals("category", (Object)ManagementModeCategory.PLANNED).findUniqueOrNull();
        }
        if (managementMode != null) {
            this.managementModeService.extendManagementMode(extendContext, managementMode, clonedGrowingSystem);
        }
        return clonedGrowingSystemResult;
    }

    public void unactivateGrowingSystems(List<String> growingSystemsIds, boolean activate) {
        if (CollectionUtils.isNotEmpty(growingSystemsIds)) {
            for (String growingSystemId : growingSystemsIds) {
                GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();
                growingSystem.setActive(activate);
                Date now = this.context.getCurrentDate();
                if (growingSystem.getEndingDate() == null) {
                    growingSystem.setEndingDate(now);
                }
                growingSystem.setUpdateDate(now);
                this.growingSystemDao.update((TopiaEntity)growingSystem);
            }
            this.getTransaction().commit();
        }
    }

    public List<GrowingSystem> findAllActiveByDomainForPlotEdit(Domain domain) {
        List<GrowingSystem> result = this.growingSystemDao.findAllActiveWritableByDomain(domain, this.getSecurityContext());
        return result;
    }

    public LinkedHashMap<Integer, String> getRelatedGrowingSystems(String growingSystemCode) {
        LinkedHashMap<Integer, String> result = this.growingSystemDao.findAllRelatedGrowingSystemsByCampaigns(growingSystemCode);
        return result;
    }

    public long getGrowingSystemsCount(Boolean active) {
        if (active == null) {
            return this.growingSystemDao.count();
        }
        return this.growingSystemDao.forActiveEquals(active).count();
    }

    public List<GrowingSystem> findAllByNetwork(Network network) {
        List result = this.growingSystemDao.forNetworksContains(network).findAll();
        return result;
    }

    public GrowingSystem validate(String growingSystemId) {
        this.authorizationService.checkValidateGrowingSystem(growingSystemId);
        this.growingSystemDao.validateGrowingSystem(growingSystemId, this.context.getCurrentDate());
        this.getTransaction().commit();
        this.getPersistenceContext().getHibernateSupport().getHibernateSession().clear();
        GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();
        return growingSystem;
    }

    public List<RefTypeAgriculture> findAllTypeAgricultures() {
        List result = this.refTypeAgricultureDao.newQueryBuilder().setOrderByArguments(new String[]{"reference_label"}).findAll();
        return result;
    }

    public List<PracticedSystem> getPracticedSystems(String growingSystemCode) {
        List result = this.practicedSystemDao.forProperties("growingSystem.code", growingSystemCode, new Object[0]).setOrderByArguments(new String[]{"campaigns", "growingSystem.name"}).findAll();
        return result;
    }

    public List<ManagementMode> getManagementModes(String growingSystemId) {
        List result = this.managementModeDao.forProperties("growingSystem.topiaId", growingSystemId, new Object[0]).setOrderByArguments(new String[]{"versionNumber", "category"}).findAll();
        return result;
    }

    public List<Integer> getGrowingSystemCampaigns(String growingSystemCode) {
        List<Integer> result = this.growingSystemDao.findCampaigns(growingSystemCode);
        return result;
    }

    public List<GrowingSystem> getAvailableGsForDuplication(String practicedSystemId, NavigationContext navigationContext) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)practicedSystemId) ? 1 : 0) != 0);
        PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
        growingSystemFilter.setPageSize(-1);
        growingSystemFilter.setActive(Boolean.valueOf(true));
        growingSystemFilter.setNavigationContext(navigationContext);
        List<GrowingSystem> result = this.growingSystemDao.findAllAvailableFoPracticedSystemDuplication(growingSystemFilter, practicedSystem.getGrowingSystem());
        return result;
    }

    public List<GrowingSystem> getGrowingSystemWithNameAndCampaign(String growingSystemName, Integer campaign) {
        List result;
        Preconditions.checkNotNull((Object)growingSystemName);
        if (campaign != null) {
            String campaignProperty = "growingPlan.domain.campaign";
            result = this.growingSystemDao.forProperties("name", growingSystemName, new Object[]{campaignProperty, campaign}).findAll();
        } else {
            result = this.growingSystemDao.forProperties("name", growingSystemName, new Object[0]).findAll();
        }
        return result;
    }

    public InputStream exportGrowingSystemsAsXlsStream(List<String> growingSystemIds) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        ExportGrowingSystemMetadata.GrowingSystemMainBeanInfo mainBeanTab = new ExportGrowingSystemMetadata.GrowingSystemMainBeanInfo();
        ExportGrowingSystemMetadata.GrowingSystemCaracteristicsBeanInfo characteristicTab = new ExportGrowingSystemMetadata.GrowingSystemCaracteristicsBeanInfo();
        ExportGrowingSystemMetadata.GrowingSystemPlotsBeanInfo plotBeanTab = new ExportGrowingSystemMetadata.GrowingSystemPlotsBeanInfo();
        ExportUtils.addAllBeanInfo(sheet, mainBeanTab, characteristicTab, plotBeanTab);
        List characteristicsEntities = (List)sheet.get(characteristicTab);
        List plotEntities = (List)sheet.get(plotBeanTab);
        try {
            if (growingSystemIds != null && !growingSystemIds.isEmpty()) {
                Iterable growingSystems = this.growingSystemDao.forTopiaIdIn(growingSystemIds).findAllLazy(100);
                for (GrowingSystem growingSystem : growingSystems) {
                    List plots;
                    growingSystem = this.anonymizeService.checkForGrowingSystemAnonymization(growingSystem);
                    ExportGrowingSystemEntity model = new ExportGrowingSystemEntity();
                    model.setGrowingSystemName(growingSystem.getName());
                    model.setSector(growingSystem.getSector());
                    model.setStartingDate(growingSystem.getStartingDate());
                    model.setGrowingPlanName(growingSystem.getGrowingPlan().getName());
                    model.setDomainName(growingSystem.getGrowingPlan().getDomain().getName());
                    model.setCampaign(growingSystem.getGrowingPlan().getDomain().getCampaign());
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, growingSystem, (EntityExportTabInfo)mainBeanTab);
                    Collection characteristics = growingSystem.getCharacteristics();
                    if (characteristics != null && !characteristics.isEmpty()) {
                        for (RefTraitSdC characteristic : characteristics) {
                            ExportGrowingSystemEntity export = (ExportGrowingSystemEntity)model.clone();
                            ExportUtils.copyFields(characteristic, (EntityExportExtra)export, null, "nom_trait", "type_trait_sdc");
                            if (growingSystem.getTypeAgriculture() != null) {
                                ExportUtils.setExtraField(export, "typeAgriculture", growingSystem.getTypeAgriculture().getReference_label());
                            }
                            ExportUtils.setExtraField(export, "categoryStrategy", growingSystem.getCategoryStrategy());
                            String characteristicComment = null;
                            if (StringUtils.isNotBlank((CharSequence)growingSystem.getCycleManagementComment())) {
                                characteristicComment = growingSystem.getCycleManagementComment();
                            } else if (StringUtils.isNotBlank((CharSequence)growingSystem.getCultureManagementComment())) {
                                characteristicComment = growingSystem.getCultureManagementComment();
                            } else if (StringUtils.isNotBlank((CharSequence)growingSystem.getGroundWorkComment())) {
                                characteristicComment = growingSystem.getGroundWorkComment();
                            } else if (StringUtils.isNotBlank((CharSequence)growingSystem.getParcelsManagementComment())) {
                                characteristicComment = growingSystem.getParcelsManagementComment();
                            }
                            ExportUtils.setExtraField(export, "characteristicComment", characteristicComment);
                            characteristicsEntities.add(export);
                        }
                    }
                    if ((plots = this.plotService.getAllGrowingSystemPlot(growingSystem)) == null) continue;
                    for (Plot plot : plots) {
                        ExportGrowingSystemEntity export = (ExportGrowingSystemEntity)model.clone();
                        ExportUtils.copyFields(plot, (EntityExportExtra)export, null, "name", "pacIlotNumber");
                        ExportUtils.setExtraField(export, "plotOutComment", growingSystem.getPlotOutputReason());
                        plotEntities.add(export);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }

    public LinkedHashMap<Integer, List<String>> getGSCodeGPCodeDomainCodeByCampaignForGrowingSystemDephyId(String dephy) {
        LinkedHashMap<Integer, List<String>> result = null;
        if (StringUtils.isNotBlank((CharSequence)dephy)) {
            result = this.growingSystemDao.findAllDephyRelatedGSCodesGPCodesDomainCodesByCampaigns(dephy);
        }
        return result;
    }

    public void importPZ0GrowingSystems(Map<Class, ImportResults> allResults) {
        ImportResults growingSystemsImportResults = allResults.remove(GrowingSystem.class);
        if (growingSystemsImportResults != null && growingSystemsImportResults.getIgnoredRecords() == 0) {
            try {
                Map entitiesAndDependencies = growingSystemsImportResults.getEntityAndDepsByCsvIds();
                int count = 1;
                int total = entitiesAndDependencies.values().size();
                for (EntityAndDependencies entityAndDependencies : entitiesAndDependencies.values()) {
                    GrowingSystemAndDependencies growingSystemAndDependencies = (GrowingSystemAndDependencies)entityAndDependencies;
                    GrowingSystem growingSystem = (GrowingSystem)growingSystemAndDependencies.getEntity();
                    long start = System.currentTimeMillis();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("D\u00e9but sauvegarde du SDC %s - %d/%d.", growingSystem.getName(), count++, total));
                    }
                    String refTypeAgricultureTopiaId = growingSystemAndDependencies.getRefTypeAgricultureId();
                    List linkedNetworks = growingSystemAndDependencies.getNetworksId();
                    GrowingSystem persistedGrowingSystem = this.createOrUpdateGrowingSystemWithoutCommit(growingSystem, linkedNetworks, null, refTypeAgricultureTopiaId, null);
                    entityAndDependencies.setEntity((TopiaEntity)persistedGrowingSystem);
                    long p1 = System.currentTimeMillis();
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Fin de sauvegarde du SDC, traitement r\u00e9alis\u00e9 en:" + (p1 - start)));
                }
            }
            catch (Exception e) {
                throw new AgrosystImportException("Echec de persistance des syst\u00e8mes de culture", (Throwable)e);
            }
        }
    }
}

