/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.growingplan;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanImpl;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.ExtendContext;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.EntityImporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.growingplan.export.GrowingPlanExportEntity;
import fr.inra.agrosyst.services.growingplan.export.GrowingPlanExportMetadata;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class GrowingPlanServiceImpl
extends AbstractAgrosystService
implements GrowingPlanService {
    private static final Log log = LogFactory.getLog(GrowingPlanServiceImpl.class);
    protected GrowingSystemService growingSystemService;
    protected AnonymizeService anonymizeService;
    protected BusinessAuthorizationService authorizationService;
    protected GrowingPlanTopiaDao growingPlanDao;
    protected GrowingSystemTopiaDao growingSystemDao;
    protected DomainTopiaDao domainDao;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setGrowingSystemDao(GrowingSystemTopiaDao growingSystemDao) {
        this.growingSystemDao = growingSystemDao;
    }

    public void setGrowingPlanDao(GrowingPlanTopiaDao growingPlanDao) {
        this.growingPlanDao = growingPlanDao;
    }

    public void setDomainDao(DomainTopiaDao domainDao) {
        this.domainDao = domainDao;
    }

    public ResultList<GrowingPlan> getFilteredGrowingPlans(GrowingPlanFilter filter) {
        ResultList<GrowingPlan> result = this.growingPlanDao.getFilteredGrowingPlans(filter, this.getSecurityContext());
        return result;
    }

    public ResultList<GrowingPlanDto> getFilteredGrowingPlansDto(GrowingPlanFilter filter) {
        ResultList<GrowingPlan> growingPlans = this.getFilteredGrowingPlans(filter);
        ResultList result = ResultList.transform(growingPlans, (Function)this.anonymizeService.getGrowingPlanToDtoFunction(true));
        return result;
    }

    public void unactivateGrowingPlans(List<String> growingPlanIds, boolean activate) {
        if (CollectionUtils.isNotEmpty(growingPlanIds)) {
            for (String growingPlanId : growingPlanIds) {
                GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanId).findUnique();
                growingPlan.setActive(activate);
                growingPlan.setUpdateDate(this.context.getCurrentDate());
                this.growingPlanDao.update((TopiaEntity)growingPlan);
            }
            this.getTransaction().commit();
        }
    }

    public GrowingPlan getGrowingPlan(String growingPlanId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)growingPlanId) ? 1 : 0) != 0);
        GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanId).findUnique();
        GrowingPlan result = this.anonymizeService.checkForGrowingPlanAnonymization(growingPlan);
        return result;
    }

    public GrowingPlan createOrUpdateGrowingPlan(GrowingPlan growingPlan) {
        String growingPlanId = growingPlan.getTopiaId();
        this.authorizationService.checkCreateOrUpdateGrowingPlan(growingPlanId);
        GrowingPlan result = this.createOrUpdateGrowingPlanWithoutCommit(growingPlan);
        this.addUserAuthorization(growingPlanId, result);
        result = this.validateAndCommit(result.getTopiaId());
        return result;
    }

    protected void addUserAuthorization(String growingPlanId, GrowingPlan result) {
        if (StringUtils.isBlank((CharSequence)growingPlanId)) {
            this.authorizationService.growingPlanCreated(result);
        }
    }

    protected GrowingPlan createOrUpdateGrowingPlanWithoutCommit(GrowingPlan growingPlan) {
        GrowingPlan result;
        growingPlan.setUpdateDate(this.context.getCurrentDate());
        if (StringUtils.isBlank((CharSequence)growingPlan.getTopiaId())) {
            if (StringUtils.isBlank((CharSequence)growingPlan.getCode())) {
                String code = UUID.randomUUID().toString();
                growingPlan.setCode(code);
            }
            growingPlan.setActive(true);
            result = (GrowingPlan)this.growingPlanDao.create((TopiaEntity)growingPlan);
        } else {
            result = (GrowingPlan)this.growingPlanDao.update((TopiaEntity)growingPlan);
        }
        return result;
    }

    public GrowingPlan newGrowingPlan() {
        GrowingPlan result = (GrowingPlan)this.growingPlanDao.newInstance();
        return result;
    }

    public List<GrowingPlan> findAllByDomain(Domain domain) {
        List result = this.growingPlanDao.forDomainEquals(domain).findAll();
        return result;
    }

    public GrowingPlan duplicateGrowingPlan(String growingPlanId, String duplicateDomainId, boolean duplicateGrowingSystems) {
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(duplicateDomainId).findUnique();
        GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanId).findUnique();
        GrowingPlan duplicatedGrowingPlan = this.duplicateGrowingPlan(new ExtendContext(true), domain, growingPlan, duplicateGrowingSystems);
        duplicatedGrowingPlan.setUpdateDate(this.context.getCurrentDate());
        this.growingPlanDao.update((TopiaEntity)duplicatedGrowingPlan);
        this.getTransaction().commit();
        return duplicatedGrowingPlan;
    }

    public GrowingPlan duplicateGrowingPlan(ExtendContext extendContext, Domain clonedDomain, GrowingPlan growingPlan, boolean duplicateGrowingSystems) {
        Binder growingPlanBinder = BinderFactory.newBinder(GrowingPlan.class);
        GrowingPlan clonedGrowingPlan = (GrowingPlan)this.growingPlanDao.newInstance();
        growingPlanBinder.copyExcluding((Object)growingPlan, (Object)clonedGrowingPlan, new String[]{"topiaId", "domain"});
        clonedGrowingPlan.setDomain(clonedDomain);
        if (extendContext.isDuplicateOnly()) {
            clonedGrowingPlan.setCode(UUID.randomUUID().toString());
        }
        Date currentDate = this.context.getCurrentDate();
        clonedGrowingPlan.setUpdateDate(currentDate);
        clonedGrowingPlan.setValidated(true);
        clonedGrowingPlan.setValidationDate(currentDate);
        clonedGrowingPlan = (GrowingPlan)this.growingPlanDao.create((TopiaEntity)clonedGrowingPlan);
        if (duplicateGrowingSystems) {
            HashMap growingSystemCache = Maps.newHashMap();
            List growingSystems = this.growingSystemDao.forGrowingPlanEquals(growingPlan).addEquals("active", (Object)true).findAll();
            for (GrowingSystem growingSystem : growingSystems) {
                GrowingSystem clone = this.growingSystemService.duplicateGrowingSystem(extendContext, clonedGrowingPlan, growingSystem);
                growingSystemCache.put(growingSystem, clone);
            }
            extendContext.setGrowingSystemCache((Map)growingSystemCache);
        }
        return clonedGrowingPlan;
    }

    public LinkedHashMap<Integer, String> getRelatedGrowingPlans(String growingPlanCode) {
        LinkedHashMap<Integer, String> result = this.growingPlanDao.findAllRelatedGrowingPlans(growingPlanCode);
        return result;
    }

    public long getGrowingPlansCount(Boolean active) {
        if (active == null) {
            return this.growingPlanDao.count();
        }
        return this.growingPlanDao.forActiveEquals(active).count();
    }

    public GrowingPlan validateAndCommit(String growingPlanId) {
        this.authorizationService.checkValidateGrowingPlan(growingPlanId);
        this.growingPlanDao.validateGrowingPlan(growingPlanId, this.context.getCurrentDate());
        this.getTransaction().commit();
        this.getPersistenceContext().getHibernateSupport().getHibernateSession().clear();
        GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanId).findUnique();
        return growingPlan;
    }

    public List<GrowingSystem> getGrowingPlanGrowingSystems(String growingPlanId) {
        List result = this.growingSystemDao.forProperties("growingPlan.topiaId", growingPlanId, new Object[0]).setOrderByArguments(new String[]{"name"}).findAll();
        return result;
    }

    public List<GrowingPlan> getGrowingPlanWithName(String growingPlanName) {
        Preconditions.checkNotNull((Object)growingPlanName);
        List result = this.growingPlanDao.forNameEquals(growingPlanName).findAll();
        return result;
    }

    public InputStream exportGrowingPlanAsXlsStream(List<String> growingPlanIds) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        GrowingPlanExportMetadata.GrowingPlanMainBeanInfo growingPlanMainBeanInfo = this.newInstance(GrowingPlanExportMetadata.GrowingPlanMainBeanInfo.class);
        ExportUtils.addAllBeanInfo(sheet, growingPlanMainBeanInfo);
        try {
            if (CollectionUtils.isNotEmpty(growingPlanIds)) {
                Iterable growingPlans = this.growingPlanDao.forTopiaIdIn(growingPlanIds).findAllLazy(100);
                for (GrowingPlan gp : growingPlans) {
                    gp = this.anonymizeService.checkForGrowingPlanAnonymization(gp);
                    GrowingPlanExportEntity model = new GrowingPlanExportEntity();
                    model.setDomainName(gp.getDomain().getName());
                    model.setCampaign(gp.getDomain().getCampaign());
                    model.setGrowingPlanName(gp.getName());
                    model.setTypeName(ExportUtils.TYPE_DEPHY_FORMATTER.format((Object)gp.getType()));
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, gp, (EntityExportTabInfo)growingPlanMainBeanInfo);
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }

    public void importGrowingPlanForXlsStream(InputStream is) {
        GrowingPlanExportMetadata.GrowingPlanMainBeanInfo growingPlanMainBeanInfo = this.newInstance(GrowingPlanExportMetadata.GrowingPlanMainBeanInfo.class);
        EntityImporter importer = new EntityImporter();
        Map<EntityExportTabInfo, List<GrowingPlanExportEntity>> datas = importer.importFromStream(is, GrowingPlanExportEntity.class, growingPlanMainBeanInfo);
        try {
            List<GrowingPlanExportEntity> mainBeanInfo = datas.get(growingPlanMainBeanInfo);
            for (GrowingPlanExportEntity beanInfo : mainBeanInfo) {
                Domain domain = (Domain)this.domainDao.forProperties("name", beanInfo.getDomainName(), new Object[]{"campaign", beanInfo.getCampaign()}).findUnique();
                GrowingPlanImpl growingPlan = new GrowingPlanImpl();
                growingPlan.setDomain(domain);
                growingPlan.setName(beanInfo.getGrowingPlanName());
                growingPlan.setType((TypeDEPHY)AbstractAgrosystModel.TYPE_DEPHY_PARSER.parse(beanInfo.getTypeName()));
                ExportUtils.copyFields(beanInfo, growingPlan, "description", "goals", "protocolReference", "institutionalStructure");
                growingPlan.setActive(true);
                growingPlan.setCode(UUID.randomUUID().toString());
                growingPlan.setUpdateDate(this.getContext().getCurrentDate());
                this.growingPlanDao.create((TopiaEntity)growingPlan);
            }
            this.getTransaction().commit();
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy fields", (Throwable)ex);
        }
    }

    public void importPZ0GrowingPlans(Map<Class, ImportResults> allResults) {
        ImportResults growingPlanResult = allResults.remove(GrowingPlan.class);
        if (growingPlanResult != null && growingPlanResult.getIgnoredRecords() == 0) {
            try {
                Map entityAndDependencies = growingPlanResult.getEntityAndDepsByCsvIds();
                int count = 1;
                int total = entityAndDependencies.values().size();
                for (EntityAndDependencies growingPlanAndDependencies : entityAndDependencies.values()) {
                    GrowingPlan growingPlan = (GrowingPlan)growingPlanAndDependencies.getEntity();
                    long start = System.currentTimeMillis();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("D\u00e9but sauvegarde du dipositif %s - %d/%d.", growingPlan.getName(), count++, total));
                    }
                    growingPlan = this.createOrUpdateGrowingPlanWithoutCommit(growingPlan);
                    growingPlanAndDependencies.setEntity((TopiaEntity)growingPlan);
                    long p1 = System.currentTimeMillis();
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Fin de sauvegarde du dispositif, traitement r\u00e9alis\u00e9 en:" + (p1 - start)));
                }
            }
            catch (Exception e) {
                throw new AgrosystImportException("Echec de persistance des dispositifs", (Throwable)e);
            }
        }
    }
}

