/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.generic;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.referential.ReferentialEntity;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.api.services.generic.GenericFilter;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;
import org.nuiton.util.PagerBean;

public class GenericEntityServiceImpl
extends AbstractAgrosystService
implements GenericEntityService {
    private static final Log log = LogFactory.getLog(GenericEntityServiceImpl.class);
    protected static final String PROPERTY_VALEUR = "Valeur";
    protected static final Function<Object, Map<String, String>> ENUM_NAME_AS_MAP = new Function<Object, Map<String, String>>(){

        public Map<String, String> apply(Object enumConstant) {
            Enum anEnum = (Enum)enumConstant;
            LinkedHashMap result = Maps.newLinkedHashMap();
            result.put(GenericEntityServiceImpl.PROPERTY_VALEUR, anEnum.name());
            return result;
        }
    };
    protected static final Function<String, Class<?>> GET_CLASS = new Function<String, Class<?>>(){

        public Class<?> apply(String input) {
            try {
                return Class.forName(input);
            }
            catch (ClassNotFoundException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"An exception occurred", (Throwable)e);
                }
                throw new AgrosystTechnicalException("Class not found", (Throwable)e);
            }
        }
    };
    protected BusinessAuthorizationService authorizationService;

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public ResultList<?> listEntities(Class<?> klass, GenericFilter filter) {
        ResultList result;
        this.authorizationService.checkIsAdmin();
        Preconditions.checkArgument((!AgrosystUser.class.equals(klass) ? 1 : 0) != 0, (Object)("Forbidden entity: " + klass));
        if (klass.isEnum()) {
            Object[] enumConstants = klass.getEnumConstants();
            PagerBean pager = DaoUtils.getPager(0, enumConstants.length, enumConstants.length);
            Iterable transformed = Iterables.transform((Iterable)Lists.newArrayList((Object[])enumConstants), ENUM_NAME_AS_MAP);
            result = ResultList.of((List)Lists.newArrayList((Iterable)transformed), (PagerBean)pager);
        } else if (TopiaEntity.class.isAssignableFrom(klass)) {
            Class<?> entityKlass = klass;
            TopiaDao dao = this.context.getDaoSupplier().getDao(entityKlass);
            StringBuilder query = new StringBuilder(String.format(" FROM %s t ", dao.getEntityClass().getName()));
            query.append(" WHERE 1 = 1 ");
            LinkedHashMap args = Maps.newLinkedHashMap();
            if (filter != null) {
                Map propertyNamesAndValues = filter.getPropertyNamesAndValues();
                if (propertyNamesAndValues != null) {
                    for (Map.Entry entry : propertyNamesAndValues.entrySet()) {
                        String propertyName = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (value.isEmpty()) continue;
                        Class returnType = this.getReturnType(entityKlass, propertyName);
                        if (returnType != null) {
                            try {
                                if (returnType.isAssignableFrom(String.class) || returnType.isEnum()) {
                                    String subQuery = DaoUtils.andAttributeLike("t", propertyName, args, value);
                                    query.append(subQuery);
                                    continue;
                                }
                                Object arg = ConvertUtils.convert((String)value, (Class)returnType);
                                String subQuery = DaoUtils.andAttributeEquals("t", propertyName, args, arg);
                                query.append(subQuery);
                            }
                            catch (NumberFormatException ex) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Invalid value for numeric field", (Throwable)ex);
                            }
                            continue;
                        }
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't get return type for property " + propertyName + " on " + entityKlass.getName()));
                    }
                }
                String subQuery = DaoUtils.andAttributeEquals("t", "active", args, filter.getActive());
                query.append(subQuery);
            }
            int page = filter != null ? filter.getPage() : 0;
            int count = filter != null ? filter.getPageSize() : 10;
            int startIndex = page * count;
            int endIndex = page * count + count - 1;
            TopiaJpaSupport jpaSupport = this.getPersistenceContext().getJpaSupport();
            List entities = jpaSupport.find(query.toString() + " ORDER BY t." + "topiaCreateDate" + ", t." + "topiaId", startIndex, endIndex, (Map)args);
            long totalCount = ((Number)jpaSupport.findUnique("SELECT COUNT(*) " + query.toString(), (Map)args)).longValue();
            PagerBean pager = DaoUtils.getPager(page, count, totalCount);
            result = ResultList.of((List)entities, (PagerBean)pager);
        } else {
            throw new UnsupportedOperationException("This class cannot be used in this service: " + klass);
        }
        return result;
    }

    protected Class getReturnType(Class klass, String methodName) {
        Class result;
        block4: {
            result = null;
            try {
                Method method = klass.getDeclaredMethod("get" + StringUtils.capitalize((String)methodName), new Class[0]);
                result = method.getReturnType();
            }
            catch (NoSuchMethodException ex) {
                Class<?>[] superKlass = klass.getInterfaces();
                for (int i = 0; i < superKlass.length && result == null; ++i) {
                    result = this.getReturnType(superKlass[i], methodName);
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Can't get method return type", (Throwable)ex);
            }
        }
        return result;
    }

    public Map<String, Long> countEntities(Class<?> ... classes) {
        List<Class<?>> list = Arrays.asList(classes);
        Map<String, Long> result = this.countEntities0(list);
        return result;
    }

    protected Map<String, Long> countEntities0(Iterable<Class<?>> classes) {
        this.authorizationService.checkIsAdmin();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Class<?> klass : classes) {
            if (klass.isEnum()) {
                ?[] enumConstants = klass.getEnumConstants();
                long count = enumConstants == null ? 0L : (long)enumConstants.length;
                result.put(klass.getName(), count);
                continue;
            }
            if (TopiaEntity.class.isAssignableFrom(klass)) {
                Class<?> entityKlass = klass;
                TopiaDao dao = this.context.getDaoSupplier().getDao(entityKlass);
                long count = dao.count();
                result.put(klass.getName(), count);
                continue;
            }
            throw new UnsupportedOperationException("This class cannot be used in this service: " + klass);
        }
        return result;
    }

    public List<String> getProperties(Class<?> klass) {
        this.authorizationService.checkIsAdmin();
        ArrayList result = Lists.newArrayList();
        if (klass.isEnum()) {
            result.add(PROPERTY_VALEUR);
        } else if (TopiaEntity.class.isAssignableFrom(klass)) {
            Class<?> entityKlass = klass;
            Set<Class<? extends TopiaEntity>> allClasses = this.getAllClassesExceptTopiaEntity(entityKlass);
            for (Class<? extends TopiaEntity> aClass : allClasses) {
                for (Field declaredField : aClass.getDeclaredFields()) {
                    if (!declaredField.getName().startsWith("PROPERTY_")) continue;
                    try {
                        String value = (String)declaredField.get(null);
                        result.add(value);
                    }
                    catch (IllegalAccessException e) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)"Un exception occured", (Throwable)e);
                    }
                }
            }
        } else {
            throw new UnsupportedOperationException("This class cannot be used in this service: " + klass);
        }
        return result;
    }

    protected Set<Class<? extends TopiaEntity>> getAllClassesExceptTopiaEntity(Class<? extends TopiaEntity> entityClass) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        Class<?>[] interfaces = entityClass.getInterfaces();
        if (interfaces != null) {
            for (Class<?> aClass : interfaces) {
                if (TopiaEntity.class.equals(aClass) || !TopiaEntity.class.isAssignableFrom(aClass)) continue;
                Class<?> parentClass = aClass;
                Set<Class<? extends TopiaEntity>> parentClasses = this.getAllClassesExceptTopiaEntity(parentClass);
                result.addAll(parentClasses);
            }
        }
        result.add(entityClass);
        return result;
    }

    public void unactivateEntities(Class<?> klass, List<String> entityIds, boolean activate) {
        this.authorizationService.checkIsAdmin();
        if (ReferentialEntity.class.isAssignableFrom(klass)) {
            Class<?> entityKlass = klass;
            TopiaDao dao = this.context.getDaoSupplier().getDao(entityKlass);
            for (String entityId : entityIds) {
                TopiaEntity entity = dao.forTopiaIdEquals(entityId).findUnique();
                ((ReferentialEntity)entity).setActive(activate);
                dao.update(entity);
            }
        } else {
            throw new UnsupportedOperationException("This class cannot be used in this service: " + klass);
        }
        this.getTransaction().commit();
    }

    public Map<String, Long> countEntitiesFromString(List<String> classesList) {
        Iterable classes = Iterables.transform(classesList, GET_CLASS);
        Map<String, Long> result = this.countEntities0(classes);
        return result;
    }

    public ResultList<?> listEntitiesFromString(String className, GenericFilter filter) {
        ResultList<?> result = this.listEntities((Class)GET_CLASS.apply((Object)className), filter);
        return result;
    }

    public List<String> getPropertiesFromString(String className) {
        List<String> result = this.getProperties((Class)GET_CLASS.apply((Object)className));
        return result;
    }

    public void unactivateEntitiesFromString(String className, List<String> entityIds, boolean activate) {
        this.unactivateEntities((Class)GET_CLASS.apply((Object)className), entityIds, activate);
    }
}

