/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.effective;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryImpl;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.AbstractInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralProductInput;
import fr.inra.agrosyst.api.entities.action.MineralProductUnit;
import fr.inra.agrosyst.api.entities.action.OrganicProductInput;
import fr.inra.agrosyst.api.entities.action.OrganicProductUnit;
import fr.inra.agrosyst.api.entities.action.OtherProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductUnit;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhaseTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpecies;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.entities.referential.RefVarieteTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.action.ActionService;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.Equipments;
import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.effective.CopyPasteZoneByCampaigns;
import fr.inra.agrosyst.api.services.effective.CopyPasteZoneDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleSpeciesDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycles;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.api.services.effective.TargetedZones;
import fr.inra.agrosyst.api.services.input.InputService;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleGraftDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystems;
import fr.inra.agrosyst.api.services.practiced.RefStadeEdiDto;
import fr.inra.agrosyst.api.services.pz0.effective.EffectiveCropCycleAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.domain.DomainServiceImpl;
import fr.inra.agrosyst.services.effective.InterventionDtoToInterventionUnivers;
import fr.inra.agrosyst.services.effective.export.EffectiveCropCycleExportEntity;
import fr.inra.agrosyst.services.effective.export.EffectiveCropCycleExportMetadata;
import fr.inra.agrosyst.services.effective.export.EffectiveSeasonalCropCycleExport;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EffectiveCropCycleServiceImpl
extends AbstractAgrosystService
implements EffectiveCropCycleService {
    public static final String NEW_NODE_PREFIX = "new-node-";
    private static final Log log = LogFactory.getLog(EffectiveCropCycleServiceImpl.class);
    protected BusinessAuthorizationService authorizationService;
    protected ActionService actionService;
    protected InputService inputService;
    protected PricesService pricesService;
    protected DomainService domainService;
    protected AnonymizeService anonymizeService;
    protected ReferentialService referentialService;
    protected ZoneTopiaDao zoneDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao;
    protected ToolsCouplingTopiaDao toolsCouplingDao;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleDao;
    protected EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionDao;
    protected EffectiveCropCyclePhaseTopiaDao effectiveCropCyclePhaseDao;
    protected EffectiveCropCycleSpeciesTopiaDao effectiveCropCycleSpeciesDao;
    protected EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeDao;
    protected EffectiveInterventionTopiaDao effectiveInterventionDao;
    protected EffectiveSpeciesStadeTopiaDao effectiveSpeciesStadeDao;
    protected AbstractActionTopiaDao abstractActionDao;
    protected AbstractInputTopiaDao abstractInputTopiaDao;
    protected RefClonePlantGrapeTopiaDao refClonePlantGrapeDao;
    protected RefVarieteTopiaDao refVarieteDao;
    protected RefStadeEDITopiaDao refStadeEDIDao;
    protected RefOrientationEDITopiaDao refOrientationEDIDao;
    protected static final Function<EffectiveSeasonalCropCycle, Collection<EffectiveCropCycleNode>> EFFECTIVE_SEASONAL_CROP_CYCLE_TO_NODE_FUNCTION = new Function<EffectiveSeasonalCropCycle, Collection<EffectiveCropCycleNode>>(){

        public Collection<EffectiveCropCycleNode> apply(EffectiveSeasonalCropCycle cycle) {
            Collection result = cycle.getNodes();
            return result;
        }
    };
    protected static final Function<EffectiveCropCycleConnection, String> EFFECTIVE_CONNECTION_BY_TARGET_ID = new Function<EffectiveCropCycleConnection, String>(){

        public String apply(EffectiveCropCycleConnection input) {
            String targetId = input.getTarget().getTopiaId();
            return targetId;
        }
    };
    protected final Function<EffectivePerennialCropCycle, CopyPasteZoneDto> EFFECTIVE_PERENNIAL_TO_CROP_CYCLE_CROP_TARGET_FUNCTION = new Function<EffectivePerennialCropCycle, CopyPasteZoneDto>(){

        public CopyPasteZoneDto apply(EffectivePerennialCropCycle epcc) {
            CopyPasteZoneDto result = new CopyPasteZoneDto();
            result.setCroppingPlanEntryId(epcc.getCroppingPlanEntry().getTopiaId());
            result.setCroppingPlanEntryName(epcc.getCroppingPlanEntry().getName());
            EffectiveCropCyclePhase phase = epcc.getPhase();
            result.setPhaseId(phase.getTopiaId());
            result.setPhaseType(phase.getType());
            result.setNbInterventions(EffectiveCropCycleServiceImpl.this.effectiveInterventionDao.forEffectiveCropCyclePhaseEquals(phase).count());
            return result;
        }
    };
    protected final Function<EffectiveCropCycleNode, CopyPasteZoneDto> EFFECTIVE_CROP_CYCLE_NODE_TO_CROP_TARGET_FUNCTION = new Function<EffectiveCropCycleNode, CopyPasteZoneDto>(){

        public CopyPasteZoneDto apply(EffectiveCropCycleNode node) {
            long nbNonIntermediateInterventions = EffectiveCropCycleServiceImpl.this.effectiveInterventionDao.forProperties("effectiveCropCycleNode", node, new Object[]{"intermediateCrop", false}).count();
            long nbIntermediateInterventions = EffectiveCropCycleServiceImpl.this.effectiveInterventionDao.forProperties("effectiveCropCycleNode", node, new Object[]{"intermediateCrop", true}).count();
            CopyPasteZoneDto result = new CopyPasteZoneDto();
            result.setCroppingPlanEntryId(node.getCroppingPlanEntry().getTopiaId());
            result.setCroppingPlanEntryName(node.getCroppingPlanEntry().getName());
            result.setRank(Integer.valueOf(node.getRank()));
            result.setNbInterventions(nbNonIntermediateInterventions);
            result.setNbIntermediateCropInterventions(nbIntermediateInterventions);
            result.setNodeId(node.getTopiaId());
            return result;
        }
    };
    public static final Function<CroppingPlanSpecies, String> GET_CROPPING_PLAN_SPECIES_CODE = new Function<CroppingPlanSpecies, String>(){

        public String apply(CroppingPlanSpecies species) {
            String code = species.getCode();
            return code;
        }
    };
    protected static final Function<SpeciesStadeDto, String> GET_SPECIES_STADE_BY_SPECIES_CODE = new Function<SpeciesStadeDto, String>(){

        public String apply(SpeciesStadeDto speciesStadeDto) {
            String code = speciesStadeDto.getSpeciesCode();
            return code;
        }
    };
    public static final Function<Pz0EffectiveSeasonalCropCycle, EffectiveSeasonalCropCycleDto> EFFECTIVE_PZ0_SEASONAL_CROP_CYCLE_TO_EFFECTIVE_PZ0_SEASONAL_CROP_CYCLE = new Function<Pz0EffectiveSeasonalCropCycle, EffectiveSeasonalCropCycleDto>(){

        public EffectiveSeasonalCropCycleDto apply(Pz0EffectiveSeasonalCropCycle cycle) {
            EffectiveSeasonalCropCycleDto result = cycle.getSeasonalCropCycle();
            return result;
        }
    };

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setInputService(InputService inputService) {
        this.inputService = inputService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setAbstractInputTopiaDao(AbstractInputTopiaDao abstractInputTopiaDao) {
        this.abstractInputTopiaDao = abstractInputTopiaDao;
    }

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    public void setZoneDao(ZoneTopiaDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setCroppingPlanSpeciesDao(CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao) {
        this.croppingPlanSpeciesDao = croppingPlanSpeciesDao;
    }

    public void setToolsCouplingDao(ToolsCouplingTopiaDao toolsCouplingDao) {
        this.toolsCouplingDao = toolsCouplingDao;
    }

    public void setEffectivePerennialCropCycleDao(EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleDao) {
        this.effectivePerennialCropCycleDao = effectivePerennialCropCycleDao;
    }

    public void setEffectiveSeasonalCropCycleDao(EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleDao) {
        this.effectiveSeasonalCropCycleDao = effectiveSeasonalCropCycleDao;
    }

    public void setEffectiveCropCycleConnectionDao(EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionDao) {
        this.effectiveCropCycleConnectionDao = effectiveCropCycleConnectionDao;
    }

    public void setEffectiveCropCyclePhaseDao(EffectiveCropCyclePhaseTopiaDao effectiveCropCyclePhaseDao) {
        this.effectiveCropCyclePhaseDao = effectiveCropCyclePhaseDao;
    }

    public void setEffectiveCropCycleSpeciesDao(EffectiveCropCycleSpeciesTopiaDao effectiveCropCycleSpeciesDao) {
        this.effectiveCropCycleSpeciesDao = effectiveCropCycleSpeciesDao;
    }

    public void setEffectiveCropCycleNodeDao(EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeDao) {
        this.effectiveCropCycleNodeDao = effectiveCropCycleNodeDao;
    }

    public void setRefClonePlantGrapeDao(RefClonePlantGrapeTopiaDao refClonePlantGrapeDao) {
        this.refClonePlantGrapeDao = refClonePlantGrapeDao;
    }

    public void setRefVarieteDao(RefVarieteTopiaDao refVarieteDao) {
        this.refVarieteDao = refVarieteDao;
    }

    public void setEffectiveInterventionDao(EffectiveInterventionTopiaDao effectiveInterventionDao) {
        this.effectiveInterventionDao = effectiveInterventionDao;
    }

    public void setRefStadeEDIDao(RefStadeEDITopiaDao refStadeEDIDao) {
        this.refStadeEDIDao = refStadeEDIDao;
    }

    public void setEffectiveSpeciesStadeDao(EffectiveSpeciesStadeTopiaDao effectiveSpeciesStadeDao) {
        this.effectiveSpeciesStadeDao = effectiveSpeciesStadeDao;
    }

    public void setAbstractActionDao(AbstractActionTopiaDao abstractActionDao) {
        this.abstractActionDao = abstractActionDao;
    }

    public void setRefOrientationEDIDao(RefOrientationEDITopiaDao refOrientationEDIDao) {
        this.refOrientationEDIDao = refOrientationEDIDao;
    }

    public Zone getZone(String zoneTopiaId) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        Zone result = this.anonymizeService.checkForZoneAnonymization(zone);
        return result;
    }

    public ResultList<Zone> getFilteredZones(EffectiveZoneFilter filter) {
        ResultList<Zone> result = this.zoneDao.getFilteredZones(filter, this.getSecurityContext());
        return result;
    }

    public ResultList<ZoneDto> getFilteredZonesDto(EffectiveZoneFilter filter) {
        ResultList<Zone> zones = this.getFilteredZones(filter);
        ResultList result = ResultList.transform(zones, (Function)this.anonymizeService.getZoneToDtoFunction());
        return result;
    }

    protected String getEffectivePerennialCropCycleInfo(String zoneTopiaId) {
        StringBuilder result = new StringBuilder();
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        List cycles = this.effectivePerennialCropCycleDao.forZoneEquals(zone).findAll();
        for (EffectivePerennialCropCycle cycle : cycles) {
            result.append(cycle.getCroppingPlanEntry().getName());
            EffectiveCropCyclePhase phase = cycle.getPhase();
            if (phase == null) continue;
            result.append(" (");
            result.append(this.effectiveInterventionDao.forEffectiveCropCyclePhaseEquals(phase).count());
            result.append(") ");
        }
        return result.toString();
    }

    protected String getEffectiveCropCycleNodesInfo(Collection<EffectiveCropCycleNode> allEffectiveCropCycleNodes) {
        StringBuilder result = new StringBuilder();
        if (allEffectiveCropCycleNodes != null && !allEffectiveCropCycleNodes.isEmpty()) {
            for (EffectiveCropCycleNode effectiveCropCycleNode : allEffectiveCropCycleNodes) {
                EffectiveCropCycleConnection effectiveCropCycleConnection = (EffectiveCropCycleConnection)this.effectiveCropCycleConnectionDao.forTargetEquals(effectiveCropCycleNode).findUniqueOrNull();
                List allEffectiveInterventions = this.effectiveInterventionDao.forEffectiveCropCycleNodeEquals(effectiveCropCycleNode).findAll();
                int interventionCount = allEffectiveInterventions.size();
                int intermediateCropInterventionCount = 0;
                if (effectiveCropCycleConnection != null && effectiveCropCycleConnection.getIntermediateCroppingPlanEntry() != null) {
                    intermediateCropInterventionCount = this.getIntermediateCropIntervetionCount(allEffectiveInterventions);
                    this.buildIntermediateInterventionsResult(result, intermediateCropInterventionCount);
                }
                this.buildCropInfoResult(result, effectiveCropCycleNode, interventionCount, intermediateCropInterventionCount);
            }
        }
        return result.toString();
    }

    private void buildCropInfoResult(StringBuilder result, EffectiveCropCycleNode effectiveCropCycleNode, int interventionCount, int intermediateCropInterventionCount) {
        result.append(" ");
        result.append(effectiveCropCycleNode.getCroppingPlanEntry().getName());
        result.append(" (");
        result.append(interventionCount - intermediateCropInterventionCount);
        result.append(") -");
    }

    private void buildIntermediateInterventionsResult(StringBuilder result, int intermediateCropInterventionCount) {
        result.append(" CI (");
        result.append(intermediateCropInterventionCount);
        result.append(") ");
    }

    private int getIntermediateCropIntervetionCount(List<EffectiveIntervention> allEffectiveInterventions) {
        int intermediateCropInterventionCount = 0;
        if (!allEffectiveInterventions.isEmpty()) {
            for (EffectiveIntervention effectiveIntervention : allEffectiveInterventions) {
                if (!effectiveIntervention.isIntermediateCrop()) continue;
                ++intermediateCropInterventionCount;
            }
        }
        return intermediateCropInterventionCount;
    }

    protected String getEffectiveSeasonalCropCyclesInfo(String zoneTopiaId) {
        String result = "";
        List allEffectiveSeasonalCropCycles = this.effectiveSeasonalCropCycleDao.forZoneEquals((Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique()).findAll();
        if (allEffectiveSeasonalCropCycles != null && !allEffectiveSeasonalCropCycles.isEmpty()) {
            StringBuilder resultBuilder = new StringBuilder();
            for (EffectiveSeasonalCropCycle effectiveSeasonalCropCycle : allEffectiveSeasonalCropCycles) {
                Collection allEffectiveCropCycleNodes = effectiveSeasonalCropCycle.getNodes();
                resultBuilder.append(this.getEffectiveCropCycleNodesInfo(allEffectiveCropCycleNodes));
            }
            result = resultBuilder.toString();
            if (result.length() > 2) {
                result = result.substring(0, result.length() - 2);
            }
        }
        return result;
    }

    public ResultList<ZoneDto> getFilteredZonesAndCroppingPlanInfosDto(EffectiveZoneFilter filter) {
        ResultList<ZoneDto> result = this.getFilteredZonesDto(filter);
        for (ZoneDto zoneDto : result) {
            String croppingPlanInfo = this.getEffectivePerennialCropCycleInfo(zoneDto.getTopiaId());
            croppingPlanInfo = croppingPlanInfo + this.getEffectiveSeasonalCropCyclesInfo(zoneDto.getTopiaId());
            zoneDto.setCroppingPlanInfo(croppingPlanInfo);
        }
        return result;
    }

    public List<CroppingPlanEntry> getZoneCroppingPlanEntries(Zone zone) {
        List entries = this.croppingPlanEntryDao.forDomainEquals(zone.getPlot().getDomain()).findAll();
        return entries;
    }

    public List<CroppingPlanEntry> getZoneCroppingPlanEntriesWithoutDomain(Zone zone) {
        List entries = this.croppingPlanEntryDao.forDomainEquals(zone.getPlot().getDomain()).setOrderByArguments(new String[]{"name"}).findAll();
        ArrayList croppingPlanEntries = Lists.newArrayListWithCapacity((int)entries.size());
        Binder croppingPlanEntryCroppingPlanEntryBinder = BinderFactory.newBinder(CroppingPlanEntry.class, CroppingPlanEntry.class);
        for (CroppingPlanEntry croppingPlanEntry : entries) {
            CroppingPlanEntryImpl lightCroppingPlanEntry = new CroppingPlanEntryImpl();
            croppingPlanEntryCroppingPlanEntryBinder.copyExcluding((Object)croppingPlanEntry, (Object)lightCroppingPlanEntry, new String[]{"domain"});
            croppingPlanEntries.add(lightCroppingPlanEntry);
        }
        return croppingPlanEntries;
    }

    public CroppingPlanEntry getPreviousCampaignCroppingPlanEntry(String zoneTopiaId) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        EffectiveCropCycleNode node = this.effectiveCropCycleNodeDao.findLastNodeForPreviousCampaign(zone);
        CroppingPlanEntry result = null;
        if (node != null) {
            result = node.getCroppingPlanEntry();
        }
        return result;
    }

    public List<EffectivePerennialCropCycleDto> getAllEffectivePerennialCropCyclesDtos(String zoneTopiaId) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        List cycles = this.effectivePerennialCropCycleDao.forZoneEquals(zone).findAll();
        List<EffectivePerennialCropCycleDto> result = this.convertPerennialCropCyclesToDto(cycles, zone);
        return result;
    }

    protected List<EffectivePerennialCropCycle> getAllEffectivePerennialCropCycles(String zoneTopiaId) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        List cycles = this.effectivePerennialCropCycleDao.forZoneEquals(zone).findAll();
        return cycles;
    }

    protected List<EffectivePerennialCropCycleDto> convertPerennialCropCyclesToDto(List<EffectivePerennialCropCycle> cycles, Zone zone) {
        ArrayList result = Lists.newArrayListWithCapacity((int)cycles.size());
        for (EffectivePerennialCropCycle cycle : cycles) {
            String domainId = cycle.getZone().getPlot().getDomain().getTopiaId();
            EffectivePerennialCropCycleDto dto = (EffectivePerennialCropCycleDto)EffectiveCropCycles.PERENNIAL_CROP_CYCLE_TO_DTO.apply((Object)cycle);
            EffectiveCropCyclePhase phase = cycle.getPhase();
            if (phase != null) {
                EffectiveCropCyclePhaseDto phaseDto = (EffectiveCropCyclePhaseDto)EffectiveCropCycles.CROP_CYCLE_PHASE_TO_DTO.apply((Object)phase);
                List interventions = this.effectiveInterventionDao.forEffectiveCropCyclePhaseEquals(phase).findAll();
                ArrayList interventionDtos = Lists.newArrayListWithCapacity((int)interventions.size());
                for (EffectiveIntervention intervention : interventions) {
                    EffectiveInterventionDto interventionDto = (EffectiveInterventionDto)EffectiveCropCycles.INTERVENTION_TO_DTO.apply((Object)intervention);
                    List abstractActions = this.abstractActionDao.forEffectiveInterventionEquals(intervention).findAll();
                    interventionDto.setActions((Collection)abstractActions);
                    List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByEffectiveIntervention(intervention);
                    interventionDto.setInputs(inputs);
                    interventionDto.setDomainId(domainId);
                    interventionDtos.add(interventionDto);
                }
                phaseDto.setInterventions((List)interventionDtos);
                dto.setPhaseDtos((List)Lists.newArrayList((Object[])new EffectiveCropCyclePhaseDto[]{phaseDto}));
            }
            String croppingPlanEntryCode = cycle.getCroppingPlanEntry().getCode();
            List<EffectiveCropCycleSpeciesDto> species = this.getCropCyclePerennialSpecies(croppingPlanEntryCode, cycle, zone.getPlot().getDomain().getCampaign());
            dto.setSpeciesDtos(species);
            result.add(dto);
        }
        return result;
    }

    protected List<EffectiveCropCycleSpeciesDto> getCropCyclePerennialSpecies(String croppingPlanEntryCode, EffectivePerennialCropCycle cycle, Integer campaign) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)croppingPlanEntryCode) ? 1 : 0) != 0);
        Preconditions.checkArgument((campaign != null ? 1 : 0) != 0);
        final HashMap speciesCodeToCycleEntity = cycle == null || cycle.getSpecies() == null ? Maps.newHashMap() : Maps.uniqueIndex((Iterable)cycle.getSpecies(), (Function)EffectiveCropCycles.GET_CROP_CYCLE_PERENNIAL_SPECIES_CODE);
        Pair entryAndSpeciesFromCode = this.domainService.getEntryAndSpeciesFromCode(croppingPlanEntryCode, (Set)Sets.newHashSet((Object[])new Integer[]{campaign}));
        Function<CroppingPlanSpeciesDto, EffectiveCropCycleSpeciesDto> decorateFunction = new Function<CroppingPlanSpeciesDto, EffectiveCropCycleSpeciesDto>(){

            public EffectiveCropCycleSpeciesDto apply(CroppingPlanSpeciesDto input) {
                String croppingPlanSpeciesCode = input.getCode();
                EffectiveCropCycleSpeciesDto result = new EffectiveCropCycleSpeciesDto(input);
                EffectiveCropCycleSpecies cropCyclePerennialSpecies = (EffectiveCropCycleSpecies)speciesCodeToCycleEntity.get(croppingPlanSpeciesCode);
                if (cropCyclePerennialSpecies != null) {
                    result.setOverGraftDate(cropCyclePerennialSpecies.getOverGraftDate());
                    result.setPlantsCertified(cropCyclePerennialSpecies.isPlantsCertified());
                    result.setGraftSupport((CropCycleGraftDto)PracticedSystems.REF_VARIETE_TO_GRAPH_DTO.apply((Object)cropCyclePerennialSpecies.getGraftSupport()));
                    result.setGraftClone((CropCycleGraftDto)PracticedSystems.REF_CLONE_TO_GRAPH_DTO.apply((Object)cropCyclePerennialSpecies.getGraftClone()));
                }
                return result;
            }
        };
        Function transformFunction = Functions.compose((Function)decorateFunction, (Function)CroppingPlans.CROPPING_PLAN_SPECIES_TO_DTO);
        Iterable transformed = Iterables.transform(((Map)entryAndSpeciesFromCode.getRight()).values(), (Function)transformFunction);
        ArrayList result = Lists.newArrayList((Iterable)transformed);
        return result;
    }

    public List<EffectiveSeasonalCropCycleDto> getAllEffectiveSeasonalCropCyclesDtos(String zoneTopiaId) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        List cycles = this.effectiveSeasonalCropCycleDao.forZoneEquals(zone).findAll();
        ArrayList result = Lists.newArrayListWithCapacity((int)cycles.size());
        for (EffectiveSeasonalCropCycle cycle : cycles) {
            String domainId = cycle.getZone().getPlot().getDomain().getTopiaId();
            EffectiveSeasonalCropCycleDto dto = (EffectiveSeasonalCropCycleDto)EffectiveCropCycles.SEASONNAL_CROP_CYCLE_TO_DTO.apply((Object)cycle);
            if (cycle.getNodes() != null) {
                ArrayList nodeDtos = Lists.newArrayListWithCapacity((int)cycle.getNodes().size());
                for (EffectiveCropCycleNode node : cycle.getNodes()) {
                    EffectiveCropCycleNodeDto nodeDto = (EffectiveCropCycleNodeDto)EffectiveCropCycles.CROP_CYCLE_NODE_TO_DTO.apply((Object)node);
                    nodeDtos.add(nodeDto);
                    List interventions = this.effectiveInterventionDao.forEffectiveCropCycleNodeEquals(node).findAll();
                    ArrayList interventionDtos = Lists.newArrayListWithCapacity((int)interventions.size());
                    for (EffectiveIntervention intervention : interventions) {
                        EffectiveInterventionDto interventionDto = (EffectiveInterventionDto)EffectiveCropCycles.INTERVENTION_TO_DTO.apply((Object)intervention);
                        List abstractActions = this.abstractActionDao.forEffectiveInterventionEquals(intervention).findAll();
                        interventionDto.setActions((Collection)abstractActions);
                        List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByEffectiveIntervention(intervention);
                        interventionDto.setInputs(inputs);
                        interventionDto.setDomainId(domainId);
                        interventionDtos.add(interventionDto);
                    }
                    nodeDto.setInterventions((List)interventionDtos);
                }
                dto.setNodeDtos((List)nodeDtos);
            }
            List<EffectiveCropCycleConnection> connections = this.effectiveCropCycleConnectionDao.findAllByEffectiveSeasonalCropCycle(cycle);
            dto.setConnectionDtos((List)Lists.newArrayList((Iterable)Iterables.transform(connections, (Function)EffectiveCropCycles.CROP_CYCLE_CONNECTION_TO_DTO)));
            result.add(dto);
        }
        return result;
    }

    protected List<EffectiveSeasonalCropCycle> getAllEffectiveSeasonalCropCycles(String zoneTopiaId) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        List cycles = this.effectiveSeasonalCropCycleDao.forZoneEquals(zone).findAll();
        return cycles;
    }

    public void updateEffectiveCropCycles(String zoneId, List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycles, List<EffectivePerennialCropCycleDto> effectivePerennialCropCycles, List<Price> prices) {
        this.authorizationService.checkCreateOrUpdateEffectiveCropCycles(zoneId);
        this.updateEffectiveCropCyclesWithoutCommit(zoneId, effectiveSeasonalCropCycles, effectivePerennialCropCycles, prices);
        this.getTransaction().commit();
    }

    protected void updateEffectiveCropCyclesWithoutCommit(String zoneId, List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycles, List<EffectivePerennialCropCycleDto> effectivePerennialCropCycles, List<Price> prices) {
        this.updateEffectiveSeasonalCropCycles(zoneId, effectiveSeasonalCropCycles);
        this.udpateEffectivePerennialCropCycles(zoneId, effectivePerennialCropCycles);
        this.updateEffectivePrices(zoneId, prices);
    }

    protected void updateEffectiveSeasonalCropCycles(String zoneId, List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycles) {
        if (effectiveSeasonalCropCycles != null) {
            Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneId).findUnique();
            Domain domain = zone.getPlot().getDomain();
            List targetedZoneCroppingPlanEntries = this.croppingPlanEntryDao.forDomainEquals(domain).findAll();
            List cycles = this.effectiveSeasonalCropCycleDao.forZoneEquals(zone).findAll();
            HashSet toDeleteCycles = Sets.newHashSet((Iterable)cycles);
            ImmutableMap idToCycles = Maps.uniqueIndex((Iterable)cycles, (Function)Entities.GET_TOPIA_ID);
            for (EffectiveSeasonalCropCycleDto cycleDto : effectiveSeasonalCropCycles) {
                String cycleId = cycleDto.getTopiaId();
                EffectiveSeasonalCropCycle cycle = this.getEffectiveSeasonalCropCycle(zone, toDeleteCycles, (Map<String, EffectiveSeasonalCropCycle>)idToCycles, cycleId);
                this.updateCycleNodesAndConnections(domain, targetedZoneCroppingPlanEntries, cycleDto, cycle);
                if (CollectionUtils.isNotEmpty((Collection)cycle.getNodes())) {
                    if (StringUtils.isBlank((CharSequence)cycleId)) {
                        this.effectiveSeasonalCropCycleDao.create((TopiaEntity)cycle);
                        continue;
                    }
                    this.effectiveSeasonalCropCycleDao.update((TopiaEntity)cycle);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)cycleId)) continue;
                toDeleteCycles.add(cycle);
            }
            this.removeEffectiveSeasonalCropCycles(toDeleteCycles);
        }
    }

    private EffectiveSeasonalCropCycle getEffectiveSeasonalCropCycle(Zone zone, Set<EffectiveSeasonalCropCycle> toDeleteCycles, Map<String, EffectiveSeasonalCropCycle> idToCycles, String cycleId) {
        EffectiveSeasonalCropCycle cycle;
        if (StringUtils.isBlank((CharSequence)cycleId)) {
            cycle = (EffectiveSeasonalCropCycle)this.effectiveSeasonalCropCycleDao.newInstance();
            cycle.setZone(zone);
        } else {
            cycle = idToCycles.get(cycleId);
            toDeleteCycles.remove(cycle);
        }
        return cycle;
    }

    private void manageCycleConnections(List<CroppingPlanEntry> targetedZoneCroppingPlanEntries, EffectiveSeasonalCropCycleDto cycleDto, Map<String, EffectiveCropCycleNode> nodeIdToEntity, EffectiveSeasonalCropCycle cycle) {
        List<EffectiveCropCycleConnection> cycleConnections = this.effectiveCropCycleConnectionDao.findAllByEffectiveSeasonalCropCycle(cycle);
        HashMap connectionByTarget = Maps.newHashMap((Map)Maps.uniqueIndex(cycleConnections, EFFECTIVE_CONNECTION_BY_TARGET_ID));
        if (CollectionUtils.isNotEmpty((Collection)cycleDto.getConnectionDtos())) {
            for (EffectiveCropCycleConnectionDto connectionDto : cycleDto.getConnectionDtos()) {
                String sourceId = null;
                if (connectionDto.getSourceId() != null) {
                    sourceId = "NODE_BEFORE".equals(connectionDto.getSourceId()) ? "NODE_BEFORE" : (String)Entities.UNESCAPE_TOPIA_ID.apply((Object)connectionDto.getSourceId());
                }
                String targetId = (String)Entities.UNESCAPE_TOPIA_ID.apply((Object)connectionDto.getTargetId());
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)targetId), (Object)"La connexion n'a pas de noeud cible");
                EffectiveCropCycleNode sourceNode = nodeIdToEntity.get(sourceId);
                EffectiveCropCycleNode targetNode = nodeIdToEntity.get(targetId);
                if (targetNode == null) continue;
                EffectiveCropCycleConnection connection = (EffectiveCropCycleConnection)connectionByTarget.remove(targetId);
                if (connection == null) {
                    connection = (EffectiveCropCycleConnection)this.effectiveCropCycleConnectionDao.newInstance();
                }
                connection.setEdaplosIssuerId(connectionDto.getEdaplosIssuerId());
                connection.setSource(sourceNode);
                connection.setTarget(targetNode);
                CroppingPlanEntry intermediateCrops = null;
                if (StringUtils.isNotBlank((CharSequence)connectionDto.getIntermediateCroppingPlanEntryId())) {
                    intermediateCrops = (CroppingPlanEntry)this.croppingPlanEntryDao.forTopiaIdEquals(connectionDto.getIntermediateCroppingPlanEntryId()).findUnique();
                }
                if (intermediateCrops == null) {
                    connection.setIntermediateCroppingPlanEntry(null);
                }
                if (intermediateCrops != null && targetedZoneCroppingPlanEntries.contains(intermediateCrops)) {
                    connection.setIntermediateCroppingPlanEntry(intermediateCrops);
                }
                if (connection.isPersisted()) {
                    this.effectiveCropCycleConnectionDao.update((TopiaEntity)connection);
                    continue;
                }
                this.effectiveCropCycleConnectionDao.create((TopiaEntity)connection);
            }
        }
        this.effectiveCropCycleConnectionDao.deleteAll(connectionByTarget.values());
    }

    private void updateCycleNodesAndConnections(Domain domain, List<CroppingPlanEntry> targetedZoneCroppingPlanEntries, EffectiveSeasonalCropCycleDto cycleDto, EffectiveSeasonalCropCycle cycle) {
        List nodeDtos;
        HashMap nodeIdToEntity = Maps.newHashMap();
        Collection result = cycle.getNodes();
        if (result == null) {
            result = Lists.newArrayList();
            cycle.setNodes(result);
        }
        if ((nodeDtos = cycleDto.getNodeDtos()) != null) {
            Map<String, CroppingPlanEntry> nodesCropsByIds = this.getNodesCropsByIds(nodeDtos);
            for (EffectiveCropCycleNodeDto nodeDto : nodeDtos) {
                String nodeId = (String)Entities.UNESCAPE_TOPIA_ID.apply((Object)nodeDto.getNodeId());
                Preconditions.checkNotNull((Object)nodeId);
                if (nodeId.equalsIgnoreCase("NODE_BEFORE")) continue;
                EffectiveCropCycleNode node = nodeId.startsWith(NEW_NODE_PREFIX) ? (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.newInstance() : (EffectiveCropCycleNode)TopiaEntities.findByTopiaId((Iterable)cycle.getNodes(), (String)nodeId);
                node.setRank(nodeDto.getX());
                node.setEdaplosIssuerId(nodeDto.getEdaplosIssuerId());
                if (!StringUtils.isNotBlank((CharSequence)nodeDto.getCroppingPlanEntryId())) continue;
                CroppingPlanEntry croppingPlanEntry = nodesCropsByIds.get(nodeDto.getCroppingPlanEntryId());
                ImmutableMap targetedZoneCroppingPlanEntriesByCodes = Maps.uniqueIndex(targetedZoneCroppingPlanEntries, DomainServiceImpl.GET_CROPPING_PLAN_ENTRY_CODE);
                CroppingPlanEntry targetedCroppingPlanEntry = (CroppingPlanEntry)targetedZoneCroppingPlanEntriesByCodes.get(croppingPlanEntry.getCode());
                if (targetedCroppingPlanEntry == null) continue;
                node.setCroppingPlanEntry(targetedCroppingPlanEntry);
                if (!node.isPersisted()) {
                    result.add(node);
                }
                nodeIdToEntity.put(nodeId, node);
                node = node.isPersisted() ? (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.update((TopiaEntity)node) : (EffectiveCropCycleNode)this.effectiveCropCycleNodeDao.create((TopiaEntity)node);
                this.updateEffectiveInterventions(nodeDto.getInterventions(), cycleDto, (Pair<String, EffectiveCropCycleNode>)Pair.of((Object)nodeId, (Object)node), null, null, domain);
            }
        }
        this.manageCycleConnections(targetedZoneCroppingPlanEntries, cycleDto, nodeIdToEntity, cycle);
        Collection nodesToDelete = CollectionUtils.subtract((Iterable)result, nodeIdToEntity.values());
        this.removeNodesChilds(nodesToDelete);
        result.retainAll(nodeIdToEntity.values());
    }

    protected Map<String, CroppingPlanEntry> getNodesCropsByIds(List<EffectiveCropCycleNodeDto> nodeDtos) {
        HashSet cropIds = Sets.newHashSet();
        for (EffectiveCropCycleNodeDto nodeDto : nodeDtos) {
            if (!StringUtils.isNotBlank((CharSequence)nodeDto.getCroppingPlanEntryId())) continue;
            cropIds.add(nodeDto.getCroppingPlanEntryId());
        }
        List nodesCrops = this.croppingPlanEntryDao.forTopiaIdIn(cropIds).findAll();
        return Maps.uniqueIndex((Iterable)nodesCrops, (Function)Entities.GET_TOPIA_ID);
    }

    protected void removeEffectiveSeasonalCropCycles(Set<EffectiveSeasonalCropCycle> cycles) {
        if (cycles != null) {
            ArrayList connectionsToRemove = Lists.newArrayList();
            for (EffectiveSeasonalCropCycle cycle : cycles) {
                Collection nodes = cycle.getNodes();
                connectionsToRemove.addAll(this.getConnectionsToRemove(nodes));
            }
            this.effectiveCropCycleConnectionDao.deleteAll(connectionsToRemove);
            this.effectiveSeasonalCropCycleDao.deleteAll(cycles);
        }
    }

    protected void removeNodesChilds(Collection<EffectiveCropCycleNode> nodesToRemove) {
        List<EffectiveCropCycleConnection> connectionsToRemove = this.getConnectionsToRemove(nodesToRemove);
        if (connectionsToRemove != null && !connectionsToRemove.isEmpty()) {
            this.effectiveCropCycleConnectionDao.deleteAll(connectionsToRemove);
        }
    }

    protected List<EffectiveCropCycleConnection> getConnectionsToRemove(Collection<EffectiveCropCycleNode> nodes) {
        ArrayList result = Lists.newArrayList();
        if (nodes != null && !nodes.isEmpty()) {
            List effectiveInterventions = this.effectiveInterventionDao.forEffectiveCropCycleNodeIn(nodes).findAll();
            this.removeEffectiveInterventions(effectiveInterventions);
            for (EffectiveCropCycleNode node : nodes) {
                EffectiveCropCycleConnection target = (EffectiveCropCycleConnection)this.effectiveCropCycleConnectionDao.forTargetEquals(node).findUniqueOrNull();
                if (target == null) continue;
                result.add(target);
            }
        }
        return result;
    }

    protected void udpateEffectivePerennialCropCycles(String zoneId, List<EffectivePerennialCropCycleDto> effectivePerennialCropCycles) {
        if (effectivePerennialCropCycles != null) {
            Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneId).findUnique();
            Domain domain = zone.getPlot().getDomain();
            Domain targetedDomain = zone.getPlot().getDomain();
            List targetedZoneCroppingPlanEntries = this.croppingPlanEntryDao.forDomainEquals(targetedDomain).findAll();
            Preconditions.checkArgument((!targetedZoneCroppingPlanEntries.isEmpty() ? 1 : 0) != 0);
            Map<String, CroppingPlanSpecies> availableCroppingPlanSpecies = this.getCroppingPlanSpecies(targetedZoneCroppingPlanEntries);
            List cycles = this.effectivePerennialCropCycleDao.forZoneEquals(zone).findAll();
            ArrayList toDelete = Lists.newArrayList((Iterable)cycles);
            ImmutableMap idToCycles = Maps.uniqueIndex((Iterable)cycles, (Function)Entities.GET_TOPIA_ID);
            for (EffectivePerennialCropCycleDto cycleDto : effectivePerennialCropCycles) {
                CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forTopiaIdEquals(cycleDto.getCroppingPlanEntryId()).findUnique();
                if (!targetedZoneCroppingPlanEntries.contains(croppingPlanEntry)) continue;
                String dtoId = cycleDto.getTopiaId();
                EffectivePerennialCropCycle cycle = this.getEffectivePerennialCropCycle(zone, toDelete, (Map<String, EffectivePerennialCropCycle>)idToCycles, dtoId);
                Binder binder = BinderFactory.newBinder(EffectivePerennialCropCycleDto.class, EffectivePerennialCropCycle.class);
                binder.copyExcluding((Object)cycleDto, (Object)cycle, new String[]{"zone", "topiaId", "orientation", "phase", "species", "croppingPlanEntry"});
                cycle.setCroppingPlanEntry(croppingPlanEntry);
                RefOrientationEDI orientation = this.loadRefOrientationEDI(cycleDto);
                cycle.setOrientation(orientation);
                Preconditions.checkState((cycleDto.getPhaseDtos().size() == 1 ? 1 : 0) != 0);
                this.managePhases(domain, cycleDto, cycle);
                this.managePhaseSpecies(availableCroppingPlanSpecies, cycleDto, cycle);
                if (StringUtils.isBlank((CharSequence)dtoId)) {
                    this.effectivePerennialCropCycleDao.create((TopiaEntity)cycle);
                    continue;
                }
                this.effectivePerennialCropCycleDao.update((TopiaEntity)cycle);
            }
            this.removeEffectivePerennialCropCycles(toDelete);
        }
    }

    protected Map<String, CroppingPlanSpecies> getCroppingPlanSpecies(List<CroppingPlanEntry> targetedZoneCroppingPlanEntries) {
        HashMap<String, CroppingPlanSpecies> availableCroppingPlanSpecies = new HashMap<String, CroppingPlanSpecies>();
        for (CroppingPlanEntry croppingPlanEntry : targetedZoneCroppingPlanEntries) {
            if (croppingPlanEntry == null || !CollectionUtils.isNotEmpty((Collection)croppingPlanEntry.getCroppingPlanSpecies())) continue;
            for (CroppingPlanSpecies croppingPlanSpecies : croppingPlanEntry.getCroppingPlanSpecies()) {
                if (croppingPlanSpecies == null) continue;
                availableCroppingPlanSpecies.put(croppingPlanSpecies.getTopiaId(), croppingPlanSpecies);
            }
        }
        return availableCroppingPlanSpecies;
    }

    private void managePhaseSpecies(Map<String, CroppingPlanSpecies> availableCroppingPlanSpecies, EffectivePerennialCropCycleDto cycleDto, EffectivePerennialCropCycle cycle) {
        if (cycleDto.getSpeciesDtos() != null) {
            Collection cycleSpeciesList = cycle.getSpecies();
            if (cycleSpeciesList == null) {
                cycleSpeciesList = Lists.newArrayList();
                cycle.setSpecies(cycleSpeciesList);
            }
            ArrayList nonDeletedSpecies = Lists.newArrayList();
            ImmutableMap idToSpecies = Maps.uniqueIndex((Iterable)cycleSpeciesList, (Function)Entities.GET_TOPIA_ID);
            for (EffectiveCropCycleSpeciesDto speciesDto : cycleDto.getSpeciesDtos()) {
                String cycleSpeciesId = speciesDto.getTopiaId();
                EffectiveCropCycleSpecies cycleSpecies = StringUtils.isBlank((CharSequence)cycleSpeciesId) ? (EffectiveCropCycleSpecies)this.effectiveCropCycleSpeciesDao.newInstance() : (EffectiveCropCycleSpecies)idToSpecies.get(cycleSpeciesId);
                String targetedCroppingPlanSpeciesId = speciesDto.getCroppingPlanSpeciesId();
                if (!StringUtils.isNotBlank((CharSequence)targetedCroppingPlanSpeciesId) || !availableCroppingPlanSpecies.containsKey(targetedCroppingPlanSpeciesId)) continue;
                CroppingPlanSpecies croppingPlanSpecies = (CroppingPlanSpecies)this.croppingPlanSpeciesDao.forTopiaIdEquals(targetedCroppingPlanSpeciesId).findUnique();
                cycleSpecies.setCroppingPlanSpecies(croppingPlanSpecies);
                cycleSpecies.setPlantsCertified(speciesDto.isPlantsCertified());
                cycleSpecies.setOverGraftDate(speciesDto.getOverGraftDate());
                RefClonePlantGrape cloneGrape = null;
                if (speciesDto.getGraftClone() != null && StringUtils.isNotBlank((CharSequence)speciesDto.getGraftClone().getTopiaId())) {
                    cloneGrape = (RefClonePlantGrape)this.refClonePlantGrapeDao.forTopiaIdEquals(speciesDto.getGraftClone().getTopiaId()).findUnique();
                }
                cycleSpecies.setGraftClone(cloneGrape);
                RefVariete variete = null;
                if (speciesDto.getGraftSupport() != null && StringUtils.isNotBlank((CharSequence)speciesDto.getGraftSupport().getTopiaId())) {
                    variete = (RefVariete)this.refVarieteDao.forTopiaIdEquals(speciesDto.getGraftSupport().getTopiaId()).findUnique();
                }
                cycleSpecies.setGraftSupport(variete);
                if (StringUtils.isBlank((CharSequence)cycleSpeciesId)) {
                    cycle.addSpecies(cycleSpecies);
                }
                nonDeletedSpecies.add(cycleSpecies);
            }
            cycleSpeciesList.retainAll(nonDeletedSpecies);
        }
    }

    private void managePhases(Domain domain, EffectivePerennialCropCycleDto cycleDto, EffectivePerennialCropCycle cycle) {
        EffectiveCropCyclePhase phase = cycle.getPhase();
        if (phase == null) {
            phase = (EffectiveCropCyclePhase)this.effectiveCropCyclePhaseDao.newInstance();
        }
        for (EffectiveCropCyclePhaseDto phaseDto : cycleDto.getPhaseDtos()) {
            phase.setDuration(phaseDto.getDuration());
            phase.setType(phaseDto.getType());
            phase = phase.isPersisted() ? (EffectiveCropCyclePhase)this.effectiveCropCyclePhaseDao.update((TopiaEntity)phase) : (EffectiveCropCyclePhase)this.effectiveCropCyclePhaseDao.create((TopiaEntity)phase);
            cycle.setPhase(phase);
            this.updateEffectiveInterventions(phaseDto.getInterventions(), null, null, cycle, phase, domain);
        }
    }

    private RefOrientationEDI loadRefOrientationEDI(EffectivePerennialCropCycleDto cycleDto) {
        RefOrientationEDI orientation = null;
        if (cycleDto.getOrientationId() != null) {
            orientation = (RefOrientationEDI)this.refOrientationEDIDao.forTopiaIdEquals(cycleDto.getOrientationId()).findUnique();
        }
        return orientation;
    }

    private EffectivePerennialCropCycle getEffectivePerennialCropCycle(Zone zone, List<EffectivePerennialCropCycle> toDelete, Map<String, EffectivePerennialCropCycle> idToCycles, String dtoId) {
        EffectivePerennialCropCycle cycle;
        if (StringUtils.isBlank((CharSequence)dtoId)) {
            cycle = (EffectivePerennialCropCycle)this.effectivePerennialCropCycleDao.newInstance();
            cycle.setZone(zone);
        } else {
            cycle = idToCycles.get(dtoId);
            toDelete.remove(cycle);
        }
        return cycle;
    }

    protected void removeEffectivePerennialCropCycles(List<EffectivePerennialCropCycle> effectivePerennialCropCycles) {
        if (effectivePerennialCropCycles != null) {
            for (EffectivePerennialCropCycle effectivePerennialCropCycle : effectivePerennialCropCycles) {
                EffectiveCropCyclePhase phase = effectivePerennialCropCycle.getPhase();
                this.removeEffectiveCropCyclePhaseChildrenObjects(phase);
            }
            this.effectivePerennialCropCycleDao.deleteAll(effectivePerennialCropCycles);
        }
    }

    protected void removeEffectiveCropCyclePhaseChildrenObjects(EffectiveCropCyclePhase phase) {
        List effectiveInterventions = this.effectiveInterventionDao.forEffectiveCropCyclePhaseEquals(phase).findAll();
        this.removeEffectiveInterventions(effectiveInterventions);
    }

    private void removeEffectiveInterventions(Collection<EffectiveIntervention> effectiveInterventions) {
        if (effectiveInterventions != null) {
            ArrayList allInputsToRemove = Lists.newArrayList();
            ArrayList allActionsToRemove = Lists.newArrayList();
            for (EffectiveIntervention intervention : effectiveInterventions) {
                List<AbstractInput> abstractInputs = this.abstractInputTopiaDao.findAllByEffectiveIntervention(intervention);
                if (abstractInputs != null) {
                    allInputsToRemove.addAll(abstractInputs);
                }
                List abstractActions = this.abstractActionDao.forEffectiveInterventionEquals(intervention).findAll();
                allActionsToRemove.addAll(abstractActions);
            }
            this.abstractInputTopiaDao.deleteAll(allInputsToRemove);
            this.effectiveInterventionDao.deleteAll(effectiveInterventions);
            this.abstractActionDao.deleteAll(allActionsToRemove);
        }
    }

    protected void updateEffectivePrices(String zoneId, List<Price> prices) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneId).findUnique();
        Domain domain = zone.getPlot().getDomain();
        this.pricesService.updatePrices(prices, domain, null);
    }

    protected void updateEffectiveInterventions(List<EffectiveInterventionDto> interventionDtos, EffectiveSeasonalCropCycleDto seasonalCropCycle, Pair<String, EffectiveCropCycleNode> nodeIdToNode, EffectivePerennialCropCycle perennialCropCycle, EffectiveCropCyclePhase phase, Domain domain) {
        Preconditions.checkArgument((boolean)(nodeIdToNode == null ^ phase == null));
        interventionDtos = interventionDtos != null ? interventionDtos : new ArrayList<EffectiveInterventionDto>();
        this.filterOnDomain(interventionDtos, domain);
        List interventions = nodeIdToNode != null && ((EffectiveCropCycleNode)nodeIdToNode.getRight()).isPersisted() ? this.effectiveInterventionDao.forEffectiveCropCycleNodeEquals((EffectiveCropCycleNode)nodeIdToNode.getRight()).findAll() : (phase != null && phase.isPersisted() ? this.effectiveInterventionDao.forEffectiveCropCyclePhaseEquals(phase).findAll() : new ArrayList());
        HashMap idsToInterventions = Maps.newHashMap((Map)Maps.uniqueIndex(interventions, (Function)Entities.GET_TOPIA_ID));
        List connectionDtos = seasonalCropCycle != null ? seasonalCropCycle.getConnectionDtos() : null;
        this.interventionDtosToInterventions(new InterventionDtoToInterventionUnivers(interventionDtos, connectionDtos, nodeIdToNode, perennialCropCycle, phase, domain, idsToInterventions));
        this.effectiveInterventionDao.deleteAll(idsToInterventions.values());
    }

    protected void filterOnDomain(List<EffectiveInterventionDto> interventionDtos, Domain domain) {
        Iterator<EffectiveInterventionDto> validInterventionDtos = interventionDtos.iterator();
        while (validInterventionDtos.hasNext()) {
            EffectiveInterventionDto interventionDto = validInterventionDtos.next();
            if (!Strings.isNullOrEmpty((String)interventionDto.getTopiaId()) || interventionDto.getDomainId().equals(domain.getTopiaId())) continue;
            validInterventionDtos.remove();
        }
    }

    private void interventionDtosToInterventions(InterventionDtoToInterventionUnivers interventionDtoToInterventionUnivers) {
        for (EffectiveInterventionDto interventionDto : interventionDtoToInterventionUnivers.getInterventionDtos()) {
            String interventionId = interventionDto.getTopiaId();
            EffectiveCropCycleNode node = interventionDtoToInterventionUnivers.getNodeIdToNode() != null ? (EffectiveCropCycleNode)interventionDtoToInterventionUnivers.getNodeIdToNode().getRight() : null;
            EffectiveIntervention intervention = this.getEffectiveIntervention(node, interventionDtoToInterventionUnivers.getPhase(), interventionDtoToInterventionUnivers.getIdsToInterventions(), interventionId);
            Map<String, CroppingPlanSpecies> phaseOrNodeSpeciesMap = this.getPhaseOrNodeCroppingPlanSpeciesByCode(interventionDto.isIntermediateCrop(), interventionDtoToInterventionUnivers.getNodeIdToNode(), interventionDtoToInterventionUnivers.getConnectionDtos(), interventionDtoToInterventionUnivers.getPerennialCropCycle());
            Set<String> speciesCodes = phaseOrNodeSpeciesMap.keySet();
            this.bindDataToIntervention(interventionDtoToInterventionUnivers.getDomain(), interventionDto, intervention, phaseOrNodeSpeciesMap);
            if (!intervention.isPersisted()) {
                EffectiveIntervention persistedIntervention = (EffectiveIntervention)this.effectiveInterventionDao.create((TopiaEntity)intervention);
                Map actions = this.actionService.createEffectiveInterventionActions(persistedIntervention, interventionDto.getActions(), speciesCodes);
                this.inputService.createInterventionInputs(null, persistedIntervention, interventionDto.getInputs(), actions);
                continue;
            }
            Map actions = this.actionService.updateEffectiveInterventionActions(intervention, interventionDto.getActions(), speciesCodes);
            this.inputService.updateInterventionInputs(null, intervention, interventionDto.getInputs(), actions);
        }
    }

    private void bindDataToIntervention(Domain domain, EffectiveInterventionDto interventionDto, EffectiveIntervention intervention, Map<String, CroppingPlanSpecies> phaseOrNodeSpeciesMap) {
        Binder binder = BinderFactory.newBinder(EffectiveInterventionDto.class, EffectiveIntervention.class);
        binder.copyExcluding((Object)interventionDto, (Object)intervention, new String[]{"topiaId", "toolCouplings", "speciesStades", "effectiveCropCycleNode", "effectiveCropCyclePhase"});
        this.bindToolsCouplingToIntervention(domain, interventionDto, intervention);
        this.bindSpeciesStadesToIntervention(interventionDto, intervention, phaseOrNodeSpeciesMap);
    }

    private void bindSpeciesStadesToIntervention(EffectiveInterventionDto interventionDto, EffectiveIntervention intervention, Map<String, CroppingPlanSpecies> phaseOrNodeSpeciesMap0) {
        Collection speciesStades = intervention.getSpeciesStades();
        HashMap phaseOrNodeSpeciesMap = Maps.newHashMap(phaseOrNodeSpeciesMap0);
        if (speciesStades == null) {
            speciesStades = Lists.newArrayList();
            intervention.setSpeciesStades(speciesStades);
        }
        if (interventionDto.getSpeciesStadesDtos() != null) {
            ArrayList nonDeletedStades = Lists.newArrayList();
            ImmutableMap idToSpeciesStade = Maps.uniqueIndex((Iterable)speciesStades, (Function)Entities.GET_TOPIA_ID);
            for (SpeciesStadeDto speciesStadeDto : interventionDto.getSpeciesStadesDtos()) {
                String speciesStadeId = speciesStadeDto.getTopiaId();
                CroppingPlanSpecies croppingPlanSpecies = null;
                String speciesCode = speciesStadeDto.getSpeciesCode();
                if (speciesCode != null) {
                    croppingPlanSpecies = (CroppingPlanSpecies)phaseOrNodeSpeciesMap.remove(speciesCode);
                }
                if (croppingPlanSpecies == null) continue;
                EffectiveSpeciesStade effectiveSpeciesStade = this.getEffectiveSpeciesStade(speciesStades, (Map<String, EffectiveSpeciesStade>)idToSpeciesStade, speciesStadeDto, speciesStadeId, croppingPlanSpecies);
                nonDeletedStades.add(effectiveSpeciesStade);
            }
            speciesStades.retainAll(nonDeletedStades);
        } else {
            for (CroppingPlanSpecies croppingPlanSpecies : phaseOrNodeSpeciesMap.values()) {
                EffectiveSpeciesStade effectiveSpeciesStade = (EffectiveSpeciesStade)this.effectiveSpeciesStadeDao.newInstance();
                effectiveSpeciesStade.setCroppingPlanSpecies(croppingPlanSpecies);
                speciesStades.add(effectiveSpeciesStade);
            }
        }
    }

    protected EffectiveSpeciesStade getEffectiveSpeciesStade(Collection<EffectiveSpeciesStade> speciesStades, Map<String, EffectiveSpeciesStade> idToSpeciesStade, SpeciesStadeDto speciesStadeDto, String speciesStadeId, CroppingPlanSpecies croppingPlanSpecies) {
        RefStadeEdiDto stadeMaxFromDto;
        RefStadeEdiDto stadeMinFromDto;
        EffectiveSpeciesStade effectiveSpeciesStade = null;
        if (StringUtils.isNotBlank((CharSequence)speciesStadeId)) {
            effectiveSpeciesStade = idToSpeciesStade.get(speciesStadeId);
        }
        if (effectiveSpeciesStade == null) {
            effectiveSpeciesStade = (EffectiveSpeciesStade)this.effectiveSpeciesStadeDao.newInstance();
        }
        effectiveSpeciesStade.setCroppingPlanSpecies(croppingPlanSpecies);
        RefStadeEDI minStade = null;
        RefStadeEdiDto refStadeEdiDto = stadeMinFromDto = speciesStadeDto != null ? speciesStadeDto.getStadeMin() : null;
        if (stadeMinFromDto != null) {
            minStade = (RefStadeEDI)this.refStadeEDIDao.forTopiaIdEquals(stadeMinFromDto.getTopiaId()).findUnique();
        }
        effectiveSpeciesStade.setMinStade(minStade);
        RefStadeEDI maxStade = null;
        RefStadeEdiDto refStadeEdiDto2 = stadeMaxFromDto = speciesStadeDto != null ? speciesStadeDto.getStadeMax() : null;
        if (stadeMaxFromDto != null) {
            maxStade = (RefStadeEDI)this.refStadeEDIDao.forTopiaIdEquals(stadeMaxFromDto.getTopiaId()).findUnique();
        }
        effectiveSpeciesStade.setMaxStade(maxStade);
        if (StringUtils.isBlank((CharSequence)speciesStadeId)) {
            speciesStades.add(effectiveSpeciesStade);
        }
        return effectiveSpeciesStade;
    }

    private void bindToolsCouplingToIntervention(Domain domain, EffectiveInterventionDto interventionDto, EffectiveIntervention intervention) {
        if (interventionDto.getToolsCouplingCodes() != null) {
            Collection toolsCouplings = intervention.getToolCouplings();
            if (toolsCouplings == null) {
                toolsCouplings = Lists.newArrayList();
                intervention.setToolCouplings(toolsCouplings);
            }
            toolsCouplings.clear();
            for (String toolsCouplingCodes : interventionDto.getToolsCouplingCodes()) {
                ToolsCoupling toolsCoupling = (ToolsCoupling)this.toolsCouplingDao.forProperties("code", toolsCouplingCodes, new Object[]{"domain", domain}).findAnyOrNull();
                if (toolsCoupling == null) continue;
                toolsCouplings.add(toolsCoupling);
            }
        }
    }

    private Map<String, CroppingPlanSpecies> getPhaseOrNodeCroppingPlanSpeciesByCode(boolean isIntermediate, Pair<String, EffectiveCropCycleNode> nodeIdToNode, List<EffectiveCropCycleConnectionDto> connectionDtos, EffectivePerennialCropCycle perennialCropCycle) {
        Collection filtratedAllowedSpecies;
        HashSet allowedSpecies = Sets.newHashSet();
        if (nodeIdToNode != null) {
            if (isIntermediate && connectionDtos != null) {
                if (CollectionUtils.isNotEmpty(connectionDtos)) {
                    HashMap loadedCPEcach = Maps.newHashMap();
                    for (EffectiveCropCycleConnectionDto connectionDto : connectionDtos) {
                        String targetedNodeId = connectionDto.getIntermediateCroppingPlanEntryId() != null ? (String)Entities.UNESCAPE_TOPIA_ID.apply((Object)connectionDto.getTargetId()) : null;
                        if (targetedNodeId == null || !targetedNodeId.equals(nodeIdToNode.getLeft())) continue;
                        CroppingPlanEntry cpe = (CroppingPlanEntry)loadedCPEcach.get(connectionDto.getIntermediateCroppingPlanEntryId());
                        if (cpe == null) {
                            cpe = (CroppingPlanEntry)this.croppingPlanEntryDao.forTopiaIdEquals(connectionDto.getIntermediateCroppingPlanEntryId()).findUnique();
                            loadedCPEcach.put(cpe.getTopiaId(), cpe);
                        }
                        if (cpe.getCroppingPlanSpecies() != null) {
                            allowedSpecies.addAll(cpe.getCroppingPlanSpecies());
                        }
                        break;
                    }
                }
            } else {
                allowedSpecies = Sets.newHashSet((Iterable)((EffectiveCropCycleNode)nodeIdToNode.getRight()).getCroppingPlanEntry().getCroppingPlanSpecies());
            }
        } else if (perennialCropCycle != null) {
            allowedSpecies = Sets.newHashSet((Iterable)perennialCropCycle.getCroppingPlanEntry().getCroppingPlanSpecies());
        }
        Map result = (Map)(CollectionUtils.isNotEmpty((Collection)(filtratedAllowedSpecies = Collections2.filter((Collection)allowedSpecies, (Predicate)Predicates.notNull()))) ? Maps.uniqueIndex((Iterable)filtratedAllowedSpecies, GET_CROPPING_PLAN_SPECIES_CODE) : new HashMap(0));
        return result;
    }

    private EffectiveIntervention getEffectiveIntervention(EffectiveCropCycleNode node, EffectiveCropCyclePhase phase, Map<String, EffectiveIntervention> phaseOrNodeInterventionsByIds, String interventionId) {
        EffectiveIntervention intervention;
        if (StringUtils.isBlank((CharSequence)interventionId)) {
            intervention = (EffectiveIntervention)this.effectiveInterventionDao.newInstance();
            if (node != null) {
                intervention.setEffectiveCropCycleNode(node);
            } else {
                intervention.setEffectiveCropCyclePhase(phase);
            }
        } else {
            intervention = phaseOrNodeInterventionsByIds.remove(interventionId);
        }
        return intervention;
    }

    public List<Price> getEffectivePrices(String zoneId, List<String> objectIds) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneId) ? 1 : 0) != 0);
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneId).findUnique();
        String domainId = zone.getPlot().getDomain().getTopiaId();
        List result = this.pricesService.getDomainPrices(domainId, objectIds);
        return result;
    }

    public List<ToolsCouplingDto> getToolsCouplingModel(String zoneTopiaId, final AgrosystInterventionType interventionType) {
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        Domain domain = zone.getPlot().getDomain();
        List toolsCouplings = this.toolsCouplingDao.forDomainEquals(domain).findAll();
        Iterable filtered = Iterables.filter((Iterable)toolsCouplings, (Predicate)new Predicate<ToolsCoupling>(){

            public boolean apply(ToolsCoupling toolsCoupling) {
                return interventionType == null || Iterables.tryFind((Iterable)toolsCoupling.getMainsActions(), (Predicate)new Predicate<RefInterventionAgrosystTravailEDI>(){

                    public boolean apply(RefInterventionAgrosystTravailEDI mainAction) {
                        return interventionType.equals((Object)mainAction.getIntervention_agrosyst());
                    }
                }).isPresent();
            }
        });
        ArrayList result = Lists.newArrayList((Iterable)Iterables.transform((Iterable)filtered, (Function)Equipments.TOOLS_COUPLING_TO_TOOLS_COUPLING_DTO));
        return result;
    }

    public void duplicateEffectiveCropCycles(String fromZoneId, String toZoneId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fromZoneId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)toZoneId) ? 1 : 0) != 0);
        List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycleDtos = this.getAllEffectiveSeasonalCropCyclesDtos(fromZoneId);
        List<EffectivePerennialCropCycleDto> effectivePerennialCropCycleDtos = this.getAllEffectivePerennialCropCyclesDtos(fromZoneId);
        for (EffectiveSeasonalCropCycleDto seasonalCropCycleDto : effectiveSeasonalCropCycleDtos) {
            seasonalCropCycleDto.setTopiaId(null);
            List nodesDto = seasonalCropCycleDto.getNodeDtos();
            HashMap mappingUUIDs = Maps.newHashMap();
            for (EffectiveCropCycleNodeDto nodeDto : nodesDto) {
                UUID uuid = UUID.randomUUID();
                mappingUUIDs.put(nodeDto.getNodeId(), uuid);
                nodeDto.setTopiaId(null);
                nodeDto.setNodeId(NEW_NODE_PREFIX + uuid.toString());
                List interventionDtos = nodeDto.getInterventions();
                nodeDto.setInterventions(this.toNewInterventionDtos(interventionDtos));
            }
            List connectionDtos = seasonalCropCycleDto.getConnectionDtos();
            for (EffectiveCropCycleConnectionDto cycleConnectionDto : connectionDtos) {
                cycleConnectionDto.setTopiaId(null);
                String sourceId = StringUtils.isBlank((CharSequence)cycleConnectionDto.getSourceId()) ? null : NEW_NODE_PREFIX + mappingUUIDs.get(cycleConnectionDto.getSourceId());
                cycleConnectionDto.setSourceId(sourceId);
                cycleConnectionDto.setTargetId(NEW_NODE_PREFIX + mappingUUIDs.get(cycleConnectionDto.getTargetId()));
            }
        }
        for (EffectivePerennialCropCycleDto effectivePerennialCropCycleDto : effectivePerennialCropCycleDtos) {
            effectivePerennialCropCycleDto.setTopiaId(null);
            List phases = effectivePerennialCropCycleDto.getPhaseDtos();
            for (EffectiveCropCyclePhaseDto phase : phases) {
                phase.setTopiaId(null);
                List interventionDtos = phase.getInterventions();
                phase.setInterventions(this.toNewInterventionDtos(interventionDtos));
            }
        }
        this.updateEffectiveSeasonalCropCycles(toZoneId, effectiveSeasonalCropCycleDtos);
        this.udpateEffectivePerennialCropCycles(toZoneId, effectivePerennialCropCycleDtos);
        this.getTransaction().commit();
    }

    protected List<EffectiveInterventionDto> toNewInterventionDtos(List<EffectiveInterventionDto> interventionDtos) {
        ArrayList newInterventionDtos = Lists.newArrayListWithCapacity((int)interventionDtos.size());
        for (EffectiveInterventionDto interventionDto : interventionDtos) {
            newInterventionDtos.add(this.toNewInterventionDto(interventionDto));
        }
        return newInterventionDtos;
    }

    protected EffectiveInterventionDto toNewInterventionDto(EffectiveInterventionDto interventionDto) {
        EffectiveInterventionDto newEffectiveInterventionDto = new EffectiveInterventionDto();
        this.bindEffectiveInterventionData(interventionDto, newEffectiveInterventionDto);
        this.setSpeciesStadeAsNonPersisted(newEffectiveInterventionDto);
        Map<AbstractAction, AbstractAction> actionsToDuplicatedActions = this.cloneActions(newEffectiveInterventionDto);
        this.cloneInputs(newEffectiveInterventionDto, actionsToDuplicatedActions);
        return newEffectiveInterventionDto;
    }

    protected Map<AbstractAction, AbstractAction> cloneActions(EffectiveInterventionDto newEffectiveInterventionDto) {
        HashMap actionsToDuplicatedActions = Maps.newHashMap();
        for (AbstractAction action : newEffectiveInterventionDto.getActions()) {
            actionsToDuplicatedActions.put(action, this.actionService.getClonedAbstractAction(action));
        }
        newEffectiveInterventionDto.setActions(actionsToDuplicatedActions.values());
        return actionsToDuplicatedActions;
    }

    protected void cloneInputs(EffectiveInterventionDto newEffectiveInterventionDto, Map<AbstractAction, AbstractAction> actionsToDuplicatedActions) {
        List inputs = newEffectiveInterventionDto.getInputs();
        ArrayList duplicatedInputs = Lists.newArrayListWithCapacity((int)inputs.size());
        for (AbstractInput input : inputs) {
            duplicatedInputs.add(this.inputService.getDuplicatedAbstractInput(actionsToDuplicatedActions, input));
        }
        newEffectiveInterventionDto.setInputs((List)duplicatedInputs);
    }

    protected void setSpeciesStadeAsNonPersisted(EffectiveInterventionDto newEffectiveInterventionDto) {
        List speciesStadeDtos = newEffectiveInterventionDto.getSpeciesStadesDtos();
        if (speciesStadeDtos != null) {
            for (SpeciesStadeDto speciesStadeDto : speciesStadeDtos) {
                speciesStadeDto.setTopiaId(null);
            }
        }
    }

    protected void bindEffectiveInterventionData(EffectiveInterventionDto interventionDto, EffectiveInterventionDto newEffectiveInterventionDto) {
        Binder binder = BinderFactory.newBinder(EffectiveInterventionDto.class);
        binder.copy((Object)interventionDto, (Object)newEffectiveInterventionDto, new String[0]);
        newEffectiveInterventionDto.setTopiaId(null);
    }

    public List<ZoneDto> getZones(Collection<String> zoneIds) {
        List plots = this.zoneDao.forTopiaIdIn(zoneIds).findAll();
        List result = Lists.transform((List)plots, (Function)this.anonymizeService.getZoneToDtoFunction(false));
        return result;
    }

    public InputStream exportEffectiveCropCyclesAsXlsStream(List<String> effectiveCropCycleIds) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        EffectiveCropCycleExportMetadata.EffectiveCropCycleBeanInfo effectiveCropCycleBeanTab = this.newInstance(EffectiveCropCycleExportMetadata.EffectiveCropCycleBeanInfo.class);
        EffectiveCropCycleExportMetadata.EffectivePerennialCropCycleSpeciesBeanInfo perennialSpeciesTab = this.newInstance(EffectiveCropCycleExportMetadata.EffectivePerennialCropCycleSpeciesBeanInfo.class);
        EffectiveCropCycleExportMetadata.EffectiveITKBeanInfo effectiveITKBeanTab = this.newInstance(EffectiveCropCycleExportMetadata.EffectiveITKBeanInfo.class);
        ExportUtils.addAllBeanInfo(sheet, effectiveCropCycleBeanTab, perennialSpeciesTab, effectiveITKBeanTab);
        List perennialEntities = (List)sheet.get(perennialSpeciesTab);
        List itkEntities = (List)sheet.get(effectiveITKBeanTab);
        try {
            if (CollectionUtils.isNotEmpty(effectiveCropCycleIds)) {
                List zones = this.zoneDao.forTopiaIdIn(effectiveCropCycleIds).findAll();
                for (Zone zone : zones) {
                    List itks;
                    zone = this.anonymizeService.checkForZoneAnonymization(zone);
                    Domain domain = zone.getPlot().getDomain();
                    EffectiveCropCycleExportEntity model = new EffectiveCropCycleExportEntity();
                    model.setZoneName(zone.getName());
                    model.setPlotName(zone.getPlot().getName());
                    if (zone.getPlot().getGrowingSystem() != null) {
                        model.setGrowingSystemName(zone.getPlot().getGrowingSystem().getName());
                        model.setGrowingPlanName(zone.getPlot().getGrowingSystem().getGrowingPlan().getName());
                    }
                    model.setDomainName(domain.getName());
                    model.setCampaign(domain.getCampaign());
                    List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycleDtos = this.getAllEffectiveSeasonalCropCyclesDtos(zone.getTopiaId());
                    List<EffectivePerennialCropCycleDto> effectivePerennialCropCycleDtos = this.getAllEffectivePerennialCropCyclesDtos(zone.getTopiaId());
                    this.exportEffectiveSeasonalCropCycles(effectiveSeasonalCropCycleDtos, sheet, effectiveCropCycleBeanTab, model);
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, effectivePerennialCropCycleDtos, (EntityExportTabInfo)effectiveCropCycleBeanTab);
                    if (effectivePerennialCropCycleDtos != null) {
                        for (EffectivePerennialCropCycleDto perennialCropCycleDto : effectivePerennialCropCycleDtos) {
                            List speciesDtos = perennialCropCycleDto.getSpeciesDtos();
                            if (speciesDtos.isEmpty()) continue;
                            EffectiveCropCycleExportEntity export = (EffectiveCropCycleExportEntity)model.clone();
                            ExportUtils.copyFields(perennialCropCycleDto, (EntityExportExtra)export, null, "croppingPlanEntryName");
                            ExportUtils.setExtraField(export, "phase", ((EffectiveCropCyclePhaseDto)perennialCropCycleDto.getPhaseDtos().get(0)).getType());
                            for (EffectiveCropCycleSpeciesDto speciesDto : speciesDtos) {
                                ExportUtils.copyFields(speciesDto, (EntityExportExtra)export, null, "speciesEspece", "speciesQualifiant", "speciesTypeSaisonnier", "speciesDestination", "varietyLibelle", "plantsCertified", "overGraftDate");
                                String graftSupport = speciesDto.getGraftSupport() != null ? speciesDto.getGraftSupport().getLabel() : null;
                                ExportUtils.setExtraField(export, "graftSupport", graftSupport);
                                String graftClone = speciesDto.getGraftClone() != null ? speciesDto.getGraftClone().getLabel() : null;
                                ExportUtils.setExtraField(export, "graftClone", graftClone);
                                perennialEntities.add(export);
                            }
                        }
                    }
                    if (effectiveSeasonalCropCycleDtos != null) {
                        for (EffectiveSeasonalCropCycleDto seasonalCycle : effectiveSeasonalCropCycleDtos) {
                            List nodes = seasonalCycle.getNodeDtos();
                            if (nodes == null) continue;
                            for (EffectiveCropCycleNodeDto node : nodes) {
                                itks = node.getInterventions();
                                if (itks == null) continue;
                                for (EffectiveInterventionDto itk : itks) {
                                    model = this.exportCommonInterventionFields(node, null, null, itk, model);
                                    this.exportToolsCouplingsSpeciesActionsInputsFields(itkEntities, domain, model, itk);
                                }
                            }
                        }
                    }
                    if (effectivePerennialCropCycleDtos == null) continue;
                    for (EffectivePerennialCropCycleDto cycle : effectivePerennialCropCycleDtos) {
                        List phases = cycle.getPhaseDtos();
                        if (phases == null) continue;
                        for (EffectiveCropCyclePhaseDto phase : phases) {
                            itks = phase.getInterventions();
                            if (itks == null) continue;
                            for (EffectiveInterventionDto itk : itks) {
                                model = this.exportCommonInterventionFields(null, phase, cycle, itk, model);
                                this.exportToolsCouplingsSpeciesActionsInputsFields(itkEntities, domain, model, itk);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }

    protected void exportEffectiveSeasonalCropCycles(List<EffectiveSeasonalCropCycleDto> seasonalCropCycleDtos, Map<EntityExportTabInfo, List<? extends EntityExportExtra>> sheet, EffectiveCropCycleExportMetadata.EffectiveCropCycleBeanInfo effectiveCropCycleBeanInfo, EffectiveCropCycleExportEntity model) throws CloneNotSupportedException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (EffectiveSeasonalCropCycleDto seasonalCropCycleDto : seasonalCropCycleDtos) {
            ArrayList nodeExports;
            EffectiveSeasonalCropCycleExport nodeExport;
            List nodeDtos = seasonalCropCycleDto.getNodeDtos();
            List connectionDtos = seasonalCropCycleDto.getConnectionDtos();
            HashMap seasonalCropCycleExports = Maps.newHashMap();
            for (EffectiveCropCycleNodeDto nodeDto : nodeDtos) {
                nodeExport = new EffectiveSeasonalCropCycleExport();
                nodeExport.setCropName(nodeDto.getLabel());
                nodeExport.setRank(nodeDto.getX());
                seasonalCropCycleExports.put(nodeDto.getNodeId(), nodeExport);
            }
            for (EffectiveCropCycleConnectionDto connectionDto : connectionDtos) {
                if (!StringUtils.isNotBlank((CharSequence)connectionDto.getIntermediateCroppingPlanEntryName())) continue;
                nodeExport = (EffectiveSeasonalCropCycleExport)seasonalCropCycleExports.get(connectionDto.getTargetId());
                nodeExport.setIntermediateCropName(connectionDto.getIntermediateCroppingPlanEntryName());
            }
            List<? extends EntityExportExtra> seasonalCropCycles = sheet.get(effectiveCropCycleBeanInfo);
            if (!sheet.containsKey(effectiveCropCycleBeanInfo)) {
                sheet.put(effectiveCropCycleBeanInfo, seasonalCropCycles);
            }
            if (CollectionUtils.isEmpty((Collection)(nodeExports = Lists.newArrayList(seasonalCropCycleExports.values())))) continue;
            for (EffectiveSeasonalCropCycleExport seasonalCropCycleExport : nodeExports) {
                EffectiveCropCycleExportEntity export = (EffectiveCropCycleExportEntity)model.clone();
                ExportUtils.copyFields(seasonalCropCycleExport, (EntityExportExtra)export, null, "cropName", "intermediateCropName");
                Integer rank = seasonalCropCycleExport.getRank();
                ExportUtils.setExtraField(export, "rank", rank == null ? null : Integer.valueOf(rank + 1));
                seasonalCropCycles.add(export);
            }
        }
    }

    protected void exportToolsCouplingsSpeciesActionsInputsFields(List<EffectiveCropCycleExportEntity> itkEntities, Domain domain, EffectiveCropCycleExportEntity model, EffectiveInterventionDto itk) throws CloneNotSupportedException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (itk.getToolsCouplingCodes() != null && !itk.getToolsCouplingCodes().isEmpty()) {
            Set tcCodes = itk.getToolsCouplingCodes();
            for (String tcCode : tcCodes) {
                ToolsCoupling toolsCoupling = (ToolsCoupling)this.toolsCouplingDao.forProperties("code", tcCode, new Object[]{"domain", domain}).findAny();
                ExportUtils.setExtraField(model, "toolsCouplings", toolsCoupling.getToolsCouplingName());
                this.exportSpeciesActionsInputsFields(itkEntities, itk, model);
            }
        } else {
            this.exportSpeciesActionsInputsFields(itkEntities, itk, model);
        }
    }

    protected void exportSpeciesActionsInputsFields(List<EffectiveCropCycleExportEntity> itkEntities, EffectiveInterventionDto itk, EffectiveCropCycleExportEntity model) throws CloneNotSupportedException {
        if (itk.getSpeciesStadesDtos() != null && !itk.getSpeciesStadesDtos().isEmpty()) {
            for (SpeciesStadeDto stade : itk.getSpeciesStadesDtos()) {
                Collection actions = itk.getActions();
                for (AbstractAction action : actions) {
                    this.exportSpeciesStadeFields(stade, model);
                    this.exportActionFields(model, action);
                    this.exportInputsFields(itkEntities, itk, model);
                }
            }
        } else {
            Collection actions = itk.getActions();
            for (AbstractAction action : actions) {
                this.exportActionFields(model, action);
                this.exportInputsFields(itkEntities, itk, model);
            }
        }
    }

    protected void exportSpeciesStadeFields(SpeciesStadeDto speciesStadeDto, EffectiveCropCycleExportEntity model) {
        ExportUtils.setExtraField(model, "species", speciesStadeDto.getSpeciesName());
        String stadeMin = speciesStadeDto.getStadeMin() != null ? speciesStadeDto.getStadeMin().getLabel() : null;
        ExportUtils.setExtraField(model, "stadeMin", stadeMin);
        String stadeMax = speciesStadeDto.getStadeMax() != null ? speciesStadeDto.getStadeMax().getLabel() : null;
        ExportUtils.setExtraField(model, "stadeMax", stadeMax);
    }

    protected void exportActionFields(EffectiveCropCycleExportEntity export, AbstractAction action) {
        ExportUtils.setExtraField(export, "actionType", action.getMainAction().getIntervention_agrosyst());
        ExportUtils.setExtraField(export, "action", action.getMainAction().getReference_label());
        ExportUtils.setExtraField(export, "mainAction", StringUtils.isNotBlank((CharSequence)action.getToolsCouplingCode()));
    }

    protected void exportInputsFields(List<EffectiveCropCycleExportEntity> itkEntities, EffectiveInterventionDto itk, EffectiveCropCycleExportEntity model) throws CloneNotSupportedException {
        List inputs = itk.getInputs();
        if (inputs != null && !inputs.isEmpty()) {
            for (AbstractInput input : inputs) {
                EffectiveCropCycleExportEntity export = (EffectiveCropCycleExportEntity)model.clone();
                String unit = "";
                AgrosystInterventionType actionType = input.getInputType();
                switch (actionType) {
                    case APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX: {
                        MineralProductUnit mpu = ((MineralProductInput)input).getMineralProductUnit();
                        if (mpu == null) break;
                        unit = mpu.name();
                        break;
                    }
                    case EPANDAGES_ORGANIQUES: {
                        OrganicProductUnit opu = ((OrganicProductInput)input).getOrganicProductUnit();
                        if (opu == null) break;
                        unit = opu.name();
                        break;
                    }
                    case APPLICATION_DE_PRODUITS_PHYTOSANITAIRES: 
                    case LUTTE_BIOLOGIQUE: 
                    case SEMIS: {
                        PhytoProductUnit ppu = ((PhytoProductInput)input).getPhytoProductUnit();
                        if (ppu == null) break;
                        unit = ppu.name();
                        break;
                    }
                    case AUTRE: {
                        unit = ((OtherProductInput)input).getOtherProductQtUnit();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported input type: " + actionType);
                    }
                }
                ExportUtils.setExtraField(export, "inputType", input.getInputType());
                ExportUtils.setExtraField(export, "product", input.getProductName());
                ExportUtils.setExtraField(export, "qtMin", input.getQtMin());
                ExportUtils.setExtraField(export, "qtAvg", input.getQtAvg());
                ExportUtils.setExtraField(export, "qtMed", input.getQtMed());
                ExportUtils.setExtraField(export, "qtMax", input.getQtMax());
                ExportUtils.setExtraField(export, "unit", unit);
                itkEntities.add(export);
            }
        } else {
            EffectiveCropCycleExportEntity export = (EffectiveCropCycleExportEntity)model.clone();
            itkEntities.add(export);
        }
    }

    protected EffectiveCropCycleExportEntity exportCommonInterventionFields(EffectiveCropCycleNodeDto node, EffectiveCropCyclePhaseDto phase, EffectivePerennialCropCycleDto perennialCropCycle, EffectiveInterventionDto itk, EffectiveCropCycleExportEntity model) throws CloneNotSupportedException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        EffectiveCropCycleExportEntity export = (EffectiveCropCycleExportEntity)model.clone();
        String cycle = node != null ? "Assol\u00e9" : "P\u00e9renne";
        ExportUtils.setExtraField(export, "itk_cycle", cycle);
        String cropField = node != null ? node.getLabel() : perennialCropCycle.getCroppingPlanEntryName();
        ExportUtils.setExtraField(export, "itk_crop", cropField);
        Integer rank = node != null ? Integer.valueOf(node.getX()) : null;
        ExportUtils.setExtraField(export, "itk_rank", rank == null ? null : Integer.valueOf(rank + 1));
        CropCyclePhaseType phaseType = phase != null ? phase.getType() : null;
        ExportUtils.setExtraField(export, "itk_phase", phaseType);
        ExportUtils.copyFields(itk, (EntityExportExtra)export, null, "name", "type", "startInterventionDate", "endInterventionDate", "transitCount", "progressionSpeed", "involvedPeopleCount", "workRate", "spatialFrequency", "intermediateCrop", "comment");
        Double workRate = itk.getWorkRate();
        Double spendingTime = workRate != null && workRate != 0.0 ? Double.valueOf(1.0 / workRate * 1000.0 / 1000.0) : null;
        Double psci = (double)itk.getTransitCount() * itk.getSpatialFrequency();
        ExportUtils.setExtraField(export, "PSCi", psci);
        ExportUtils.setExtraField(export, "spendingTime", spendingTime);
        return export;
    }

    protected List<EffectivePerennialCropCycle> getAllEffectivePerennialCropCycles(Zone zone) {
        List cycles = this.effectivePerennialCropCycleDao.forZoneEquals(zone).findAll();
        return cycles;
    }

    protected List<EffectivePerennialCropCycle> getAllEffectivePerennialCropCyclesWithSameCrop(Zone zone, CroppingPlanEntry cp) {
        List cycles = this.effectivePerennialCropCycleDao.forProperties("zone", zone, new Object[]{"croppingPlanEntry", cp}).findAll();
        return cycles;
    }

    protected List<EffectiveSeasonalCropCycle> getAllEffectiveSeasonalCropCycles(Zone zone) {
        List cycles = this.effectiveSeasonalCropCycleDao.forZoneEquals(zone).findAll();
        return cycles;
    }

    protected List<EffectiveCropCycleNode> getAllEffectiveCropCycleNodes(Zone zone) {
        ArrayList result = Lists.newArrayList();
        List<EffectiveSeasonalCropCycle> cycles = this.getAllEffectiveSeasonalCropCycles(zone);
        if (cycles != null) {
            for (EffectiveSeasonalCropCycle cycle : cycles) {
                Collection nodes = (Collection)EFFECTIVE_SEASONAL_CROP_CYCLE_TO_NODE_FUNCTION.apply((Object)cycle);
                if (nodes == null) continue;
                result.addAll(nodes);
            }
        }
        return result;
    }

    protected List<EffectiveSeasonalCropCycle> getAllEffectiveSeasonalCropCycleWithSameCrop(List<EffectiveSeasonalCropCycle> escc, CroppingPlanEntry cp) {
        Iterator<EffectiveSeasonalCropCycle> i$;
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(escc) && (i$ = escc.iterator()).hasNext()) {
            EffectiveSeasonalCropCycle effectiveSeasonalCropCycle = i$.next();
            Collection nodes = effectiveSeasonalCropCycle.getNodes();
            for (EffectiveCropCycleNode node : nodes) {
                if (node.getCroppingPlanEntry() != cp) continue;
                result.add(effectiveSeasonalCropCycle);
                break;
            }
        }
        return result;
    }

    public CopyPasteZoneByCampaigns getAvailableZonesForCopy(String zoneTopiaId) {
        Zone zoneFrom = (Zone)this.zoneDao.forTopiaIdEquals(zoneTopiaId).findUnique();
        Domain domain = zoneFrom.getPlot().getDomain();
        List<Zone> zones = this.zoneDao.findZonesFromDomainCode(domain.getCode(), this.getSecurityContext());
        HashMap<Integer, List<CopyPasteZoneDto>> copyPasteZoneDtoByCampaign = new HashMap<Integer, List<CopyPasteZoneDto>>();
        CopyPasteZoneByCampaigns result = new CopyPasteZoneByCampaigns();
        result.setZonesByCampaigns(copyPasteZoneDtoByCampaign);
        for (Zone zone : zones) {
            List<EffectivePerennialCropCycle> allEffectivePerennialCropCycles = this.getAllEffectivePerennialCropCycles(zone.getTopiaId());
            List<EffectiveSeasonalCropCycle> allEffectiveSeasonalCropCycles = this.getAllEffectiveSeasonalCropCycles(zone.getTopiaId());
            ArrayList cropTargets = Lists.newArrayList();
            if (allEffectivePerennialCropCycles != null && !allEffectivePerennialCropCycles.isEmpty()) {
                cropTargets.addAll(Lists.newArrayList((Iterable)Iterables.transform(allEffectivePerennialCropCycles, this.EFFECTIVE_PERENNIAL_TO_CROP_CYCLE_CROP_TARGET_FUNCTION)));
            }
            if (allEffectiveSeasonalCropCycles != null && !allEffectiveSeasonalCropCycles.isEmpty()) {
                for (EffectiveSeasonalCropCycle allEffectiveSeasonalCropCycle : allEffectiveSeasonalCropCycles) {
                    Collection nodes = allEffectiveSeasonalCropCycle.getNodes();
                    if (nodes == null) continue;
                    cropTargets.addAll(Lists.newArrayList((Iterable)Iterables.transform((Iterable)nodes, this.EFFECTIVE_CROP_CYCLE_NODE_TO_CROP_TARGET_FUNCTION)));
                }
            }
            String zoneId = zone.getTopiaId();
            String zoneName = zone.getName();
            double zoneArea = zone.getArea();
            String plotName = zone.getPlot().getName();
            double plotArea = zone.getPlot().getArea();
            String domainName = zone.getPlot().getDomain().getName();
            int domainCampaign = zone.getPlot().getDomain().getCampaign();
            GrowingSystem gs = zone.getPlot().getGrowingSystem();
            String gsName = "";
            String gpName = "";
            if (gs != null) {
                gsName = gs.getName();
                gpName = gs.getGrowingPlan().getName();
            }
            for (CopyPasteZoneDto cropTarget : cropTargets) {
                cropTarget.setZoneId(zoneId);
                cropTarget.setZoneName(zoneName);
                cropTarget.setZoneArea(zoneArea);
                cropTarget.setPlotName(plotName);
                cropTarget.setPlotArea(plotArea);
                cropTarget.setDomainName(domainName);
                cropTarget.setGrowingPlanName(gpName);
                cropTarget.setGrowingSystemName(gsName);
                cropTarget.setCampaign(Integer.valueOf(domainCampaign));
                this.addCropTocopyPasteZoneDtoByCampaign(copyPasteZoneDtoByCampaign, cropTarget);
            }
        }
        return result;
    }

    protected void addCropTocopyPasteZoneDtoByCampaign(HashMap<Integer, List<CopyPasteZoneDto>> copyPasteZoneDtoByCampaign, CopyPasteZoneDto cropTarget) {
        List<CopyPasteZoneDto> copyPasteZoneDtosForCampaing = copyPasteZoneDtoByCampaign.get(cropTarget.getCampaign());
        if (copyPasteZoneDtosForCampaing == null) {
            copyPasteZoneDtosForCampaing = new ArrayList<CopyPasteZoneDto>();
            copyPasteZoneDtoByCampaign.put(cropTarget.getCampaign(), copyPasteZoneDtosForCampaing);
        }
        copyPasteZoneDtosForCampaing.add(cropTarget);
    }

    protected void copyInterventionsToTargetedNodes(List<EffectiveInterventionDto> interventionDtos, Zone targetedZone, List<String> targetedNodeIds) {
        if (CollectionUtils.isNotEmpty(targetedNodeIds)) {
            List<EffectiveCropCycleNode> targetedNodes = this.getNodesFromJspIds(targetedNodeIds);
            List<CroppingPlanSpecies> fromZoneSpecies = this.getFromCroppingPlanSpecieses(interventionDtos);
            Map fromSpeciesKeyToSpeciesCode = this.referentialService.getCroppingPlanSpeciesCodeByRefEspeceAndVarietyKey(fromZoneSpecies);
            for (EffectiveCropCycleNode targetedNode : targetedNodes) {
                List<EffectiveInterventionDto> copiedInterventionDtos = this.toNewInterventionDtos(interventionDtos);
                EffectiveCropCycleConnection targetedConnection = (EffectiveCropCycleConnection)this.effectiveCropCycleConnectionDao.forTargetEquals(targetedNode).findUniqueOrNull();
                Map<String, String> targetedSpeciesKeyToSpeciesCode = this.getSpeciesKeyToSpeciesCode(targetedNode, targetedConnection);
                Map<String, String> fromSpeciesCodeToSpeciesCode = this.getFromSpeciesCodeToSpeciesCode(fromSpeciesKeyToSpeciesCode, targetedSpeciesKeyToSpeciesCode);
                CroppingPlanEntry targetedIntermediateCrop = targetedConnection != null ? targetedConnection.getIntermediateCroppingPlanEntry() : null;
                CroppingPlanEntry targetedCrop = targetedNode.getCroppingPlanEntry();
                this.validIntermediateStatus(copiedInterventionDtos, targetedIntermediateCrop);
                this.doSeedingActionsAndInputsMigration(copiedInterventionDtos, targetedCrop, targetedIntermediateCrop, fromSpeciesCodeToSpeciesCode);
                this.addCroppingPanSpeciesSpeciesStades(copiedInterventionDtos, targetedCrop, targetedIntermediateCrop, fromSpeciesCodeToSpeciesCode);
                Map<String, EffectiveIntervention> idToIntervention = this.getEffectiveSeasonalInterventionById(targetedNode);
                ArrayList connectionDtos = targetedConnection != null ? Lists.newArrayList((Object[])new EffectiveCropCycleConnectionDto[]{(EffectiveCropCycleConnectionDto)EffectiveCropCycles.CROP_CYCLE_CONNECTION_TO_DTO.apply((Object)targetedConnection)}) : null;
                InterventionDtoToInterventionUnivers interventionDtoToInterventionUnivers = new InterventionDtoToInterventionUnivers(copiedInterventionDtos, connectionDtos, (Pair<String, EffectiveCropCycleNode>)Pair.of((Object)targetedNode.getTopiaId(), (Object)targetedNode), null, null, targetedZone.getPlot().getDomain(), idToIntervention);
                this.interventionDtosToInterventions(interventionDtoToInterventionUnivers);
            }
        }
    }

    protected void validIntermediateStatus(List<EffectiveInterventionDto> interventionDtos, CroppingPlanEntry targetedIntermediateCrop) {
        for (EffectiveInterventionDto interventionDto : interventionDtos) {
            boolean isIntermediate = interventionDto.isIntermediateCrop() && targetedIntermediateCrop != null;
            interventionDto.setIntermediateCrop(isIntermediate);
        }
    }

    protected Map<String, EffectiveIntervention> getEffectiveSeasonalInterventionById(EffectiveCropCycleNode targetedNode) {
        ArrayList interventions = Lists.newArrayList();
        interventions.addAll(this.effectiveInterventionDao.forEffectiveCropCycleNodeEquals(targetedNode).findAll());
        return Maps.newHashMap((Map)Maps.uniqueIndex((Iterable)interventions, (Function)Entities.GET_TOPIA_ID));
    }

    protected List<EffectiveCropCycleNode> getNodesFromJspIds(List<String> targetedNodeIds) {
        ArrayList nodes = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(targetedNodeIds)) {
            ArrayList nodeIds = Lists.newArrayListWithExpectedSize((int)targetedNodeIds.size());
            for (String nodeId : targetedNodeIds) {
                if (!StringUtils.isNotBlank((CharSequence)nodeId)) continue;
                nodeIds.add(Entities.UNESCAPE_TOPIA_ID.apply((Object)nodeId));
            }
            List zoneNodes = this.effectiveCropCycleNodeDao.forTopiaIdIn(nodeIds).findAll();
            nodes.addAll(zoneNodes);
        }
        return nodes;
    }

    protected Map<String, String> getSpeciesKeyToSpeciesCode(EffectiveCropCycleNode node, EffectiveCropCycleConnection connection) {
        CroppingPlanEntry croppingPlanEntry;
        Map<Object, Object> targetedSpeciesIdToCode = Maps.newHashMap();
        if (node != null) {
            croppingPlanEntry = node.getCroppingPlanEntry();
            targetedSpeciesIdToCode = this.doCroppingPlanEntrySpeciesKeyToSpeciesCode(croppingPlanEntry);
        }
        if (connection != null) {
            croppingPlanEntry = connection.getIntermediateCroppingPlanEntry();
            targetedSpeciesIdToCode.putAll(this.doCroppingPlanEntrySpeciesKeyToSpeciesCode(croppingPlanEntry));
        }
        return targetedSpeciesIdToCode;
    }

    protected Map<String, String> doCroppingPlanEntrySpeciesKeyToSpeciesCode(CroppingPlanEntry croppingPlanEntry) {
        HashMap targetedSpeciesKeyToSpeciesCode = Maps.newHashMap();
        if (croppingPlanEntry != null) {
            List croppingPlanSpecies = croppingPlanEntry.getCroppingPlanSpecies();
            targetedSpeciesKeyToSpeciesCode.putAll(this.referentialService.getCroppingPlanSpeciesCodeByRefEspeceAndVarietyKey((Collection)croppingPlanSpecies));
        }
        return targetedSpeciesKeyToSpeciesCode;
    }

    protected void copyInterventionsToTargetedPhases(List<EffectiveInterventionDto> interventionDtos, Zone zone, List<String> targetedPhaseIds) {
        if (CollectionUtils.isNotEmpty(targetedPhaseIds)) {
            ArrayList phases = Lists.newArrayList();
            phases.addAll(this.effectiveCropCyclePhaseDao.forTopiaIdIn(targetedPhaseIds).findAll());
            List<CroppingPlanSpecies> fromZoneSpecies = this.getFromCroppingPlanSpecieses(interventionDtos);
            Map fromSpeciesKeyToSpeciesCode = this.referentialService.getRefEspeceAndVarietyKeyByCroppingPlanSpeciesCode(fromZoneSpecies);
            for (EffectiveCropCyclePhase phase : phases) {
                EffectivePerennialCropCycle targetedPerennialCropCycle = (EffectivePerennialCropCycle)this.effectivePerennialCropCycleDao.forPhaseEquals(phase).findUnique();
                CroppingPlanEntry toZoneCrop = targetedPerennialCropCycle.getCroppingPlanEntry();
                List<EffectiveInterventionDto> copiedInterventionDtos = this.toNewInterventionDtos(interventionDtos);
                Map<String, String> fromSpeciesCodeToSpeciesCode = this.getFromSpeciesCodesToSpeciesCodes(fromSpeciesKeyToSpeciesCode, toZoneCrop);
                this.doSeedingActionsAndInputsMigration(copiedInterventionDtos, toZoneCrop, null, fromSpeciesCodeToSpeciesCode);
                this.addCroppingPanSpeciesSpeciesStades(copiedInterventionDtos, toZoneCrop, null, fromSpeciesCodeToSpeciesCode);
                Map<String, EffectiveIntervention> idToIntervention = this.getPerennialEffectiveInterventionsByIds(phase);
                this.interventionDtosToInterventions(new InterventionDtoToInterventionUnivers(copiedInterventionDtos, null, null, targetedPerennialCropCycle, phase, zone.getPlot().getDomain(), idToIntervention));
            }
        }
    }

    private Map<String, String> getFromSpeciesCodesToSpeciesCodes(Map<String, String> fromSpeciesKeyToSpeciesCode, CroppingPlanEntry toZoneCrop) {
        List toZoneSpecies = toZoneCrop.getCroppingPlanSpecies();
        Map targetedSpeciesKeyToSpeciesCode = this.referentialService.getCroppingPlanSpeciesCodeByRefEspeceAndVarietyKey((Collection)toZoneSpecies);
        return this.getFromSpeciesCodeToSpeciesCode(fromSpeciesKeyToSpeciesCode, targetedSpeciesKeyToSpeciesCode);
    }

    private Map<String, EffectiveIntervention> getPerennialEffectiveInterventionsByIds(EffectiveCropCyclePhase phase) {
        ArrayList interventions = Lists.newArrayList();
        interventions.addAll(this.effectiveInterventionDao.forEffectiveCropCyclePhaseEquals(phase).findAll());
        return Maps.newHashMap((Map)Maps.uniqueIndex((Iterable)interventions, (Function)Entities.GET_TOPIA_ID));
    }

    protected Map<String, String> getFromSpeciesCodeToSpeciesCode(Map<String, String> fromSpeciesKeyToSpeciesCode, Map<String, String> targetedSpeciesKeyToSpeciesCode) {
        HashMap fromSpeciesCodeToSpeciesCode = Maps.newHashMap();
        for (Map.Entry<String, String> targetedSpeciesKeyToCode : targetedSpeciesKeyToSpeciesCode.entrySet()) {
            String fromSpeciesCode = fromSpeciesKeyToSpeciesCode.get(targetedSpeciesKeyToCode.getKey());
            if (!StringUtils.isNotBlank((CharSequence)fromSpeciesCode)) continue;
            fromSpeciesCodeToSpeciesCode.put(fromSpeciesCode, targetedSpeciesKeyToCode.getValue());
        }
        return fromSpeciesCodeToSpeciesCode;
    }

    protected List<CroppingPlanSpecies> getFromCroppingPlanSpecieses(List<EffectiveInterventionDto> interventionDtos) {
        String fromDomainId = interventionDtos.get(0).getDomainId();
        HashSet speciesCodes = Sets.newHashSet();
        for (EffectiveInterventionDto interventionDto : interventionDtos) {
            for (SpeciesStadeDto speciesStadeDto : interventionDto.getSpeciesStadesDtos()) {
                speciesCodes.add(speciesStadeDto.getSpeciesCode());
            }
        }
        List<CroppingPlanSpecies> interventionSpecies = this.croppingPlanSpeciesDao.getCroppingPlanSpeciesForCodeAndDomainId(speciesCodes, fromDomainId);
        return interventionSpecies;
    }

    public void copyInterventions(List<TargetedZones> zonesDto, List<EffectiveInterventionDto> interventionDtos) {
        if (CollectionUtils.isNotEmpty(interventionDtos) && CollectionUtils.isNotEmpty(zonesDto)) {
            Iterable<String> zoneIds = this.getZoneIdsFromZoneDtos(zonesDto);
            List zones = this.zoneDao.forTopiaIdIn(Sets.newHashSet(zoneIds)).findAll();
            ImmutableMap indexedZones = Maps.uniqueIndex((Iterable)zones, (Function)Entities.GET_TOPIA_ID);
            for (TargetedZones targetedZoneDto : zonesDto) {
                Zone targetedZone = (Zone)indexedZones.get(targetedZoneDto.getZoneId());
                if (targetedZone == null) continue;
                this.copyInterventionsToTargetedNodes(interventionDtos, targetedZone, targetedZoneDto.getNodes());
                this.copyInterventionsToTargetedPhases(interventionDtos, targetedZone, targetedZoneDto.getPhases());
            }
            this.getTransaction().commit();
        }
    }

    protected Iterable<String> getZoneIdsFromZoneDtos(List<TargetedZones> zonesDto) {
        return Iterables.transform(zonesDto, (Function)new Function<TargetedZones, String>(){

            public String apply(TargetedZones input) {
                return input.getZoneId();
            }
        });
    }

    public void importPZ0EffectiveCropCycles(Collection<EffectiveCropCycleAndDependencies> effectiveCropCycleAndDependencies) {
        try {
            int count = 1;
            int total = effectiveCropCycleAndDependencies.size();
            for (EffectiveCropCycleAndDependencies entityAndDependencies : effectiveCropCycleAndDependencies) {
                String zoneId = entityAndDependencies.getZoneId();
                long start = System.currentTimeMillis();
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("D\u00e9but sauvegarde du cycle de cultures r\u00e9alis\u00e9 '%s' - %d/%d.", zoneId, count++, total));
                }
                ArrayList seasonalCropCycles = null;
                if (entityAndDependencies.getEffectivePz0SeasonalCropCyclesByCsvId() != null) {
                    Collection seasonalCropCycleDtos = entityAndDependencies.getEffectivePz0SeasonalCropCyclesByCsvId().values();
                    seasonalCropCycles = Lists.newArrayList((Iterable)Iterables.transform(seasonalCropCycleDtos, EFFECTIVE_PZ0_SEASONAL_CROP_CYCLE_TO_EFFECTIVE_PZ0_SEASONAL_CROP_CYCLE));
                }
                ArrayList effectivePerennialCropCycleDtos = null;
                if (entityAndDependencies.getEffectivePz0PerennialCropCyclesByCsvId() != null) {
                    Map effectivePerennialCropCyclesByCsvId = entityAndDependencies.getEffectivePz0PerennialCropCyclesByCsvId();
                    Collection pz0EffectivePerennialCropCycles = effectivePerennialCropCyclesByCsvId.values();
                    ArrayList perennialCropCycleDtos = Lists.newArrayListWithCapacity((int)pz0EffectivePerennialCropCycles.size());
                    for (Pz0EffectivePerennialCropCycle pz0EffectivePerennialCropCycle : pz0EffectivePerennialCropCycles) {
                        perennialCropCycleDtos.add(pz0EffectivePerennialCropCycle.getPerennialCropCycleDto());
                    }
                    effectivePerennialCropCycleDtos = Lists.newArrayList((Iterable)perennialCropCycleDtos);
                }
                ArrayList prices = null;
                if (!entityAndDependencies.getPrices().isEmpty()) {
                    prices = Lists.newArrayList(entityAndDependencies.getPrices().values());
                }
                this.updateEffectiveCropCyclesWithoutCommit(zoneId, seasonalCropCycles, effectivePerennialCropCycleDtos, prices);
                long p1 = System.currentTimeMillis();
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Fin de sauvegarde du cycle de cultures r\u00e9alis\u00e9 en:" + (p1 - start)));
            }
        }
        catch (Exception e) {
            throw new AgrosystImportException("Echec de persistance des cycles de culture du r\u00e9alis\u00e9", (Throwable)e);
        }
    }

    protected void doSeedingActionsAndInputsMigration(List<EffectiveInterventionDto> interventionDtos, CroppingPlanEntry targetedCrop, CroppingPlanEntry targetedIntermediateCrop, Map<String, String> fromSpeciesCodeToSpeciesCode) {
        for (EffectiveInterventionDto interventionDto : interventionDtos) {
            List targetedSpecieses = interventionDto.isIntermediateCrop() ? targetedIntermediateCrop.getCroppingPlanSpecies() : targetedCrop.getCroppingPlanSpecies();
            HashMap targetedSpeciesByCodes = Maps.newHashMap();
            for (CroppingPlanSpecies targetedSpeciese : targetedSpecieses) {
                targetedSpeciesByCodes.put(GET_CROPPING_PLAN_SPECIES_CODE.apply((Object)targetedSpeciese), targetedSpeciese);
            }
            this.actionService.migrateActionsSpeciesToTargetedSpecies(interventionDto.getActions(), (Map)targetedSpeciesByCodes, fromSpeciesCodeToSpeciesCode);
            this.inputService.migrateInputSpeciesToTargetedSpecies(interventionDto);
        }
    }

    protected void addCroppingPanSpeciesSpeciesStades(List<EffectiveInterventionDto> interventionDtos, CroppingPlanEntry targetedNodeOrPhaseCrop, CroppingPlanEntry targetedIntermediateCrop, Map<String, String> fromSpeciesCodeToSpeciesCode) {
        for (EffectiveInterventionDto interventionDto : interventionDtos) {
            List targetedSpecieses = interventionDto.isIntermediateCrop() ? targetedIntermediateCrop.getCroppingPlanSpecies() : targetedNodeOrPhaseCrop.getCroppingPlanSpecies();
            ImmutableMap targetedSpeciesByCodes = Maps.uniqueIndex((Iterable)targetedSpecieses, GET_CROPPING_PLAN_SPECIES_CODE);
            this.setSpeciesStadesBySpeciesCode((Map<String, CroppingPlanSpecies>)targetedSpeciesByCodes, fromSpeciesCodeToSpeciesCode, interventionDto);
        }
    }

    protected void setSpeciesStadesBySpeciesCode(Map<String, CroppingPlanSpecies> targetedSpeciesByCodes, Map<String, String> fromSpeciesCodeToSpeciesCode, EffectiveInterventionDto interventionDto) {
        List fromSpeciesStadeDtos = interventionDto.getSpeciesStadesDtos();
        if (fromSpeciesStadeDtos == null) {
            fromSpeciesStadeDtos = Lists.newArrayList();
        }
        ArrayList validSpeciesStadeDtos = Lists.newArrayList();
        for (SpeciesStadeDto fromSpeciesStadeDto : fromSpeciesStadeDtos) {
            String speciesCode = targetedSpeciesByCodes.get(fromSpeciesStadeDto.getSpeciesCode()) != null ? fromSpeciesStadeDto.getSpeciesCode() : fromSpeciesCodeToSpeciesCode.get(fromSpeciesStadeDto.getSpeciesCode());
            if (!StringUtils.isNotBlank((CharSequence)speciesCode)) continue;
            fromSpeciesStadeDto.setSpeciesCode(speciesCode);
            validSpeciesStadeDtos.add(fromSpeciesStadeDto);
        }
        validSpeciesStadeDtos = validSpeciesStadeDtos.isEmpty() ? null : validSpeciesStadeDtos;
        interventionDto.setSpeciesStadesDtos((List)validSpeciesStadeDtos);
    }
}

