/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.edaplos;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.edaplos.EdaplosDomainDto;
import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingResult;
import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingStatus;
import fr.inra.agrosyst.api.services.edaplos.EdaplosPlotDto;
import fr.inra.agrosyst.api.services.edaplos.EdaplosService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.edaplos.EdaplosDocumentParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.nuiton.topia.persistence.TopiaEntity;

public class EdaplosServiceImpl
extends AbstractAgrosystService
implements EdaplosService {
    private static final Log log = LogFactory.getLog(EdaplosServiceImpl.class);
    public static final int BUFFER_SIZE = 1024;
    protected DomainTopiaDao domainDao;
    protected PlotTopiaDao plotDao;
    protected ZoneTopiaDao zoneDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao;
    protected DomainService domainService;
    protected PlotService plotService;
    protected EffectiveCropCycleService effectiveCropCycleService;

    public DomainTopiaDao getDomainDao() {
        return this.domainDao;
    }

    public void setDomainDao(DomainTopiaDao domainDao) {
        this.domainDao = domainDao;
    }

    public PlotTopiaDao getPlotDao() {
        return this.plotDao;
    }

    public void setPlotDao(PlotTopiaDao plotDao) {
        this.plotDao = plotDao;
    }

    public ZoneTopiaDao getZoneDao() {
        return this.zoneDao;
    }

    public void setZoneDao(ZoneTopiaDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public CroppingPlanEntryTopiaDao getCroppingPlanEntryTopiaDao() {
        return this.croppingPlanEntryTopiaDao;
    }

    public void setCroppingPlanEntryTopiaDao(CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao) {
        this.croppingPlanEntryTopiaDao = croppingPlanEntryTopiaDao;
    }

    public DomainService getDomainService() {
        return this.domainService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public PlotService getPlotService() {
        return this.plotService;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public EffectiveCropCycleService getEffectiveCropCycleService() {
        return this.effectiveCropCycleService;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public List<EdaplosParsingResult> validEdaplosData(InputStream inputStream) {
        ArrayList results = Lists.newArrayList();
        List<InputStream> streams = this.extractZipOrRegularFile(inputStream);
        try {
            for (InputStream stream : streams) {
                SAXReader reader = new SAXReader();
                reader.setEncoding("utf-8");
                Document doc = reader.read(stream);
                EdaplosDocumentParser parser = this.newInstance(EdaplosDocumentParser.class);
                EdaplosParsingResult result = parser.parse(doc);
                results.add(result);
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        catch (DocumentException ex) {
            throw new AgrosystTechnicalException("Can't parse xml file", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<InputStream> extractZipOrRegularFile(InputStream inputStream) {
        ZipInputStream zipInputStream = null;
        ArrayList inputStreams = Lists.newArrayList();
        try {
            zipInputStream = new ZipInputStream(inputStream);
            while (zipInputStream.getNextEntry() != null) {
                ByteArrayOutputStream out = null;
                try {
                    int n;
                    byte[] buffer = new byte[1024];
                    out = new ByteArrayOutputStream();
                    while ((n = zipInputStream.read(buffer, 0, 1024)) > -1) {
                        out.write(buffer, 0, n);
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
                    inputStreams.add(is);
                    zipInputStream.closeEntry();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (Exception e) {
            try {
                throw new AgrosystTechnicalException("Can't parse xml file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)zipInputStream);
        return inputStreams;
    }

    public Map<Class, ImportResult> importEdaplos(List<EdaplosParsingResult> edaplosParsingResults) {
        HashMap result = Maps.newHashMap();
        if (edaplosParsingResults != null) {
            for (EdaplosParsingResult edaplosParsingResult : edaplosParsingResults) {
                if (edaplosParsingResult.getEdaplosParsingStatus() != EdaplosParsingStatus.SUCCESS) continue;
                ImportResult domainsImportResult = (ImportResult)result.get(Domain.class);
                if (domainsImportResult == null) {
                    domainsImportResult = new ImportResult();
                    result.put(Domain.class, domainsImportResult);
                }
                List eDomains = edaplosParsingResult.getDomains();
                for (EdaplosDomainDto eDomain : eDomains) {
                    Domain domain;
                    if (StringUtils.isNotBlank((CharSequence)eDomain.getTopiaId())) {
                        domain = (Domain)this.domainDao.forTopiaIdEquals(eDomain.getTopiaId()).findUnique();
                    } else {
                        domain = this.domainService.newDomain();
                        domain.setCampaign(Integer.parseInt(eDomain.getCampaign()));
                        domain.setCode(UUID.randomUUID().toString());
                        domain.setSiret(eDomain.getSiret());
                    }
                    domain.setName(eDomain.getName());
                    domain.setLocation(eDomain.getLocation());
                    domain.setMainContact(eDomain.getMainContact());
                    DomainType domainType = DomainType.EXPLOITATION_AGRICOLE;
                    domain.setType(domainType);
                    domain.setUpdateDate(new Date());
                    domain = this.domainService.createOrUpdateDomain(domain, eDomain.getLocation().getTopiaId(), null, null, eDomain.getCroppingPlanEntryDtos(), null, null, null, null, null, null);
                    if (eDomain.getPlots() != null && !eDomain.getPlots().isEmpty()) {
                        ImportResult plotImportResult = (ImportResult)result.get(Plot.class);
                        if (plotImportResult == null) {
                            plotImportResult = new ImportResult();
                            result.put(Plot.class, plotImportResult);
                        }
                        for (EdaplosPlotDto ePlot : eDomain.getPlots()) {
                            String realEntryTopiaId;
                            String entryCode;
                            List entriesFromEDomain;
                            String entryId;
                            Plot plot;
                            ArrayList<Zone> zones = new ArrayList<Zone>();
                            if (StringUtils.isNotBlank((CharSequence)ePlot.getTopiaId())) {
                                plot = (Plot)this.plotDao.forTopiaIdEquals(ePlot.getTopiaId()).findUnique();
                            } else {
                                plot = (Plot)this.plotDao.newInstance();
                                plot.setName(ePlot.getPlotName());
                                plot.setActive(true);
                                plot.setWaterFlowDistance(WaterFlowDistance.LESS_THAN_THREE);
                                plot.setBufferStrip(BufferStrip.NONE);
                                plot.setMaxSlope(MaxSlope.ZERO);
                                Zone defaultZone = (Zone)this.zoneDao.newInstance();
                                defaultZone.setName("Zone principale");
                                defaultZone.setType(ZoneType.PRINCIPALE);
                                defaultZone.setActive(true);
                                defaultZone.setCode(UUID.randomUUID().toString());
                                zones.add(defaultZone);
                            }
                            plot.seteDaplosIssuerId(ePlot.getIssuerId());
                            if (!Strings.isNullOrEmpty((String)ePlot.getArea())) {
                                plot.setArea(Double.parseDouble(ePlot.getArea()));
                            }
                            if (plot.isPersisted()) {
                                this.plotDao.update((TopiaEntity)plot);
                                plotImportResult.incUpdated();
                            } else {
                                plot = this.plotService.createOrUpdatePlot(plot, domain.getTopiaId(), domain.getLocation().getTopiaId(), null, null, null, null, null, null, null, zones, null);
                                plotImportResult.incCreated();
                            }
                            if (ePlot.getSeasonalCycleDto() == null || CollectionUtils.isEmpty((Collection)ePlot.getSeasonalCycleDto().getNodeDtos())) continue;
                            String myZoneId = ((Zone)this.plotService.getPlotZones(plot).get(0)).getTopiaId();
                            for (EffectiveCropCycleNodeDto cropCycleNode : ePlot.getSeasonalCycleDto().getNodeDtos()) {
                                entryId = cropCycleNode.getCroppingPlanEntryId();
                                if (!entryId.startsWith("new-entry-")) continue;
                                entriesFromEDomain = eDomain.getCroppingPlanEntryDtos();
                                for (CroppingPlanEntryDto entryFromEDomain : entriesFromEDomain) {
                                    if (!entryId.equals(entryFromEDomain.getTopiaId())) continue;
                                    entryCode = entryFromEDomain.getCode();
                                    realEntryTopiaId = ((CroppingPlanEntry)this.croppingPlanEntryTopiaDao.forProperties("code", entryCode, new Object[]{"domain", domain}).findUnique()).getTopiaId();
                                    cropCycleNode.setCroppingPlanEntryId(realEntryTopiaId);
                                }
                            }
                            for (EffectiveCropCycleConnectionDto cropCycleConn : ePlot.getSeasonalCycleDto().getConnectionDtos()) {
                                entryId = cropCycleConn.getIntermediateCroppingPlanEntryId();
                                if (!entryId.startsWith("new-entry")) continue;
                                List entriesFromDomain = eDomain.getCroppingPlanEntryDtos();
                                for (CroppingPlanEntryDto entryFromEDomain : entriesFromDomain) {
                                    if (!entryId.equals(entryFromEDomain.getTopiaId())) continue;
                                    entryCode = entryFromEDomain.getCode();
                                    realEntryTopiaId = ((CroppingPlanEntry)this.croppingPlanEntryTopiaDao.forProperties("code", entryCode, new Object[]{"domain", domain}).findUnique()).getTopiaId();
                                    cropCycleConn.setIntermediateCroppingPlanEntryId(realEntryTopiaId);
                                }
                            }
                            for (EffectivePerennialCropCycleDto perennialCycleDto : ePlot.getPerennialCycleDtos()) {
                                entryId = perennialCycleDto.getCroppingPlanEntryId();
                                if (!entryId.startsWith("new-entry-")) continue;
                                entriesFromEDomain = eDomain.getCroppingPlanEntryDtos();
                                for (CroppingPlanEntryDto entryFromEDomain : entriesFromEDomain) {
                                    if (!entryId.equals(entryFromEDomain.getTopiaId())) continue;
                                    entryCode = entryFromEDomain.getCode();
                                    realEntryTopiaId = ((CroppingPlanEntry)this.croppingPlanEntryTopiaDao.forProperties("code", entryCode, new Object[]{"domain", domain}).findUnique()).getTopiaId();
                                    perennialCycleDto.setCroppingPlanEntryId(realEntryTopiaId);
                                }
                            }
                            ArrayList<EffectiveSeasonalCropCycleDto> effSeasonalCycleDtos = new ArrayList<EffectiveSeasonalCropCycleDto>();
                            effSeasonalCycleDtos.add(ePlot.getSeasonalCycleDto());
                            this.effectiveCropCycleService.updateEffectiveCropCycles(myZoneId, effSeasonalCycleDtos, ePlot.getPerennialCycleDtos(), null);
                        }
                    }
                    this.getTransaction().commit();
                }
            }
        }
        return result;
    }
}

