/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.edaplos;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSol;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSolTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGevesTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.TypeCulture;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.edaplos.EdaplosDomainDto;
import fr.inra.agrosyst.api.services.edaplos.EdaplosDomainImportStatus;
import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingResult;
import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingStatus;
import fr.inra.agrosyst.api.services.edaplos.EdaplosPlotDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.common.CommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;

public class EdaplosDocumentParser {
    private static final Log log = LogFactory.getLog(EdaplosDocumentParser.class);
    protected static String ERROR_SIRET = "Le SIRET du domaine est une information obligatoire hors il est manquant dans le document.";
    protected static String ERROR_INVALID_CAMPAIGN = "Le format de la campagne (%s) pour le domaine ''%s'' n'est pas valide";
    protected static String ERROR_INVALID_CAMPAIGN_FOR_PLOT = "La campagne pour la parcelle ''%s'' (%s, domaine %s) n'est pas valide";
    protected static String ERROR_INVALID_IDENTIFIER_FOR_PLOT = "L'identifiant pour la parcelle ''%s'' (domaine %s) n'est pas valide";
    protected static String ERROR_NO_CAMPAIGN_FOR_DOMAIN = "Aucune campagne n'est d\u00e9finie pour le domaine ''%s'', de siret ''%s''";
    protected static String DOMAIN_CREATE = "Le domaine ayant le num\u00e9ro de siret :%s, sera cr\u00e9\u00e9 pour la campagne : %s";
    protected static String DOMAIN_FORBIDDEN = "Vous n'avez pas les droits d'\u00e9criture sur le domain avec num\u00e9ro de siret : %s, et la campagne : %s";
    protected static String DOMAIN_UPDATE = "Le domaine de siret :%s, et pour la campagne : %s est d\u00e9j\u00e0 dans Agrosyst avec le nom : %s. Des informations seront rajout\u00e9es";
    protected static final String PLOT_NO_CAMPAIGN_DEFINED = "Il n'y a pas de campagne de renseign\u00e9 pour cette parcelle: %s";
    protected static final String PLOT_OUT_OF_RANGE_CAMPAIGN = "Campagne %d non valide pour cette parcelle: %s";
    protected static final String PLOT_UNKNOWN = "Une parcelle n'a pas d'identifiant, elle ne sera pas import\u00e9e";
    protected static final String PLOT_UNKNOWN_ISSUER = "IssuerInternalReference inconnue pour la parcelle %s";
    protected static final String PLOT_NO_INDENTIFICATION = "Impossible de chercher la parcelle ayant pour identifiant :%s. Probl\u00e8me : les informations suivantes sont incompl\u00e8tes: nom :%s, surface:%s. La parcelle ne sera pas cr\u00e9\u00e9e et l'itin\u00e9raire technique ne sera pas compl\u00e9t\u00e9.";
    protected static final String PLOT_INCORRECT_AREA_TYPE = "La surface de la parcelle doit \u00eatre de type \"A17 - Surface de la parcelle culturale\"  ou \"ABE05 - Surface de la parcelle p\u00e9renne\", pour la parcelle ayant pour identifiant :%s. Impossible de chercher la parcelle, l'itin\u00e9raire technique ne sera pas compl\u00e9t\u00e9.";
    protected static final String TO_MANY_PLOTS_FOUND = "Trop de parcelles avec comme nom:%s et comme surface:%s dans le domaine :%s ! Les informations ne seront pas ajout\u00e9es.";
    protected static final String PLOT_CREATED = "Aucune parcelle trouv\u00e9e pour cette campagne ! Elle sera cr\u00e9\u00e9e";
    protected static final String ERROR_SOIL_OCCUPATION_NO_ISSUERID = "La parcelle ayant pour identifiant (%s) poss\u00e8de une occupation du sol sans identifiant. Aucune donn\u00e9e ne pourra \u00eatre ajout\u00e9e";
    protected static final String ERROR_SOIL_OCCUPATION_NO_TYPE = "L'occupation du sol (%s) sur la parcelle (%s), ne poss\u00e8de pas de type. Cette information est obligatoire.";
    protected static final String ERROR_SOIL_OCCUPATION_WRONG_TYPE = "L'occupation du sol (%s) sur la parcelle (%s) est de type (%s). Ce type d'occupation du sol n'est pas g\u00e9r\u00e9 par Agrosyst. Contactez l'\u00e9quipe Agrosyst.";
    protected static final String ERROR_SOIL_OCCUPATION_WRONG_RANK_FORMAT = "Le rang de l'occupation du sol ayant pour identifiant : %s, n'a pas le bon format (il faut un entier ou une valeur nulle)";
    protected static final String ERROR_SOIL_OCCUPATION_RANK_BELOW_ZERO = "Le rang de l'occupation du sol ayant pour identifiant : %s (parcelle : %s), n'a pas le bon format (il faut un entier positif)";
    protected static final String ERROR_SOIL_OCCUPATION_RANK_MUST_BE_ZERO = "Le rang de l'occupation du sol ayant pour identifiant : %s, doit \u00eatre zero (il est de %s)";
    protected static final String ERROR_SOIL_OCCUPATION_NO_SPECIES = "L'occupation du sol ayant pour identifiant : %s, ne poss\u00e8de pas de cultures";
    protected static final String ERROR_SOIL_OCCUPATION_CONNECTION_WITHOUT_NODE = "Une succession de cultures assol\u00e9es poss\u00e8de des cultures interm\u00e9diaires mais aucune culture principale (occupation du sol : %s, rang : %s)";
    protected static final String ERROR_SOIL_OCCUPATION_NO_NODE = "Succession de cultures assol\u00e9es : il n'est pas possible d'ajouter une culture interm\u00e9diaire si aucune culture principale n'existe (occupation du sol : %s, rang : %s)";
    protected static final String ERROR_SOIL_OCCUPATION_NO_TARGET = "Occupation du sol (%s) sur la parcelle (%s), impossible d'importer la culture interm\u00e9diaire (%s) car la culture principale n'existe pas";
    protected static final String ERROR_SOIL_OCCUPATION_NO_SOURCE = "Occupation du sol (%s) sur la parcelle (%s), impossible d'importer la culture interm\u00e9diaire (%s) car la culture pr\u00e9c\u00e9dente n'existe pas";
    protected static final String ERROR_SOIL_OCCUPATION_WRONG_CROPPING_TYPE = "Sur la parcelle (%s), l'occupation du sol (%s) poss\u00e8de une culture p\u00e9renne (%s) associ\u00e9e \u00e0 une culture d\u00e9rob\u00e9e ou interm\u00e9daire. Ceci emp\u00eache l'import de se d\u00e9rouler convenablement.";
    protected static final String ERROR_SOIL_OCCUPATION_TOO_MANY_PROD_CYCLE = "Sur la parcelle (%s), l'occupation du sol (S) poss\u00e8de plus d'un cycle de production.";
    protected static final String ERROR_SPECIES_BOTANICALCODE_MISSING = "L'occupation du sol ayant pour identifiant : %s, poss\u00e8de une culture sans identifiant d'esp\u00e8ce botanique";
    protected static final String ERROR_NO_EXISTING_SPECIES = "L'occupation du sol ayant pour identifiant : %s, poss\u00e8de une esp\u00e8ce qui n'a pas \u00e9t\u00e9 retrouv\u00e9e dans le r\u00e9f\u00e9rentiel des esp\u00e8ces Agrosyst. Voici les caract\u00e9ristiques de cette culture : Esp\u00e8ce botanique (%s), Qualifiant (%s), Type saisonnier (%s)";
    protected static final String ERROR_NO_PLANT_COVER = "L'occupation du sol ayant pour identifiant : %s, poss\u00e8de une esp\u00e8ce \u00e0 laquelle il n'est pas possible d'attribuer un type (assol\u00e9e ou p\u00e9renne). Contactez l'\u00e9quipe Agrosyst avec les caract\u00e9ristiques de cette culture : Esp\u00e8ce botanique (%s), Qualifiant (%s), Type saisonnier (%s)";
    protected static final String ERROR_NO_VALID_SPECIES = "L'occupation du sol ayant pour identifiant : %s, ne poss\u00e8de aucune esp\u00e8ce valide permettant de cr\u00e9er une culture";
    protected static final String ERROR_GEVESCODE_NOT_A_NUMBER = "L'occupation du sol ayant pour identifiant : %s, poss\u00e8de une vari\u00e9t\u00e9 dont l'identifiant n'est pas un nombre. Cet identifiant est %s";
    protected static final String ERROR_GEVESCODE_MISSING = "L'occupation du sol ayant pour identifiant : %s, poss\u00e8de une vari\u00e9t\u00e9 dont l'identifiant n'est pas pr\u00e9sent dans le r\u00e9f\u00e9rentiel vari\u00e9t\u00e9 d'Agrosyst. Contactez l'\u00e9quipe Agrosyst avec l'identifiant de cette vari\u00e9t\u00e9 %s";
    protected static final String ERROR_VARIETY_NAME_MISSING = "L'occupation du sol ayant pour identifiant : %s, poss\u00e8de une vari\u00e9t\u00e9 sans libell\u00e9 (Esp\u00e8ce botanique - %s, Qualifiant - %s, Type saisonnier - %s). Cette donn\u00e9e est obligatoire";
    protected static final String ERROR_VARIETY_MISSING = "L'occupation du sol ayant pour identifiant : %s, poss\u00e8de une vari\u00e9t\u00e9 dont le nom n'est pas pr\u00e9sent dans le r\u00e9f\u00e9rentiel vari\u00e9t\u00e9 d'Agrosyst. Contactez l'\u00e9quipe Agrosyst avec le nom de cette vari\u00e9t\u00e9 %s";
    protected static final String ERROR_MORE_THAN_ONE_VARIETY = "L'occupation du sol ayant pour identifiant : %s, poss\u00e8de une culture reli\u00e9e \u00e0 plusieurs vari\u00e9t\u00e9s (maximum 1 vari\u00e9t\u00e9). Cette culture est la suivante : Esp\u00e8ce botanique (%s), Qualifiant (%s), Type saisonnier (%s)";
    protected static final String ERROR_INTERVENTION_NO_GUID = "Sur la parcelle (%s), occupation du sol (%s), une intervention ne poss\u00e8de pas d'identifiant. Import Impossible.";
    protected static final String ERROR_INTERVENTION_NO_EDI_TYPE = "Sur la parcelle (%s), occupation du sol (%s), l'intervention (%s) n'a pas de type renseign\u00e9. Import impossible.";
    protected static final String ERROR_INTERVENTION_NO_SUBORDINATE_TYPE = "Sur la parcelle (%s), occupation du sol (%s), l'intervention (%s) n'a pas de qualifiant renseign\u00e9. Import impossible.";
    protected static final String ERROR_INTERVENTION_NOT_ONE_PERIOD = "Sur la parcelle (%s), occupation du sol (%s), l'intervention (%s) doit avoir une et une seule fen\u00eatre temporelle";
    protected static final String ERROR_INTERVENTION_NO_STARTING_DATE = "Sur la parcelle (%s), occupation du sol (%s), l'intervention (%s) n'a pas de date de d\u00e9but. Import impossible.";
    protected static final String ERROR_INTERVENTION_TO_MANY_REASONS = "Sur la parcelle (%s), occupation du sol (%s), l'intervention (%s) a trop de commentaires. Import impossible.";
    protected static String INFO_PLOT_EMPTY = "Pas de parcelles pour le domaine de Siret %s, aucune information ne sera import\u00e9e";
    protected static String INFO_NO_PLOT_SOIL_OCCUPATION = "Il n'y a pas d'occupation du sol pour la parcelle ayant pour identifiant %s. Aucune information ne sera ajout\u00e9e";
    protected static final String VALID_TYPE_CODE = "415";
    protected DomainTopiaDao domainTopiaDao;
    protected DomainService domainService;
    protected PlotTopiaDao plotTopiaDao;
    protected ZoneTopiaDao zoneTopiaDao;
    protected RefLocationTopiaDao locationTopiaDao;
    protected EffectiveCropCycleService effectiveCropCycleService;
    protected EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao;
    protected EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeTopiaDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionTopiaDao;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao;
    protected RefCultureEdiGroupeCouvSolTopiaDao refCultureEdiGroupeCouvSolTopiaDao;
    protected RefEspeceTopiaDao refEspeceTopiaDao;
    protected RefVarieteGevesTopiaDao refVarieteGevesTopiaDao;
    protected RefVarietePlantGrapeTopiaDao refVarietePlantGrapeTopiaDao;
    protected BusinessAuthorizationService authorizationService;
    protected EdaplosParsingResult edaplosParsingResult;

    public void setDomainTopiaDao(DomainTopiaDao domainTopiaDao) {
        this.domainTopiaDao = domainTopiaDao;
    }

    public void setPlotTopiaDao(PlotTopiaDao plotTopiaDao) {
        this.plotTopiaDao = plotTopiaDao;
    }

    public void setZoneTopiaDao(ZoneTopiaDao zoneTopiaDao) {
        this.zoneTopiaDao = zoneTopiaDao;
    }

    public void setEffectiveSeasonalCropCycleTopiaDao(EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao) {
        this.effectiveSeasonalCropCycleTopiaDao = effectiveSeasonalCropCycleTopiaDao;
    }

    public void setLocationTopiaDao(RefLocationTopiaDao locationTopiaDao) {
        this.locationTopiaDao = locationTopiaDao;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setEffectiveCropCycleNodeTopiaDao(EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeTopiaDao) {
        this.effectiveCropCycleNodeTopiaDao = effectiveCropCycleNodeTopiaDao;
    }

    public void setEffectiveCropCycleConnectionTopiaDao(EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionTopiaDao) {
        this.effectiveCropCycleConnectionTopiaDao = effectiveCropCycleConnectionTopiaDao;
    }

    public void setEffectivePerennialCropCycleTopiaDao(EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao) {
        this.effectivePerennialCropCycleTopiaDao = effectivePerennialCropCycleTopiaDao;
    }

    public void setRefCultureEdiGroupeCouvSolTopiaDao(RefCultureEdiGroupeCouvSolTopiaDao refCultureEdiGroupeCouvSolTopiaDao) {
        this.refCultureEdiGroupeCouvSolTopiaDao = refCultureEdiGroupeCouvSolTopiaDao;
    }

    public void setRefEspeceTopiaDao(RefEspeceTopiaDao refEspeceTopiaDao) {
        this.refEspeceTopiaDao = refEspeceTopiaDao;
    }

    public void setRefVarieteGevesTopiaDao(RefVarieteGevesTopiaDao refVarieteGevesTopiaDao) {
        this.refVarieteGevesTopiaDao = refVarieteGevesTopiaDao;
    }

    public void setRefVarietePlantGrapeTopiaDao(RefVarietePlantGrapeTopiaDao refVarietePlantGrapeTopiaDao) {
        this.refVarietePlantGrapeTopiaDao = refVarietePlantGrapeTopiaDao;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public EdaplosParsingResult parse(Document document) {
        this.edaplosParsingResult = this.processEdaplosFileParsing(document);
        return this.edaplosParsingResult;
    }

    protected EdaplosParsingResult processEdaplosFileParsing(Document document) {
        EdaplosParsingResult eDaplosParsingResult = new EdaplosParsingResult();
        boolean endParsing = false;
        while (!endParsing) {
            Element rootElement = document.getRootElement();
            if (rootElement == null) continue;
            Element metadataElement = rootElement.element("CropDataSheetDocument");
            if (metadataElement == null) {
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                eDaplosParsingResult.addErrorMessage("Le document ne contient pas les informations n\u00e9cessaires comme le TypeCode et l'Identification.");
                break;
            }
            String typeCode = metadataElement.elementText("TypeCode");
            String documentId = metadataElement.elementText("Identification");
            if (typeCode == null || documentId == null) {
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                eDaplosParsingResult.addErrorMessage("Le document ne contient pas les informations n\u00e9cessaires comme le TypeCode et l'Identification.");
                break;
            }
            if (!VALID_TYPE_CODE.equalsIgnoreCase(typeCode)) {
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                eDaplosParsingResult.addErrorMessage(String.format(ERROR_SIRET, documentId));
                break;
            }
            Element issuerCropDataSheetParty = metadataElement.element("IssuerCropDataSheetParty");
            if (issuerCropDataSheetParty == null) {
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                eDaplosParsingResult.addErrorMessage("Le document ne contient pas les informations n\u00e9cessaires pour l'\u00e9metteur.");
                break;
            }
            String siret = issuerCropDataSheetParty.elementText("Identification");
            String name = issuerCropDataSheetParty.elementText("Name");
            Element address = issuerCropDataSheetParty.element("SpecifiedUnstructuredAddress");
            if (address == null) {
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                eDaplosParsingResult.addErrorMessage("Le document ne contient pas les informations \u00e0 la localisation du domain (balise SpecifiedUnstructuredAddress).");
                break;
            }
            String cityName = address.elementText("CityName");
            String postcodeCode = address.elementText("PostcodeCode");
            if (StringUtils.isBlank((CharSequence)cityName) || StringUtils.isBlank((CharSequence)postcodeCode)) {
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                eDaplosParsingResult.addErrorMessage("Le document ne contient pas les informations \u00e0 la localisation du domain (Code postal).");
                break;
            }
            RefLocation location = (RefLocation)this.locationTopiaDao.forProperties("codePostal", postcodeCode, new Object[]{"commune", cityName}).findAnyOrNull();
            if (location == null) {
                List list = this.locationTopiaDao.forProperties("codePostal", postcodeCode, new Object[0]).findAll();
            }
            if (location == null) {
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                eDaplosParsingResult.addErrorMessage(String.format("Le nom de la commune %s et son code postal %s ne permettent pas de retouver son emplacement", cityName, postcodeCode));
                break;
            }
            Element recipientCropDataSheetParty = metadataElement.element("RecipientCropDataSheetParty");
            if (recipientCropDataSheetParty == null) {
                eDaplosParsingResult.addErrorMessage("Les information concernant le responsable du domaine ne peuvent \u00eatre retrouv\u00e9es (balise RecipientCropDataSheetParty).");
                break;
            }
            Element contact = recipientCropDataSheetParty.element("DefinedPartyContact");
            if (contact == null) {
                eDaplosParsingResult.addErrorMessage("Les information concernant le responsable du domaine ne peuvent \u00eatre retrouv\u00e9es (balise DefinedPartyContact).");
                break;
            }
            String mainContact = contact.elementText("PersonName");
            if (mainContact == null) {
                eDaplosParsingResult.addErrorMessage("Les information concernant le responsable du domaine ne peuvent \u00eatre retrouv\u00e9es (balise PersonName).");
                break;
            }
            if (StringUtils.isBlank((CharSequence)siret)) {
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                eDaplosParsingResult.addErrorMessage(String.format(ERROR_SIRET, documentId));
                break;
            }
            List plotElements = rootElement.elements("AgriculturalPlot");
            if (plotElements == null || plotElements.isEmpty()) {
                eDaplosParsingResult.addInfoMessage(String.format(INFO_PLOT_EMPTY, siret));
                break;
            }
            HashSet<String> stCampaigns = new HashSet<String>();
            for (Element plot : plotElements) {
                String harvestedYear = plot.elementText("HarvestedYear");
                if (!StringUtils.isNotBlank((CharSequence)harvestedYear)) continue;
                stCampaigns.add(harvestedYear);
            }
            if (stCampaigns.isEmpty()) {
                eDaplosParsingResult.addErrorMessage(String.format(ERROR_NO_CAMPAIGN_FOR_DOMAIN, name, siret));
                eDaplosParsingResult.setEdaplosParsingStatus(EdaplosParsingStatus.FAIL);
                break;
            }
            for (String stCampaign : stCampaigns) {
                EdaplosDomainDto edaplosDomainDto = new EdaplosDomainDto();
                edaplosDomainDto.setSiret(siret);
                edaplosDomainDto.setMainContact(mainContact);
                edaplosDomainDto.setCampaign(stCampaign);
                edaplosDomainDto.setName(name);
                edaplosDomainDto.setCityName(cityName);
                edaplosDomainDto.setPostcodeCode(postcodeCode);
                edaplosDomainDto.setLocation(location);
                if (!CommonService.ARE_CAMPAIGNS_VALIDS(stCampaign)) {
                    String invalidCampaign = String.format(ERROR_INVALID_CAMPAIGN, stCampaign, siret);
                    edaplosDomainDto.addErrorMessage(invalidCampaign);
                    eDaplosParsingResult.addDomain(edaplosDomainDto);
                    continue;
                }
                Integer campaign = Integer.valueOf(stCampaign);
                Domain domain = (Domain)this.domainTopiaDao.forProperties("siret", siret, new Object[]{"campaign", campaign}).findUniqueOrNull();
                if (domain == null) {
                    edaplosDomainDto.setStatus(EdaplosDomainImportStatus.CREATE);
                    edaplosDomainDto.addInfoMessage(String.format(DOMAIN_CREATE, siret, stCampaign));
                } else {
                    if (!this.authorizationService.isDomainWritable(domain.getTopiaId())) {
                        edaplosDomainDto.setTopiaId(domain.getTopiaId());
                        edaplosDomainDto.setCampaign(stCampaign);
                        edaplosDomainDto.setStatus(EdaplosDomainImportStatus.FORBIDDEN);
                        edaplosDomainDto.addInfoMessage(String.format(DOMAIN_FORBIDDEN, siret, stCampaign));
                        eDaplosParsingResult.addDomain(edaplosDomainDto);
                        continue;
                    }
                    edaplosDomainDto.setTopiaId(domain.getTopiaId());
                    edaplosDomainDto.setCampaign(stCampaign);
                    List persistedCroppingPlanEntries = this.domainService.getCroppingPlanDtos(domain.getTopiaId());
                    edaplosDomainDto.setCroppingPlanEntryDtos((List)Lists.newArrayList((Iterable)persistedCroppingPlanEntries));
                    edaplosDomainDto.setStatus(EdaplosDomainImportStatus.UPDATE);
                    edaplosDomainDto.addInfoMessage(String.format(DOMAIN_UPDATE, siret, stCampaign, domain.getName()));
                }
                this.processPlotImport(edaplosDomainDto, plotElements, domain, campaign);
                eDaplosParsingResult.addDomain(edaplosDomainDto);
            }
            endParsing = true;
        }
        return eDaplosParsingResult;
    }

    protected void processPlotImport(EdaplosDomainDto edaplosDomainDto, List<Element> plotList, Domain domain, Integer campaign) {
        for (Element plotElement : plotList) {
            EdaplosPlotDto edaplosPlotDto = new EdaplosPlotDto();
            String plotName = plotElement.elementText("Identification");
            if (StringUtils.isBlank((CharSequence)plotName)) {
                edaplosPlotDto.addPlotErrorMessage("Un nom de parcelle est manquant sur le domaine : " + edaplosDomainDto.getSiret());
                edaplosDomainDto.addPlot(edaplosPlotDto);
                continue;
            }
            edaplosPlotDto.setPlotName(plotName);
            String issuerPlotId = plotElement.elementText("IssuerInternalReference");
            if (StringUtils.isBlank((CharSequence)issuerPlotId)) {
                String invalidIdentifier = String.format(ERROR_INVALID_IDENTIFIER_FOR_PLOT, plotName, edaplosDomainDto.getSiret());
                edaplosPlotDto.addPlotErrorMessage(invalidIdentifier);
                edaplosDomainDto.addPlot(edaplosPlotDto);
                continue;
            }
            edaplosPlotDto.setIssuerId(issuerPlotId);
            String plotCampaign = plotElement.elementText("HarvestedYear");
            if (StringUtils.isEmpty((CharSequence)plotCampaign) || !CommonService.ARE_CAMPAIGNS_VALIDS(plotCampaign)) {
                String invalidPlotCampaign = String.format(ERROR_INVALID_CAMPAIGN_FOR_PLOT, issuerPlotId, plotName, edaplosDomainDto.getSiret());
                edaplosPlotDto.addPlotErrorMessage(invalidPlotCampaign);
                edaplosDomainDto.addPlot(edaplosPlotDto);
                continue;
            }
            Integer plotCampaignInt = Integer.valueOf(plotElement.elementText("HarvestedYear"));
            if (!plotCampaignInt.equals(campaign)) continue;
            Plot plot = null;
            Zone zone = null;
            if (domain != null && domain.isPersisted()) {
                if (StringUtils.isNotBlank((CharSequence)issuerPlotId)) {
                    plot = (Plot)this.plotTopiaDao.forProperties("eDaplosIssuerId", issuerPlotId, new Object[]{"domain", domain}).findUniqueOrNull();
                }
                if (plot == null) {
                    Element includedAgriculturalArea = plotElement.element("IncludedAgriculturalArea");
                    if (includedAgriculturalArea != null && (includedAgriculturalArea.elementText("Type") == null || !includedAgriculturalArea.elementText("Type").equals("A17") && !includedAgriculturalArea.elementText("Type").equals("ABE05"))) {
                        edaplosPlotDto.addPlotErrorMessage(String.format(PLOT_INCORRECT_AREA_TYPE, issuerPlotId));
                        edaplosDomainDto.addPlot(edaplosPlotDto);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)plotName) || includedAgriculturalArea == null || StringUtils.isBlank((CharSequence)includedAgriculturalArea.elementText("ActualMeasure"))) {
                        plotName = StringUtils.isBlank((CharSequence)plotName) ? "NOM INCONNU" : plotName;
                        edaplosPlotDto.setPlotName(plotName);
                        String area = includedAgriculturalArea == null || StringUtils.isBlank((CharSequence)includedAgriculturalArea.elementText("ActualMeasure")) ? "SURFACE INCONNUE" : includedAgriculturalArea.elementText("ActualMeasure");
                        edaplosPlotDto.setArea(area);
                        edaplosPlotDto.addPlotErrorMessage(String.format(PLOT_NO_INDENTIFICATION, issuerPlotId, plotName, area));
                        edaplosDomainDto.addPlot(edaplosPlotDto);
                        continue;
                    }
                    double plotArea = Double.valueOf(includedAgriculturalArea.elementText("ActualMeasure"));
                    List plots = this.plotTopiaDao.forProperties("domain", domain, new Object[]{"name", plotName, "area", plotArea}).findAll();
                    if (plots.size() > 1) {
                        edaplosPlotDto.setStatus("MANY");
                        edaplosPlotDto.addPlotErrorMessage(String.format(TO_MANY_PLOTS_FOUND, plotName, plotArea, domain.getName()));
                        edaplosDomainDto.addPlot(edaplosPlotDto);
                        continue;
                    }
                    if (plots.size() == 1) {
                        plot = (Plot)plots.get(0);
                        edaplosPlotDto.setIssuerId(issuerPlotId);
                    }
                }
            }
            if (plot == null) {
                edaplosPlotDto.setIssuerId(issuerPlotId);
                edaplosPlotDto.setStatus("CREATE");
                edaplosPlotDto.addPlotInfoMessage(PLOT_CREATED);
            } else {
                List effectivePerennialCropCycleDtos;
                log.warn((Object)"Parcelle trouv\u00e9e !");
                zone = (Zone)this.zoneTopiaDao.forPlotEquals(plot).findUnique();
                edaplosPlotDto.setTopiaId(plot.getTopiaId());
                edaplosPlotDto.setStatus("OK");
                List effectiveSeasonalCropCycleDtos = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(zone.getTopiaId());
                if (effectiveSeasonalCropCycleDtos != null && !effectiveSeasonalCropCycleDtos.isEmpty()) {
                    edaplosPlotDto.setSeasonalCycleDto((EffectiveSeasonalCropCycleDto)effectiveSeasonalCropCycleDtos.get(0));
                }
                if ((effectivePerennialCropCycleDtos = this.effectiveCropCycleService.getAllEffectivePerennialCropCyclesDtos(zone.getTopiaId())) != null && !effectivePerennialCropCycleDtos.isEmpty()) {
                    edaplosPlotDto.setPerennialCycleDtos(effectivePerennialCropCycleDtos);
                }
            }
            List soilOccupationElements = plotElement.elements("AppliedPlotSoilOccupation");
            if (soilOccupationElements == null || soilOccupationElements.isEmpty()) {
                edaplosPlotDto.addPlotInfoMessage(String.format(INFO_PLOT_EMPTY, issuerPlotId));
            } else {
                this.processPlotSoilOccupation(edaplosPlotDto, soilOccupationElements, zone, edaplosDomainDto);
            }
            edaplosDomainDto.addPlot(edaplosPlotDto);
        }
    }

    protected void processPlotSoilOccupation(EdaplosPlotDto edaplosPlotDto, List<Element> soilOccupationList, Zone zone, EdaplosDomainDto eDomainDto) {
        for (Element soilOccupationElement : soilOccupationList) {
            String soilOccupationSequence;
            String soilOccupationIssuerId = soilOccupationElement.elementText("Identification");
            if (StringUtils.isBlank((CharSequence)soilOccupationIssuerId)) {
                edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_NO_ISSUERID, edaplosPlotDto.getIssuerId()));
                continue;
            }
            String soilOccupationType = soilOccupationElement.elementText("TypeCode");
            if (StringUtils.isBlank((CharSequence)soilOccupationType)) {
                edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_NO_TYPE, soilOccupationIssuerId, edaplosPlotDto.getIssuerId()));
                continue;
            }
            CroppingPlanEntryDto croppingPlanEntryDto = new CroppingPlanEntryDto();
            if (soilOccupationType.equals("ABA00")) {
                croppingPlanEntryDto.setType(CroppingEntryType.MAIN);
            } else if (soilOccupationType.equals("ABA09")) {
                croppingPlanEntryDto.setType(CroppingEntryType.CATCH);
            } else if (soilOccupationType.equals("ABA03") || soilOccupationType.equals("ABA04")) {
                croppingPlanEntryDto.setType(CroppingEntryType.INTERMEDIATE);
            } else {
                edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_WRONG_TYPE, soilOccupationIssuerId, edaplosPlotDto.getIssuerId(), soilOccupationType));
                continue;
            }
            List speciesOnSoilOccupation = soilOccupationElement.elements("SownAgriculturalCrop");
            if (speciesOnSoilOccupation == null || speciesOnSoilOccupation.isEmpty()) {
                edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_NO_SPECIES, soilOccupationIssuerId));
                continue;
            }
            this.addSpeciesToCroppingPlanEntry(speciesOnSoilOccupation, edaplosPlotDto, croppingPlanEntryDto, soilOccupationIssuerId);
            if (croppingPlanEntryDto.getSpecies() == null || croppingPlanEntryDto.getSpecies().isEmpty()) {
                edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_NO_VALID_SPECIES, soilOccupationIssuerId));
                continue;
            }
            CroppingPlanSpeciesDto speciesToGetCycle = (CroppingPlanSpeciesDto)croppingPlanEntryDto.getSpecies().iterator().next();
            TypeCulture soilOccType = this.getCycleTypeFromSpecies(speciesToGetCycle);
            if (soilOccType == null) continue;
            if (CollectionUtils.isNotEmpty((Collection)eDomainDto.getCroppingPlanEntryDtos())) {
                this.getRightCroppingPlanEntry(croppingPlanEntryDto, eDomainDto.getCroppingPlanEntryDtos());
            }
            if (croppingPlanEntryDto.getTopiaId() == null) {
                croppingPlanEntryDto.setTopiaId("new-entry-" + UUID.randomUUID().toString());
                String agrosystCode = UUID.randomUUID().toString();
                croppingPlanEntryDto.setCode(agrosystCode);
                eDomainDto.addCroppingPlanEntryDto(croppingPlanEntryDto);
            }
            if (!StringUtils.isNumericSpace((CharSequence)(soilOccupationSequence = soilOccupationElement.elementText("SequenceNumeric")))) {
                edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_WRONG_RANK_FORMAT, soilOccupationIssuerId));
                continue;
            }
            int soilOccupationRank = 1;
            if (!StringUtils.isBlank((CharSequence)soilOccupationSequence)) {
                soilOccupationRank = Integer.parseInt(soilOccupationSequence) - 1;
            }
            if (soilOccupationRank < 0) {
                edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_RANK_BELOW_ZERO, soilOccupationIssuerId, edaplosPlotDto.getIssuerId()));
                continue;
            }
            List prodCycles = soilOccupationElement.elements("SpecifiedAgriculturalCropProductionCycle");
            if (soilOccType.equals((Object)TypeCulture.PERENNE) || soilOccType.equals((Object)TypeCulture.PLURI_ANNUELLE)) {
                if (!croppingPlanEntryDto.getType().equals((Object)CroppingEntryType.MAIN)) {
                    edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_WRONG_CROPPING_TYPE, soilOccupationIssuerId, edaplosPlotDto.getIssuerId(), croppingPlanEntryDto.getName()));
                    continue;
                }
                List effPerennialCycleDtos = edaplosPlotDto.getPerennialCycleDtos();
                EffectivePerennialCropCycleDto perennialCycleDto = null;
                for (EffectivePerennialCropCycleDto existingPerennialCycleDto : effPerennialCycleDtos) {
                    if (existingPerennialCycleDto.getEdaplosIssuerId() != null && existingPerennialCycleDto.getEdaplosIssuerId().equals(soilOccupationIssuerId)) {
                        perennialCycleDto = existingPerennialCycleDto;
                        break;
                    }
                    if (!existingPerennialCycleDto.getCroppingPlanEntryId().equals(croppingPlanEntryDto.getTopiaId())) continue;
                    perennialCycleDto = existingPerennialCycleDto;
                    perennialCycleDto.setEdaplosIssuerId(soilOccupationIssuerId);
                    break;
                }
                if (perennialCycleDto != null) continue;
                perennialCycleDto = new EffectivePerennialCropCycleDto();
                perennialCycleDto.setCroppingPlanEntryId(croppingPlanEntryDto.getTopiaId());
                ArrayList<EffectiveCropCyclePhaseDto> phaseDtos = new ArrayList<EffectiveCropCyclePhaseDto>();
                EffectiveCropCyclePhaseDto phaseDto = new EffectiveCropCyclePhaseDto();
                phaseDto.setType(CropCyclePhaseType.PLEINE_PRODUCTION);
                phaseDto.setInterventions(new ArrayList());
                phaseDtos.add(phaseDto);
                perennialCycleDto.setPhaseDtos(phaseDtos);
                perennialCycleDto.setWeedType(WeedType.PARTIEL);
                perennialCycleDto.setEdaplosIssuerId(soilOccupationIssuerId);
                effPerennialCycleDtos.add(perennialCycleDto);
                continue;
            }
            EffectiveSeasonalCropCycleDto effSeasonalCropCycleDto = edaplosPlotDto.getSeasonalCycleDto();
            if (effSeasonalCropCycleDto == null) {
                effSeasonalCropCycleDto = new EffectiveSeasonalCropCycleDto();
                edaplosPlotDto.setSeasonalCycleDto(effSeasonalCropCycleDto);
            }
            if (croppingPlanEntryDto.getType().equals((Object)CroppingEntryType.CATCH) || croppingPlanEntryDto.getType().equals((Object)CroppingEntryType.MAIN)) {
                if (CollectionUtils.isEmpty((Collection)edaplosPlotDto.getSeasonalCycleDto().getNodeDtos()) && !CollectionUtils.isEmpty((Collection)edaplosPlotDto.getSeasonalCycleDto().getConnectionDtos())) {
                    edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_CONNECTION_WITHOUT_NODE, soilOccupationIssuerId, soilOccupationRank));
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)edaplosPlotDto.getSeasonalCycleDto().getNodeDtos()) && soilOccupationRank > 0) {
                    edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_RANK_MUST_BE_ZERO, soilOccupationIssuerId, soilOccupationRank));
                    continue;
                }
                ArrayList<EffectiveCropCycleNodeDto> effNodeDtos = effSeasonalCropCycleDto.getNodeDtos();
                if (effNodeDtos == null) {
                    effNodeDtos = new ArrayList<EffectiveCropCycleNodeDto>();
                    effSeasonalCropCycleDto.setNodeDtos(effNodeDtos);
                }
                EffectiveCropCycleNodeDto effNodeDto = null;
                Iterator i = effNodeDtos.iterator();
                while (effNodeDto == null && i.hasNext()) {
                    EffectiveCropCycleNodeDto eNodeDto = (EffectiveCropCycleNodeDto)i.next();
                    if (!eNodeDto.getEdaplosIssuerId().equals(soilOccupationIssuerId) && eNodeDto.getX() != soilOccupationRank || (effNodeDto = eNodeDto).getEdaplosIssuerId() != null && !effNodeDto.getEdaplosIssuerId().isEmpty()) continue;
                    effNodeDto.setEdaplosIssuerId(soilOccupationIssuerId);
                }
                if (effNodeDto == null) {
                    effNodeDto = this.createNodeDto(soilOccupationIssuerId, croppingPlanEntryDto.getTopiaId(), soilOccupationRank);
                    effNodeDtos.add(effNodeDto);
                }
                if (effSeasonalCropCycleDto.getConnectionDtos() != null) continue;
                ArrayList connectionDtos = new ArrayList();
                effSeasonalCropCycleDto.setConnectionDtos(connectionDtos);
                continue;
            }
            if (!croppingPlanEntryDto.getType().equals((Object)CroppingEntryType.INTERMEDIATE)) continue;
            if (CollectionUtils.isEmpty((Collection)edaplosPlotDto.getSeasonalCycleDto().getNodeDtos())) {
                edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_NO_NODE, soilOccupationIssuerId, soilOccupationRank));
                continue;
            }
            ArrayList<EffectiveCropCycleConnectionDto> connectionDtos = effSeasonalCropCycleDto.getConnectionDtos();
            if (connectionDtos == null) {
                connectionDtos = new ArrayList<EffectiveCropCycleConnectionDto>();
                effSeasonalCropCycleDto.setConnectionDtos(connectionDtos);
            }
            EffectiveCropCycleConnectionDto connDto = null;
            block3: for (EffectiveCropCycleConnectionDto connectionDto : connectionDtos) {
                if (connectionDto.getEdaplosIssuerId() != null && connectionDto.getEdaplosIssuerId().equals(soilOccupationIssuerId)) {
                    connDto = connectionDto;
                    break;
                }
                for (EffectiveCropCycleNodeDto eNode : effSeasonalCropCycleDto.getNodeDtos()) {
                    if (!connectionDto.getTargetId().equals(eNode.getNodeId()) || eNode.getX() != soilOccupationRank) continue;
                    connDto = connectionDto;
                    connDto.setEdaplosIssuerId(soilOccupationIssuerId);
                    continue block3;
                }
            }
            if (connDto == null) {
                String connectionTarget = null;
                String connectionSource = null;
                for (EffectiveCropCycleNodeDto eNode : effSeasonalCropCycleDto.getNodeDtos()) {
                    if (eNode.getX() == soilOccupationRank) {
                        connectionTarget = eNode.getNodeId();
                    }
                    if (soilOccupationRank > 0 && eNode.getX() == soilOccupationRank - 1) {
                        connectionSource = eNode.getNodeId();
                    }
                    if (connectionTarget == null || connectionSource == null) continue;
                    break;
                }
                if (connectionTarget == null) {
                    edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_NO_TARGET, soilOccupationIssuerId, edaplosPlotDto.getIssuerId(), croppingPlanEntryDto.getName()));
                    continue;
                }
                if (soilOccupationRank > 0 && connectionSource == null) {
                    edaplosPlotDto.addSoilOccErrorMessage(String.format(ERROR_SOIL_OCCUPATION_NO_SOURCE, soilOccupationIssuerId, edaplosPlotDto.getIssuerId(), croppingPlanEntryDto.getName()));
                    continue;
                }
                connDto = this.createConnectionDto(soilOccupationIssuerId, connectionSource, connectionTarget, croppingPlanEntryDto.getTopiaId());
                connectionDtos.add(connDto);
            }
            if (soilOccupationRank != 0 || connDto.getSourceId() != null) continue;
            connDto.setSourceId("NODE_BEFORE");
        }
    }

    protected void getRightCroppingPlanEntry(CroppingPlanEntryDto entryDto, List<CroppingPlanEntryDto> entryDtoList) {
        for (CroppingPlanEntryDto persistedCroppingPlanEntry : entryDtoList) {
            ArrayList persistedCroppingPlanSpecies = Lists.newArrayList((Iterable)persistedCroppingPlanEntry.getSpecies());
            ArrayList eSpecies = Lists.newArrayList((Iterable)entryDto.getSpecies());
            HashMap persistedSpeciesWithoutDuplicate = Maps.newHashMap();
            for (CroppingPlanSpeciesDto persistedSpecies : persistedCroppingPlanSpecies) {
                String eKey = persistedSpecies.getSpeciesEspece() + persistedSpecies.getSpeciesQualifiant() + persistedSpecies.getSpeciesTypeSaisonnier() + persistedSpecies.getVarietyId() + persistedCroppingPlanEntry.getType();
                persistedSpeciesWithoutDuplicate.put(eKey, persistedSpecies);
            }
            HashMap eSpeciesWithoutDuplicate = Maps.newHashMap();
            for (CroppingPlanSpeciesDto eSoilOccupationSpecies : eSpecies) {
                String eKey = eSoilOccupationSpecies.getSpeciesEspece() + eSoilOccupationSpecies.getSpeciesQualifiant() + eSoilOccupationSpecies.getSpeciesTypeSaisonnier() + eSoilOccupationSpecies.getVarietyId() + entryDto.getType();
                eSpeciesWithoutDuplicate.put(eKey, eSoilOccupationSpecies);
            }
            if (persistedSpeciesWithoutDuplicate.size() != eSpeciesWithoutDuplicate.size()) continue;
            ArrayList equalSpecies = new ArrayList();
            for (Map.Entry persistedSpeciesElement : persistedSpeciesWithoutDuplicate.entrySet()) {
                for (Map.Entry eSoilOccupationSpeciesElement : eSpeciesWithoutDuplicate.entrySet()) {
                    if (!((String)persistedSpeciesElement.getKey()).equals(eSoilOccupationSpeciesElement.getKey())) continue;
                    equalSpecies.add(persistedSpeciesElement.getValue());
                }
            }
            if (eSpeciesWithoutDuplicate.size() != equalSpecies.size() || entryDto.getTopiaId() != null) continue;
            entryDto.setTopiaId(persistedCroppingPlanEntry.getTopiaId());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void addSpeciesToCroppingPlanEntry(List<Element> speciesXmlList, EdaplosPlotDto ePlotDto, CroppingPlanEntryDto eEntry, String eIssuerId) {
        ArrayList<CroppingPlanSpeciesDto> eSpeciesSet = new ArrayList<CroppingPlanSpeciesDto>();
        Iterator<Element> i$ = speciesXmlList.iterator();
        while (true) {
            String varietyCode;
            String varietyName;
            RefEspece refEspece;
            block15: {
                if (!i$.hasNext()) {
                    eEntry.setSpecies(eSpeciesSet);
                    return;
                }
                Element speciesElement = i$.next();
                String speciesBotanicalCode = speciesElement.elementText("BotanicalSpeciesCode");
                String speciesSupplementaryBotanicalCode = speciesElement.elementText("SupplementaryBotanicalSpeciesCode");
                String speciesSowingPeriodCode = speciesElement.elementText("SowingPeriodCode");
                if (StringUtils.isBlank((CharSequence)speciesBotanicalCode)) {
                    ePlotDto.addSoilOccErrorMessage(String.format(ERROR_SPECIES_BOTANICALCODE_MISSING, eIssuerId));
                    continue;
                }
                if (speciesSupplementaryBotanicalCode == null) {
                    speciesSupplementaryBotanicalCode = "";
                }
                if (speciesSowingPeriodCode == null) {
                    speciesSowingPeriodCode = "";
                }
                if ((refEspece = (RefEspece)this.refEspeceTopiaDao.forProperties("code_espece_botanique", speciesBotanicalCode, new Object[]{"code_qualifiant_AEE", speciesSupplementaryBotanicalCode, "code_type_saisonnier_AEE", speciesSowingPeriodCode}).findAnyOrNull()) == null) {
                    ePlotDto.addSoilOccErrorMessage(String.format(ERROR_NO_EXISTING_SPECIES, eIssuerId, speciesBotanicalCode, speciesSupplementaryBotanicalCode, speciesSowingPeriodCode));
                    continue;
                }
                List varieties = speciesElement.elements("SownCropSpeciesVariety");
                varietyName = null;
                varietyCode = null;
                if (varieties != null && !varieties.isEmpty()) {
                    if (varieties.size() > 1) {
                        Element variety = (Element)varieties.get(0);
                        varietyName = variety.elementText("Description");
                        if (StringUtils.isBlank((CharSequence)varietyName)) {
                            ePlotDto.addSoilOccErrorMessage(String.format(ERROR_VARIETY_NAME_MISSING, eIssuerId, speciesBotanicalCode, speciesSupplementaryBotanicalCode, speciesSowingPeriodCode));
                            continue;
                        }
                        varietyCode = variety.elementText("Type");
                        if (StringUtils.isNotBlank((CharSequence)varietyCode)) {
                            if (!StringUtils.isNumeric((CharSequence)varietyCode)) {
                                ePlotDto.addSoilOccErrorMessage(String.format(ERROR_GEVESCODE_NOT_A_NUMBER, eIssuerId, varietyCode));
                                continue;
                            }
                            Integer varietyCodeNum = Integer.parseInt(varietyCode);
                            RefVarieteGeves refVarieteGeves = (RefVarieteGeves)this.refVarieteGevesTopiaDao.forNum_DossierEquals(varietyCodeNum).findUniqueOrNull();
                            if (refVarieteGeves == null) {
                                ePlotDto.addSoilOccErrorMessage(String.format(ERROR_GEVESCODE_MISSING, eIssuerId, varietyCode));
                                continue;
                            }
                            break block15;
                        } else {
                            ePlotDto.addSoilOccErrorMessage(String.format(ERROR_VARIETY_MISSING, eIssuerId, varietyName));
                            continue;
                        }
                    }
                    ePlotDto.addSoilOccErrorMessage(String.format(ERROR_MORE_THAN_ONE_VARIETY, eIssuerId, speciesBotanicalCode, speciesSupplementaryBotanicalCode, speciesSowingPeriodCode));
                    continue;
                }
            }
            CroppingPlanSpeciesDto croppingPlanSpeciesDto = new CroppingPlanSpeciesDto();
            croppingPlanSpeciesDto.setSpeciesId(refEspece.getTopiaId());
            croppingPlanSpeciesDto.setSpeciesEspece(refEspece.getLibelle_espece_botanique());
            croppingPlanSpeciesDto.setSpeciesQualifiant(refEspece.getLibelle_qualifiant_AEE());
            croppingPlanSpeciesDto.setSpeciesTypeSaisonnier(refEspece.getLibelle_type_saisonnier_AEE());
            if (eEntry.getName() == null || eEntry.getName().isEmpty()) {
                String speciesBotanicalLabel = refEspece.getLibelle_espece_botanique();
                String speciesSupplementaryBotanicalLabel = refEspece.getLibelle_qualifiant_AEE().isEmpty() ? "" : ", " + refEspece.getLibelle_qualifiant_AEE();
                String speciesSowingPeriodLabel = refEspece.getLibelle_type_saisonnier_AEE().isEmpty() ? "" : ", " + refEspece.getLibelle_type_saisonnier_AEE();
                eEntry.setName(speciesBotanicalLabel + speciesSupplementaryBotanicalLabel + speciesSowingPeriodLabel);
            }
            if (varietyCode != null) {
                croppingPlanSpeciesDto.setVarietyId(varietyCode);
                croppingPlanSpeciesDto.setVarietyLibelle(varietyName);
            }
            eSpeciesSet.add(croppingPlanSpeciesDto);
        }
    }

    protected TypeCulture getCycleTypeFromSpecies(CroppingPlanSpeciesDto eSpecies) {
        RefEspece refEspece = (RefEspece)this.refEspeceTopiaDao.forTopiaIdEquals(eSpecies.getSpeciesId()).findUnique();
        RefCultureEdiGroupeCouvSol refCultureEdiGroupeCouvSol = (RefCultureEdiGroupeCouvSol)this.refCultureEdiGroupeCouvSolTopiaDao.forProperties("code_espece_botanique", refEspece.getCode_espece_botanique(), new Object[]{"code_qualifiant_aee", refEspece.getCode_qualifiant_AEE(), "code_type_saisonnier_aee", refEspece.getCode_type_saisonnier_AEE()}).findAnyOrNull();
        if (refCultureEdiGroupeCouvSol == null) {
            return null;
        }
        return refCultureEdiGroupeCouvSol.getTypeCulture();
    }

    protected boolean isPlotExisting(EdaplosPlotDto plot) {
        return plot.getTopiaId() != null && !plot.getTopiaId().isEmpty();
    }

    protected EffectiveCropCycleNodeDto createNodeDto(String soilOccupationIssuerId, String croppingPlanEntryTopiaId, int rank) {
        EffectiveCropCycleNodeDto nodeDto = new EffectiveCropCycleNodeDto();
        nodeDto.setEdaplosIssuerId(soilOccupationIssuerId);
        nodeDto.setCroppingPlanEntryId(croppingPlanEntryTopiaId);
        nodeDto.setNodeId("new-node-" + UUID.randomUUID().toString());
        nodeDto.setInterventions(new ArrayList());
        nodeDto.setX(rank);
        return nodeDto;
    }

    protected EffectiveCropCycleConnectionDto createConnectionDto(String issuerID, String sourceId, String targetId, String croppingPlanEntryId) {
        EffectiveCropCycleConnectionDto connectionDto = new EffectiveCropCycleConnectionDto();
        connectionDto.setEdaplosIssuerId(issuerID);
        connectionDto.setSourceId(sourceId);
        connectionDto.setTargetId(targetId);
        connectionDto.setIntermediateCroppingPlanEntryId(croppingPlanEntryId);
        return connectionDto;
    }
}

