/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.domain.export;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatusTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import fr.inra.agrosyst.api.entities.referential.RefOTEXTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalisTopiaDao;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.common.export.UniqueDualLinkedHashMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;

public class DomainExportMetadata {

    public static class DomainStatusBeanInfo
    extends DomainCommonBeanInfo {
        protected RefOTEXTopiaDao refOTEXTopiaDao;

        public void setRefOTEXTopiaDao(RefOTEXTopiaDao refOTEXTopiaDao) {
            this.refOTEXTopiaDao = refOTEXTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Statut et Main d'Oeuvre";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"statusComment", (Object)"Commentaires du statut");
            columns.put((Object)"partnersNumber", (Object)"Nombre d'associ\u00e9");
            columns.put((Object)"otherWorkForce", (Object)"Main d'oeuvre familiale ou main d'oeuvre des associ\u00e9s");
            columns.put((Object)"familyWorkForceWage", (Object)"R\u00e9mun\u00e9ration de la main d'oeuvre Familiale");
            columns.put((Object)"permanentEmployeesWorkForce", (Object)"Main d'oeuvre salari\u00e9s permanents");
            columns.put((Object)"temporaryEmployeesWorkForce", (Object)"Main d'oeuvre salari\u00e9s temporaires");
            columns.put((Object)"cropsWorkForce", (Object)"Main d'oeuvre totale affect\u00e9e \u00e0 la conduite des cultures");
            columns.put((Object)"wageCosts", (Object)"Charges salariales");
            columns.put((Object)"workforceComment", (Object)"Commentaire sur la main d'oeuvre");
            columns.put((Object)"orientation", (Object)"Description de l'orientation");
            columns.put((Object)"otex18", (Object)"Orientation technico-\u00e9conomique de l'exploitation agricole OTEX");
            columns.put((Object)"otex70", (Object)"Pr\u00e9cision OTEX");
            columns.put((Object)"usedAgriculturalArea", (Object)"SAU totale");
            columns.put((Object)"experimentalAgriculturalArea", (Object)"SAU mobilis\u00e9e pour l'exp\u00e9rimentation");
            columns.put((Object)"homogenizationExperimentalAgriculturalArea", (Object)"SAU mobilis\u00e9e pour l'exp\u00e9rimentation dont SAU en homog\u00e9n\u00e9isation");
            columns.put((Object)"msaFee", (Object)"Cotisations MSA");
            columns.put((Object)"averageTenantFarming", (Object)"Fermage moyen");
            columns.put((Object)"decoupledAssistance", (Object)"Aides d\u00e9coupl\u00e9es");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            Function getOtex18 = ExportUtils.ifNotNull("otex18", new Function<RefOTEX, Object>(){

                public Object apply(RefOTEX input) {
                    return input.getLibelle_OTEX_18_postes();
                }
            });
            result.put("otex18", getOtex18);
            Function getOtex70 = ExportUtils.ifNotNull("otex70", new Function<RefOTEX, Object>(){

                public Object apply(RefOTEX input) {
                    return input.getLibelle_OTEX_70_postes();
                }
            });
            result.put("otex70", getOtex70);
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            result.put("otex18", this.refOTEXTopiaDao.findPropertyDistinctValues("libelle_OTEX_18_postes"));
            result.put("otex70", this.refOTEXTopiaDao.findPropertyDistinctValues("libelle_OTEX_70_postes"));
            return result;
        }
    }

    public static class DomainSolBeanInfo
    extends DomainCommonBeanInfo {
        protected RefSolArvalisTopiaDao refSolArvalisTopiaDao;

        public void setRefSolArvalisTopiaDao(RefSolArvalisTopiaDao refSolArvalisTopiaDao) {
            this.refSolArvalisTopiaDao = refSolArvalisTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Sols";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"region", (Object)"Region");
            columns.put((Object)"solArvalis", (Object)"Type de sol Arvalis");
            columns.put((Object)"name", (Object)"Nom local");
            columns.put((Object)"importance", (Object)"Importance relative du type de sol sur le domaine");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            Function getSolRegion = ExportUtils.ifNotNull("refSolArvalis", new Function<RefSolArvalis, Object>(){

                public Object apply(RefSolArvalis input) {
                    return input.getSol_region();
                }
            });
            result.put("region", getSolRegion);
            Function getSolNom = ExportUtils.ifNotNull("refSolArvalis", new Function<RefSolArvalis, Object>(){

                public Object apply(RefSolArvalis input) {
                    return input.getSol_nom();
                }
            });
            result.put("solArvalis", getSolNom);
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            result.put("region", this.refSolArvalisTopiaDao.findPropertyDistinctValues("sol_region"));
            result.put("solArvalis", this.refSolArvalisTopiaDao.findPropertyDistinctValues("sol_nom"));
            return result;
        }
    }

    public static class DomainToolsCouplingBeanInfo
    extends DomainCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Combinaison d'outils";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"toolsCouplingName", (Object)"Nom");
            columns.put((Object)"workforce", (Object)"Nombre de personnes mobilis\u00e9es");
            columns.put((Object)"comment", (Object)"Commentaire");
            columns.put((Object)"agrosystInterventionTypes", (Object)"Type d'action");
            columns.put((Object)"mainsActions", (Object)"Actions principales");
            columns.put((Object)"tractor", (Object)"Mat\u00e9riel de Traction ou Automoteur");
            columns.put((Object)"equipments", (Object)"Outils ou mat\u00e9riel d'irrigation");
            return columns;
        }
    }

    public static class DomainMaterielBeanInfo
    extends DomainCommonBeanInfo {
        protected RefMaterielTopiaDao refMaterielTopiaDao;

        public void setRefMaterielTopiaDao(RefMaterielTopiaDao refMaterielTopiaDao) {
            this.refMaterielTopiaDao = refMaterielTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Materiels";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"typeMateriel1", (Object)"Mat\u00e9riel type 1");
            columns.put((Object)"typeMateriel2", (Object)"Mat\u00e9riel type 2");
            columns.put((Object)"typeMateriel3", (Object)"Mat\u00e9riel type 3");
            columns.put((Object)"typeMateriel4", (Object)"Mat\u00e9riel type 4");
            columns.put((Object)"unite", (Object)"Unit\u00e9");
            columns.put((Object)"uniteParAn", (Object)"Unit\u00e9 par an");
            columns.put((Object)"name", (Object)"Nom");
            columns.put((Object)"description", (Object)"Description");
            columns.put((Object)"materielETA", (Object)"Materiel ETA / CUMA");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            Function getter = ExportUtils.ifNotNull("refMateriel", new Function<RefMateriel, Object>(){

                public Object apply(RefMateriel input) {
                    return input.getTypeMateriel1();
                }
            });
            result.put("typeMateriel1", getter);
            getter = ExportUtils.ifNotNull("refMateriel", new Function<RefMateriel, Object>(){

                public Object apply(RefMateriel input) {
                    return input.getTypeMateriel2();
                }
            });
            result.put("typeMateriel2", getter);
            getter = ExportUtils.ifNotNull("refMateriel", new Function<RefMateriel, Object>(){

                public Object apply(RefMateriel input) {
                    return input.getTypeMateriel3();
                }
            });
            result.put("typeMateriel3", getter);
            getter = ExportUtils.ifNotNull("refMateriel", new Function<RefMateriel, Object>(){

                public Object apply(RefMateriel input) {
                    return input.getTypeMateriel4();
                }
            });
            result.put("typeMateriel4", getter);
            getter = ExportUtils.ifNotNull("refMateriel", new Function<RefMateriel, Object>(){

                public Object apply(RefMateriel input) {
                    return input.getUnite();
                }
            });
            result.put("unite", getter);
            getter = ExportUtils.ifNotNull("refMateriel", new Function<RefMateriel, Object>(){

                public Object apply(RefMateriel input) {
                    return input.getUniteParAn();
                }
            });
            result.put("uniteParAn", getter);
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            result.put("typeMateriel1", this.refMaterielTopiaDao.findPropertyDistinctValues("typeMateriel1"));
            result.put("typeMateriel2", this.refMaterielTopiaDao.findPropertyDistinctValues("typeMateriel2"));
            result.put("typeMateriel3", this.refMaterielTopiaDao.findPropertyDistinctValues("typeMateriel3"));
            result.put("typeMateriel4", this.refMaterielTopiaDao.findPropertyDistinctValues("typeMateriel4"));
            result.put("unite", this.refMaterielTopiaDao.findPropertyDistinctValues("unite"));
            return result;
        }
    }

    public static class DomainGpsDataBeanInfo
    extends DomainCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Donn\u00e9es GPS";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"name", (Object)"Nom du centre");
            columns.put((Object)"latitude", (Object)"Latitude");
            columns.put((Object)"longitude", (Object)"Longitude");
            columns.put((Object)"description", (Object)"Description");
            return columns;
        }
    }

    public static class DomainCroppingPlanEntryBeanInfo
    extends DomainCommonBeanInfo {
        protected RefEspeceTopiaDao refEspeceTopiaDao;

        public void setRefEspeceTopiaDao(RefEspeceTopiaDao refEspeceTopiaDao) {
            this.refEspeceTopiaDao = refEspeceTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Assolements";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"name", (Object)"Culture");
            columns.put((Object)"sellingPrice", (Object)"Prix de vente (\u20ac)");
            columns.put((Object)"type", (Object)"Type");
            columns.put((Object)"libelle_espece_botanique", (Object)"Esp\u00e8ce");
            columns.put((Object)"libelle_qualifiant_AEE", (Object)"Qualifiant");
            columns.put((Object)"libelle_type_saisonnier_AEE", (Object)"Type saisonnier");
            columns.put((Object)"libelle_destination_AEE", (Object)"Destination");
            columns.put((Object)"label", (Object)"C\u00e9page/Vari\u00e9t\u00e9");
            return columns;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("type", ExportUtils.allStringOf(CroppingEntryType.class));
            result.put("libelle_espece_botanique", this.refEspeceTopiaDao.findPropertyDistinctValues("libelle_espece_botanique"));
            result.put("libelle_qualifiant_AEE", this.refEspeceTopiaDao.findPropertyDistinctValues("libelle_qualifiant_AEE"));
            result.put("libelle_type_saisonnier_AEE", this.refEspeceTopiaDao.findPropertyDistinctValues("libelle_type_saisonnier_AEE"));
            result.put("libelle_destination_AEE", this.refEspeceTopiaDao.findPropertyDistinctValues("libelle_destination_AEE"));
            return result;
        }
    }

    public static class DomainMainBeanInfo
    extends DomainCommonBeanInfo {
        protected RefLegalStatusTopiaDao refLegalStatusTopiaDao;

        public void setRefLegalStatusTopiaDao(RefLegalStatusTopiaDao refLegalStatusTopiaDao) {
            this.refLegalStatusTopiaDao = refLegalStatusTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "G\u00e9n\u00e9ralit\u00e9s";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"description", (Object)"Description");
            columns.put((Object)"legalStatus", (Object)"Statut juridique ou institutionnel");
            columns.put((Object)"petiteRegionAgricole", (Object)"Petite r\u00e9gion agricole");
            columns.put((Object)"zoning", (Object)"Zonage du domaine");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("petiteRegionAgricole", new Function<K, Object>(){

                public Object apply(K input) {
                    Preconditions.checkArgument((boolean)(input instanceof Domain));
                    Domain domain = (Domain)input;
                    return domain.getLocation().getPetiteRegionAgricoleNom();
                }
            });
            Function getLegalStatus = ExportUtils.ifNotNull("legalStatus", new Function<RefLegalStatus, Object>(){

                public Object apply(RefLegalStatus input) {
                    return input.getLibelle_INSEE();
                }
            });
            result.put("legalStatus", getLegalStatus);
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("legalStatus", this.refLegalStatusTopiaDao.findPropertyDistinctValues("libelle_INSEE"));
            result.put("zoning", ExportUtils.allStringOf(Zoning.class));
            return result;
        }
    }

    public static abstract class DomainCommonBeanInfo
    implements EntityExportTabInfo {
        @Override
        public BidiMap<String, String> getCommonColumns() {
            UniqueDualLinkedHashMap result = new UniqueDualLinkedHashMap();
            result.put("domainType", "Type de domaine");
            result.put("departement", "D\u00e9partement");
            result.put("postalCode", "Code Postal");
            result.put("domainName", "Nom du domaine");
            result.put("campaign", "Campagne");
            result.put("mainContact", "Nom de l'interlocuteur principal");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            UniqueDualLinkedHashMap result = new UniqueDualLinkedHashMap();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            LinkedHashMap result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            HashMap result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            result.put("domainType", ExportUtils.allStringOf(DomainType.class));
            return result;
        }
    }
}

