/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.domain;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesImpl;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.EquipmentTopiaDao;
import fr.inra.agrosyst.api.entities.GeoPoint;
import fr.inra.agrosyst.api.entities.GeoPointTopiaDao;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.GroundTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.WeatherStation;
import fr.inra.agrosyst.api.entities.WeatherStationTopiaDao;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatusTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import fr.inra.agrosyst.api.entities.referential.RefOTEXTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalisTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.entities.referential.RefVarieteTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.common.UsageList;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.DomainExtendException;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.ExtendContext;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.common.EntityUsageService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.EntityImporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.domain.export.DomainExportEntity;
import fr.inra.agrosyst.services.domain.export.DomainExportMetadata;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class DomainServiceImpl
extends AbstractAgrosystService
implements DomainService {
    private static final Log log = LogFactory.getLog(DomainServiceImpl.class);
    public static final int BUFFER_SIZE = 1024;
    protected static final Predicate<CroppingPlanSpeciesDto> IS_CROPPING_SPECIES_EMPTY = new Predicate<CroppingPlanSpeciesDto>(){

        public boolean apply(CroppingPlanSpeciesDto input) {
            String speciesId = input.getSpeciesId();
            boolean result = Strings.isNullOrEmpty((String)speciesId);
            return result;
        }
    };
    protected static final Function<CroppingPlanSpeciesDto, String> GET_SPECIES_TOPIA_ID = new Function<CroppingPlanSpeciesDto, String>(){

        public String apply(CroppingPlanSpeciesDto input) {
            return Strings.nullToEmpty((String)input.getTopiaId());
        }
    };
    protected static final Predicate<? super CroppingPlanEntryDto> IS_CROPPING_PLAN_ENTRY_EMPTY = new Predicate<CroppingPlanEntryDto>(){

        public boolean apply(CroppingPlanEntryDto input) {
            boolean result = true;
            if (input != null) {
                result = Strings.isNullOrEmpty((String)input.getName()) && input.getSellingPrice() == 0.0 && (input.getSpecies() == null || input.getSpecies().isEmpty());
            }
            return result;
        }
    };
    public static final Function<CroppingPlanEntry, String> GET_CROPPING_PLAN_ENTRY_CODE = new Function<CroppingPlanEntry, String>(){

        public String apply(CroppingPlanEntry input) {
            String result = input.getCode();
            return result;
        }
    };
    protected static final Function<CroppingPlanSpecies, String> GET_SPECIES_CODE = new Function<CroppingPlanSpecies, String>(){

        public String apply(CroppingPlanSpecies input) {
            String result = input.getCode();
            return result;
        }
    };
    protected GrowingPlanService growingPlanService;
    protected PlotService plotService;
    protected BusinessAuthorizationService authorizationService;
    protected PricesService pricesService;
    protected AnonymizeService anonymizeService;
    protected EntityUsageService entityUsageService;
    protected ReferentialService referentialService;
    protected DomainTopiaDao domainDao;
    protected GrowingPlanTopiaDao growingPlanDao;
    protected GeoPointTopiaDao geoPointDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao;
    protected EquipmentTopiaDao equipmentDao;
    protected GroundTopiaDao groundDao;
    protected ToolsCouplingTopiaDao toolsCouplingDao;
    protected WeatherStationTopiaDao weatherStationDao;
    protected PlotTopiaDao plotDao;
    protected RefLegalStatusTopiaDao refLegalStatusDao;
    protected RefLocationTopiaDao locationDao;
    protected RefOTEXTopiaDao refOTEXDao;
    protected RefEspeceTopiaDao refEspeceDao;
    protected RefVarieteTopiaDao refVarieteDao;
    protected RefStationMeteoTopiaDao refStationMeteoDao;
    protected RefSolArvalisTopiaDao refSolArvalisDao;
    protected RefMaterielTopiaDao refMaterielTopiaDao;
    protected RefInterventionAgrosystTravailEDITopiaDao refInterventionAgrosystTravailEDITopiaDao;
    protected AbstractActionTopiaDao abstractActionDao;
    protected PracticedInterventionTopiaDao practicedInterventionDao;
    protected EffectiveInterventionTopiaDao effectiveInterventionDao;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setEntityUsageService(EntityUsageService entityUsageService) {
        this.entityUsageService = entityUsageService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setGrowingPlanDao(GrowingPlanTopiaDao growingPlanDao) {
        this.growingPlanDao = growingPlanDao;
    }

    public void setDomainDao(DomainTopiaDao domainDao) {
        this.domainDao = domainDao;
    }

    public void setRefLegalStatusDao(RefLegalStatusTopiaDao refLegalStatusDao) {
        this.refLegalStatusDao = refLegalStatusDao;
    }

    public void setLocationDao(RefLocationTopiaDao locationDao) {
        this.locationDao = locationDao;
    }

    public void setRefOTEXDao(RefOTEXTopiaDao refOTEXDao) {
        this.refOTEXDao = refOTEXDao;
    }

    public void setRefEspeceDao(RefEspeceTopiaDao refEspeceDao) {
        this.refEspeceDao = refEspeceDao;
    }

    public void setRefVarieteDao(RefVarieteTopiaDao refVarieteDao) {
        this.refVarieteDao = refVarieteDao;
    }

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setCroppingPlanSpeciesDao(CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao) {
        this.croppingPlanSpeciesDao = croppingPlanSpeciesDao;
    }

    public void setEquipmentDao(EquipmentTopiaDao equipmentDao) {
        this.equipmentDao = equipmentDao;
    }

    public void setToolsCouplingDao(ToolsCouplingTopiaDao toolsCouplingDao) {
        this.toolsCouplingDao = toolsCouplingDao;
    }

    public void setWeatherStationDao(WeatherStationTopiaDao weatherStationDao) {
        this.weatherStationDao = weatherStationDao;
    }

    public void setRefStationMeteoDao(RefStationMeteoTopiaDao refStationMeteoDao) {
        this.refStationMeteoDao = refStationMeteoDao;
    }

    public void setAbstractActionDao(AbstractActionTopiaDao abstractActionDao) {
        this.abstractActionDao = abstractActionDao;
    }

    public void setPracticedInterventionDao(PracticedInterventionTopiaDao practicedInterventionDao) {
        this.practicedInterventionDao = practicedInterventionDao;
    }

    public void setEffectiveInterventionDao(EffectiveInterventionTopiaDao effectiveInterventionDao) {
        this.effectiveInterventionDao = effectiveInterventionDao;
    }

    public void setPlotDao(PlotTopiaDao plotDao) {
        this.plotDao = plotDao;
    }

    public void setGeoPointDao(GeoPointTopiaDao geoPointDao) {
        this.geoPointDao = geoPointDao;
    }

    public void setGroundDao(GroundTopiaDao groundDao) {
        this.groundDao = groundDao;
    }

    public void setRefSolArvalisDao(RefSolArvalisTopiaDao refSolArvalisDao) {
        this.refSolArvalisDao = refSolArvalisDao;
    }

    public void setRefMaterielTopiaDao(RefMaterielTopiaDao refMaterielTopiaDao) {
        this.refMaterielTopiaDao = refMaterielTopiaDao;
    }

    public void setRefInterventionAgrosystTravailEDITopiaDao(RefInterventionAgrosystTravailEDITopiaDao refInterventionAgrosystTravailEDITopiaDao) {
        this.refInterventionAgrosystTravailEDITopiaDao = refInterventionAgrosystTravailEDITopiaDao;
    }

    public List<Domain> getAllDomains() {
        List domains = this.domainDao.findAll();
        return domains;
    }

    public Domain getDomain(String domainId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domainId) ? 1 : 0) != 0);
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        Domain result = this.anonymizeService.checkForDomainAnonymization(domain);
        return result;
    }

    public Domain newDomain() {
        Domain result = (Domain)this.domainDao.newInstance();
        result.setActive(true);
        return result;
    }

    public GeoPoint newGpsData() {
        GeoPoint result = (GeoPoint)this.geoPointDao.newInstance();
        return result;
    }

    public WeatherStation newWeatherStation() {
        return (WeatherStation)this.weatherStationDao.newInstance();
    }

    public DomainDto getDomainByCode(String domainCode) {
        Domain domain = (Domain)this.domainDao.forCodeEquals(domainCode).findAny();
        DomainDto result = (DomainDto)this.anonymizeService.getDomainToDtoFunction(false).apply((Object)domain);
        return result;
    }

    public Domain createOrUpdateDomain(Domain domain, String locationId, String legalStatusId, List<GeoPoint> geoPoints, List<CroppingPlanEntryDto> croppingPlan, Integer otex18code, Integer otex70code, List<Ground> grounds, List<Equipment> equipments, List<ToolsCoupling> toolsCouplings, List<Price> prices) {
        String domainId = domain.getTopiaId();
        this.authorizationService.checkCreateOrUpdateDomain(domainId);
        Domain persistedDomain = this.createOrUpdateDomainWithoutCommit(domain, locationId, legalStatusId, geoPoints, croppingPlan, otex18code, otex70code, grounds, equipments, toolsCouplings, prices);
        this.addUserAuthorization(domainId, persistedDomain);
        Domain validatedResult = this.validateAndCommit(persistedDomain.getTopiaId());
        return validatedResult;
    }

    protected void addUserAuthorization(String domainId, Domain persistedDomain) {
        if (StringUtils.isBlank((CharSequence)domainId)) {
            this.authorizationService.domainCreated(persistedDomain);
        }
    }

    protected Domain createOrUpdateDomainWithoutCommit(Domain domain, String locationId, String legalStatusId, List<GeoPoint> geoPoints, Collection<CroppingPlanEntryDto> croppingPlanDtos, Integer otex18code, Integer otex70code, List<Ground> grounds, List<Equipment> equipments, List<ToolsCoupling> toolsCouplings, List<Price> prices) {
        String domainId = domain.getTopiaId();
        this.validPreconditions(domain, locationId, geoPoints, toolsCouplings, croppingPlanDtos);
        if (!DomainType.EXPLOITATION_AGRICOLE.equals((Object)domain.getType()) || !DomainType.FERME_DE_LYCEE_AGRICOLE.equals((Object)domain.getType())) {
            domain.setLegalStatus(null);
        }
        this.setLocation(domain, locationId);
        domain.setUpdateDate(this.context.getCurrentDate());
        Domain persistedDomain = this.saveDomain(domain, domainId);
        this.addDomainLegalStatus(legalStatusId, persistedDomain);
        this.addDomainOtex18(otex18code, persistedDomain);
        this.addDomainOtex70(otex70code, persistedDomain);
        this.bindDomainToGrounds(grounds, persistedDomain, domainId);
        this.bindDomainToGeoPoint(geoPoints, persistedDomain, domainId);
        this.manageEquipmentAndToolsCoupling(persistedDomain, equipments, toolsCouplings, domainId);
        this.manageCrops(croppingPlanDtos, persistedDomain, domainId);
        this.pricesService.updatePrices(prices, persistedDomain, null);
        return persistedDomain;
    }

    private void setLocation(Domain domain, String locationId) {
        RefLocation location = (RefLocation)this.locationDao.forTopiaIdEquals(locationId).findUnique();
        domain.setLocation(location);
    }

    private List<CroppingPlanEntry> findExistingCroppingPlans(String domainId) {
        List<Object> existingCroppingPlan = StringUtils.isNotBlank((CharSequence)domainId) ? this.getCroppingPlan0(domainId) : Lists.newArrayList();
        return existingCroppingPlan;
    }

    private Domain saveDomain(Domain domain, String domainId) {
        Domain result;
        if (StringUtils.isBlank((CharSequence)domainId)) {
            this.setDomainCode(domain);
            result = (Domain)this.domainDao.create((TopiaEntity)domain);
        } else {
            result = (Domain)this.domainDao.update((TopiaEntity)domain);
        }
        return result;
    }

    private void setDomainCode(Domain domain) {
        if (StringUtils.isBlank((CharSequence)domain.getCode())) {
            domain.setCode(UUID.randomUUID().toString());
        }
    }

    private void manageCrops(Collection<CroppingPlanEntryDto> croppingPlanDtos, Domain persistedDomain, String domainId) {
        if (croppingPlanDtos != null) {
            Iterables.removeIf(croppingPlanDtos, IS_CROPPING_PLAN_ENTRY_EMPTY);
            HashMap especesIndex = Maps.newHashMap();
            HashMap varietesIndex = Maps.newHashMap();
            for (CroppingPlanEntryDto entry : croppingPlanDtos) {
                if (entry.getSpecies() == null) continue;
                for (CroppingPlanSpeciesDto species : entry.getSpecies()) {
                    String speciesId = species.getSpeciesId();
                    especesIndex.put(speciesId, this.refEspeceDao.forTopiaIdEquals(speciesId).findUnique());
                    String varietyId = species.getVarietyId();
                    if (Strings.isNullOrEmpty((String)varietyId)) continue;
                    varietesIndex.put(varietyId, this.refVarieteDao.forTopiaIdEquals(varietyId).findUnique());
                }
            }
            List<CroppingPlanEntry> existingCroppingPlan = this.findExistingCroppingPlans(domainId);
            ArrayList croppingPlanEntriesToDelete = Lists.newArrayList(existingCroppingPlan);
            ImmutableMap entityEntriesIndex = Maps.uniqueIndex(existingCroppingPlan, (Function)Entities.GET_TOPIA_ID);
            for (CroppingPlanEntryDto dtoEntry : croppingPlanDtos) {
                String cpEntryId = dtoEntry.getTopiaId();
                CroppingPlanEntry entityEntry = (CroppingPlanEntry)entityEntriesIndex.get(cpEntryId);
                if (entityEntry == null) {
                    entityEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.newInstance();
                    this.setCropCode(dtoEntry, entityEntry);
                } else {
                    croppingPlanEntriesToDelete.remove(entityEntry);
                }
                entityEntry.setDomain(persistedDomain);
                entityEntry.setName(dtoEntry.getName());
                entityEntry.setSellingPrice(dtoEntry.getSellingPrice());
                entityEntry.setType(dtoEntry.getType());
                Collection dtoSpeciesList = dtoEntry.getSpecies();
                if (dtoSpeciesList == null) {
                    dtoSpeciesList = Lists.newArrayList();
                    dtoEntry.setSpecies(dtoSpeciesList);
                }
                List<CroppingPlanSpecies> species = this.removeUnusedCroppingPlanSpecies(entityEntry, dtoSpeciesList);
                ImmutableMap speciesById = Maps.uniqueIndex(species, (Function)Entities.GET_TOPIA_ID);
                for (CroppingPlanSpeciesDto dtoSpecies : dtoSpeciesList) {
                    CroppingPlanSpecies entitySpecies;
                    String speciesTopiaId = dtoSpecies.getTopiaId();
                    if (Strings.isNullOrEmpty((String)speciesTopiaId)) {
                        entitySpecies = (CroppingPlanSpecies)this.croppingPlanSpeciesDao.newInstance();
                        String speciesCode = StringUtils.isBlank((CharSequence)dtoSpecies.getCode()) ? UUID.randomUUID().toString() : dtoSpecies.getCode();
                        entitySpecies.setCode(speciesCode);
                        entityEntry.addCroppingPlanSpecies(entitySpecies);
                    } else {
                        entitySpecies = (CroppingPlanSpecies)speciesById.get(speciesTopiaId);
                        Preconditions.checkState((entitySpecies != null ? 1 : 0) != 0, (Object)("CroppingPlanSpecies non trouv\u00e9e: " + speciesTopiaId));
                    }
                    String especeId = dtoSpecies.getSpeciesId();
                    RefEspece refEspece = (RefEspece)especesIndex.get(especeId);
                    Preconditions.checkState((refEspece != null ? 1 : 0) != 0, (Object)("Espece non trouv\u00e9e: " + especeId));
                    entitySpecies.setSpecies(refEspece);
                    String varietyId = dtoSpecies.getVarietyId();
                    if (Strings.isNullOrEmpty((String)varietyId)) continue;
                    RefVariete refVariete = (RefVariete)varietesIndex.get(varietyId);
                    Preconditions.checkState((refVariete != null ? 1 : 0) != 0, (Object)("Vari\u00e9t\u00e9 non trouv\u00e9e: " + varietyId));
                    entitySpecies.setVariety(refVariete);
                    Preconditions.checkArgument((boolean)this.referentialService.validVarietesFromCodeEspeceEdi(refVariete, refEspece.getCode_espece_botanique()), (Object)String.format("Vari\u00e9t\u00e9 %s non valide pour l'esp\u00e8ce %s", refVariete.getLabel(), refEspece.getLibelle_espece_botanique()));
                }
                if (entityEntry.isPersisted()) {
                    this.croppingPlanEntryDao.update((TopiaEntity)entityEntry);
                    continue;
                }
                this.croppingPlanEntryDao.create((TopiaEntity)entityEntry);
            }
            for (CroppingPlanEntry croppingPlanEntryToDelete : croppingPlanEntriesToDelete) {
                List croppingPlanSpeciesToDelete = croppingPlanEntryToDelete.getCroppingPlanSpecies();
                if (croppingPlanSpeciesToDelete == null) continue;
                croppingPlanEntryToDelete.clearCroppingPlanSpecies();
                this.croppingPlanSpeciesDao.deleteAll(croppingPlanSpeciesToDelete);
            }
            this.croppingPlanEntryDao.deleteAll(croppingPlanEntriesToDelete);
        }
    }

    protected void setCropCode(CroppingPlanEntryDto dtoEntry, CroppingPlanEntry entityEntry) {
        if (StringUtils.isBlank((CharSequence)dtoEntry.getCode())) {
            entityEntry.setCode(UUID.randomUUID().toString());
        } else {
            entityEntry.setCode(dtoEntry.getCode());
        }
    }

    protected List<CroppingPlanSpecies> removeUnusedCroppingPlanSpecies(CroppingPlanEntry entityEntry, Collection<CroppingPlanSpeciesDto> dtoSpeciesList) {
        Iterables.removeIf(dtoSpeciesList, IS_CROPPING_SPECIES_EMPTY);
        final ImmutableListMultimap dtoSpeciesIndex = Multimaps.index(dtoSpeciesList, GET_SPECIES_TOPIA_ID);
        List entitySpeciesList = entityEntry.getCroppingPlanSpecies();
        if (entitySpeciesList == null) {
            entitySpeciesList = Lists.newArrayList();
        }
        Iterables.removeIf((Iterable)entitySpeciesList, (Predicate)new Predicate<CroppingPlanSpecies>(){

            public boolean apply(CroppingPlanSpecies species) {
                String speciesTopiaId = species.getTopiaId();
                boolean result = !dtoSpeciesIndex.containsKey((Object)speciesTopiaId);
                return result;
            }
        });
        return entitySpeciesList;
    }

    protected void manageEquipmentAndToolsCoupling(Domain persistedDomain, List<Equipment> equipments, List<ToolsCoupling> toolsCouplings, String domainId) {
        ArrayList<ToolsCoupling> existingToolsCouplings;
        ArrayList<Equipment> existingEquipments;
        HashMap equipmentsCache = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)domainId)) {
            existingEquipments = new ArrayList();
            existingToolsCouplings = new ArrayList();
        } else {
            existingEquipments = this.equipmentDao.forDomainEquals(persistedDomain).findAll();
            existingToolsCouplings = this.toolsCouplingDao.forDomainEquals(persistedDomain).findAll();
        }
        List<Equipment> equipmentsToDelete = this.bindDomainToEquipments(persistedDomain, equipments, equipmentsCache, existingEquipments);
        List<ToolsCoupling> toolsCouplingsToDelete = this.bindDomainToToolsCouplings(persistedDomain, toolsCouplings, equipmentsCache, existingToolsCouplings);
        this.deleteNotUsedToolsCouplings(toolsCouplingsToDelete);
        this.equipmentDao.deleteAll(equipmentsToDelete);
    }

    protected void deleteNotUsedToolsCouplings(List<ToolsCoupling> toolsCouplingsToDelete) {
        for (ToolsCoupling toolsCouplingsToDel : toolsCouplingsToDelete) {
            toolsCouplingsToDel.setTractor(null);
            this.toolsCouplingDao.delete(toolsCouplingsToDel);
        }
    }

    protected List<ToolsCoupling> bindDomainToToolsCouplings(final Domain persistedDomain, List<ToolsCoupling> toolsCouplings, final Map<String, Equipment> equipmentsCache, List<ToolsCoupling> existingToolsCouplings) {
        return this.easyBindNoDelete(this.toolsCouplingDao, existingToolsCouplings, toolsCouplings, new Function<ToolsCoupling, Void>(){

            public Void apply(ToolsCoupling input) {
                if (StringUtils.isBlank((CharSequence)input.getCode())) {
                    input.setCode(UUID.randomUUID().toString());
                }
                input.setDomain(persistedDomain);
                return null;
            }
        }, new Function<ToolsCoupling, Void>(){

            public Void apply(ToolsCoupling input) {
                Collection equipments;
                Equipment tractor = input.getTractor();
                if (tractor != null) {
                    String tractorId = input.getTractor().getTopiaId();
                    Equipment domainTractor = (Equipment)equipmentsCache.get(tractorId);
                    input.setTractor(domainTractor);
                }
                if ((equipments = input.getEquipments()) != null) {
                    for (Equipment equipment : equipments) {
                        String equipmentId = equipment.getTopiaId();
                        Equipment fromCache = (Equipment)equipmentsCache.get(equipmentId);
                        if (fromCache == null) continue;
                        equipment.setTopiaId(fromCache.getTopiaId());
                    }
                }
                return null;
            }
        }, new String[]{"domain"});
    }

    protected List<Equipment> bindDomainToEquipments(final Domain persistedDomain, List<Equipment> equipments, final Map<String, Equipment> equipmentsCache, List<Equipment> existingEquipments) {
        return this.easyBindNoDelete(this.equipmentDao, existingEquipments, equipments, new Function<Equipment, Void>(){

            public Void apply(Equipment input) {
                if (StringUtils.isBlank((CharSequence)input.getCode())) {
                    input.setCode(UUID.randomUUID().toString());
                }
                input.setDomain(persistedDomain);
                return null;
            }
        }, new Function<Equipment, Void>(){

            public Void apply(Equipment input) {
                String topiaId = input.getTopiaId();
                equipmentsCache.put(topiaId, input);
                if (topiaId.startsWith("NEW-EQUIPMENT-")) {
                    input.setTopiaId(null);
                }
                return null;
            }
        }, new String[]{"domain"});
    }

    protected void bindDomainToGeoPoint(List<GeoPoint> geoPoints, final Domain persistedDomain, String domainId) {
        ArrayList existingGeoPoints = StringUtils.isBlank((CharSequence)domainId) ? new ArrayList() : this.geoPointDao.forDomainEquals(persistedDomain).findAll();
        this.easyBind(this.geoPointDao, existingGeoPoints, geoPoints, new Function<GeoPoint, Void>(){

            public Void apply(GeoPoint input) {
                input.setDomain(persistedDomain);
                return null;
            }
        }, new String[]{"domain"});
    }

    protected void bindDomainToGrounds(List<Ground> grounds, final Domain persistedDomain, String domainId) {
        ArrayList existingGrounds = StringUtils.isBlank((CharSequence)domainId) ? new ArrayList() : this.groundDao.forDomainEquals(persistedDomain).findAll();
        this.easyBind(this.groundDao, existingGrounds, grounds, new Function<Ground, Void>(){

            public Void apply(Ground input) {
                input.setDomain(persistedDomain);
                return null;
            }
        }, new String[]{"domain"});
    }

    protected void addDomainOtex70(Integer otex70code, Domain persistedDomain) {
        if (otex70code != null) {
            RefOTEX refOtex70 = (RefOTEX)this.refOTEXDao.forCode_OTEX_70_postesEquals(otex70code).findAny();
            persistedDomain.setOtex70(refOtex70);
        } else {
            persistedDomain.setOtex70(null);
        }
    }

    protected void addDomainOtex18(Integer otex18code, Domain persistedDomain) {
        if (otex18code != null) {
            RefOTEX refOtex18 = (RefOTEX)this.refOTEXDao.forCode_OTEX_18_postesEquals(otex18code).findAny();
            persistedDomain.setOtex18(refOtex18);
        } else {
            persistedDomain.setOtex18(null);
        }
    }

    protected void addDomainLegalStatus(String legalStatusId, Domain persistedDomain) {
        if (!StringUtils.isBlank((CharSequence)legalStatusId) && (persistedDomain.getType().equals((Object)DomainType.EXPLOITATION_AGRICOLE) || persistedDomain.getType().equals((Object)DomainType.FERME_DE_LYCEE_AGRICOLE))) {
            RefLegalStatus legalStatus = (RefLegalStatus)this.refLegalStatusDao.forTopiaIdEquals(legalStatusId).findUnique();
            persistedDomain.setLegalStatus(legalStatus);
        }
    }

    protected void validPreconditions(Domain domain, String locationId, List<GeoPoint> geoPoints, List<ToolsCoupling> toolsCouplings, Collection<CroppingPlanEntryDto> croppingPlanEntryDtos) {
        if (geoPoints != null) {
            for (GeoPoint geoPoint : geoPoints) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)geoPoint.getName()), (Object)"Le nom du centre est obligatoire sur une coordon\u00e9es d'un centre op\u00e9rationnels");
            }
        }
        if (toolsCouplings != null) {
            for (ToolsCoupling toolsCoupling : toolsCouplings) {
                Equipment tractor;
                Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{toolsCoupling.getToolsCouplingName()}), (Object)"Aucun nom de d\u00e9finie sur la combinaison d'outil");
                Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)toolsCoupling.getMainsActions()), (Object)"Aucune action principale de d\u00e9finie");
                if (toolsCoupling.isManualIntervention()) {
                    Preconditions.checkArgument((toolsCoupling.getTractor() == null ? 1 : 0) != 0);
                    Preconditions.checkArgument((boolean)CollectionUtils.isEmpty((Collection)toolsCoupling.getEquipments()));
                    continue;
                }
                Collection tcEquipments = toolsCoupling.getEquipments();
                boolean irrigationEquipmentsPresent = false;
                boolean nonIrrigationEquipmentsPresent = false;
                if (tcEquipments != null && tcEquipments.size() > 0) {
                    for (Equipment tcEquipment : tcEquipments) {
                        boolean isIrrigationEquipment;
                        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tcEquipment.getName()), (Object)"Aucun nom de d\u00e9finit sur l'eqipement");
                        boolean bl = isIrrigationEquipment = tcEquipment.getRefMateriel() != null && tcEquipment.getRefMateriel() instanceof RefMaterielIrrigation;
                        if (isIrrigationEquipment) {
                            irrigationEquipmentsPresent = true;
                            continue;
                        }
                        nonIrrigationEquipmentsPresent = true;
                    }
                }
                if ((tractor = toolsCoupling.getTractor()) == null) {
                    Preconditions.checkArgument((boolean)irrigationEquipmentsPresent, (Object)"Combinaison d'outils non valide, aucun tracteur/automoteur/mat\u00e9riel d'irrigation pr\u00e9sent");
                    Preconditions.checkArgument((!nonIrrigationEquipmentsPresent ? 1 : 0) != 0, (Object)"Combinaison d'outils non valide, du mat\u00e9riel d'irrigation ne peut \u00eatre associ\u00e9 avec du mat\u00e9riel autre qu'un tracteur ou un automoteur");
                    continue;
                }
                if (tractor.getRefMateriel() == null || !(tractor.getRefMateriel() instanceof RefMaterielAutomoteur)) {
                    Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)tcEquipments), (Object)"Combinaison d'outils non valide, aucun \u00e9quipement pr\u00e9sent avec le tracteur");
                }
                if (!CollectionUtils.isNotEmpty((Collection)tcEquipments)) continue;
                Preconditions.checkArgument((!irrigationEquipmentsPresent || !nonIrrigationEquipmentsPresent ? 1 : 0) != 0, (Object)"Combinaison d'outils non valide, du mat\u00e9riel d'irrigation ne peut \u00eatre associ\u00e9 avec du mat\u00e9riel autre qu'un tracteur ou un automoteur");
            }
        }
        if (croppingPlanEntryDtos != null) {
            for (CroppingPlanEntryDto croppingPlanEntryDto : croppingPlanEntryDtos) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)croppingPlanEntryDto.getName()));
                Preconditions.checkNotNull((Object)croppingPlanEntryDto.getType(), (Object)"Type de culture non d\u00e9fini");
                Collection speciesDtos = croppingPlanEntryDto.getSpecies();
                if (!CollectionUtils.isNotEmpty((Collection)speciesDtos)) continue;
                for (CroppingPlanSpeciesDto speciesDto : speciesDtos) {
                    Preconditions.checkNotNull((Object)speciesDto.getSpeciesId(), (Object)"Identifiant de l'esp\u00e8ce non renseign\u00e9");
                }
            }
        }
        Preconditions.checkArgument((boolean)CommonService.ARE_CAMPAIGNS_VALIDS(Integer.toString(domain.getCampaign())), (Object)"Campagne non valide pour le domaine");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domain.getMainContact()) ? 1 : 0) != 0, (Object)"Aucun contact de renseign\u00e9");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domain.getName()) ? 1 : 0) != 0, (Object)"Le nom du domaine est obligatoire");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locationId) ? 1 : 0) != 0, (Object)"Commune non renseign\u00e9e");
        Preconditions.checkNotNull((Object)domain.getType(), (Object)"Le type de domaine est obligatoire");
    }

    public ResultList<Domain> getFilteredDomains(DomainFilter filter) {
        ResultList result = this.getFilteredDomains0(filter);
        result = this.anonymizeService.checkForDomainsAnonymization(result);
        return result;
    }

    public List<Domain> getDomainWithName(String name) {
        Preconditions.checkNotNull((Object)name);
        List domains = this.domainDao.forNameEquals(name).findAll();
        return domains;
    }

    protected ResultList<Domain> getFilteredDomains0(DomainFilter filter) {
        ResultList<Domain> result = this.domainDao.getFilteredDomains(filter, this.getSecurityContext());
        return result;
    }

    public ResultList<DomainDto> getFilteredDomainsDto(DomainFilter filter) {
        ResultList<Domain> domains = this.getFilteredDomains0(filter);
        ResultList result = ResultList.transform(domains, (Function)this.anonymizeService.getDomainToDtoFunction(true));
        return result;
    }

    public List<DomainDto> getDomains(Collection<String> domainIds) {
        List domains = this.domainDao.forTopiaIdIn(domainIds).findAll();
        List result = Lists.transform((List)domains, (Function)this.anonymizeService.getDomainToDtoFunction(true));
        return result;
    }

    public void unactivateDomains(List<String> domainIds, boolean activate) {
        if (domainIds != null && !domainIds.isEmpty()) {
            for (String domainId : domainIds) {
                Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
                domain.setActive(activate);
                domain.setUpdateDate(this.context.getCurrentDate());
                this.domainDao.update((TopiaEntity)domain);
            }
            this.getTransaction().commit();
        }
    }

    public List<RefLegalStatus> getAllRefLegalStatus() {
        List refAllLegalStatus = this.refLegalStatusDao.findAll();
        return refAllLegalStatus;
    }

    public RefStationMeteo findRefStationMeteoByTopiaId(String topiaId) {
        return (RefStationMeteo)this.refStationMeteoDao.forTopiaIdEquals(topiaId).findUnique();
    }

    public Equipment newMateriel() {
        Equipment result = (Equipment)this.equipmentDao.newInstance();
        return result;
    }

    public Ground newSol() {
        Ground result = (Ground)this.groundDao.newInstance();
        return result;
    }

    public Domain extendDomain(String domainTopiaId, int extendCampaign) throws DomainExtendException {
        Domain sourceDomain = (Domain)this.domainDao.forTopiaIdEquals(domainTopiaId).findUnique();
        LinkedHashMap<Integer, String> relatedDomains = this.domainDao.findAllRelatedDomains(sourceDomain.getCode());
        if (relatedDomains != null && !relatedDomains.isEmpty()) {
            Integer closestLowerCampaign = null;
            for (Map.Entry<Integer, String> relatedDomain : relatedDomains.entrySet()) {
                Integer currentCampaign = relatedDomain.getKey();
                if (currentCampaign == extendCampaign) {
                    throw new DomainExtendException("The domain is already extended for this campaign");
                }
                if (currentCampaign >= extendCampaign || (closestLowerCampaign == null || currentCampaign <= closestLowerCampaign) && closestLowerCampaign != null) continue;
                closestLowerCampaign = currentCampaign;
            }
            Set<Integer> relatedCampaigns = relatedDomains.keySet();
            if (closestLowerCampaign == null) {
                closestLowerCampaign = (Integer)Iterables.getLast(relatedCampaigns);
            }
            String lastDomainId = relatedDomains.get(closestLowerCampaign);
            sourceDomain = (Domain)this.domainDao.forTopiaIdEquals(lastDomainId).findUnique();
        } else if (sourceDomain.getCampaign() == extendCampaign) {
            throw new DomainExtendException("The domain is already extended for this campaign");
        }
        HashMap groundCache = Maps.newHashMap();
        try {
            List toolsCouplings;
            List grounds;
            Binder domainBinder = BinderFactory.newBinder(Domain.class);
            Domain clonedDomainDraft = (Domain)this.domainDao.newInstance();
            domainBinder.copyExcluding((Object)sourceDomain, (Object)clonedDomainDraft, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "weatherStations", "defaultWeatherStation"});
            clonedDomainDraft.setTopiaId(null);
            clonedDomainDraft.setCampaign(extendCampaign);
            if (sourceDomain.getWeatherStations() != null) {
                Binder weatherStationBinder = BinderFactory.newBinder(WeatherStation.class);
                for (WeatherStation ws : sourceDomain.getWeatherStations()) {
                    WeatherStation clone = (WeatherStation)this.weatherStationDao.newInstance();
                    weatherStationBinder.copyExcluding((Object)ws, (Object)clone, new String[]{"topiaId"});
                    clonedDomainDraft.addWeatherStations(clone);
                    if (!ws.equals(sourceDomain.getDefaultWeatherStation())) continue;
                    clonedDomainDraft.setDefaultWeatherStation(clone);
                }
            }
            Date currentDate = this.context.getCurrentDate();
            clonedDomainDraft.setUpdateDate(currentDate);
            clonedDomainDraft.setValidated(true);
            clonedDomainDraft.setValidationDate(currentDate);
            Domain clonedDomain = (Domain)this.domainDao.create((TopiaEntity)clonedDomainDraft);
            List geoPoints = this.geoPointDao.forDomainEquals(sourceDomain).findAll();
            if (geoPoints != null && !geoPoints.isEmpty()) {
                Binder gpsDataBinder = BinderFactory.newBinder(GeoPoint.class);
                for (GeoPoint geoPoint : geoPoints) {
                    GeoPoint clone = (GeoPoint)this.geoPointDao.newInstance();
                    gpsDataBinder.copyExcluding((Object)geoPoint, (Object)clone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                    clone.setDomain(clonedDomain);
                    this.geoPointDao.create((TopiaEntity)clone);
                }
            }
            if ((grounds = this.groundDao.forDomainEquals(sourceDomain).findAll()) != null && !grounds.isEmpty()) {
                Binder solBinder = BinderFactory.newBinder(Ground.class);
                for (Ground sol : grounds) {
                    Ground cloneSol = (Ground)this.groundDao.newInstance();
                    solBinder.copyExcluding((Object)sol, (Object)cloneSol, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                    cloneSol.setDomain(clonedDomain);
                    cloneSol = (Ground)this.groundDao.create((TopiaEntity)cloneSol);
                    groundCache.put(sol, cloneSol);
                }
            }
            HashMap<String, Equipment> equipmentClones = new HashMap<String, Equipment>();
            List equipments = this.equipmentDao.forDomainEquals(sourceDomain).findAll();
            if (equipments != null && !equipments.isEmpty()) {
                Binder binder = BinderFactory.newBinder(Equipment.class);
                for (Equipment equipment : equipments) {
                    Equipment clone = (Equipment)this.equipmentDao.newInstance();
                    binder.copyExcluding((Object)equipment, (Object)clone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                    clone.setDomain(clonedDomain);
                    clone = (Equipment)this.equipmentDao.create((TopiaEntity)clone);
                    equipmentClones.put(equipment.getTopiaId(), clone);
                }
            }
            if ((toolsCouplings = this.toolsCouplingDao.forDomainEquals(sourceDomain).findAll()) != null && !toolsCouplings.isEmpty()) {
                for (ToolsCoupling toolsCoupling : toolsCouplings) {
                    Binder binder = BinderFactory.newBinder(ToolsCoupling.class);
                    ToolsCoupling clonedToolsCoupling = (ToolsCoupling)this.toolsCouplingDao.newInstance();
                    binder.copyExcluding((Object)toolsCoupling, (Object)clonedToolsCoupling, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "mainsActions", "tractor", "equipments"});
                    clonedToolsCoupling.setDomain(clonedDomain);
                    if (toolsCoupling.getTractor() != null) {
                        clonedToolsCoupling.setTractor((Equipment)equipmentClones.get(toolsCoupling.getTractor().getTopiaId()));
                    }
                    ArrayList clonedMainsActions = Lists.newArrayList((Iterable)toolsCoupling.getMainsActions());
                    clonedToolsCoupling.setMainsActions((Collection)clonedMainsActions);
                    if (toolsCoupling.getEquipments() != null) {
                        ArrayList clonedEquipements = Lists.newArrayList();
                        for (Equipment equipement : toolsCoupling.getEquipments()) {
                            clonedEquipements.add(equipmentClones.get(equipement.getTopiaId()));
                        }
                        clonedToolsCoupling.setEquipments((Collection)clonedEquipements);
                    }
                    this.toolsCouplingDao.create((TopiaEntity)clonedToolsCoupling);
                }
            }
            ExtendContext extendContext = new ExtendContext();
            extendContext.setGroundCache((Map)groundCache);
            List growingPlans = this.growingPlanDao.forDomainEquals(sourceDomain).addEquals("active", (Object)true).findAll();
            for (GrowingPlan growingPlan : growingPlans) {
                this.growingPlanService.duplicateGrowingPlan(extendContext, clonedDomain, growingPlan, true);
            }
            List plots = this.plotDao.forDomainEquals(sourceDomain).addEquals("active", (Object)true).findAll();
            for (Plot plot : plots) {
                Plot clone = this.plotService.extendPlot(extendContext, clonedDomain, plot);
                Map growingSystemCache = extendContext.getGrowingSystemCache();
                if (growingSystemCache == null) continue;
                GrowingSystem cloneGrowingSystem = (GrowingSystem)growingSystemCache.get(plot.getGrowingSystem());
                clone.setGrowingSystem(cloneGrowingSystem);
            }
            List<CroppingPlanEntry> croppingPlan = this.getCroppingPlan0(sourceDomain.getTopiaId());
            if (croppingPlan != null) {
                Binder binder = BinderFactory.newBinder(CroppingPlanEntry.class);
                final Binder speciesBinder = BinderFactory.newBinder(CroppingPlanSpecies.class);
                for (CroppingPlanEntry cpEntry : croppingPlan) {
                    final CroppingPlanEntry clonedCpEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.newInstance();
                    binder.copyExcluding((Object)cpEntry, (Object)clonedCpEntry, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "croppingPlanSpecies"});
                    clonedCpEntry.setDomain(clonedDomain);
                    this.croppingPlanEntryDao.create((TopiaEntity)clonedCpEntry);
                    if (cpEntry.getCroppingPlanSpecies() == null) continue;
                    clonedCpEntry.setCroppingPlanSpecies((List)ImmutableList.copyOf((Collection)Lists.transform((List)cpEntry.getCroppingPlanSpecies(), (Function)new Function<CroppingPlanSpecies, CroppingPlanSpecies>(){

                        public CroppingPlanSpecies apply(CroppingPlanSpecies input) {
                            CroppingPlanSpecies clone = (CroppingPlanSpecies)DomainServiceImpl.this.croppingPlanSpeciesDao.newInstance();
                            speciesBinder.copyExcluding((Object)input, (Object)clone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                            clone.setCroppingPlanEntry(clonedCpEntry);
                            CroppingPlanSpecies result = (CroppingPlanSpecies)DomainServiceImpl.this.croppingPlanSpeciesDao.create((TopiaEntity)clone);
                            return result;
                        }
                    })));
                }
            }
            this.getTransaction().commit();
            return clonedDomain;
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't clone object", (Throwable)ex);
        }
    }

    public LinkedHashMap<Integer, String> getRelatedDomains(String domainCode) {
        LinkedHashMap<Integer, String> result = this.domainDao.findAllRelatedDomains(domainCode);
        return result;
    }

    public ToolsCoupling newToolsCoupling() {
        ToolsCoupling result = (ToolsCoupling)this.toolsCouplingDao.newInstance();
        return result;
    }

    protected List<CroppingPlanEntry> getCroppingPlan0(String domainId) {
        String propertyDomainId = "domain.topiaId";
        List result = this.croppingPlanEntryDao.forProperties(propertyDomainId, domainId, new Object[0]).setOrderByArguments(new String[]{"name"}).findAll();
        return result;
    }

    protected List<CroppingPlanSpecies> getCroppingPlanSpecies(String domainId) {
        String propertyDomainId = "croppingPlanEntry.domain.topiaId";
        List result = this.croppingPlanSpeciesDao.forProperties(propertyDomainId, domainId, new Object[0]).findAll();
        return result;
    }

    public InputStream exportDomainAsXlsStream(List<String> domainIds) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        DomainExportMetadata.DomainMainBeanInfo domainMainTabInfo = this.newInstance(DomainExportMetadata.DomainMainBeanInfo.class);
        DomainExportMetadata.DomainGpsDataBeanInfo geoPointTabInfo = this.newInstance(DomainExportMetadata.DomainGpsDataBeanInfo.class);
        DomainExportMetadata.DomainSolBeanInfo groundTabInfo = this.newInstance(DomainExportMetadata.DomainSolBeanInfo.class);
        DomainExportMetadata.DomainStatusBeanInfo domainStatusTabInfo = this.newInstance(DomainExportMetadata.DomainStatusBeanInfo.class);
        DomainExportMetadata.DomainMaterielBeanInfo equipmentTabInfo = this.newInstance(DomainExportMetadata.DomainMaterielBeanInfo.class);
        DomainExportMetadata.DomainToolsCouplingBeanInfo domainToolsCouplingBeanInfo = this.newInstance(DomainExportMetadata.DomainToolsCouplingBeanInfo.class);
        DomainExportMetadata.DomainCroppingPlanEntryBeanInfo croppingPlanTabInfo = this.newInstance(DomainExportMetadata.DomainCroppingPlanEntryBeanInfo.class);
        ExportUtils.addAllBeanInfo(sheet, domainMainTabInfo, geoPointTabInfo, groundTabInfo, domainStatusTabInfo, equipmentTabInfo, domainToolsCouplingBeanInfo, croppingPlanTabInfo);
        List croppingPlans = (List)sheet.get(croppingPlanTabInfo);
        List toolsCouplingsExports = (List)sheet.get(domainToolsCouplingBeanInfo);
        try {
            if (CollectionUtils.isNotEmpty(domainIds)) {
                Iterable domains = this.domainDao.forTopiaIdIn(domainIds).findAllLazy(100);
                for (Domain domain : domains) {
                    DomainExportEntity export;
                    domain = this.anonymizeService.checkForDomainAnonymization(domain);
                    DomainExportEntity model = new DomainExportEntity();
                    model.setDomainType(domain.getType());
                    model.setDomainName(domain.getName());
                    model.setCampaign(domain.getCampaign());
                    model.setPostalCode(domain.getLocation().getCodePostal());
                    model.setMainContact(domain.getMainContact());
                    model.setDepartement(domain.getLocation().getDepartement());
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, domain, (EntityExportTabInfo)domainMainTabInfo);
                    List domainGeoPoints = this.geoPointDao.forDomainEquals(domain).findAll();
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, domainGeoPoints, (EntityExportTabInfo)geoPointTabInfo);
                    List grounds = this.groundDao.forDomainEquals(domain).findAll();
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, grounds, (EntityExportTabInfo)groundTabInfo);
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, domain, (EntityExportTabInfo)domainStatusTabInfo);
                    List domainEquipments = this.equipmentDao.forDomainEquals(domain).findAll();
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, domainEquipments, (EntityExportTabInfo)equipmentTabInfo);
                    List toolsCouplings = this.toolsCouplingDao.forDomainEquals(domain).findAll();
                    for (ToolsCoupling toolsCoupling : toolsCouplings) {
                        Collection mainsActions = toolsCoupling.getMainsActions();
                        for (RefInterventionAgrosystTravailEDI mainAction : mainsActions) {
                            Collection equipments = toolsCoupling.getEquipments();
                            if (equipments.isEmpty()) {
                                export = (DomainExportEntity)model.clone();
                                ExportUtils.copyFields(toolsCoupling, (EntityExportExtra)export, null, "toolsCouplingName", "workforce", "comment");
                                ExportUtils.setExtraField(export, "agrosystInterventionTypes", mainAction.getIntervention_agrosyst());
                                ExportUtils.setExtraField(export, "mainsActions", mainAction.getReference_label());
                                if (toolsCoupling.getTractor() != null) {
                                    ExportUtils.setExtraField(export, "tractors", toolsCoupling.getTractor().getName());
                                }
                                toolsCouplingsExports.add(export);
                                continue;
                            }
                            for (Equipment equipment : equipments) {
                                DomainExportEntity export2 = (DomainExportEntity)model.clone();
                                ExportUtils.copyFields(toolsCoupling, (EntityExportExtra)export2, null, "toolsCouplingName", "workforce", "comment");
                                ExportUtils.setExtraField(export2, "agrosystInterventionTypes", mainAction.getIntervention_agrosyst());
                                ExportUtils.setExtraField(export2, "mainsActions", mainAction.getReference_label());
                                if (toolsCoupling.getTractor() != null) {
                                    ExportUtils.setExtraField(export2, "tractor", toolsCoupling.getTractor().getName());
                                }
                                ExportUtils.setExtraField(export2, "equipments", equipment.getName());
                                toolsCouplingsExports.add(export2);
                            }
                        }
                    }
                    List<CroppingPlanEntry> croppingPlan = this.getCroppingPlan0(domain.getTopiaId());
                    for (CroppingPlanEntry croppingPlanEntry : croppingPlan) {
                        List species = croppingPlanEntry.getCroppingPlanSpecies();
                        if (CollectionUtils.isEmpty((Collection)species)) {
                            DomainExportEntity export3 = (DomainExportEntity)model.clone();
                            ExportUtils.copyFields(croppingPlanEntry, (EntityExportExtra)export3, null, "name", "sellingPrice", "type");
                            croppingPlans.add(export3);
                            continue;
                        }
                        for (CroppingPlanSpecies aSpecies : species) {
                            export = (DomainExportEntity)model.clone();
                            ExportUtils.copyFields(croppingPlanEntry, (EntityExportExtra)export, null, "name", "sellingPrice", "type");
                            ExportUtils.copyFields(aSpecies.getSpecies(), (EntityExportExtra)export, null, "libelle_espece_botanique", "libelle_qualifiant_AEE", "libelle_type_saisonnier_AEE", "libelle_destination_AEE");
                            if (aSpecies.getVariety() != null) {
                                ExportUtils.setExtraField(export, "label", aSpecies.getVariety().getLabel());
                            }
                            croppingPlans.add(export);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }

    public void importDomainForXlsStream(InputStream is) {
        DomainExportMetadata.DomainMainBeanInfo domainMainTabInfo = this.newInstance(DomainExportMetadata.DomainMainBeanInfo.class);
        DomainExportMetadata.DomainGpsDataBeanInfo geoPointTabInfo = this.newInstance(DomainExportMetadata.DomainGpsDataBeanInfo.class);
        DomainExportMetadata.DomainSolBeanInfo groundTabInfo = this.newInstance(DomainExportMetadata.DomainSolBeanInfo.class);
        DomainExportMetadata.DomainStatusBeanInfo domainStatusTabInfo = this.newInstance(DomainExportMetadata.DomainStatusBeanInfo.class);
        DomainExportMetadata.DomainMaterielBeanInfo equipmentTabInfo = this.newInstance(DomainExportMetadata.DomainMaterielBeanInfo.class);
        DomainExportMetadata.DomainToolsCouplingBeanInfo domainToolsCouplingBeanInfo = this.newInstance(DomainExportMetadata.DomainToolsCouplingBeanInfo.class);
        DomainExportMetadata.DomainCroppingPlanEntryBeanInfo croppingPlanTabInfo = this.newInstance(DomainExportMetadata.DomainCroppingPlanEntryBeanInfo.class);
        EntityImporter importer = new EntityImporter();
        Map<EntityExportTabInfo, List<DomainExportEntity>> datas = importer.importFromStream(is, DomainExportEntity.class, domainMainTabInfo, geoPointTabInfo, groundTabInfo, domainStatusTabInfo, equipmentTabInfo, domainToolsCouplingBeanInfo, croppingPlanTabInfo);
        List<DomainExportEntity> mainBeanInfo = datas.get(domainMainTabInfo);
        MultiKeyMap domainCache = new MultiKeyMap();
        for (DomainExportEntity beanInfo : mainBeanInfo) {
            int domainCampaign;
            String domainName = beanInfo.getDomainName();
            if (domainCache.containsKey((Object)domainName, (Object)(domainCampaign = beanInfo.getCampaign()))) continue;
            Domain domain = (Domain)this.domainDao.newInstance();
            domain.setType(beanInfo.getDomainType());
            domain.setCampaign(domainCampaign);
            domain.setName(domainName);
            domain.setLocation((RefLocation)this.locationDao.forCodePostalEquals(beanInfo.getPostalCode()).findAny());
            domain.setMainContact(beanInfo.getMainContact());
            domain.setDescription((String)beanInfo.getExtras().get("description"));
            domain.setLegalStatus((RefLegalStatus)this.refLegalStatusDao.forLibelle_INSEEEquals((String)beanInfo.getExtras().get("legalStatus")).findUniqueOrNull());
            domain.setZoning((Zoning)beanInfo.getExtras().get("zoning"));
            domain.setActive(true);
            domain.setCode(UUID.randomUUID().toString());
            domain.setUpdateDate(this.getContext().getCurrentDate());
            domain = (Domain)this.domainDao.create((TopiaEntity)domain);
            domainCache.put((Object)domainName, (Object)domainCampaign, (Object)domain);
        }
        List<DomainExportEntity> geoBeanInfo = datas.get(geoPointTabInfo);
        for (DomainExportEntity beanInfo : geoBeanInfo) {
            String domainName = beanInfo.getDomainName();
            int domainCampaign = beanInfo.getCampaign();
            Domain domain = (Domain)domainCache.get((Object)domainName, (Object)domainCampaign);
            GeoPoint geoPoint = (GeoPoint)this.geoPointDao.newInstance();
            geoPoint.setName(beanInfo.getExtraAsString("name"));
            String latitude = beanInfo.getExtraAsString("latitude");
            String longitude = beanInfo.getExtraAsString("longitude");
            geoPoint.setLatitude(Double.parseDouble(latitude.replace(',', '.')));
            geoPoint.setLongitude(Double.parseDouble(longitude.replace(',', '.')));
            geoPoint.setDomain(domain);
            geoPoint.setDescription((String)beanInfo.getExtras().get("description"));
            geoPoint = (GeoPoint)this.geoPointDao.create((TopiaEntity)geoPoint);
        }
        List<DomainExportEntity> groundBeanInfo = datas.get(groundTabInfo);
        for (DomainExportEntity beanInfo : groundBeanInfo) {
            String domainName = beanInfo.getDomainName();
            int domainCampaign = beanInfo.getCampaign();
            Domain domain = (Domain)domainCache.get((Object)domainName, (Object)domainCampaign);
            Ground ground = (Ground)this.groundDao.newInstance();
            ground.setName(beanInfo.getExtraAsString("name"));
            ground.setImportance(Double.parseDouble(beanInfo.getExtraAsString("importance")));
            ground.setComment(beanInfo.getExtraAsString("comment"));
            String nomSol = beanInfo.getExtraAsString("solArvalis");
            String regionSol = beanInfo.getExtraAsString("region");
            RefSolArvalis refSolArvalis = (RefSolArvalis)this.refSolArvalisDao.forProperties("sol_nom", nomSol, new Object[]{"sol_region", regionSol}).findUnique();
            ground.setRefSolArvalis(refSolArvalis);
            ground.setDomain(domain);
            ground = (Ground)this.groundDao.create((TopiaEntity)ground);
        }
        List<DomainExportEntity> statusBeanInfo = datas.get(domainStatusTabInfo);
        for (DomainExportEntity beanInfo : statusBeanInfo) {
            String domainName = beanInfo.getDomainName();
            int domainCampaign = beanInfo.getCampaign();
            Domain domain = (Domain)domainCache.get((Object)domainName, (Object)domainCampaign);
            try {
                ExportUtils.copyFields(beanInfo, domain, "statusComment", "partnersNumber", "otherWorkForce", "familyWorkForceWage", "permanentEmployeesWorkForce", "temporaryEmployeesWorkForce", "cropsWorkForce", "wageCosts", "workforceComment", "orientation", "otex18", "otex70", "usedAgriculturalArea", "experimentalAgriculturalArea", "homogenizationExperimentalAgriculturalArea", "msaFee", "averageTenantFarming", "decoupledAssistance");
            }
            catch (Exception ex) {
                throw new AgrosystTechnicalException("Can't copy fields", (Throwable)ex);
            }
        }
        List<DomainExportEntity> materielBeanInfo = datas.get(equipmentTabInfo);
        HashMap equipmentCache = Maps.newHashMap();
        for (DomainExportEntity beanInfo : materielBeanInfo) {
            String domainName = beanInfo.getDomainName();
            int domainCampaign = beanInfo.getCampaign();
            Domain domain = (Domain)domainCache.get((Object)domainName, (Object)domainCampaign);
            Equipment equipment = (Equipment)this.equipmentDao.newInstance();
            equipment.setName(beanInfo.getExtraAsString("name"));
            equipment.setDescription(beanInfo.getExtraAsString("description"));
            equipment.setMaterielETA("oui".equalsIgnoreCase(beanInfo.getExtraAsString("materielETA")));
            String materielType1 = beanInfo.getExtraAsString("typeMateriel1");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{materielType1})) {
                String materielType2 = beanInfo.getExtraAsString("typeMateriel2");
                String materielType3 = beanInfo.getExtraAsString("typeMateriel3");
                String materielType4 = beanInfo.getExtraAsString("typeMateriel4");
                String uniteParAn = beanInfo.getExtraAsString("uniteParAn");
                double uniteParAnd = Double.parseDouble(uniteParAn.replace(',', '.'));
                RefMateriel refMateriel = (RefMateriel)this.refMaterielTopiaDao.forProperties("typeMateriel1", materielType1, new Object[]{"typeMateriel2", materielType2, "typeMateriel3", materielType3, "typeMateriel4", materielType4, "uniteParAn", uniteParAnd}).findUnique();
                equipment.setRefMateriel(refMateriel);
            }
            equipment.setDomain(domain);
            equipment.setCode(UUID.randomUUID().toString());
            equipment = (Equipment)this.equipmentDao.create((TopiaEntity)equipment);
            equipmentCache.put(equipment.getName(), equipment);
        }
        List<DomainExportEntity> toolsCouplingBeanInfo = datas.get(domainToolsCouplingBeanInfo);
        HashMap toolsCouplingCache = Maps.newHashMap();
        for (DomainExportEntity beanInfo : toolsCouplingBeanInfo) {
            String equipment;
            String tractor;
            ToolsCoupling toolCoupling;
            String domainName = beanInfo.getDomainName();
            int domainCampaign = beanInfo.getCampaign();
            Domain domain = (Domain)domainCache.get((Object)domainName, (Object)domainCampaign);
            String toolsCouplingName = beanInfo.getExtraAsString("toolsCouplingName");
            if (toolsCouplingCache.containsKey(toolsCouplingName)) {
                toolCoupling = (ToolsCoupling)toolsCouplingCache.get(toolsCouplingName);
            } else {
                toolCoupling = (ToolsCoupling)this.toolsCouplingDao.newInstance();
                toolCoupling.setToolsCouplingName(toolsCouplingName);
                toolCoupling.setComment(beanInfo.getExtraAsString("comment"));
                String workForce = beanInfo.getExtraAsString("workforce");
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{workForce})) {
                    toolCoupling.setWorkforce(Integer.valueOf(Integer.parseInt(workForce)));
                }
                toolCoupling.setDomain(domain);
                toolCoupling.setCode(UUID.randomUUID().toString());
                toolsCouplingCache.put(toolsCouplingName, toolCoupling);
            }
            RefInterventionAgrosystTravailEDI interventionAgrosystTravailEDI = (RefInterventionAgrosystTravailEDI)this.refInterventionAgrosystTravailEDITopiaDao.forIntervention_agrosystEquals(AgrosystInterventionType.valueOf((String)beanInfo.getExtraAsString("agrosystInterventionTypes"))).findUnique();
            if (toolCoupling.getMainsActions() == null || !toolCoupling.getMainsActions().contains(interventionAgrosystTravailEDI)) {
                toolCoupling.addMainsActions(interventionAgrosystTravailEDI);
            }
            if (!Strings.isNullOrEmpty((String)(tractor = beanInfo.getExtraAsString("tractor")))) {
                toolCoupling.setTractor((Equipment)equipmentCache.get(tractor));
            }
            if (Strings.isNullOrEmpty((String)(equipment = beanInfo.getExtraAsString("equipments")))) {
                toolCoupling.addEquipments((Equipment)equipmentCache.get(equipment));
            }
            if (toolCoupling.isPersisted()) {
                toolCoupling = (ToolsCoupling)this.toolsCouplingDao.update((TopiaEntity)toolCoupling);
                continue;
            }
            toolCoupling = (ToolsCoupling)this.toolsCouplingDao.create((TopiaEntity)toolCoupling);
        }
        List<DomainExportEntity> croppingPlanBeanInfo = datas.get(croppingPlanTabInfo);
        HashMap croppingPlanEntryCache = Maps.newHashMap();
        for (DomainExportEntity beanInfo : croppingPlanBeanInfo) {
            CroppingPlanEntry croppingPlanEntry;
            String domainName = beanInfo.getDomainName();
            int domainCampaign = beanInfo.getCampaign();
            Domain domain = (Domain)domainCache.get((Object)domainName, (Object)domainCampaign);
            String croppingPlanEntryName = beanInfo.getExtraAsString("name");
            if (croppingPlanEntryCache.containsKey(croppingPlanEntryName)) {
                croppingPlanEntry = (CroppingPlanEntry)croppingPlanEntryCache.get(croppingPlanEntryName);
            } else {
                croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.newInstance();
                croppingPlanEntry.setDomain(domain);
                croppingPlanEntry.setName(croppingPlanEntryName);
                croppingPlanEntry.setCode(UUID.randomUUID().toString());
                croppingPlanEntry.setType(CroppingEntryType.valueOf((String)beanInfo.getExtraAsString("type")));
                String price = beanInfo.getExtraAsString("sellingPrice");
                if (StringUtils.isNotBlank((CharSequence)price)) {
                    croppingPlanEntry.setSellingPrice(Double.valueOf(Double.parseDouble(price.replace(',', '.'))));
                }
            }
            String species = beanInfo.getExtraAsString("libelle_espece_botanique");
            if (StringUtils.isNotBlank((CharSequence)species)) {
                String qualifiant = beanInfo.getExtraAsString("libelle_qualifiant_AEE");
                String type = beanInfo.getExtraAsString("libelle_type_saisonnier_AEE");
                String destination = beanInfo.getExtraAsString("libelle_destination_AEE");
                RefEspece refEspece = (RefEspece)this.refEspeceDao.forProperties("libelle_espece_botanique", species, new Object[]{"libelle_qualifiant_AEE", Strings.nullToEmpty((String)qualifiant), "libelle_type_saisonnier_AEE", Strings.nullToEmpty((String)type), "libelle_destination_AEE", Strings.nullToEmpty((String)destination)}).findUnique();
                CroppingPlanSpeciesImpl croppingPlanSpecies = new CroppingPlanSpeciesImpl();
                croppingPlanSpecies.setCode(UUID.randomUUID().toString());
                croppingPlanSpecies.setSpecies(refEspece);
                croppingPlanEntry.addCroppingPlanSpecies((CroppingPlanSpecies)croppingPlanSpecies);
            }
            if (croppingPlanEntry.isPersisted()) {
                this.croppingPlanEntryDao.update((TopiaEntity)croppingPlanEntry);
                continue;
            }
            this.croppingPlanEntryDao.create((TopiaEntity)croppingPlanEntry);
        }
        this.getTransaction().commit();
    }

    public boolean checkDomainExistence(String domainName) {
        long domain = this.domainDao.countDomainWithName(domainName);
        boolean result = domain > 0L;
        return result;
    }

    public long getDomainsCount(Boolean active) {
        if (active == null) {
            return this.domainDao.count();
        }
        return this.domainDao.forActiveEquals(active).count();
    }

    public List<Price> getDomainPrices(String domainTopiaId) {
        List result = this.pricesService.getDomainPrices(domainTopiaId, null);
        return result;
    }

    public void deleteToolsCouplings(Collection<ToolsCoupling> toolsCouplings) {
        HashSet allPracticedInterventionsToRemove = Sets.newHashSet();
        HashSet allEffectiveInterventionsToRemove = Sets.newHashSet();
        HashSet allActionsToRemove = Sets.newHashSet();
        for (ToolsCoupling toolsCoupling : toolsCouplings) {
            List practicedInterventions = this.practicedInterventionDao.forToolsCouplingCodesContains(toolsCoupling.getCode()).findAll();
            List toolsCouplingAbstractActions = this.abstractActionDao.forToolsCouplingCodeEquals(toolsCoupling.getCode()).findAll();
            allActionsToRemove.addAll(toolsCouplingAbstractActions);
            for (PracticedIntervention practicedIntervention : practicedInterventions) {
                List interventionAbstractActions = this.abstractActionDao.forPracticedInterventionEquals(practicedIntervention).findAll();
                if (interventionAbstractActions.equals(toolsCouplingAbstractActions)) {
                    allPracticedInterventionsToRemove.add(practicedIntervention);
                    continue;
                }
                Collection toolCouplingsCodes = practicedIntervention.getToolsCouplingCodes();
                toolCouplingsCodes.remove(toolsCoupling.getCode());
            }
            List effectiveInterventions = this.effectiveInterventionDao.forToolCouplingsContains(toolsCoupling).findAll();
            for (EffectiveIntervention effectiveIntervention : effectiveInterventions) {
                List interventionAbstractActions = this.abstractActionDao.forEffectiveInterventionEquals(effectiveIntervention).findAll();
                if (interventionAbstractActions.equals(toolsCouplingAbstractActions)) {
                    allEffectiveInterventionsToRemove.add(effectiveIntervention);
                    continue;
                }
                effectiveIntervention.getToolCouplings().remove(toolsCoupling);
            }
        }
        this.practicedInterventionDao.deleteAll(allPracticedInterventionsToRemove);
        this.effectiveInterventionDao.deleteAll(allEffectiveInterventionsToRemove);
        this.abstractActionDao.deleteAll(allActionsToRemove);
    }

    public void deleteUnusedMainAction(String toolsCouplingCode, Collection<RefInterventionAgrosystTravailEDI> originalMainsActions, Collection<RefInterventionAgrosystTravailEDI> actualMainsActions) {
        Collection mainsActionsToRemove = CollectionUtils.subtract(originalMainsActions, actualMainsActions);
        List interventionAbstractActions = this.abstractActionDao.forToolsCouplingCodeEquals(toolsCouplingCode).findAll();
        HashSet allPracticedInterventionsToRemove = Sets.newHashSet();
        HashSet allEffectiveInterventionsToRemove = Sets.newHashSet();
        HashSet allActionsToRemove = Sets.newHashSet();
        for (AbstractAction action : interventionAbstractActions) {
            EffectiveIntervention effectiveIntervention;
            AbstractAction actionToRemove = null;
            for (RefInterventionAgrosystTravailEDI mainAction : mainsActionsToRemove) {
                if (!action.getMainAction().getTopiaId().equals(mainAction.getTopiaId())) continue;
                actionToRemove = action;
                allActionsToRemove.add(actionToRemove);
                break;
            }
            if (actionToRemove == null) continue;
            PracticedIntervention practicedIntervention = actionToRemove.getPracticedIntervention();
            List interventionActions = this.abstractActionDao.forPracticedInterventionEquals(practicedIntervention).findAll();
            if (interventionActions != null && interventionActions.size() == 1) {
                allPracticedInterventionsToRemove.add(practicedIntervention);
            }
            if ((interventionActions = this.abstractActionDao.forEffectiveInterventionEquals(effectiveIntervention = actionToRemove.getEffectiveIntervention()).findAll()) == null || interventionActions.size() != 1) continue;
            allEffectiveInterventionsToRemove.add(effectiveIntervention);
        }
        this.practicedInterventionDao.deleteAll(allPracticedInterventionsToRemove);
        this.effectiveInterventionDao.deleteAll(allEffectiveInterventionsToRemove);
        this.abstractActionDao.deleteAll(allActionsToRemove);
    }

    public Domain validateAndCommit(String domainId) {
        this.authorizationService.checkValidateDomain(domainId);
        this.domainDao.validateDomain(domainId, this.context.getCurrentDate());
        this.getTransaction().commit();
        this.getPersistenceContext().getHibernateSupport().getHibernateSession().clear();
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        return domain;
    }

    public List<GeoPoint> getGeoPoints(String domainId) {
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        List result = this.geoPointDao.forDomainEquals(domain).findAll();
        result = this.anonymizeService.checkForGeoPointAnonymization(result);
        return result;
    }

    public List<Equipment> getEquipments(String domainId) {
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        List result = this.equipmentDao.forDomainEquals(domain).findAll();
        return result;
    }

    public List<Ground> getGrounds(String domainId) {
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        List result = this.groundDao.forDomainEquals(domain).findAll();
        return result;
    }

    public List<ToolsCoupling> getToolsCouplings(String domainId) {
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        List result = this.toolsCouplingDao.forDomainEquals(domain).findAll();
        return result;
    }

    public UsageList<ToolsCoupling> getToolsCouplingAndUsage(String domainId) {
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        List elements = this.toolsCouplingDao.forDomainEquals(domain).findAll();
        UsageList<ToolsCoupling> result = this.entityUsageService.getToolsCouplingUsageList(elements, domain.getCampaign());
        return result;
    }

    public List<String> getCroppingPlanCodeForDomainsAndCampaigns(String code, Set<Integer> campaigns) {
        List<String> result = this.domainDao.findCroppingPlanCodeForDomainsAndCampaigns(code, campaigns);
        return result;
    }

    public List<String> getCroppingPlanSpeciesCodeForCropCodeAndCampaigns(String cropCode, Set<Integer> campaigns) {
        List<String> result = this.domainDao.findCroppingPlanSpeciesCodeForCropCodeAndCampaigns(cropCode, campaigns);
        return result;
    }

    public List<String> getToolsCouplingCodeForDomainsAndCampaigns(String code, Set<Integer> campaigns) {
        List<String> result = this.domainDao.findToolsCouplingCodeForDomainsAndCampaigns(code, campaigns);
        return result;
    }

    public List<ToolsCoupling> getToolsCouplingsForDomainCodeAndCampaigns(String code, Set<Integer> campaigns) {
        List<ToolsCoupling> result = this.domainDao.findToolsCouplingsForDomainCodeAndCampaigns(code, campaigns);
        return result;
    }

    public List<CroppingPlanEntryDto> getCroppingPlanDtos(String domainId) {
        List<CroppingPlanEntry> entities = this.getCroppingPlan0(domainId);
        List result = Lists.transform(entities, (Function)CroppingPlans.CROPPING_PLAN_ENTRY_TO_DTO);
        return result;
    }

    public UsageList<CroppingPlanEntryDto> getCroppingPlanEntryDtoAndUsage(String domainId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domainId) ? 1 : 0) != 0);
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        List<CroppingPlanEntry> elements = this.getCroppingPlan0(domain.getTopiaId());
        UsageList<CroppingPlanEntryDto> result = this.entityUsageService.getCroppingPlanEntryDtoAndUsage(elements, domain.getCampaign());
        return result;
    }

    public Map<String, Boolean> getCroppingPlanSpeciesUsage(String domainId) {
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        List<CroppingPlanSpecies> elements = this.getCroppingPlanSpecies(domain.getTopiaId());
        Map<String, Boolean> result = this.entityUsageService.getCroppingPlanSpeciesUsageMap(elements, domain.getCampaign(), domain.getCode());
        return result;
    }

    public Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> getEntryAndSpeciesFromCode(String croppingPlanEntryCode, Set<Integer> campaignsSet) {
        Preconditions.checkArgument((campaignsSet != null && !campaignsSet.isEmpty() ? 1 : 0) != 0);
        List<CroppingPlanEntry> entries = this.croppingPlanEntryDao.findEntriesFromCode(croppingPlanEntryCode, campaignsSet);
        Preconditions.checkState((entries != null && !entries.isEmpty() ? 1 : 0) != 0, (Object)("No CroppingPlanEntry found with code: " + croppingPlanEntryCode));
        LinkedHashMap species = Maps.newLinkedHashMap();
        for (CroppingPlanEntry entry : entries) {
            if (entry.getCroppingPlanSpecies() == null) continue;
            species.putAll(Maps.uniqueIndex((Iterable)entry.getCroppingPlanSpecies(), (Function)CroppingPlans.GET_SPECIES_CODE));
        }
        CroppingPlanEntry entry = entries.iterator().next();
        Pair result = Pair.of((Object)entry, (Object)species);
        return result;
    }

    public Map<String, Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>>> findSpeciesCodeByCropCodeForCampaigns(List<String> croppingPlanEntryCodes, Set<Integer> campaignsSet) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(croppingPlanEntryCodes) && CollectionUtils.isNotEmpty(campaignsSet)) {
            for (String croppingPlanEntryCode : croppingPlanEntryCodes) {
                Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> pair = this.getEntryAndSpeciesFromCode(croppingPlanEntryCode, campaignsSet);
                if (pair == null || pair.getValue() == null) continue;
                Map cpss = (Map)pair.getValue();
                result.put(((CroppingPlanEntry)pair.getKey()).getCode(), pair);
            }
        }
        return result;
    }

    public String getDomainCodeForGrowingSystem(String growingSystemId) {
        String result = this.domainDao.getDomainCodeForGrowingSystem(growingSystemId);
        return result;
    }

    public List<Domain> getActiveWritableDomainsForDecisionRuleCreation() {
        List<Domain> result = this.domainDao.getActiveWritableDomainsForDecisionRuleCreation(this.getSecurityContext());
        return result;
    }

    public List<String> findDomainIdsForCodeAndCampaigns(String code, Set<Integer> campaigns, boolean includeCropsFromInactiveDomains) {
        List<String> result = this.domainDao.findDomainIdsForCampaigns(code, campaigns, includeCropsFromInactiveDomains);
        return result;
    }

    protected Boolean validateEquipment(List<Equipment> equipments) {
        Boolean result = true;
        if (equipments != null) {
            equipments.removeAll(Collections.singleton(null));
            for (Equipment equipment : equipments) {
                if (!StringUtils.isBlank((CharSequence)equipment.getName())) continue;
                result = false;
            }
        }
        return result;
    }

    protected Boolean validateToolsCoupling(List<ToolsCoupling> toolsCouplings) {
        Boolean result = true;
        if (toolsCouplings != null) {
            toolsCouplings.removeAll(Collections.singleton(null));
            for (ToolsCoupling toolsCoupling : toolsCouplings) {
                if (toolsCoupling.getMainsActions() == null || toolsCoupling.getMainsActions().isEmpty()) {
                    result = false;
                }
                if (!StringUtils.isBlank((CharSequence)toolsCoupling.getToolsCouplingName())) continue;
                result = false;
            }
        }
        return result;
    }

    public List<String> copyTools(String fromDomain, List<String> toDomainIds, Boolean includeToolCouplings, List<Equipment> equipmentsToCopy, List<ToolsCoupling> toolsCouplingsToCopy) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)toDomainIds.size());
        Preconditions.checkArgument((boolean)this.validateEquipment(equipmentsToCopy));
        if (includeToolCouplings.booleanValue()) {
            Preconditions.checkArgument((boolean)this.validateToolsCoupling(toolsCouplingsToCopy));
        }
        Domain domainFrom = (Domain)this.domainDao.forTopiaIdEquals(fromDomain).findUnique();
        List toDomains = this.domainDao.forTopiaIdIn(toDomainIds).findAll();
        if (equipmentsToCopy == null) {
            equipmentsToCopy = Lists.newArrayList();
        }
        ImmutableMap indexedEquipments = Maps.uniqueIndex((Iterable)equipmentsToCopy, (Function)Entities.GET_TOPIA_ID);
        if (toDomains != null && !toDomains.isEmpty()) {
            Binder binder = BinderFactory.newBinder(Equipment.class);
            for (Domain toDomain : toDomains) {
                HashMap copiedEquipments = Maps.newHashMapWithExpectedSize((int)indexedEquipments.size());
                if (toDomain.getCode().equals(domainFrom.getCode())) {
                    for (Equipment equipment : equipmentsToCopy) {
                        Equipment toEquipment = null;
                        if (StringUtils.isNotBlank((CharSequence)equipment.getCode())) {
                            toEquipment = (Equipment)this.equipmentDao.forProperties("domain", toDomain, new Object[]{"code", equipment.getCode()}).findUniqueOrNull();
                        }
                        if (toEquipment == null) {
                            String originalId = equipment.getTopiaId();
                            Equipment copiedEquipment = (Equipment)this.equipmentDao.newInstance();
                            binder.copyExcluding((Object)equipment, (Object)copiedEquipment, new String[]{"topiaId", "domain"});
                            if (Strings.isNullOrEmpty((String)copiedEquipment.getCode())) {
                                copiedEquipment.setCode(UUID.randomUUID().toString());
                            }
                            copiedEquipment.setDomain(toDomain);
                            copiedEquipment = (Equipment)this.equipmentDao.create((TopiaEntity)copiedEquipment);
                            copiedEquipments.put(originalId, copiedEquipment);
                            continue;
                        }
                        copiedEquipments.put(equipment.getTopiaId(), toEquipment);
                    }
                } else {
                    for (Equipment equipment : equipmentsToCopy) {
                        Equipment copiedEquipment = (Equipment)this.equipmentDao.newInstance();
                        binder.copyExcluding((Object)equipment, (Object)copiedEquipment, new String[]{"topiaId", "code", "domain"});
                        copiedEquipment.setCode(UUID.randomUUID().toString());
                        copiedEquipment.setDomain(toDomain);
                        copiedEquipment = (Equipment)this.equipmentDao.create((TopiaEntity)copiedEquipment);
                        copiedEquipments.put(equipment.getTopiaId(), copiedEquipment);
                    }
                }
                if (includeToolCouplings.booleanValue() && toolsCouplingsToCopy != null && !toolsCouplingsToCopy.isEmpty()) {
                    ArrayList copiedToolsCouplings = Lists.newArrayList();
                    Binder toolsCouplingBinder = BinderFactory.newBinder(ToolsCoupling.class);
                    if (toDomain.getCode().equals(domainFrom.getCode())) {
                        for (ToolsCoupling toolsCoupling : toolsCouplingsToCopy) {
                            ToolsCoupling toToolsCoupling = null;
                            if (StringUtils.isNotBlank((CharSequence)toolsCoupling.getCode())) {
                                toToolsCoupling = (ToolsCoupling)this.toolsCouplingDao.forProperties("domain", toDomain, new Object[]{"code", toolsCoupling.getCode()}).findUniqueOrNull();
                            }
                            if (toToolsCoupling != null) continue;
                            ToolsCoupling copiedToolsCoupling = (ToolsCoupling)this.toolsCouplingDao.newInstance();
                            toolsCouplingBinder.copyExcluding((Object)toolsCoupling, (Object)copiedToolsCoupling, new String[]{"topiaId", "domain", "tractor", "equipments", "mainsActions"});
                            if (Strings.isNullOrEmpty((String)copiedToolsCoupling.getCode())) {
                                copiedToolsCoupling.setCode(UUID.randomUUID().toString());
                            }
                            this.copyRelatedEntitiesToToolsCoupling(copiedEquipments, copiedToolsCouplings, copiedToolsCoupling, toolsCoupling, toDomain);
                        }
                    } else {
                        for (ToolsCoupling toolsCoupling : toolsCouplingsToCopy) {
                            ToolsCoupling copiedToolsCoupling = (ToolsCoupling)this.toolsCouplingDao.newInstance();
                            toolsCouplingBinder.copyExcluding((Object)toolsCoupling, (Object)copiedToolsCoupling, new String[]{"topiaId", "domain", "tractor", "equipments", "mainsActions", "code"});
                            copiedToolsCoupling.setCode(UUID.randomUUID().toString());
                            this.copyRelatedEntitiesToToolsCoupling(copiedEquipments, copiedToolsCouplings, copiedToolsCoupling, toolsCoupling, toDomain);
                        }
                    }
                    this.toolsCouplingDao.createAll(copiedToolsCouplings);
                }
                result.add(toDomain.getName() + " (" + toDomain.getCampaign() + ")");
            }
        }
        this.getTransaction().commit();
        return result;
    }

    protected void copyRelatedEntitiesToToolsCoupling(Map<String, Equipment> copiedEquipments, List<ToolsCoupling> copiedToolsCouplings, ToolsCoupling copiedToolsCoupling, ToolsCoupling toolsCoupling, Domain toDomain) {
        if (toolsCoupling.getTractor() != null) {
            copiedToolsCoupling.setTractor(copiedEquipments.get(toolsCoupling.getTractor().getTopiaId()));
        }
        if (toolsCoupling.getEquipments() != null && !toolsCoupling.getEquipments().isEmpty()) {
            ArrayList copiedTCEquipments = Lists.newArrayListWithExpectedSize((int)toolsCoupling.getEquipments().size());
            for (Equipment toolsCouplingEquipment : toolsCoupling.getEquipments()) {
                copiedTCEquipments.add(copiedEquipments.get(toolsCouplingEquipment.getTopiaId()));
            }
            copiedToolsCoupling.setEquipments((Collection)copiedTCEquipments);
        }
        ArrayList clonedMainsActions = Lists.newArrayList((Iterable)toolsCoupling.getMainsActions());
        copiedToolsCoupling.setMainsActions((Collection)clonedMainsActions);
        copiedToolsCoupling.setDomain(toDomain);
        copiedToolsCouplings.add(copiedToolsCoupling);
    }

    public double getDomainSAUArea(String domainId) {
        Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        Double result = domain.getUsedAgriculturalArea();
        if (result == null) {
            result = this.plotDao.getDomainPlotTotalArea(domainId);
        }
        return result;
    }

    public void importPZ0Domains(Map<Class, ImportResults> allResults) {
        ImportResults domainsImportResults = allResults.remove(Domain.class);
        if (domainsImportResults != null && domainsImportResults.getIgnoredRecords() == 0) {
            try {
                Map entitiesAndDependencies = domainsImportResults.getEntityAndDepsByCsvIds();
                Collection domainsAndDependencies = entitiesAndDependencies.values();
                int nbDomains = domainsAndDependencies.size();
                int i = 1;
                for (EntityAndDependencies entityAndDependencies : domainsAndDependencies) {
                    Map croppingPlanEntryDtoByCsvId;
                    DomainAndDependencies domainAndDependencies = (DomainAndDependencies)entityAndDependencies;
                    Domain domain = (Domain)domainAndDependencies.getEntity();
                    Collection<CroppingPlanEntryDto> crops = domainAndDependencies.getCroppingPlanEntryDtosByPZ0CsvId() == null ? null : domainAndDependencies.getCroppingPlanEntryDtosByPZ0CsvId().values();
                    ArrayList equipments = domainAndDependencies.getEquipments() == null ? new ArrayList() : Lists.newArrayList((Iterable)domainAndDependencies.getEquipments());
                    ArrayList toolsCouplings = domainAndDependencies.getToolsCouplings() == null ? new ArrayList() : Lists.newArrayList((Iterable)domainAndDependencies.getToolsCouplings());
                    ArrayList grounds = domainAndDependencies.getGrounds() == null ? null : Lists.newArrayList((Iterable)domainAndDependencies.getGrounds());
                    long start = System.currentTimeMillis();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("D\u00e9but sauvegarde du domaine:'%s', campagne:%d - %d/%d.", domain.getName(), domain.getCampaign(), i++, nbDomains));
                        log.info((Object)("Nb crops:" + (crops == null ? 0 : crops.size())));
                        log.info((Object)("Nb tc:" + toolsCouplings.size()));
                    }
                    domain = this.createOrUpdateDomainWithoutCommit(domain, domainAndDependencies.getLocationId(), domainAndDependencies.getLegalStatusTopiaId(), null, crops, domainAndDependencies.getOtex18(), domainAndDependencies.getOtex70(), grounds, equipments, toolsCouplings, null);
                    domainAndDependencies.setEntity((TopiaEntity)domain);
                    long p1 = System.currentTimeMillis();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Sauvegarde du domaine en:" + (p1 - start)));
                        log.info((Object)"Mise \u00e0 jour cultures du domaine.");
                    }
                    List<CroppingPlanEntry> croppingPlanEntries = this.getCroppingPlan0(domain.getTopiaId());
                    if (crops != null && (croppingPlanEntryDtoByCsvId = domainAndDependencies.getCroppingPlanEntryDtosByPZ0CsvId()) != null && !croppingPlanEntryDtoByCsvId.isEmpty()) {
                        ImmutableMap persistedCroppingPlanEntryByCode = Maps.uniqueIndex(croppingPlanEntries, GET_CROPPING_PLAN_ENTRY_CODE);
                        for (Map.Entry cropToSaveIter : croppingPlanEntryDtoByCsvId.entrySet()) {
                            CroppingPlanEntryDto dto = (CroppingPlanEntryDto)cropToSaveIter.getValue();
                            CroppingPlanEntry persistedCroppingPlanEntry = (CroppingPlanEntry)persistedCroppingPlanEntryByCode.get(dto.getCode());
                            dto.setTopiaId(persistedCroppingPlanEntry.getTopiaId());
                            Collection speciesToSaves = dto.getSpecies();
                            if (!CollectionUtils.isNotEmpty((Collection)speciesToSaves)) continue;
                            List persistedSpecies = persistedCroppingPlanEntry.getCroppingPlanSpecies();
                            ImmutableMap persistedSpeciesByCode = Maps.uniqueIndex((Iterable)persistedSpecies, GET_SPECIES_CODE);
                            for (CroppingPlanSpeciesDto speciesToSave : speciesToSaves) {
                                speciesToSave.setTopiaId(((CroppingPlanSpecies)persistedSpeciesByCode.get(speciesToSave.getCode())).getTopiaId());
                            }
                        }
                    }
                    long p2 = System.currentTimeMillis();
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Mise \u00e0 jour des culture en:" + (p2 - p1)));
                    log.info((Object)("Fin de sauvegarde du domaine, traitement r\u00e9alis\u00e9 en:" + (p2 - start)));
                }
            }
            catch (Exception e) {
                throw new AgrosystImportException("Echec de persistance des domaines", (Throwable)e);
            }
        }
    }
}

