/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.demo;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.EquipmentTopiaDao;
import fr.inra.agrosyst.api.entities.GeoPoint;
import fr.inra.agrosyst.api.entities.GeoPointTopiaDao;
import fr.inra.agrosyst.api.entities.GroundTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkManager;
import fr.inra.agrosyst.api.entities.NetworkManagerTopiaDao;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.action.IrrigationActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OtherActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.TillageActionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhaseTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.entities.history.MessageTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhaseTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemSource;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.AbstractRefBioAgressorTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPCTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCulturesTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActiveTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCategTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelleTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenneTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSolTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefDepartmentShapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinageTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceToVarieteTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorgTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFATopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrgaTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefGesCarburantTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefGesEngraisTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefGesPhytoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefGesSemenceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatusTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLienCulturesEdiActaTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referential.RefMesureTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjCarburantTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjEngraisTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjGesOutilTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjPhytoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjSemenceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefOTEXTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObsTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalisTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppaTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdCTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgricultureTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTypeTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefUniteEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGevesTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParcTopiaDao;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.UserRoleTopiaDao;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.DomainExtendException;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.network.NetworkManagerDto;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.AgrosystConfigurationHelper;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.DefaultServiceContext;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.network.Networks;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaNotFoundException;
import org.nuiton.util.StringUtil;

public class DemoDatas
extends AbstractAgrosystService {
    private static final Log log = LogFactory.getLog(DemoDatas.class);
    protected static final int DEMO_DOMAINS_COUNT = 100;
    protected static final int DEMO_PRACTICED_SYSTEMS_COUNT = 100;
    protected static final List<Integer> CAMPAIGNS = Lists.newArrayList((Object[])new Integer[]{2012, 2013});
    public static final List<CroppingEntryType> CROPPING_ENTRY_TYPES = Lists.newArrayList((Object[])CroppingEntryType.values());
    protected static final String LOREM_IPSUM_SOURCE = "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat. Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.";
    protected static final List<String> LOREM_IPSUM = Lists.newArrayList((Iterable)Splitter.on((String)".").trimResults().omitEmptyStrings().split((CharSequence)"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat. Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet."));
    protected static final List<String> LOREM_IPSUM_WORDS = Lists.newArrayList((Iterable)Splitter.onPattern((String)"[,. ]").trimResults().omitEmptyStrings().split((CharSequence)"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat. Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet."));
    protected static final List<String> CONTACTS = Lists.newArrayList((Object[])new String[]{"Annie Verssaire", "Alain Stant\u00e9", "Debby Scott", "Jean Peuplu", "G\u00e9rard Manvussa", "L\u00e9o Plac\u00e9", "Barbie Chaite", "Yvon Souf-Rire", "Tom Hatemozza", "Ella Malocoeur"});
    protected static final List<String> DOMAIN_NAMES = Lists.newArrayList((Object[])new String[]{"La Bouineli\u00e8re", "Le clos Gautier", "La porte Gell\u00e9e", "Cou\u00ebron les bains", "Baulon", "Avalon", "La boulogne", "Les Rideli\u00e8res", "La Godefroy", "Kermoger", "Les brosses", "\u00c0 l'or\u00e9e des champs", "Domaine de la bergerie", "Domaine des ormes", "Domaine de verchant", "La martelli\u00e8re", "Croix bonneau", "Wattignies", "Pirmil", "Mangin", "Les prairies mauves", "Bouffay", "Lauriers", "Motte rouge", "Petit port", "Ch\u00eane des anglais", "Talensac", "Neustrie"});
    protected static final Predicate<Network> SDC_COMPLIANT_NETWORKS = new Predicate<Network>(){

        public boolean apply(Network input) {
            String name = input.getName();
            return name.startsWith("EXPE") || name.startsWith("IR");
        }
    };
    protected final List<RefEspece> especes = Lists.newArrayList();
    protected final List<RefVarieteGeves> varieteGeveses = Lists.newArrayList();
    protected final List<RefVarietePlantGrape> varietePlantGrapes = Lists.newArrayList();
    protected final List<RefSolArvalis> solArvalis = Lists.newArrayList();
    protected final List<RefMateriel> refMateriel = Lists.newArrayList();
    protected final List<RefFertiMinUNIFA> fertiMinUnifa = Lists.newArrayList();
    protected final Map<AgrosystInterventionType, List<RefInterventionAgrosystTravailEDI>> interventionsTravailEDI = Maps.newHashMap();
    protected final List<RefFertiEngraisorg> fertiEngraisorg = Lists.newArrayList();
    protected ImportService importService;
    protected DomainService domainService;
    protected EffectiveCropCycleService effectiveCropCycleService;
    protected PracticedSystemService practicedSystemService;
    protected NetworkService networkService;
    protected AuthenticationService authenticationService;
    protected Random random = new Random(43508234345L);
    protected static final Set<String> ADMIN_EMAILS = ImmutableSet.of((Object)"antoine.schellenberger@orleans.inra.fr", (Object)"estelle.ancelet@orleans.inra.fr", (Object)"stephane.cadoux@grignon.inra.fr", (Object)"nicolas.munier-jolain@dijon.inra.fr", (Object)"ophelie.jolys@dijon.inra.fr", (Object)"thimel@codelutin.com", (Object[])new String[]{"chatellier@codelutin.com", "kaufmann@codelutin.com", "cosse@codelutin.com", "couteau@codelutin.com", "maisonneuve@codelutin.com", "morin@codelutin.com", "martel@codelutin.com", "bavencoff@codelutin.com"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void onInit(AgrosystServiceConfig serviceConfig) {
        if (serviceConfig.isGenerateBuiltinReferentials()) {
            transaction = null;
            try {
                transactionSupplier = DemoDatas.getAgrosystTopiaPersistenceContextSupplier(serviceConfig);
                serviceContext = new DefaultServiceContext(serviceConfig, transactionSupplier);
                transaction = serviceContext.getPersistenceContext();
                demoDatas = serviceContext.newService(DemoDatas.class);
                demoDatas.checkForDemoReferentials();
            }
            catch (Exception eee) {
                if (!DemoDatas.log.isErrorEnabled()) ** GOTO lbl24
                DemoDatas.log.error((Object)"Unable to create demo datas", (Throwable)eee);
            }
            finally {
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (TopiaException te) {
                        DemoDatas.log.error((Object)"Unable to close transaction", (Throwable)te);
                    }
                }
            }
        } else if (DemoDatas.log.isInfoEnabled()) {
            DemoDatas.log.info((Object)"Skipping builtin referentials generation");
        }
lbl24:
        // 6 sources

        if (serviceConfig.isGenerateBuiltinUsers()) {
            transaction = null;
            try {
                transactionSupplier = DemoDatas.getAgrosystTopiaPersistenceContextSupplier(serviceConfig);
                serviceContext = new DefaultServiceContext(serviceConfig, transactionSupplier);
                transaction = serviceContext.getPersistenceContext();
                demoDatas = serviceContext.newService(DemoDatas.class);
                demoDatas.checkForBuiltinUsers();
            }
            catch (Exception eee) {
                if (!DemoDatas.log.isErrorEnabled()) ** GOTO lbl43
                DemoDatas.log.error((Object)"Unable to create builtin users", (Throwable)eee);
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        } else if (DemoDatas.log.isInfoEnabled()) {
            DemoDatas.log.info((Object)"Skipping demo data generation");
        }
lbl43:
        // 6 sources

        if (serviceConfig.isDemoModeEnabled()) {
            transaction = null;
            try {
                transactionSupplier = DemoDatas.getAgrosystTopiaPersistenceContextSupplier(serviceConfig);
                serviceContext = new DefaultServiceContext(serviceConfig, transactionSupplier);
                transaction = serviceContext.getPersistenceContext();
                demoDatas = serviceContext.newService(DemoDatas.class);
                demoDatas.checkForDemoDatas();
            }
            catch (Exception eee) {
                if (!DemoDatas.log.isErrorEnabled()) ** GOTO lbl62
                DemoDatas.log.error((Object)"Unable to create demo data", (Throwable)eee);
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        } else if (DemoDatas.log.isInfoEnabled()) {
            DemoDatas.log.info((Object)"Skipping demo data generation");
        }
lbl62:
        // 6 sources

    }

    protected static Supplier<AgrosystTopiaPersistenceContext> getAgrosystTopiaPersistenceContextSupplier(AgrosystServiceConfig serviceConfig) {
        AgrosystTopiaApplicationContext applicationContext;
        Properties rootProperties = AgrosystConfigurationHelper.getRootContextProperties(serviceConfig);
        try {
            applicationContext = (AgrosystTopiaApplicationContext)TopiaApplicationContextCache.getContext((Properties)rootProperties, AgrosystConfigurationHelper.getCreateTopiaContextFunction(serviceConfig));
            applicationContext.applicationInit();
        }
        catch (TopiaNotFoundException tnfe) {
            throw new TopiaException("Unable to initialize TopiaContext", (Throwable)tnfe);
        }
        return new Supplier<AgrosystTopiaPersistenceContext>(){

            public AgrosystTopiaPersistenceContext get() {
                return applicationContext.newPersistenceContext();
            }
        };
    }

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected int randomInt(int max) {
        return this.randomInt(0, max);
    }

    protected int randomInt(int min, int max) {
        int result = max == 0 ? 0 : this.random.nextInt(max - min) + min;
        return result;
    }

    protected double randomDouble(double max) {
        return this.randomDouble(0.0, max, 2);
    }

    protected double randomDouble(double min, double max) {
        return this.randomDouble(min, max, 2);
    }

    protected double randomDouble(double min, double max, int round) {
        double result = max == 0.0 ? 0.0 : (double)Math.round((this.random.nextDouble() * (max - min) + min) * Math.pow(10.0, round)) / Math.pow(10.0, round);
        return result;
    }

    protected String randomName(List<String> list) {
        int index = this.randomInt(list.size());
        String result = list.get(index);
        result = result.substring(0, 1).toUpperCase() + result.substring(1);
        return result;
    }

    protected <T> T randomElem(List<T> list) {
        int index = this.randomInt(list.size());
        T result = list.get(index);
        return result;
    }

    protected <T> T randomEnum(T[] values) {
        int index = this.randomInt(values.length);
        T result = values[index];
        return result;
    }

    public void checkForDemoReferentials() {
        this.checkForDemoActaTraitementsProduits();
        this.checkForDemoActaTraitementsProduitsCateg();
        this.checkForDemoCommunes();
        this.checkForDemoDepartments();
        this.checkForDemoMateriels();
        this.checkForDemoSolsArvalis();
        this.checkForDemoStatutJuridique();
        this.checkForDemoEspeces();
        this.checkForDemoVarietesGeves();
        this.checkForDemoVarietesPlantGrape();
        this.checkForDemoClonesPlantGrape();
        this.checkForDemoEspecesToVarietes();
        this.checkForDemoOtex();
        this.checkForDemoOrientationEdi();
        this.checkForDemoInterventionAgrosysytTravailEdi();
        this.checkForDemoTypeTravailEdi();
        this.checkForDemoStadesEdi();
        this.checkForDemoParcelleZonageEdi();
        this.checkForDemoSolTextureGeppa();
        this.checkForDemoSolProfondeurIndigo();
        this.checkForDemoSolCaracteristiquesIndigo();
        this.checkForDemoUnitesEdi();
        this.checkForDemoFertiMinUNIFA();
        this.checkForDemoBioAgressors();
        this.checkForDemoRefFertiOrga();
        this.checkForDemoFertiEngraisOrg();
        this.checkForDemoStationMeteo();
        this.checkForDemoTypeAgriculture();
        this.checkForDemoIndicatorReferentials();
        this.checkForDemoMesureReferentials();
        this.checkForDemoSupportOrganeEdi();
        this.checkForDemoActaSubstanceActive();
        this.checkForDemoProtocoleVgObs();
        this.checkForDemoElementVoisinage();
        this.checkForDemoIphyReferentials();
        this.checkForDemoActaDosageSpc();
        this.checkForDemoActaGroupeCultures();
        this.checkForDemoLienCulturesEdiActa();
        this.checkForDemoSaActaIphy();
        this.checkForDemoTraitSdC();
        this.checkForDemoCouvSolAnnuelle();
        this.checkForDemoCultureEdiGroupeCouvSol();
        this.checkForDemoCouvSolPerenne();
        this.checkForDemoZoneClimatiqueIphy();
    }

    public void checkForBuiltinUsers() {
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        if (userTopiaDao.count() == 0L) {
            this.createDemoUsers();
            this.promuteAdmins();
            this.promuteIsDataProcessors();
        }
        this.getTransaction().commit();
    }

    public void checkForDemoDatas() {
        PracticedSystemTopiaDao practicedSystemTopiaDao;
        DomainTopiaDao domainTopiaDao;
        NetworkTopiaDao networkTopiaDao;
        AgrosystUserTopiaDao userTopiaDao;
        this.checkForDemoReferentials();
        MessageTopiaDao messageTopiaDao = this.context.getPersistenceContext().getMessageDao();
        if (messageTopiaDao.count() == 0L) {
            this.createBrodcastInfoMessage();
        }
        if ((userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao()).count() == 0L) {
            this.createDemoUsers();
            this.promuteAdmins();
            this.promuteIsDataProcessors();
        }
        if ((networkTopiaDao = this.context.getPersistenceContext().getNetworkDao()).count() == 0L) {
            this.createDemoNetworks();
            this.promuteNetworkResponsibles();
        }
        if ((domainTopiaDao = this.context.getPersistenceContext().getDomainDao()).count() == 0L) {
            this.createDemoDomains();
            this.createDemoInterventionCulturales();
            this.promuteDomainResponsibles();
            this.promuteGrowingPlanResponsibles();
            this.promuteGrowingSystemDataProcessors();
            this.promuteLutinsDomainResponsibles();
        }
        if ((practicedSystemTopiaDao = this.context.getPersistenceContext().getPracticedSystemDao()).count() == 0L) {
            this.createDemoPracticedSystems();
        }
    }

    protected void createPlots(Domain domain) {
        GrowingPlanTopiaDao growingPlanTopiaDao = this.context.getPersistenceContext().getGrowingPlanDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = this.context.getPersistenceContext().getGrowingSystemDao();
        int count = this.random.nextInt(4);
        for (int i = 0; i < count; ++i) {
            RefLocation location = domain.getLocation();
            List growingPlans = growingPlanTopiaDao.forDomainEquals(domain).findAll();
            if (growingPlans != null && !growingPlans.isEmpty()) {
                GrowingPlan growingPlan = (GrowingPlan)this.randomElem(growingPlans);
                GrowingSystem growingSystem = (GrowingSystem)growingSystemTopiaDao.forGrowingPlanEquals(growingPlan).findAnyOrNull();
                if (growingSystem == null) continue;
                String plotName = String.format("Parcelle %s %d", domain.getName(), i + 1);
                boolean active = true;
                if (!growingSystem.isActive()) {
                    active = false;
                }
                this.createPlots(domain, plotName, this.randomDouble(30.0, 100.0, 0), i, 47.21, -1.49, "", growingSystem, location, this.randomEnum(MaxSlope.values()), this.randomEnum(BufferStrip.values()), this.randomEnum(WaterFlowDistance.values()), active);
                continue;
            }
            this.createPlots(domain, String.format("Parcelle %s %d (libre)", domain.getName(), i), this.randomDouble(30.0, 100.0, 0), 15, -41.2, 0.6, null, null, domain.getLocation(), this.randomEnum(MaxSlope.values()), this.randomEnum(BufferStrip.values()), this.randomEnum(WaterFlowDistance.values()), true);
        }
        this.context.getTransaction().commit();
    }

    protected void createBrodcastInfoMessage() {
        log.info((Object)"Cr\u00e9ation d'un message de test.");
        MessageTopiaDao messageTopiaDao = this.context.getPersistenceContext().getMessageDao();
        Message message = (Message)messageTopiaDao.newInstance();
        message.setMessageDate(new Date());
        message.setTitle("Information concernant cette instance d'Agrosyst");
        message.setContent("<h1>Ce message est un message de test</h1>      <h2>Il ne faut pas en tenir compte</h2>      <p>Agrosyst est un syst\u00e8me d\u2019information d\u00e9di\u00e9 \u00e0 la description et l\u2019\u00e9valuation des syst\u00e8mes de culture. Il a \u00e9t\u00e9 d\u00e9velopp\u00e9 par l\u2019INRA, dans le cadre du plan ECOPHYTO financ\u00e9 par l\u2019ONEMA, pour le compte du r\u00e9seau DEPHY, en partenariat avec le minist\u00e8re en charge de l\u2019agriculture, la Cellule d\u2019Animation Nationale du r\u00e9seau DEPHY  et de nombreux acteurs (techniciens et ing\u00e9nieurs des chambres d\u2019agriculture ou des instituts techniques, experts) repr\u00e9sent\u00e9s au sein du Comit\u00e9 des Partenaires.</p>      <h3>Ceci est un message fictif !</h3>      <p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore </p>      <p>magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut </p>      <p>aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum </p>      <p>dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa </p>      <p>qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit </p>      <p>in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero </p>      <p>eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis </p>");
        messageTopiaDao.create((TopiaEntity)message);
        this.context.getTransaction().commit();
    }

    protected void createPlots(Domain domain, String name, Double area, Integer pacIlotNumber, Double latitude, Double longitude, String comment, GrowingSystem growingSystem, RefLocation location, MaxSlope maxSlope, BufferStrip bufferStrip, WaterFlowDistance waterFlowDistance, boolean active) {
        PlotTopiaDao plotTopiaDao = this.context.getPersistenceContext().getPlotDao();
        ZoneTopiaDao zoneTopiaDao = this.context.getPersistenceContext().getZoneDao();
        Plot plot = (Plot)plotTopiaDao.create("domain", domain, new Object[]{"area", area, "comment", comment, "growingSystem", growingSystem, "latitude", latitude, "location", location, "longitude", longitude, "maxSlope", maxSlope, "bufferStrip", bufferStrip, "name", name, "pacIlotNumber", pacIlotNumber, "waterFlowDistance", waterFlowDistance, "active", active, "code", UUID.randomUUID().toString()});
        zoneTopiaDao.create("plot", plot, new Object[]{"name", "Zone principale", "area", area, "active", active, "type", ZoneType.PRINCIPALE, "code", UUID.randomUUID().toString()});
    }

    protected void createDemoUser(AgrosystUserTopiaDao userTopiaDao, String firstName, String lastName, String email, String org, String phone) {
        String password = StringUtil.encodeSHA1((String)"password");
        if (ADMIN_EMAILS.contains(email)) {
            password = StringUtil.encodeSHA1((String)";;password..");
        }
        userTopiaDao.create("email", email, new Object[]{"password", password, "firstName", firstName, "lastName", lastName, "organisation", org, "phoneNumber", phone, "active", org != null});
    }

    protected void createDemoUsers() {
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        if (log.isInfoEnabled()) {
            log.info((Object)"Cr\u00e9ation des utilisateurs...");
        }
        this.createDemoUser(userTopiaDao, "Admin", "Admin", "admin@inra.fr", null, null);
        this.createDemoUser(userTopiaDao, "Antoine", "Schellenberger", "antoine.schellenberger@orleans.inra.fr", "INRA Orl\u00e9ans", null);
        this.createDemoUser(userTopiaDao, "Estelle", "Ancelet", "estelle.ancelet@orleans.inra.fr", "INRA Orl\u00e9ans", null);
        this.createDemoUser(userTopiaDao, "Oph\u00e9lie", "Jolys", "ophelie.jolys@dijon.inra.fr", "INRA Dijon", null);
        this.createDemoUser(userTopiaDao, "Nicolas", "Munier-Jolain", "nicolas.munier-jolain@dijon.inra.fr", "INRA Dijon", null);
        this.createDemoUser(userTopiaDao, "Sophie", "Buleon", "sophie.buleon@ardeche.chambagri.fr", "CA Ardeche/Drome", null);
        this.createDemoUser(userTopiaDao, "David", "Lafond", "david.lafond@vignevin.com", "Institut fran\u00e7ais de la vigne et du vin, Angers", null);
        this.createDemoUser(userTopiaDao, "David", "Bouill\u00e9", "david.bouille@ille-et-vilaine.chambagri.fr", "CA Ille-et-Vilaine", null);
        this.createDemoUser(userTopiaDao, "Arnaud", "Thimel", "thimel@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "\u00c9ric", "Chatellier", "chatellier@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "L\u00e9o", "Kaufmann", "kaufmann@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "David", "Coss\u00e9", "cosse@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Jean", "Couteau", "couteau@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Kevin", "Morin", "morin@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Samuel", "Maisonneuve", "maisonneuve@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Benjamin", "Poussin", "poussin@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Estelle", "Gendron", "gendron@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Sylvain", "Bavencoff", "bavencoff@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Julien", "Ruchaud", "ruchaud@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Yannick", "Martel", "martel@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Tony", "Chemit", "chemit@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "Brendan", "Le Ny", "leny@codelutin.com", "Code Lutin", "02.40.50.29.28");
        this.createDemoUser(userTopiaDao, "D\u00e9mo", "User", "demo@inra.fr", "D\u00e9mo", null);
        this.createDemoUser(userTopiaDao, "Resp.", "IT1", "rr@inra.fr", "Test", null);
        this.createDemoUser(userTopiaDao, "Resp.", "\u00c0 l'or\u00e9e des champs", "rd@inra.fr", "Test", null);
        this.createDemoUser(userTopiaDao, "Resp.", "BioPlan 0", "rgp@inra.fr", "Test", null);
        this.createDemoUser(userTopiaDao, "Expl. SdC", "Campagne", "egsc@inra.fr", "Test", null);
        this.createDemoUser(userTopiaDao, "Expl. SdC", "Tout", "egsi@inra.fr", "Test", null);
        this.createDemoUser(userTopiaDao, "Expl.", "SI", "esi@inra.fr", "Test", null);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%d utilisateurs cr\u00e9\u00e9s.", userTopiaDao.count()));
        }
        this.getTransaction().commit();
    }

    protected void promuteAdmins() {
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = this.context.getPersistenceContext().getUserRoleDao();
        List users = userTopiaDao.findAll();
        Iterable admins = Iterables.filter((Iterable)users, (Predicate)new Predicate<AgrosystUser>(){

            public boolean apply(AgrosystUser user) {
                String email = user.getEmail();
                boolean result = user.isActive() && ADMIN_EMAILS.contains(email);
                return result;
            }
        });
        long countBefore = userRoleTopiaDao.count();
        for (AgrosystUser admin : admins) {
            userRoleTopiaDao.create("agrosystUser", admin, new Object[]{"type", RoleType.ADMIN});
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%d utilisateurs promus Admins.", userRoleTopiaDao.count() - countBefore));
        }
        this.getTransaction().commit();
    }

    protected void promuteIsDataProcessors() {
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = this.context.getPersistenceContext().getUserRoleDao();
        Optional any = userTopiaDao.forEmailEquals("esi@inra.fr").tryFindAny();
        if (any.isPresent()) {
            userRoleTopiaDao.create("agrosystUser", any.get(), new Object[]{"type", RoleType.IS_DATA_PROCESSOR});
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Utilisateur '%s' promu Exploitant SI.", ((AgrosystUser)any.get()).getEmail()));
            }
        }
        this.getTransaction().commit();
    }

    protected void promuteDomainResponsibles() {
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = this.context.getPersistenceContext().getUserRoleDao();
        DomainTopiaDao domainTopiaDao = this.context.getPersistenceContext().getDomainDao();
        AgrosystUser user = (AgrosystUser)userTopiaDao.forEmailEquals("rd@inra.fr").findAny();
        if (user.getEmail().equals("rd@inra.fr")) {
            Domain domain = (Domain)domainTopiaDao.forNameEquals("\u00c0 l'or\u00e9e des champs").findAny();
            userRoleTopiaDao.create("agrosystUser", user, new Object[]{"type", RoleType.DOMAIN_RESPONSIBLE, "domainCode", domain.getCode()});
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Utilisateur '%s' promu responsable du domaine '%s' ", user.getEmail(), domain.getName()));
            }
        }
    }

    protected void promuteLutinsDomainResponsibles() {
        String[] emails;
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = this.context.getPersistenceContext().getUserRoleDao();
        DomainTopiaDao domainTopiaDao = this.context.getPersistenceContext().getDomainDao();
        for (String email : emails = new String[]{"poussin@codelutin.com", "gendron@codelutin.com", "bavencoff@codelutin.com", "ruchaud@codelutin.com", "martel@codelutin.com", "chemit@codelutin.com", "leny@codelutin.com"}) {
            AgrosystUser user = (AgrosystUser)userTopiaDao.forEmailEquals(email).findAny();
            Domain domain = null;
            while (domain == null) {
                String domainName = this.randomElem(DOMAIN_NAMES);
                domain = (Domain)domainTopiaDao.forNameEquals(domainName).findAnyOrNull();
            }
            userRoleTopiaDao.create("agrosystUser", user, new Object[]{"type", RoleType.DOMAIN_RESPONSIBLE, "domainCode", domain.getCode()});
            if (!log.isInfoEnabled()) continue;
            log.info((Object)String.format("Utilisateur '%s' promu responsable du domaine '%s' ", user.getEmail(), domain.getName()));
        }
    }

    protected void promuteGrowingPlanResponsibles() {
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = this.context.getPersistenceContext().getUserRoleDao();
        GrowingPlanTopiaDao growingPlanTopiaDao = this.context.getPersistenceContext().getGrowingPlanDao();
        AgrosystUser user = (AgrosystUser)userTopiaDao.forEmailEquals("rgp@inra.fr").findAny();
        GrowingPlan gp = (GrowingPlan)growingPlanTopiaDao.findAllLazy().iterator().next();
        userRoleTopiaDao.create("agrosystUser", user, new Object[]{"type", RoleType.GROWING_PLAN_RESPONSIBLE, "growingPlanCode", gp.getCode()});
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Utilisateur '%s' promu responsable du dispositif '%s' ", user.getEmail(), gp.getName()));
        }
    }

    protected void promuteNetworkResponsibles() {
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = this.context.getPersistenceContext().getUserRoleDao();
        NetworkTopiaDao networkTopiaDao = this.context.getPersistenceContext().getNetworkDao();
        AgrosystUser user = (AgrosystUser)userTopiaDao.forEmailEquals("rr@inra.fr").findAny();
        Network network = (Network)networkTopiaDao.forNameEquals("IT1").findAny();
        userRoleTopiaDao.create("agrosystUser", user, new Object[]{"type", RoleType.NETWORK_RESPONSIBLE, "networkId", network.getTopiaId()});
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Utilisateur '%s' promu responsable du r\u00e9seau  '%s'", user.getEmail(), network.getName()));
        }
    }

    protected void promuteGrowingSystemDataProcessors() {
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = this.context.getPersistenceContext().getUserRoleDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = this.context.getPersistenceContext().getGrowingSystemDao();
        GrowingSystem gs = (GrowingSystem)growingSystemTopiaDao.findAllLazy().iterator().next();
        AgrosystUser user = (AgrosystUser)userTopiaDao.forEmailEquals("egsi@inra.fr").findAny();
        userRoleTopiaDao.create("agrosystUser", user, new Object[]{"type", RoleType.GS_DATA_PROCESSOR, "growingSystemCode", gs.getCode()});
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Utilisateur '%s' promu exploitant SdC du SdC '%s'", user.getEmail(), gs.getName()));
        }
        user = (AgrosystUser)userTopiaDao.forEmailEquals("egsc@inra.fr").findAny();
        userRoleTopiaDao.create("agrosystUser", user, new Object[]{"type", RoleType.GS_DATA_PROCESSOR, "growingSystemId", gs.getTopiaId()});
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Utilisateur '%s' promu exploitant SdC du SdC '%s' pour la campagne %d", user.getEmail(), gs.getName(), gs.getGrowingPlan().getDomain().getCampaign()));
        }
    }

    public void createDemoDomains() {
        if (log.isInfoEnabled()) {
            log.info((Object)"G\u00e9n\u00e9ration des domaines...");
        }
        DomainTopiaDao domainTopiaDao = this.context.getPersistenceContext().getDomainDao();
        RefLocationTopiaDao refLocationTopiaDao = this.context.getPersistenceContext().getRefLocationDao();
        List locations = refLocationTopiaDao.findAll();
        RefLegalStatusTopiaDao refLegalStatusTopiaDao = this.context.getPersistenceContext().getRefLegalStatusDao();
        RefLegalStatus refLegalStatus = (RefLegalStatus)refLegalStatusTopiaDao.forCode_INSEEEquals(16).findUnique();
        MultiKeyMap nameAndCampaignMap = new MultiKeyMap();
        for (int i = 0; i < 100; ++i) {
            Domain domain;
            String name = this.randomElem(DOMAIN_NAMES);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Cr\u00e9ation du domaine '%s' (%d/%d)", name, i + 1, 100));
            }
            int initialCampaign = this.randomElem(CAMPAIGNS);
            Domain existingDomain = (Domain)nameAndCampaignMap.get((Object)name, (Object)initialCampaign);
            int campaign = initialCampaign;
            if (existingDomain == null) {
                domain = (Domain)domainTopiaDao.create("name", name, new Object[]{"campaign", initialCampaign, "mainContact", this.randomElem(CONTACTS), "active", true, "type", this.randomEnum(DomainType.values()), "description", this.randomElem(LOREM_IPSUM), "location", this.randomElem(locations), "legalStatus", refLegalStatus, "croppingPlanComment", this.randomElem(LOREM_IPSUM), "otherActivitiesComment", this.randomElem(LOREM_IPSUM), "code", UUID.randomUUID().toString(), "usedAgriculturalArea", this.randomDouble(10.0, 50.0, 0), "otherWorkForce", this.randomDouble(0.0, 3.0, 0), "temporaryEmployeesWorkForce", this.randomDouble(0.0, 3.0, 0), "permanentEmployeesWorkForce", this.randomDouble(0.0, 3.0, 0), "updateDate", this.context.getCurrentDate(), "validationDate", this.context.getCurrentDate(), "validated", true});
                this.createGpsDatas(domain);
                this.createGrowingPlans(domain);
                this.createCroppingPlan(domain);
                this.createSolsArvalis(domain);
                this.createMaterielAndTooling(domain);
                this.createPlots(domain);
                nameAndCampaignMap.put((Object)name, (Object)initialCampaign, (Object)domain);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)String.format("Nouveau domaine '%s' pour la campagne %d", name, campaign));
                continue;
            }
            do {
                existingDomain = (Domain)nameAndCampaignMap.get((Object)name, (Object)campaign);
            } while (nameAndCampaignMap.get((Object)name, (Object)(++campaign)) != null);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Prolongation du domaine '%s' sur la campagne %d", name, campaign));
            }
            try {
                domain = this.domainService.extendDomain(existingDomain.getTopiaId(), campaign);
                nameAndCampaignMap.put((Object)name, (Object)campaign, (Object)domain);
                continue;
            }
            catch (DomainExtendException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Un exception occured", (Throwable)e);
            }
        }
        this.context.getTransaction().commit();
        if (log.isInfoEnabled()) {
            log.info((Object)(domainTopiaDao.count() + " domaines cr\u00e9\u00e9s"));
        }
    }

    protected List<GeoPoint> createGpsDatas(Domain domain) {
        GeoPointTopiaDao gpsDatasTopiaDao = this.context.getPersistenceContext().getGeoPointDao();
        GeoPoint gpsData2 = (GeoPoint)gpsDatasTopiaDao.create("description", this.randomElem(LOREM_IPSUM), new Object[]{"longitude", -0.04972, "latitude", 48.49163, "name", this.randomName(LOREM_IPSUM_WORDS), "domain", domain});
        ArrayList gpsDatas = Lists.newArrayList((Object[])new GeoPoint[]{gpsData2});
        return gpsDatas;
    }

    protected void createCroppingPlan(Domain domain) {
        CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao = this.context.getPersistenceContext().getCroppingPlanEntryDao();
        CroppingPlanSpeciesTopiaDao croppingPlanSpeciesTopiaDao = this.context.getPersistenceContext().getCroppingPlanSpeciesDao();
        for (int j = 0; j < 6; ++j) {
            RefEspece refEspece = this.randomEspece();
            CroppingPlanEntry entry = (CroppingPlanEntry)croppingPlanEntryTopiaDao.create("domain", domain, new Object[]{"name", refEspece.getLibelle_espece_botanique(), "sellingPrice", this.randomDouble(10.0, 90.0, 2), "type", this.randomElem(CROPPING_ENTRY_TYPES), "code", UUID.randomUUID().toString()});
            for (int i = 0; i < 3; ++i) {
                RefVarietePlantGrape refVariete = null;
                if ("ZMO".equals(refEspece.getCode_espece_botanique())) {
                    if (i > 0) {
                        refVariete = this.randomVarietePlantGrape();
                    }
                } else if (i > 0) {
                    refVariete = this.randomVarieteGeves();
                }
                CroppingPlanSpecies species = (CroppingPlanSpecies)croppingPlanSpeciesTopiaDao.create("croppingPlanEntry", entry, new Object[]{"species", refEspece, "variety", refVariete, "code", UUID.randomUUID().toString()});
                entry.addCroppingPlanSpecies(species);
            }
        }
    }

    protected RefSolArvalis randomRefSolArvalis() {
        if (this.solArvalis.isEmpty()) {
            RefSolArvalisTopiaDao solArvalisTopiaDao = this.context.getPersistenceContext().getRefSolArvalisDao();
            List ids = solArvalisTopiaDao.findAllIds();
            for (int i = 0; i < 100; ++i) {
                this.solArvalis.add((RefSolArvalis)solArvalisTopiaDao.forTopiaIdEquals((String)this.randomElem(ids)).findUnique());
            }
        }
        return this.randomElem(this.solArvalis);
    }

    protected void createSolsArvalis(Domain domain) {
        GroundTopiaDao solTopiaDao = this.context.getPersistenceContext().getGroundDao();
        for (int i = 0; i < 3; ++i) {
            RefSolArvalis refSolArvalis = this.randomRefSolArvalis();
            solTopiaDao.create("name", refSolArvalis.getSol_nom(), new Object[]{"refSolArvalis", refSolArvalis, "importance", this.randomDouble(100.0), "comment", this.randomElem(LOREM_IPSUM), "domain", domain});
        }
    }

    protected RefMateriel randomRefMateriel() {
        if (this.refMateriel.isEmpty()) {
            RefMaterielTopiaDao refMaterielTopiaDao = this.context.getPersistenceContext().getRefMaterielDao();
            List ids = refMaterielTopiaDao.findAllIds();
            for (int i = 0; i < 100; ++i) {
                this.refMateriel.add((RefMateriel)refMaterielTopiaDao.forTopiaIdEquals((String)this.randomElem(ids)).findUnique());
            }
        }
        return this.randomElem(this.refMateriel);
    }

    protected void createMaterielAndTooling(Domain domain) {
        ArrayList mainsActions;
        EquipmentTopiaDao equipmentTopiaDao = this.context.getPersistenceContext().getEquipmentDao();
        Equipment materielTracteur = null;
        Equipment materielOutils = null;
        Equipment materielAutomoteur = null;
        Equipment materielIrrigation = null;
        for (int i = 0; i < 10; ++i) {
            String name;
            RefMateriel refMateriel = null;
            if (i == 5) {
                name = "Autre " + i;
            } else {
                refMateriel = this.randomRefMateriel();
                name = refMateriel.getTypeMateriel1() + " " + i;
            }
            Equipment materiel = (Equipment)equipmentTopiaDao.create("refMateriel", refMateriel, new Object[]{"name", name, "materielETA", i % 2 == 0, "description", this.randomElem(LOREM_IPSUM), "code", UUID.randomUUID().toString(), "domain", domain});
            if (refMateriel == null) continue;
            Class<?> klass = refMateriel.getClass();
            if (RefMaterielAutomoteur.class.isAssignableFrom(klass)) {
                materielAutomoteur = materiel;
                continue;
            }
            if (RefMaterielTraction.class.isAssignableFrom(klass)) {
                materielTracteur = materiel;
                continue;
            }
            if (RefMaterielOutil.class.isAssignableFrom(klass)) {
                materielOutils = materiel;
                continue;
            }
            if (!RefMaterielIrrigation.class.isAssignableFrom(klass)) continue;
            materielIrrigation = materiel;
        }
        ToolsCouplingTopiaDao toolsCouplingTopiaDao = this.context.getPersistenceContext().getToolsCouplingDao();
        if (materielAutomoteur != null) {
            mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{this.randomActionTravailEDI(AgrosystInterventionType.TRAVAIL_DU_SOL), this.randomActionTravailEDI(AgrosystInterventionType.IRRIGATION), this.randomActionTravailEDI(AgrosystInterventionType.RECOLTE)});
            toolsCouplingTopiaDao.create("tractor", materielAutomoteur, new Object[]{"mainsActions", mainsActions, "toolsCouplingName", "Intervention Automoteur", "code", UUID.randomUUID().toString(), "domain", domain});
        }
        if (materielTracteur != null && (materielOutils != null || materielIrrigation != null)) {
            mainsActions = Lists.newArrayList((Object[])new RefInterventionAgrosystTravailEDI[]{this.randomActionTravailEDI(AgrosystInterventionType.ENTRETIEN_TAILLE_VIGNE_ET_VERGER), this.randomActionTravailEDI(AgrosystInterventionType.LUTTE_BIOLOGIQUE), this.randomActionTravailEDI(AgrosystInterventionType.RECOLTE)});
            ToolsCoupling coupling = (ToolsCoupling)toolsCouplingTopiaDao.create("tractor", materielTracteur, new Object[]{"mainsActions", mainsActions, "toolsCouplingName", "Intervention Tracteur", "code", UUID.randomUUID().toString(), "domain", domain});
            if (materielOutils != null) {
                coupling.addEquipments(materielOutils);
            }
            if (materielIrrigation != null) {
                coupling.addEquipments(materielIrrigation);
            }
        }
    }

    protected RefVarietePlantGrape randomVarietePlantGrape() {
        if (this.varietePlantGrapes.isEmpty()) {
            RefVarietePlantGrapeTopiaDao refVarietePlantGrapeTopiaDao = this.context.getPersistenceContext().getRefVarietePlantGrapeDao();
            List ids = refVarietePlantGrapeTopiaDao.findAllIds();
            for (int i = 0; i < 100; ++i) {
                this.varietePlantGrapes.add((RefVarietePlantGrape)refVarietePlantGrapeTopiaDao.forTopiaIdEquals((String)this.randomElem(ids)).findUnique());
            }
        }
        return this.randomElem(this.varietePlantGrapes);
    }

    protected RefVarieteGeves randomVarieteGeves() {
        if (this.varieteGeveses.isEmpty()) {
            RefVarieteGevesTopiaDao refVarieteGevesTopiaDao = this.context.getPersistenceContext().getRefVarieteGevesDao();
            List ids = refVarieteGevesTopiaDao.findAllIds();
            for (int i = 0; i < 100; ++i) {
                this.varieteGeveses.add((RefVarieteGeves)refVarieteGevesTopiaDao.forTopiaIdEquals((String)this.randomElem(ids)).findUnique());
            }
        }
        return this.randomElem(this.varieteGeveses);
    }

    protected RefEspece randomEspece() {
        if (this.especes.isEmpty()) {
            RefEspeceTopiaDao refEspeceTopiaDao = this.context.getPersistenceContext().getRefEspeceDao();
            List ids = refEspeceTopiaDao.findAllIds();
            for (int i = 0; i < 100; ++i) {
                this.especes.add((RefEspece)refEspeceTopiaDao.forTopiaIdEquals((String)this.randomElem(ids)).findUnique());
            }
        }
        return this.randomElem(this.especes);
    }

    protected List<GrowingPlan> createGrowingPlans(Domain domain) {
        int count = this.random.nextInt(2) + 1;
        GrowingPlanTopiaDao dispositifTopiaDao = this.context.getPersistenceContext().getGrowingPlanDao();
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i <= count; ++i) {
            String name = this.randomName(LOREM_IPSUM_WORDS) + " " + dispositifTopiaDao.count();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("[%s/%d] G\u00e9n\u00e9ration du dispositif : %s", domain.getName(), domain.getCampaign(), name));
            }
            GrowingPlan growingPlan = (GrowingPlan)dispositifTopiaDao.create("name", name, new Object[]{"type", this.randomEnum(TypeDEPHY.values()), "domain", domain, "active", true, "code", UUID.randomUUID().toString(), "updateDate", this.context.getCurrentDate(), "validationDate", this.context.getCurrentDate(), "validated", true});
            this.createGrowingSystems(domain, growingPlan);
        }
        this.context.getTransaction().commit();
        return result;
    }

    protected void createDemoNetworks() {
        String name;
        int i;
        String authenticationToken;
        NetworkTopiaDao networkTopiaDao = this.context.getPersistenceContext().getNetworkDao();
        NetworkManagerTopiaDao networkManagerTopiaDao = this.context.getPersistenceContext().getNetworkManagerDao();
        AgrosystUserTopiaDao userTopiaDao = this.context.getPersistenceContext().getAgrosystUserDao();
        UserDto userDto = this.authenticationService.login("thimel@codelutin.com", ";;password..");
        if (userDto != null && !Strings.isNullOrEmpty((String)(authenticationToken = userDto.getAuthenticationToken()))) {
            ((DefaultServiceContext)this.context).setAuthenticationToken(authenticationToken);
            if (log.isInfoEnabled()) {
                log.info((Object)("Login success, will generate DemoData as " + userDto.getEmail()));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"G\u00e9n\u00e9ration des r\u00e9seaux...");
        }
        List users = userTopiaDao.findAll();
        HashMap networks = Maps.newHashMap();
        NetworkManager nCanManager = (NetworkManager)networkManagerTopiaDao.newInstance();
        nCanManager.setAgrosystUser((AgrosystUser)this.randomElem(users));
        nCanManager.setActive(true);
        if (log.isInfoEnabled()) {
            log.info((Object)"G\u00e9n\u00e9ration du r\u00e9seau : CAN");
        }
        Network nCan = (Network)networkTopiaDao.newInstance();
        nCan.setName("CAN");
        nCan.setActive(true);
        nCan = this.networkService.createOrUpdateNetwork(nCan, (Collection)Lists.newArrayList((Object[])new NetworkManagerDto[]{(NetworkManagerDto)Networks.TO_MANAGER_DTO.apply((Object)nCanManager)}), null);
        networks.put(nCan.getName(), nCan);
        for (i = 0; i < 3; ++i) {
            NetworkManager nMExpe = (NetworkManager)networkManagerTopiaDao.newInstance();
            nMExpe.setAgrosystUser((AgrosystUser)this.randomElem(users));
            nMExpe.setActive(true);
            name = "EXPE" + i;
            if (log.isInfoEnabled()) {
                log.info((Object)("G\u00e9n\u00e9ration du r\u00e9seau : " + name));
            }
            Network nExpe = (Network)networkTopiaDao.newInstance();
            nExpe.setName(name);
            nExpe.setActive(true);
            nExpe = this.networkService.createOrUpdateNetwork(nExpe, (Collection)Lists.newArrayList((Object[])new NetworkManagerDto[]{(NetworkManagerDto)Networks.TO_MANAGER_DTO.apply((Object)nMExpe)}), (List)Lists.newArrayList((Object[])new String[]{nCan.getTopiaId()}));
            networks.put(nExpe.getName(), nExpe);
            NetworkManager nMIt = (NetworkManager)networkManagerTopiaDao.newInstance();
            nMIt.setAgrosystUser((AgrosystUser)this.randomElem(users));
            nMIt.setActive(true);
            name = "IT" + i;
            if (log.isInfoEnabled()) {
                log.info((Object)("G\u00e9n\u00e9ration du r\u00e9seau : " + name));
            }
            Network nIt = (Network)networkTopiaDao.newInstance();
            nIt.setName("IT" + i);
            nIt.setActive(true);
            nIt = this.networkService.createOrUpdateNetwork(nIt, (Collection)Lists.newArrayList((Object[])new NetworkManagerDto[]{(NetworkManagerDto)Networks.TO_MANAGER_DTO.apply((Object)nMIt)}), (List)Lists.newArrayList((Object[])new String[]{nCan.getTopiaId()}));
            networks.put(nIt.getName(), nIt);
        }
        for (i = 0; i < 3; ++i) {
            NetworkManager nMIr = (NetworkManager)networkManagerTopiaDao.newInstance();
            nMIr.setAgrosystUser((AgrosystUser)this.randomElem(users));
            nMIr.setActive(true);
            name = "IR" + i;
            if (log.isInfoEnabled()) {
                log.info((Object)("G\u00e9n\u00e9ration du r\u00e9seau : " + name));
            }
            Network nIr = (Network)networkTopiaDao.newInstance();
            nIr.setName(name);
            nIr.setActive(true);
            nIr = this.networkService.createOrUpdateNetwork(nIr, (Collection)Lists.newArrayList((Object[])new NetworkManagerDto[]{(NetworkManagerDto)Networks.TO_MANAGER_DTO.apply((Object)nMIr)}), (List)Lists.newArrayList((Object[])new String[]{((Network)networks.get("IT1")).getTopiaId()}));
            networks.put(nIr.getName(), nIr);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%d r\u00e9seaux cr\u00e9\u00e9s.", networkTopiaDao.count()));
        }
        this.context.getTransaction().commit();
    }

    protected void createGrowingSystems(Domain domain, GrowingPlan growingPlan) {
        int count = this.random.nextInt(2) + 1;
        NetworkTopiaDao networkTopiaDao = this.context.getPersistenceContext().getNetworkDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = this.context.getPersistenceContext().getGrowingSystemDao();
        List allNetworks = networkTopiaDao.findAll();
        ArrayList networks = Lists.newArrayList((Iterable)Iterables.filter((Iterable)allNetworks, SDC_COMPLIANT_NETWORKS));
        for (int i = 0; i < count; ++i) {
            String dephyNumber = String.format("Y%sK%s", Strings.padStart((String)("" + this.random.nextInt(1000)), (int)3, (char)'0'), Strings.padStart((String)("" + i), (int)3, (char)'0'));
            String name = this.randomName(LOREM_IPSUM_WORDS) + " " + growingSystemTopiaDao.count();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("[%s/%d - %s] G\u00e9n\u00e9ration du syst\u00e8me de culture : %s", domain.getName(), domain.getCampaign(), growingPlan.getName(), name));
            }
            growingSystemTopiaDao.create("name", name, new Object[]{"dephyNumber", dephyNumber, "networks", Arrays.asList((Network)this.randomElem(networks)), "growingPlan", growingPlan, "sector", this.randomEnum(Sector.values()), "active", true, "startingDate", new Date(), "code", UUID.randomUUID().toString(), "affectedAreaRate", this.randomDouble(70.0, 100.0, 0), "updateDate", this.context.getCurrentDate()});
        }
        this.context.getTransaction().commit();
    }

    protected void createDemoPracticedSystems() {
        if (log.isInfoEnabled()) {
            log.info((Object)"G\u00e9n\u00e9ration de 100 syst\u00e8mes synth\u00e9tis\u00e9s...");
        }
        PracticedSystemTopiaDao practicedSystemTopiaDao = this.context.getPersistenceContext().getPracticedSystemDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = this.context.getPersistenceContext().getGrowingSystemDao();
        PracticedPlotTopiaDao practicedPlotTopiaDao = this.context.getPersistenceContext().getPracticedPlotDao();
        List growingSystems = growingSystemTopiaDao.findAll();
        for (int i = 0; i < 100; ++i) {
            String campaigns = i % 3 == 0 ? "2012,2013" : (i % 3 == 1 ? "2012,2013,2014" : "2013,2014,2015");
            PracticedSystem practicedSystem = (PracticedSystem)practicedSystemTopiaDao.create("name", "Syst\u00e8me synth\u00e9tis\u00e9 " + i, new Object[]{"growingSystem", this.randomElem(growingSystems), "source", this.randomEnum(PracticedSystemSource.values()), "campaigns", CommonService.ARRANGE_CAMPAIGNS.apply((Object)campaigns), "updateDate", this.context.getCurrentDate(), "active", true});
            this.createDemoPracticedCropCycles(practicedSystem);
            if (!this.random.nextBoolean()) continue;
            practicedPlotTopiaDao.create("practicedSystem", practicedSystem, new Object[]{"name", "Parcelle type " + i, "area", 42.0, "maxSlope", this.randomEnum(MaxSlope.values()), "bufferStrip", this.randomEnum(BufferStrip.values()), "waterFlowDistance", this.randomEnum(WaterFlowDistance.values())});
        }
        this.context.getTransaction().commit();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%d syst\u00e8mes synth\u00e9tis\u00e9s cr\u00e9\u00e9s.", practicedSystemTopiaDao.count()));
        }
    }

    protected void createDemoPracticedCropCycles(PracticedSystem practicedSystem) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cr\u00e9ation de donn\u00e9es de d\u00e9mo pour le syst\u00e8me synth\u00e9tis\u00e9 '" + practicedSystem.getName() + "'"));
        }
        PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleTopiaDao = this.context.getPersistenceContext().getPracticedSeasonalCropCycleDao();
        PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleTopiaDao = this.context.getPersistenceContext().getPracticedPerennialCropCycleDao();
        PracticedCropCyclePhaseTopiaDao cropCyclePhaseTopiaDao = this.context.getPersistenceContext().getPracticedCropCyclePhaseDao();
        PracticedCropCycleNodeTopiaDao cropCycleNodeTopiaDao = this.context.getPersistenceContext().getPracticedCropCycleNodeDao();
        PracticedCropCycleConnectionTopiaDao cropCycleConnectionTopiaDao = this.context.getPersistenceContext().getPracticedCropCycleConnectionDao();
        ArrayList phaseDurations = Lists.newArrayList((Object[])new Integer[]{5, 7, 3, 10, 15, 30});
        GrowingSystem growingSystem = practicedSystem.getGrowingSystem();
        List croppingPlans = this.domainService.getCroppingPlanDtos(growingSystem.getGrowingPlan().getDomain().getTopiaId());
        ArrayList mainCroppingPlans = Lists.newArrayList((Iterable)Iterables.filter((Iterable)croppingPlans, (Predicate)Predicates.not((Predicate)CroppingPlans.IS_ENTRY_INTERMEDIATE)));
        ArrayList inteCroppingPlans = Lists.newArrayList((Iterable)Iterables.filter((Iterable)croppingPlans, (Predicate)CroppingPlans.IS_ENTRY_INTERMEDIATE));
        if (!mainCroppingPlans.isEmpty()) {
            PracticedCropCyclePhase cropCyclePhaseTmp = (PracticedCropCyclePhase)cropCyclePhaseTopiaDao.newInstance();
            cropCyclePhaseTmp.setDuration((Integer)this.randomElem(phaseDurations));
            cropCyclePhaseTmp.setType(CropCyclePhaseType.PLEINE_PRODUCTION);
            PracticedCropCyclePhase cropCyclePhase = (PracticedCropCyclePhase)cropCyclePhaseTopiaDao.create((TopiaEntity)cropCyclePhaseTmp);
            ArrayList cropCyclePhases = Lists.newArrayList((Object[])new PracticedCropCyclePhase[]{cropCyclePhase});
            practicedPerennialCropCycleTopiaDao.create("practicedSystem", practicedSystem, new Object[]{"croppingPlanEntryCode", ((CroppingPlanEntryDto)this.randomElem(mainCroppingPlans)).getCode(), "cropCyclePhases", cropCyclePhases, "weedType", this.randomEnum(WeedType.values())});
            this.createDemoPracticedITK(practicedSystem, cropCyclePhase, null);
            PracticedSeasonalCropCycle practicedSeasonalCropCycle = (PracticedSeasonalCropCycle)practicedSeasonalCropCycleTopiaDao.create("practicedSystem", practicedSystem, new Object[0]);
            PracticedCropCycleNode node1 = (PracticedCropCycleNode)cropCycleNodeTopiaDao.create("practicedSeasonalCropCycle", practicedSeasonalCropCycle, new Object[]{"rank", 0, "croppingPlanEntryCode", ((CroppingPlanEntryDto)this.randomElem(mainCroppingPlans)).getCode()});
            PracticedCropCycleNode node2 = (PracticedCropCycleNode)cropCycleNodeTopiaDao.create("practicedSeasonalCropCycle", practicedSeasonalCropCycle, new Object[]{"rank", 1, "croppingPlanEntryCode", ((CroppingPlanEntryDto)this.randomElem(mainCroppingPlans)).getCode()});
            PracticedCropCycleNode node3 = (PracticedCropCycleNode)cropCycleNodeTopiaDao.create("practicedSeasonalCropCycle", practicedSeasonalCropCycle, new Object[]{"rank", 1, "y", 1, "croppingPlanEntryCode", ((CroppingPlanEntryDto)this.randomElem(mainCroppingPlans)).getCode()});
            PracticedCropCycleNode node4 = (PracticedCropCycleNode)cropCycleNodeTopiaDao.create("practicedSeasonalCropCycle", practicedSeasonalCropCycle, new Object[]{"rank", 2, "croppingPlanEntryCode", ((CroppingPlanEntryDto)this.randomElem(mainCroppingPlans)).getCode(), "endCycle", this.random.nextBoolean()});
            PracticedCropCycleConnection conn1 = (PracticedCropCycleConnection)cropCycleConnectionTopiaDao.create("source", node1, new Object[]{"target", node2, "croppingPlanEntryFrequency", 61});
            if (this.random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn1.setIntermediateCroppingPlanEntryCode(((CroppingPlanEntryDto)this.randomElem(inteCroppingPlans)).getCode());
            }
            PracticedCropCycleConnection conn2 = (PracticedCropCycleConnection)cropCycleConnectionTopiaDao.create("source", node1, new Object[]{"target", node3, "croppingPlanEntryFrequency", 39});
            if (this.random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn2.setIntermediateCroppingPlanEntryCode(((CroppingPlanEntryDto)this.randomElem(inteCroppingPlans)).getCode());
            }
            PracticedCropCycleConnection conn3 = (PracticedCropCycleConnection)cropCycleConnectionTopiaDao.create("source", node2, new Object[]{"target", node4, "croppingPlanEntryFrequency", 100});
            if (this.random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn3.setIntermediateCroppingPlanEntryCode(((CroppingPlanEntryDto)this.randomElem(inteCroppingPlans)).getCode());
            }
            PracticedCropCycleConnection conn4 = (PracticedCropCycleConnection)cropCycleConnectionTopiaDao.create("source", node3, new Object[]{"target", node4, "croppingPlanEntryFrequency", 100});
            if (this.random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn4.setIntermediateCroppingPlanEntryCode(((CroppingPlanEntryDto)this.randomElem(inteCroppingPlans)).getCode());
            }
            this.createDemoPracticedITK(practicedSystem, null, conn1);
            this.createDemoPracticedITK(practicedSystem, null, conn2);
            this.createDemoPracticedITK(practicedSystem, null, conn3);
            this.createDemoPracticedITK(practicedSystem, null, conn4);
        }
    }

    protected void createDemoPracticedITK(PracticedSystem practicedSystem, PracticedCropCyclePhase phase, PracticedCropCycleConnection conn) {
        HashSet speciesCodes;
        Preconditions.checkArgument((boolean)(conn == null ^ phase == null));
        PracticedInterventionTopiaDao practicedInterventionTopiaDao = this.context.getPersistenceContext().getPracticedInterventionDao();
        PracticedSpeciesStadeTopiaDao practicedSpeciesStadeDao = this.context.getPersistenceContext().getPracticedSpeciesStadeDao();
        CroppingPlanEntryTopiaDao croppingPlanEntryDao = this.context.getPersistenceContext().getCroppingPlanEntryDao();
        CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao = this.context.getPersistenceContext().getCroppingPlanSpeciesDao();
        if (conn != null) {
            String croppingPlanEntryCode = conn.getTarget().getCroppingPlanEntryCode();
            CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
            List croppingPlanSpecies = croppingPlanSpeciesDao.forCroppingPlanEntryEquals(croppingPlanEntry).findAll();
            speciesCodes = Sets.newHashSet((Iterable)Iterables.transform((Iterable)croppingPlanSpecies, (Function)new Function<CroppingPlanSpecies, String>(){

                public String apply(CroppingPlanSpecies croppingPlanSpecies) {
                    return croppingPlanSpecies.getCode();
                }
            }));
        } else {
            speciesCodes = Sets.newHashSet();
        }
        int count = this.random.nextInt(2) + 1;
        for (int i = 0; i < count; ++i) {
            AgrosystInterventionType type = this.randomEnum(AgrosystInterventionType.values());
            HashSet toolsCouplingCodes = Sets.newHashSet();
            ToolsCouplingTopiaDao toolsCouplingTopiaDao = this.context.getPersistenceContext().getToolsCouplingDao();
            List toolsCouplings = toolsCouplingTopiaDao.forDomainEquals(practicedSystem.getGrowingSystem().getGrowingPlan().getDomain()).findAll();
            if (toolsCouplings != null) {
                for (ToolsCoupling toolsCoupling : toolsCouplings) {
                    for (RefInterventionAgrosystTravailEDI action : toolsCoupling.getMainsActions()) {
                        if (action.getIntervention_agrosyst() != type) continue;
                        toolsCouplingCodes.add(toolsCoupling.getCode());
                    }
                }
            }
            ArrayList speciesStades = Lists.newArrayList();
            for (String speciesCode : speciesCodes) {
                PracticedSpeciesStade speciesStade = (PracticedSpeciesStade)practicedSpeciesStadeDao.create("speciesCode", speciesCode, new Object[0]);
                speciesStades.add(speciesStade);
            }
            String name = String.format("%s %s %s", this.randomElem(LOREM_IPSUM_WORDS), this.randomElem(LOREM_IPSUM_WORDS), this.randomElem(LOREM_IPSUM_WORDS));
            PracticedIntervention inter = (PracticedIntervention)practicedInterventionTopiaDao.create("practicedCropCycleConnection", conn, new Object[]{"practicedCropCyclePhase", phase, "name", name, "workRate", this.randomDouble(0.5, 1.5), "type", this.randomEnum(AgrosystInterventionType.values()), "toolsCouplingCodes", toolsCouplingCodes, "startingPeriodDate", this.randomInt(1, 28) + "/" + this.randomInt(1, 12), "endingPeriodDate", this.randomInt(1, 28) + "/" + this.randomInt(1, 12), "temporalFrequency", this.randomDouble(1.0, 2.0, 0), "spatialFrequency", this.randomDouble(0.0, 1.0), "speciesStades", speciesStades});
            this.createDemoActions(inter, null);
        }
    }

    protected void createDemoInterventionCulturales() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Cr\u00e9ation des interventions culturales r\u00e9alis\u00e9es pour les zones...");
        }
        ZoneTopiaDao zoneTopiaDao = this.context.getPersistenceContext().getZoneDao();
        EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao = this.context.getPersistenceContext().getEffectiveSeasonalCropCycleDao();
        EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao = this.context.getPersistenceContext().getEffectivePerennialCropCycleDao();
        EffectiveCropCyclePhaseTopiaDao cropCyclePhaseTopiaDao = this.context.getPersistenceContext().getEffectiveCropCyclePhaseDao();
        EffectiveCropCycleNodeTopiaDao cropCycleNodeTopiaDao = this.context.getPersistenceContext().getEffectiveCropCycleNodeDao();
        EffectiveCropCycleConnectionTopiaDao cropCycleConnectionTopiaDao = this.context.getPersistenceContext().getEffectiveCropCycleConnectionDao();
        ArrayList phaseDurations = Lists.newArrayList((Object[])new Integer[]{5, 7, 3, 10, 15, 30});
        List zones = zoneTopiaDao.findAll();
        int count = zones.size();
        int index = 0;
        for (Zone zone : zones) {
            ++index;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Cr\u00e9ation des interventions culturales r\u00e9alis\u00e9es (%d/%d)", index, count));
            }
            List croppingPlans = this.effectiveCropCycleService.getZoneCroppingPlanEntries(zone);
            ArrayList mainCroppingPlans = Lists.newArrayList();
            ArrayList inteCroppingPlans = Lists.newArrayList();
            for (CroppingPlanEntry croppingPlanEntry : croppingPlans) {
                if (croppingPlanEntry.getType() == CroppingEntryType.INTERMEDIATE) {
                    inteCroppingPlans.add(croppingPlanEntry);
                    continue;
                }
                mainCroppingPlans.add(croppingPlanEntry);
            }
            if (mainCroppingPlans.isEmpty()) {
                return;
            }
            EffectiveCropCyclePhase cropCyclePhase = (EffectiveCropCyclePhase)cropCyclePhaseTopiaDao.newInstance();
            cropCyclePhase.setDuration((Integer)this.randomElem(phaseDurations));
            cropCyclePhase.setType(CropCyclePhaseType.PLEINE_PRODUCTION);
            cropCyclePhase = (EffectiveCropCyclePhase)cropCyclePhaseTopiaDao.create((TopiaEntity)cropCyclePhase);
            effectivePerennialCropCycleTopiaDao.create("zone", zone, new Object[]{"croppingPlanEntry", this.randomElem(mainCroppingPlans), "phase", cropCyclePhase, "weedType", this.randomEnum(WeedType.values())});
            this.createDemoEffectiveInterventions(zone, cropCyclePhase, null);
            EffectiveCropCycleNode node1 = (EffectiveCropCycleNode)cropCycleNodeTopiaDao.create("rank", 0, new Object[]{"croppingPlanEntry", this.randomElem(mainCroppingPlans)});
            EffectiveCropCycleNode node2 = (EffectiveCropCycleNode)cropCycleNodeTopiaDao.create("rank", 1, new Object[]{"croppingPlanEntry", this.randomElem(mainCroppingPlans)});
            EffectiveCropCycleNode node3 = (EffectiveCropCycleNode)cropCycleNodeTopiaDao.create("rank", 2, new Object[]{"croppingPlanEntry", this.randomElem(mainCroppingPlans)});
            EffectiveCropCycleConnection conn = (EffectiveCropCycleConnection)cropCycleConnectionTopiaDao.create("source", node1, new Object[]{"target", node2});
            if (this.random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn.setIntermediateCroppingPlanEntry((CroppingPlanEntry)this.randomElem(inteCroppingPlans));
            }
            EffectiveCropCycleConnection conn2 = (EffectiveCropCycleConnection)cropCycleConnectionTopiaDao.create("source", node2, new Object[]{"target", node3});
            if (this.random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn2.setIntermediateCroppingPlanEntry((CroppingPlanEntry)this.randomElem(inteCroppingPlans));
            }
            effectiveSeasonalCropCycleTopiaDao.create("zone", zone, new Object[]{"nodes", Lists.newArrayList((Object[])new EffectiveCropCycleNode[]{node1, node2, node3})});
            this.createDemoEffectiveInterventions(zone, null, node1);
            this.createDemoEffectiveInterventions(zone, null, node2);
            this.createDemoEffectiveInterventions(zone, null, node3);
        }
    }

    protected void createDemoEffectiveInterventions(Zone zone, EffectiveCropCyclePhase phase, EffectiveCropCycleNode node) {
        Preconditions.checkArgument((boolean)(node == null ^ phase == null));
        EffectiveInterventionTopiaDao effectiveInterventionTopiaDao = this.context.getPersistenceContext().getEffectiveInterventionDao();
        EffectiveSpeciesStadeTopiaDao effectiveSpeciesStadeDao = this.context.getPersistenceContext().getEffectiveSpeciesStadeDao();
        int count = this.random.nextInt(2) + 1;
        for (int i = 0; i < count; ++i) {
            AgrosystInterventionType type = this.randomEnum(AgrosystInterventionType.values());
            ToolsCouplingTopiaDao toolsCouplingTopiaDao = this.context.getPersistenceContext().getToolsCouplingDao();
            List toolsCouplings = toolsCouplingTopiaDao.forDomainEquals(zone.getPlot().getDomain()).findAll();
            HashSet selectedToolsCoupling = Sets.newHashSet();
            if (toolsCouplings != null) {
                for (ToolsCoupling toolsCoupling : toolsCouplings) {
                    if (toolsCoupling.getMainsActions() == null) continue;
                    for (RefInterventionAgrosystTravailEDI mainAction : toolsCoupling.getMainsActions()) {
                        if (mainAction.getIntervention_agrosyst() != type) continue;
                        selectedToolsCoupling.add(toolsCoupling);
                    }
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, zone.getPlot().getDomain().getCampaign());
            calendar.add(6, -this.randomInt(120));
            Date startDate = calendar.getTime();
            calendar.add(6, this.randomInt(365));
            Date endDate = calendar.getTime();
            ArrayList speciesStades = Lists.newArrayList();
            if (node != null) {
                for (CroppingPlanSpecies species : node.getCroppingPlanEntry().getCroppingPlanSpecies()) {
                    EffectiveSpeciesStade speciesStade = (EffectiveSpeciesStade)effectiveSpeciesStadeDao.create("croppingPlanSpecies", species, new Object[0]);
                    speciesStades.add(speciesStade);
                }
            }
            String name = String.format("%s %s %s", this.randomElem(LOREM_IPSUM_WORDS), this.randomElem(LOREM_IPSUM_WORDS), this.randomElem(LOREM_IPSUM_WORDS));
            EffectiveIntervention inter = (EffectiveIntervention)effectiveInterventionTopiaDao.create("effectiveCropCycleNode", node, new Object[]{"effectiveCropCyclePhase", phase, "name", name, "spatialFrequency", this.randomInt(1, 2), "transitCount", this.randomInt(1, 3), "workRate", this.randomDouble(0.5, 1.5), "type", type, "toolCouplings", selectedToolsCoupling, "startInterventionDate", startDate, "endInterventionDate", endDate, "speciesStades", speciesStades});
            this.createDemoActions(null, inter);
        }
    }

    protected void createDemoActions(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        Preconditions.checkArgument((boolean)(practicedIntervention == null ^ effectiveIntervention == null));
        HashSet alreadyDone = Sets.newHashSet();
        int count = this.random.nextInt(3) + 2;
        for (int i = 0; i < count; ++i) {
            int agrosystInterventionType = this.random.nextInt(6);
            if (alreadyDone.contains(agrosystInterventionType)) continue;
            switch (agrosystInterventionType) {
                case 1: {
                    this.createMineralFertilizersSpreadingAction(practicedIntervention, effectiveIntervention);
                    break;
                }
                case 2: {
                    this.createOrganicFertilizersSpreadingAction(practicedIntervention, effectiveIntervention);
                    break;
                }
                case 3: {
                    this.createMaintenancePruningVinesAction(practicedIntervention, effectiveIntervention);
                    break;
                }
                case 4: {
                    this.createIrrigationAction(practicedIntervention, effectiveIntervention);
                    break;
                }
                case 5: {
                    this.createTillageAction(practicedIntervention, effectiveIntervention);
                    break;
                }
                default: {
                    this.createOtherAction(practicedIntervention, effectiveIntervention);
                }
            }
            alreadyDone.add(agrosystInterventionType);
        }
    }

    protected RefFertiMinUNIFA randomFertiMinUNIFA() {
        if (this.fertiMinUnifa.isEmpty()) {
            RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao = this.context.getPersistenceContext().getRefFertiMinUNIFADao();
            List ids = refFertiMinUNIFATopiaDao.findAllIds();
            for (int i = 0; i < 100; ++i) {
                this.fertiMinUnifa.add((RefFertiMinUNIFA)refFertiMinUNIFATopiaDao.forTopiaIdEquals((String)this.randomElem(ids)).findUnique());
            }
        }
        return this.randomElem(this.fertiMinUnifa);
    }

    protected RefFertiEngraisorg randomFertiEngraisorg() {
        if (this.fertiEngraisorg.isEmpty()) {
            RefFertiEngraisorgTopiaDao refFertiEngraisorgTopiaDao = this.context.getPersistenceContext().getRefFertiEngraisorgDao();
            List ids = refFertiEngraisorgTopiaDao.findAllIds();
            for (int i = 0; i < 100; ++i) {
                this.fertiEngraisorg.add((RefFertiEngraisorg)refFertiEngraisorgTopiaDao.forTopiaIdEquals((String)this.randomElem(ids)).findUnique());
            }
        }
        return this.randomElem(this.fertiEngraisorg);
    }

    protected RefInterventionAgrosystTravailEDI randomActionTravailEDI(AgrosystInterventionType interventionAgrosyst) {
        if (!this.interventionsTravailEDI.containsKey(interventionAgrosyst)) {
            RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = this.context.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
            List ids = refActionAgrosystTravailEDITopiaDao.forIntervention_agrosystEquals(interventionAgrosyst).findAllIds();
            this.interventionsTravailEDI.put(interventionAgrosyst, new ArrayList());
            for (int i = 0; i < 10; ++i) {
                this.interventionsTravailEDI.get(interventionAgrosyst).add((RefInterventionAgrosystTravailEDI)refActionAgrosystTravailEDITopiaDao.forTopiaIdEquals((String)this.randomElem(ids)).findUnique());
            }
        }
        return this.randomElem(this.interventionsTravailEDI.get(interventionAgrosyst));
    }

    protected void createMineralFertilizersSpreadingAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionTopiaDao = this.context.getPersistenceContext().getMineralFertilizersSpreadingActionDao();
        mineralFertilizersSpreadingActionTopiaDao.create("effectiveIntervention", effectiveIntervention, new Object[]{"practicedIntervention", practicedIntervention, "mainAction", this.randomActionTravailEDI(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX)});
    }

    protected void createOrganicFertilizersSpreadingAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionTopiaDao = this.context.getPersistenceContext().getOrganicFertilizersSpreadingActionDao();
        organicFertilizersSpreadingActionTopiaDao.create("effectiveIntervention", effectiveIntervention, new Object[]{"practicedIntervention", practicedIntervention, "mainAction", this.randomActionTravailEDI(AgrosystInterventionType.EPANDAGES_ORGANIQUES)});
    }

    protected void createMaintenancePruningVinesAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionTopiaDao = this.context.getPersistenceContext().getMaintenancePruningVinesActionDao();
        maintenancePruningVinesActionTopiaDao.create("effectiveIntervention", effectiveIntervention, new Object[]{"practicedIntervention", practicedIntervention, "mainAction", this.randomActionTravailEDI(AgrosystInterventionType.ENTRETIEN_TAILLE_VIGNE_ET_VERGER)});
    }

    protected void createIrrigationAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        IrrigationActionTopiaDao irrigationActionTopiaDao = this.context.getPersistenceContext().getIrrigationActionDao();
        irrigationActionTopiaDao.create("effectiveIntervention", effectiveIntervention, new Object[]{"practicedIntervention", practicedIntervention, "mainAction", this.randomActionTravailEDI(AgrosystInterventionType.IRRIGATION), "waterQuantityAverage", this.randomDouble(5.0, 42.0)});
    }

    protected void createTillageAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        TillageActionTopiaDao tillageActionTopiaDao = this.context.getPersistenceContext().getTillageActionDao();
        tillageActionTopiaDao.create("effectiveIntervention", effectiveIntervention, new Object[]{"practicedIntervention", practicedIntervention, "mainAction", this.randomActionTravailEDI(AgrosystInterventionType.TRAVAIL_DU_SOL), "tillageDepth", this.randomDouble(10.0, 150.0)});
    }

    protected void createOtherAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        OtherActionTopiaDao otherActionTopiaDao = this.context.getPersistenceContext().getOtherActionDao();
        otherActionTopiaDao.create("effectiveIntervention", effectiveIntervention, new Object[]{"practicedIntervention", practicedIntervention, "mainAction", this.randomActionTravailEDI(AgrosystInterventionType.AUTRE)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoMateriels() {
        block3: {
            RefMaterielTopiaDao refMaterielTopiaDao = this.context.getPersistenceContext().getRefMaterielDao();
            if (refMaterielTopiaDao.count() != 0L) break block3;
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des mat\u00e9riels...");
            }
            InputStream isAutomoteurs1 = null;
            InputStream isAutomoteurs2 = null;
            InputStream isIrrigation1 = null;
            InputStream isOutils1 = null;
            InputStream isOutils2 = null;
            InputStream isTracteurs1 = null;
            InputStream isTracteurs2 = null;
            try {
                isAutomoteurs1 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_automoteur_recolte.csv");
                this.importService.importMaterielAutomoteursCSV(isAutomoteurs1);
                isAutomoteurs2 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_automoteur_vitiarbo.csv");
                this.importService.importMaterielAutomoteursCSV(isAutomoteurs2);
                isIrrigation1 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_materiel_irrigation.csv");
                this.importService.importMaterielIrrigationCSV(isIrrigation1);
                isOutils1 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_outils_vitiarbo.csv");
                this.importService.importMaterielOutilsCSV(isOutils1);
                isOutils2 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_outils.csv");
                this.importService.importMaterielOutilsCSV(isOutils2);
                isTracteurs1 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_tracteurs_vitiarbo.csv");
                this.importService.importMaterielTracteursCSV(isTracteurs1);
                isTracteurs2 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_tracteurs.csv");
                this.importService.importMaterielTracteursCSV(isTracteurs2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)isAutomoteurs1);
                IOUtils.closeQuietly(isAutomoteurs2);
                IOUtils.closeQuietly(isOutils1);
                IOUtils.closeQuietly(isIrrigation1);
                IOUtils.closeQuietly(isOutils2);
                IOUtils.closeQuietly(isTracteurs1);
                IOUtils.closeQuietly(isTracteurs2);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)isAutomoteurs1);
            IOUtils.closeQuietly((InputStream)isAutomoteurs2);
            IOUtils.closeQuietly((InputStream)isOutils1);
            IOUtils.closeQuietly((InputStream)isIrrigation1);
            IOUtils.closeQuietly((InputStream)isOutils2);
            IOUtils.closeQuietly((InputStream)isTracteurs1);
            IOUtils.closeQuietly((InputStream)isTracteurs2);
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoCommunes() {
        block3: {
            RefLocationTopiaDao refLocationTopiaDao = this.context.getPersistenceContext().getRefLocationDao();
            if (refLocationTopiaDao.count() != 0L) break block3;
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des communes...");
            }
            InputStream isCodesPostauxEtCommunes = null;
            InputStream isCommunes = null;
            InputStream isCodesPostaux = null;
            InputStream isRegionsAgricoles = null;
            try {
                isCodesPostauxEtCommunes = DemoDatas.class.getResourceAsStream("/referentiels/communes_osm.csv");
                isCommunes = DemoDatas.class.getResourceAsStream("/referentiels/communes_insee.csv");
                isCodesPostaux = DemoDatas.class.getResourceAsStream("/referentiels/communes_codePosteaux.csv");
                isRegionsAgricoles = DemoDatas.class.getResourceAsStream("/referentiels/communes_regionsAgricoles.txt");
                this.importService.importCommuneOsmCSV(isCodesPostauxEtCommunes, isRegionsAgricoles);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(isCommunes);
                IOUtils.closeQuietly(isCodesPostaux);
                IOUtils.closeQuietly(isRegionsAgricoles);
                IOUtils.closeQuietly((InputStream)isCodesPostauxEtCommunes);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)isCommunes);
            IOUtils.closeQuietly((InputStream)isCodesPostaux);
            IOUtils.closeQuietly((InputStream)isRegionsAgricoles);
            IOUtils.closeQuietly((InputStream)isCodesPostauxEtCommunes);
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoDepartments() {
        RefDepartmentShapeTopiaDao refDepartmentShapeDao = this.context.getPersistenceContext().getRefDepartmentShapeDao();
        if (refDepartmentShapeDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des shapes de d\u00e9partements ...");
            }
            InputStream isShapes = null;
            try {
                isShapes = DemoDatas.class.getResourceAsStream("/referentiels/geoflar-departements.csv");
                this.importService.importDepartmentShapes(isShapes);
            }
            finally {
                IOUtils.closeQuietly((InputStream)isShapes);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoActaTraitementsProduits() {
        RefActaTraitementsProduitTopiaDao refActaTraitementsProduitTopiaDao = this.context.getPersistenceContext().getRefActaTraitementsProduitDao();
        if (refActaTraitementsProduitTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel ActaTraitementsProduits");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_traitements_produits.csv");
                this.importService.importActaTraitementsProduits(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoActaTraitementsProduitsCateg() {
        RefActaTraitementsProduitsCategTopiaDao refActaTraitementsProduitsCategTopiaDao = this.context.getPersistenceContext().getRefActaTraitementsProduitsCategDao();
        if (refActaTraitementsProduitsCategTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel ActaTraitementsProduitsCateg");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_traitements_produits_categ.csv");
                this.importService.importActaTraitementsProduitsCateg(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoSolsArvalis() {
        RefSolArvalisTopiaDao refSolArvalisTopiaDao = this.context.getPersistenceContext().getRefSolArvalisDao();
        if (refSolArvalisTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des sols arvalis...");
            }
            InputStream solsStream = null;
            try {
                solsStream = DemoDatas.class.getResourceAsStream("/referentiels/sols_arvalis.csv");
                this.importService.importSolArvalisCSV(solsStream, null);
            }
            finally {
                IOUtils.closeQuietly((InputStream)solsStream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoStatutJuridique() {
        RefLegalStatusTopiaDao legalStatusTopiaDao = this.context.getPersistenceContext().getRefLegalStatusDao();
        if (legalStatusTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des statuts juridiques...");
            }
            InputStream statusStream = null;
            try {
                statusStream = DemoDatas.class.getResourceAsStream("/referentiels/statut_juridique.csv");
                this.importService.importLegalStatusCSV(statusStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)statusStream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoEspeces() {
        RefEspeceTopiaDao dao = this.context.getPersistenceContext().getRefEspeceDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des esp\u00e8ces...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/cultures_AEE_complet.csv");
                this.importService.importEspeces(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoVarietesGeves() {
        RefVarieteGevesTopiaDao dao = this.context.getPersistenceContext().getRefVarieteGevesDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des vari\u00e9t\u00e9s GEVES...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/varietes_GEVES.csv");
                this.importService.importVarietesGeves(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoVarietesPlantGrape() {
        RefVarietePlantGrapeTopiaDao dao = this.context.getPersistenceContext().getRefVarietePlantGrapeDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des vari\u00e9t\u00e9s PlantGrape...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/varietes_PlantGrape.csv");
                this.importService.importVarietesPlantGrape(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoClonesPlantGrape() {
        RefClonePlantGrapeTopiaDao dao = this.context.getPersistenceContext().getRefClonePlantGrapeDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des clones PlantGrape...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/clones_PlantGrape.csv");
                this.importService.importClonesPlantGrape(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoEspecesToVarietes() {
        RefEspeceToVarieteTopiaDao dao = this.context.getPersistenceContext().getRefEspeceToVarieteDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import des esp\u00e8ces <> vari\u00e9t\u00e9s...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/cultures_varietes.csv");
                this.importService.importEspecesToVarietes(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoOtex() {
        RefOTEXTopiaDao dao = this.context.getPersistenceContext().getRefOTEXDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel OTEX...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/OTEX.csv");
                this.importService.importOtexCSV(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoOrientationEdi() {
        RefOrientationEDITopiaDao dao = this.context.getPersistenceContext().getRefOrientationEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel Orientation EDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/orientation_edi.csv");
                this.importService.importOrientationEdiCSV(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoInterventionAgrosysytTravailEdi() {
        RefInterventionAgrosystTravailEDITopiaDao dao = this.context.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel ActionAgrosyst_travailEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/interventionAgrosyst_travailEDI.csv");
                this.importService.importInterventionAgrosystTravailEdiCSV(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoTypeTravailEdi() {
        RefTypeTravailEDITopiaDao dao = this.context.getPersistenceContext().getRefTypeTravailEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel Type_travailEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/typeTravailEDI.csv");
                this.importService.importTypeTravailEdiCSV(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForDemoStadesEdi() {
        RefStadeEDITopiaDao dao = this.context.getPersistenceContext().getRefStadeEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel stadesEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/stades_EDI.csv");
                this.importService.importStadesEdiCSV(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoSolProfondeurIndigo() {
        RefSolProfondeurIndigoTopiaDao dao = this.context.getPersistenceContext().getRefSolProfondeurIndigoDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel sol profondeur indigo...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/sol_profondeur_indigo.csv");
                this.importService.importSolProfondeurIndigo(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoSolCaracteristiquesIndigo() {
        RefSolCaracteristiqueIndigoTopiaDao dao = this.context.getPersistenceContext().getRefSolCaracteristiqueIndigoDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel sol caracteristiques indigo...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/sol_caracteristiques_indigo.csv");
                this.importService.importSolCarateristiquesIndigo(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoParcelleZonageEdi() {
        RefParcelleZonageEDITopiaDao dao = this.context.getPersistenceContext().getRefParcelleZonageEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel parcelle zonage edi...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/zonage_parcelle_edi.csv");
                this.importService.importZonageParcelleEdi(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoSolTextureGeppa() {
        RefSolTextureGeppaTopiaDao dao = this.context.getPersistenceContext().getRefSolTextureGeppaDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel sol texture geppa...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/sol_texture_geppa.csv");
                this.importService.importSolTextureGeppa(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoUnitesEdi() {
        RefUniteEDITopiaDao dao = this.context.getPersistenceContext().getRefUniteEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel unit\u00e9s EDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/unites_EDI.csv");
                this.importService.importUniteEDI(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoFertiMinUNIFA() {
        RefFertiMinUNIFATopiaDao dao = this.context.getPersistenceContext().getRefFertiMinUNIFADao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel FertiMinUNIFA...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ferti_min_UNIFA.csv");
                this.importService.importFertiMinUNIFA(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoBioAgressors() {
        InputStream stream;
        AbstractRefBioAgressorTopiaDao dao = this.context.getPersistenceContext().getRefAdventiceDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel Adventices...");
            }
            stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/adventices.csv");
                this.importService.importAdventices(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
        if ((dao = this.context.getPersistenceContext().getRefNuisibleEDIDao()).count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel NuisiblesEDI...");
            }
            stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/nuisibles_edi.csv");
                this.importService.importNuisiblesEDI(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoRefFertiOrga() {
        RefFertiOrgaTopiaDao dao = this.context.getPersistenceContext().getRefFertiOrgaDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel ferti_orga...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ferti_orga.csv");
                this.importService.importFertiOrga(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoFertiEngraisOrg() {
        RefFertiEngraisorgTopiaDao dao = this.context.getPersistenceContext().getRefFertiEngraisorgDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel FertiEngraisorg...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ferti_engraisorg.csv");
                this.importService.importFertiEngraisOrg(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoStationMeteo() {
        RefStationMeteoTopiaDao dao = this.context.getPersistenceContext().getRefStationMeteoDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel Station meteo...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/station_meteo_inra.csv");
                this.importService.importStationMeteo(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoTypeAgriculture() {
        RefTypeAgricultureTopiaDao dao = this.context.getPersistenceContext().getRefTypeAgricultureDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel TypeAgriculture...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/type_agriculture.csv");
                this.importService.importTypeAgriculture(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoIndicatorReferentials() {
        RefNrjGesOutilTopiaDao refNrjGesOutilsTopiaDao;
        RefNrjSemenceTopiaDao refNrjSemenceTopiaDao;
        RefNrjPhytoTopiaDao refNrjPhytoTopiaDao;
        RefNrjEngraisTopiaDao refNrjEngraisTopiaDao;
        RefNrjCarburantTopiaDao refNrjCarburantTopiaDao;
        RefGesSemenceTopiaDao refGesSemenceTopiaDao;
        RefGesPhytoTopiaDao refGesPhytoTopiaDao;
        RefGesEngraisTopiaDao refGesEngraisTopiaDao;
        RefGesCarburantTopiaDao refGesCarburantTopiaDao = this.context.getPersistenceContext().getRefGesCarburantDao();
        if (refGesCarburantTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/ges_carburants.csv");
                this.importService.importGesCarburants(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if ((refGesEngraisTopiaDao = this.context.getPersistenceContext().getRefGesEngraisDao()).count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/ges_engrais.csv");
                this.importService.importGesEngrais(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if ((refGesPhytoTopiaDao = this.context.getPersistenceContext().getRefGesPhytoDao()).count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/ges_phyto.csv");
                this.importService.importGesPhyto(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if ((refGesSemenceTopiaDao = this.context.getPersistenceContext().getRefGesSemenceDao()).count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/ges_semences.csv");
                this.importService.importGesSemences(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if ((refNrjCarburantTopiaDao = this.context.getPersistenceContext().getRefNrjCarburantDao()).count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_carburants.csv");
                this.importService.importNrjCarburants(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if ((refNrjEngraisTopiaDao = this.context.getPersistenceContext().getRefNrjEngraisDao()).count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_engrais.csv");
                this.importService.importNrjEngrais(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if ((refNrjPhytoTopiaDao = this.context.getPersistenceContext().getRefNrjPhytoDao()).count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_phyto.csv");
                this.importService.importNrjPhyto(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if ((refNrjSemenceTopiaDao = this.context.getPersistenceContext().getRefNrjSemenceDao()).count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_semences.csv");
                this.importService.importNrjSemences(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if ((refNrjGesOutilsTopiaDao = this.context.getPersistenceContext().getRefNrjGesOutilDao()).count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_ges_outils.csv");
                this.importService.importNrjGesOutils(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        this.context.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoMesureReferentials() {
        RefUnitesQualifiantEDITopiaDao refUnitesQualifiantEDITopiaDao;
        RefValeurQualitativeEDITopiaDao refValeurQualitativeEDITopiaDao;
        RefTypeNotationEDITopiaDao refTypeNotationEDITopiaDao;
        RefStadeNuisibleEDITopiaDao refStadeNuisibleEDITopiaDao;
        RefMesureTopiaDao refMesureTopiaDao = this.context.getPersistenceContext().getRefMesureDao();
        if (refMesureTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel Mesures...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/mesures.csv");
                this.importService.importMesure(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
        if ((refStadeNuisibleEDITopiaDao = this.context.getPersistenceContext().getRefStadeNuisibleEDIDao()).count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel StadeNuisibleEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/stades_nuisibles_edi.csv");
                this.importService.importStadeNuisibleEDI(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
        if ((refTypeNotationEDITopiaDao = this.context.getPersistenceContext().getRefTypeNotationEDIDao()).count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel TypeNotationEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/type_notation_edi.csv");
                this.importService.importTypeNotationEDI(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
        if ((refValeurQualitativeEDITopiaDao = this.context.getPersistenceContext().getRefValeurQualitativeEDIDao()).count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel ValeurQualitativeEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/valeurs_qualitatives_edi.csv");
                this.importService.importValeurQualitativeEDI(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
        if ((refUnitesQualifiantEDITopiaDao = this.context.getPersistenceContext().getRefUnitesQualifiantEDIDao()).count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel UnitesQualifiantEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/unites_qualifiants_edi.csv");
                this.importService.importUnitesQualifiantEDI(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoSupportOrganeEdi() {
        RefSupportOrganeEDITopiaDao refSupportOrganeEdiTopiaDao = this.context.getPersistenceContext().getRefSupportOrganeEDIDao();
        if (refSupportOrganeEdiTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel SupportOrganeEdi...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/support_organe_edi.csv");
                this.importService.importSupportOrganeEDI(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoActaSubstanceActive() {
        RefActaSubstanceActiveTopiaDao refActaSubstanceActiveTopiaDao = this.context.getPersistenceContext().getRefActaSubstanceActiveDao();
        if (refActaSubstanceActiveTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel ActaSubstanceActive...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_SA.csv");
                this.importService.importActaSubstanceActive(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoProtocoleVgObs() {
        RefProtocoleVgObsTopiaDao refProtocoleVgObsTopiaDao = this.context.getPersistenceContext().getRefProtocoleVgObsDao();
        if (refProtocoleVgObsTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel ProtocoleVgObs...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/protocoles_vgobs.csv");
                this.importService.importProtocoleVgObs(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoElementVoisinage() {
        RefElementVoisinageTopiaDao refElementVoisinageTopiaDao = this.context.getPersistenceContext().getRefElementVoisinageDao();
        if (refElementVoisinageTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel ElementVoisinage...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/elements_voisinage.csv");
                this.importService.importElementVoisinage(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    protected void checkForDemoIphyReferentials() {
        this.checkForDemoPhytoSubstanceActiveIphy();
        this.checkForDemoRcesoCaseGroundWater();
        this.checkForDemoRcesoFuzzySetGroundWater();
        this.checkForDemoRcesoRulesGroundWater();
        this.checkForDemoRcesuRunoffPotRulesParc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoPhytoSubstanceActiveIphy() {
        RefPhytoSubstanceActiveIphyTopiaDao refPhytoSubstanceActiveIphyTopiaDao = this.context.getPersistenceContext().getRefPhytoSubstanceActiveIphyDao();
        if (refPhytoSubstanceActiveIphyTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel RefPhytoSubstanceActiveIphy");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/phyto_substanceactives-iphy.csv");
                this.importService.importPhytoSubstanceActiveIphy(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoRcesoCaseGroundWater() {
        RefRcesoCaseGroundWaterTopiaDao refRcesoCaseGroundWaterTopiaDao = this.context.getPersistenceContext().getRefRcesoCaseGroundWaterDao();
        if (refRcesoCaseGroundWaterTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel RcesoCaseGroundWater");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/rceso/case-groundwater.csv");
                this.importService.importRcesoCaseGroundWater(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoRcesoFuzzySetGroundWater() {
        RefRcesoFuzzySetGroundWaterTopiaDao refRcesoFuzzySetGroundWaterTopiaDao = this.context.getPersistenceContext().getRefRcesoFuzzySetGroundWaterDao();
        if (refRcesoFuzzySetGroundWaterTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel RcesoFuzzySetGroundWater");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/rceso/fuzzyset-groundwater.csv");
                this.importService.importRcesoFuzzySetGroundWater(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoRcesoRulesGroundWater() {
        RefRcesoRulesGroundWaterTopiaDao refRcesoRulesGroundWaterTopiaDao = this.context.getPersistenceContext().getRefRcesoRulesGroundWaterDao();
        if (refRcesoRulesGroundWaterTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel RcesoRulesGroundWater");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/rceso/rules-groundwater.csv");
                this.importService.importRcesoRulesGroundWater(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoRcesuRunoffPotRulesParc() {
        RefRcesuRunoffPotRulesParcTopiaDao refRcesuRunoffPotRulesParcTopiaDao = this.context.getPersistenceContext().getRefRcesuRunoffPotRulesParcDao();
        if (refRcesuRunoffPotRulesParcTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel RcesuRunoffPotRulesParc");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/rcesu/runoff-pot-rules-parc.csv");
                this.importService.importRcesuRunoffPotRulesParc(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoSaActaIphy() {
        RefSaActaIphyTopiaDao refSaActaIphyTopiaDao = this.context.getPersistenceContext().getRefSaActaIphyDao();
        if (refSaActaIphyTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel refSaActaIphy");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/SA_ACTA_IPHY.csv");
                this.importService.importSaActaIphy(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoLienCulturesEdiActa() {
        RefLienCulturesEdiActaTopiaDao refLienCulturesEdiActaTopiaDao = this.context.getPersistenceContext().getRefLienCulturesEdiActaDao();
        if (refLienCulturesEdiActaTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel refLienCulturesEdiActa");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/LienCultures-EDI-ACTA.csv");
                this.importService.importLienCulturesEdiActa(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoActaGroupeCultures() {
        RefActaGroupeCulturesTopiaDao refActaGroupeCulturesTopiaDao = this.context.getPersistenceContext().getRefActaGroupeCulturesDao();
        if (refActaGroupeCulturesTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel refActaGroupeCultures");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_GroupeCultures.csv");
                this.importService.importActaGroupeCultures(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoActaDosageSpc() {
        RefActaDosageSPCTopiaDao refActaDosageSPCTopiaDao = this.context.getPersistenceContext().getRefActaDosageSPCDao();
        if (refActaDosageSPCTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel refActaDosageSPC");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_dosage_SPC_complet.csv");
                this.importService.importActaDosageSpc(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoTraitSdC() {
        RefTraitSdCTopiaDao refTraitSdCTopiaDao = this.context.getPersistenceContext().getRefTraitSdCDao();
        if (refTraitSdCTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel refTraitSdC");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/traitSdC.csv");
                this.importService.importTraitSdC(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoCouvSolPerenne() {
        RefCouvSolPerenneTopiaDao refCouvSolPerenneTopiaDao = this.context.getPersistenceContext().getRefCouvSolPerenneDao();
        if (refCouvSolPerenneTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel refCouvSolPerenneTopiaDao");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/Couv-sol_Perennes.csv");
                this.importService.importCouvSolPerenne(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoCultureEdiGroupeCouvSol() {
        RefCultureEdiGroupeCouvSolTopiaDao refCultureEdiGroupeCouvSolTopiaDao = this.context.getPersistenceContext().getRefCultureEdiGroupeCouvSolDao();
        if (refCultureEdiGroupeCouvSolTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel refCultureEdiGroupeCouvSol");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/CulturesEDI_Groupe-couv-sol.csv");
                this.importService.importCultureEdiGroupeCouvSol(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoCouvSolAnnuelle() {
        RefCouvSolAnnuelleTopiaDao refCouvSolAnnuelleTopiaDao = this.context.getPersistenceContext().getRefCouvSolAnnuelleDao();
        if (refCouvSolAnnuelleTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel refCouvSolAnnuelle");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/Couv-sol_Annuelles.csv");
                this.importService.importCouvSolAnnuelle(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForDemoZoneClimatiqueIphy() {
        RefZoneClimatiqueIphyTopiaDao refZoneClimatiqueIphyTopiaDao = this.context.getPersistenceContext().getRefZoneClimatiqueIphyDao();
        if (refZoneClimatiqueIphyTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Import du r\u00e9f\u00e9rentiel RefZoneClimatiqueIphy");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/zones_climatiques_IPHY.csv");
                this.importService.importZoneClimatiqueIphy(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            this.context.getTransaction().commit();
        }
    }
}

