/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.context;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.context.NavigationContextService;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class NavigationContextServiceImpl
extends AbstractAgrosystService
implements NavigationContextService {
    private static final Log log = LogFactory.getLog(NavigationContextServiceImpl.class);
    protected NetworkService networkService;
    protected DomainService domainService;
    protected GrowingPlanService growingPlanService;
    protected GrowingSystemService growingSystemService;
    protected AnonymizeService anonymizeService;
    protected NetworkTopiaDao networkDao;
    protected DomainTopiaDao domainDao;
    protected GrowingPlanTopiaDao growingPlanDao;
    protected GrowingSystemTopiaDao growingSystemDao;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setNetworkDao(NetworkTopiaDao networkDao) {
        this.networkDao = networkDao;
    }

    public void setDomainDao(DomainTopiaDao domainDao) {
        this.domainDao = domainDao;
    }

    public void setGrowingPlanDao(GrowingPlanTopiaDao growingPlanDao) {
        this.growingPlanDao = growingPlanDao;
    }

    public void setGrowingSystemDao(GrowingSystemTopiaDao growingSystemDao) {
        this.growingSystemDao = growingSystemDao;
    }

    public List<Integer> getAllCampaigns() {
        List<Integer> result = this.domainDao.getAllCampaigns();
        return result;
    }

    public ResultList<Network> getAllNetworks() {
        ResultList result = this.networkService.getFilteredNetworks(null);
        return result;
    }

    public ResultList<DomainDto> getAllDomainsForCampaign(Set<Integer> campaigns, Set<String> networkIds) {
        NavigationContext navigationContext = new NavigationContext();
        navigationContext.setCampaigns(campaigns);
        navigationContext.setNetworks(networkIds);
        DomainFilter filter = new DomainFilter();
        filter.setNavigationContext(navigationContext);
        ResultList result = this.domainService.getFilteredDomainsDto(filter);
        return result;
    }

    public ResultList<GrowingPlanDto> getAllGrowingPlansForDomains(Set<Integer> campaigns, Set<String> domainIds, Set<String> networkIds) {
        NavigationContext navigationContext = new NavigationContext();
        navigationContext.setCampaigns(campaigns);
        navigationContext.setNetworks(networkIds);
        navigationContext.setDomains(domainIds);
        GrowingPlanFilter filter = new GrowingPlanFilter();
        filter.setNavigationContext(navigationContext);
        ResultList result = this.growingPlanService.getFilteredGrowingPlansDto(filter);
        return result;
    }

    public ResultList<GrowingSystemDto> getAllGrowingSystemsForGrowingPlans(Set<Integer> campaigns, Set<String> domainIds, Set<String> growingPlansIds, Set<String> networkIds) {
        NavigationContext navigationContext = new NavigationContext();
        navigationContext.setCampaigns(campaigns);
        navigationContext.setNetworks(networkIds);
        navigationContext.setDomains(domainIds);
        navigationContext.setGrowingPlans(growingPlansIds);
        GrowingSystemFilter filter = new GrowingSystemFilter();
        filter.setNavigationContext(navigationContext);
        ResultList result = this.growingSystemService.getFilteredGrowingSystemsDto(filter);
        return result;
    }

    public NavigationContext verify(NavigationContext navigationContext) {
        Preconditions.checkArgument((navigationContext != null ? 1 : 0) != 0);
        NavigationContext result = new NavigationContext();
        final HashSet campaigns = Sets.newHashSet();
        Set networks = result.getNetworks();
        final Set domains = result.getDomains();
        final Set growingPlans = result.getGrowingPlans();
        Set growingSystems = result.getGrowingSystems();
        final Predicate isValidDomain = Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<Domain>(){

            public boolean apply(Domain domain) {
                boolean result = campaigns.isEmpty() || campaigns.contains(domain.getCampaign());
                return result;
            }
        });
        final Predicate isValidGrowingPlan = Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<GrowingPlan>(){

            public boolean apply(GrowingPlan growingPlan) {
                Domain domain = growingPlan.getDomain();
                boolean result = isValidDomain.apply((Object)domain);
                return result &= domains.isEmpty() || domains.contains(domain.getTopiaId());
            }
        });
        Predicate isValidGrowingSystem = Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<GrowingSystem>(){

            public boolean apply(GrowingSystem growingSystem) {
                GrowingPlan growingPlan = growingSystem.getGrowingPlan();
                boolean result = isValidGrowingPlan.apply((Object)growingPlan);
                return result &= growingPlans.isEmpty() || growingPlans.contains(growingPlan.getTopiaId());
            }
        });
        if (navigationContext.getCampaigns() != null) {
            campaigns.addAll(navigationContext.getCampaigns());
        }
        result.setCampaigns((Set)campaigns);
        if (navigationContext.getNetworksCount() > 0) {
            for (String networkId : navigationContext.getNetworks()) {
                Network network = (Network)this.networkDao.forTopiaIdEquals(networkId).findUniqueOrNull();
                if (Predicates.notNull().apply((Object)network)) {
                    networks.add(networkId);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("The network (%s) does not exist.", networkId));
            }
        }
        if (navigationContext.getDomainsCount() > 0) {
            for (String domainId : navigationContext.getDomains()) {
                Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUniqueOrNull();
                if (isValidDomain.apply((Object)domain)) {
                    domains.add(domainId);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("The domain (%s) does not exist or does not match any of the campaigns %s.", domainId, campaigns));
            }
        }
        if (navigationContext.getGrowingPlansCount() > 0) {
            for (String growingPlanId : navigationContext.getGrowingPlans()) {
                GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanId).findUniqueOrNull();
                if (isValidGrowingPlan.apply((Object)growingPlan)) {
                    growingPlans.add(growingPlanId);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("The growingPlan (%s) does not exist or does not match any of the campaigns %s or domains %s.", growingPlanId, campaigns, domains));
            }
        }
        if (navigationContext.getGrowingSystemsCount() > 0) {
            for (String growingSystemId : navigationContext.getGrowingSystems()) {
                GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUniqueOrNull();
                if (isValidGrowingSystem.apply((Object)growingSystem)) {
                    growingSystems.add(growingSystemId);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("The growingSystem (%s) does not exist or does not match any of the campaigns %s, domains %s or growingPlans %s.", growingSystemId, campaigns, domains, growingPlans));
            }
        }
        return result;
    }

    public NavigationContext verify(NavigationContext navigationContext, TopiaEntity newEntity) {
        Preconditions.checkArgument((navigationContext != null ? 1 : 0) != 0);
        String entityId = newEntity.getTopiaId();
        Preconditions.checkNotNull((Object)entityId);
        Integer campaign = null;
        if (newEntity instanceof Network) {
            if (navigationContext.getNetworksCount() >= 1) {
                navigationContext.getNetworks().add(entityId);
            }
        } else if (newEntity instanceof Domain) {
            if (navigationContext.getDomainsCount() >= 1) {
                navigationContext.getDomains().add(entityId);
            }
            campaign = ((Domain)newEntity).getCampaign();
        } else if (newEntity instanceof GrowingPlan) {
            if (navigationContext.getGrowingPlansCount() >= 1) {
                navigationContext.getGrowingPlans().add(entityId);
            }
            campaign = ((GrowingPlan)newEntity).getDomain().getCampaign();
        } else if (newEntity instanceof GrowingSystem) {
            if (navigationContext.getGrowingSystemsCount() >= 1) {
                navigationContext.getGrowingSystems().add(entityId);
            }
            campaign = ((GrowingSystem)newEntity).getGrowingPlan().getDomain().getCampaign();
        } else {
            String message = "This method is supposed to be used with new Domain/GrowingPlan/GrowingSystem/Network entities only";
            throw new UnsupportedOperationException(message);
        }
        if (campaign != null && navigationContext.getCampaignsCount() >= 1) {
            navigationContext.getCampaigns().add(campaign);
        }
        NavigationContext result = this.verify(navigationContext);
        return result;
    }

    public Map<String, String> getNetworks(Set<String> networkIds, int maxCount) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (networkIds != null && !networkIds.isEmpty()) {
            int max = maxCount >= 0 ? maxCount : Integer.MAX_VALUE;
            List networks = this.networkDao.forTopiaIdIn(networkIds).setOrderByArguments(new String[]{"name"}).find(0, max);
            for (Network network : networks) {
                result.put(network.getTopiaId(), network.getName());
            }
        }
        return result;
    }

    public Map<String, String> getDomains(Set<String> domainsIds, int maxCount) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (domainsIds != null && !domainsIds.isEmpty()) {
            int max = maxCount >= 0 ? maxCount : Integer.MAX_VALUE;
            List domains = this.domainDao.forTopiaIdIn(domainsIds).setOrderByArguments(new String[]{"name"}).find(0, max);
            Map domainsMap = this.anonymizeService.getDomainsAsMap((Iterable)domains);
            result.putAll(domainsMap);
        }
        return result;
    }

    public Map<String, String> getGrowingPlans(Set<String> growingPlansIds, int maxCount) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (growingPlansIds != null && !growingPlansIds.isEmpty()) {
            int max = maxCount >= 0 ? maxCount : Integer.MAX_VALUE;
            List growingPlans = this.growingPlanDao.forTopiaIdIn(growingPlansIds).setOrderByArguments(new String[]{"name"}).find(0, max);
            Map growingPlansMap = this.anonymizeService.getGrowingPlansAsMap((Iterable)growingPlans);
            result.putAll(growingPlansMap);
        }
        return result;
    }

    public Map<String, String> getGrowingSystems(Set<String> growingSystemsIds, int maxCount) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (growingSystemsIds != null && !growingSystemsIds.isEmpty()) {
            int max = maxCount >= 0 ? maxCount : Integer.MAX_VALUE;
            List growingSystems = this.growingSystemDao.forTopiaIdIn(growingSystemsIds).setOrderByArguments(new String[]{"name"}).find(0, max);
            for (GrowingSystem growingSystem : growingSystems) {
                result.put(growingSystem.getTopiaId(), growingSystem.getName());
            }
        }
        return result;
    }
}

