/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common.export;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.BeanUtil;

public class ExportUtils {
    private static final Log log = LogFactory.getLog(ExportUtils.class);
    protected static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final ValueFormatter<TypeDEPHY> TYPE_DEPHY_FORMATTER = new ValueFormatter<TypeDEPHY>(){

        public String format(TypeDEPHY input) {
            String result = null;
            switch (input) {
                case DEPHY_EXPE: {
                    result = "DEPHY-EXPE";
                    break;
                }
                case DEPHY_FERME: {
                    result = "DEPHY-FERME";
                    break;
                }
                case NOT_DEPHY: {
                    result = "Hors DEPHY";
                    break;
                }
            }
            return result;
        }
    };

    public static <K> void copyFields(K source, EntityExportExtra destination, Map<String, Function<K, Object>> customTransformers, Iterable<String> fields) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        for (final String field : fields) {
            Set descriptors;
            Object value;
            if (customTransformers != null && customTransformers.containsKey(field)) {
                Function<K, Object> function = customTransformers.get(field);
                value = function.apply(source);
            } else {
                value = PropertyUtils.getProperty(source, (String)field);
            }
            if (value != null && value instanceof TopiaEntity && log.isWarnEnabled()) {
                String message = String.format("A transformer is probably missing for property %s#%s", source.getClass().getName(), field);
                log.warn((Object)message);
            }
            if ((descriptors = BeanUtil.getDescriptors(destination.getClass(), (Predicate)Predicates.and((Predicate)BeanUtil.IS_WRITE_DESCRIPTOR, (Predicate)new Predicate<PropertyDescriptor>(){

                public boolean apply(PropertyDescriptor input) {
                    return field.equals(input.getName());
                }
            }))) != null && !descriptors.isEmpty()) {
                Preconditions.checkState((descriptors.size() == 1 ? 1 : 0) != 0, (Object)("Unexpected size for field " + destination.getClass().getName() + "#" + field + "; size=" + descriptors.size()));
                PropertyDescriptor descriptor = (PropertyDescriptor)descriptors.iterator().next();
                descriptor.getWriteMethod().invoke((Object)destination, value);
                continue;
            }
            ExportUtils.setExtraField(destination, field, value);
        }
    }

    public static <K> void copyFields(EntityExportExtra source, K destination, String ... fields) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        for (final String field : fields) {
            Object value;
            Set descriptors = BeanUtil.getDescriptors(source.getClass(), (Predicate)Predicates.and((Predicate)BeanUtil.IS_READ_DESCRIPTOR, (Predicate)new Predicate<PropertyDescriptor>(){

                public boolean apply(PropertyDescriptor input) {
                    return field.equals(input.getName());
                }
            }));
            if (!descriptors.isEmpty()) {
                Preconditions.checkState((descriptors.size() == 1 ? 1 : 0) != 0, (Object)("Unexpected size for field " + destination.getClass().getName() + "#" + field + "; size=" + descriptors.size()));
                PropertyDescriptor descriptor = (PropertyDescriptor)descriptors.iterator().next();
                value = descriptor.getReadMethod().invoke(destination, new Object[0]);
            } else {
                value = source.getExtra(field);
                String stringValue = (String)value;
                if (StringUtils.isNotBlank((CharSequence)stringValue)) {
                    Class type = PropertyUtils.getPropertyType(destination, (String)field);
                    if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
                        value = "oui".equalsIgnoreCase(stringValue);
                    } else if (Date.class.isAssignableFrom(type)) {
                        value = dateFormat.parse(stringValue);
                    } else if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
                        value = Double.parseDouble(stringValue.replace(',', '.'));
                    } else if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
                        value = Integer.parseInt(stringValue);
                    } else if (type.isEnum()) {
                        value = Enum.valueOf(type, stringValue);
                    }
                }
            }
            PropertyUtils.setProperty(destination, (String)field, (Object)value);
        }
    }

    public static <K> void copyFields(K source, EntityExportExtra destination, Map<String, Function<K, Object>> customTransformers, String ... fields) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        ArrayList list = Lists.newArrayList((Object[])fields);
        ExportUtils.copyFields(source, destination, customTransformers, list);
    }

    public static void setExtraField(EntityExportExtra destination, String field, Object value) {
        Object replaced;
        HashMap extra = destination.getExtras();
        if (extra == null) {
            extra = Maps.newHashMap();
            destination.setExtras(extra);
        }
        if ((replaced = extra.put(field, value)) != null && log.isWarnEnabled()) {
            log.warn((Object)("Valeur remplac\u00e9e (" + field + "): " + replaced));
        }
    }

    public static <R extends EntityExportExtra, K> void export(Map<EntityExportTabInfo, List<? extends EntityExportExtra>> sheet, R model, K entity, EntityExportTabInfo tabInfo) throws CloneNotSupportedException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ExportUtils.export(sheet, model, ImmutableList.of(entity), tabInfo);
    }

    public static <R extends EntityExportExtra, K> void export(Map<EntityExportTabInfo, List<? extends EntityExportExtra>> sheet, R model, Iterable<K> entities, EntityExportTabInfo tabInfo) throws CloneNotSupportedException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List<? extends EntityExportExtra> list = sheet.get(tabInfo);
        Set tabFields = tabInfo.getExtraColumns().keySet();
        Map customTransformers = tabInfo.getCustomFormatters();
        for (K entity : entities) {
            EntityExportExtra transformed = (EntityExportExtra)model.clone();
            ExportUtils.copyFields(entity, transformed, customTransformers, tabFields);
            list.add(transformed);
        }
    }

    public static <R extends EntityExportExtra> void addAllBeanInfo(Map<EntityExportTabInfo, List<? extends EntityExportExtra>> sheet, EntityExportTabInfo ... tabInfos) {
        for (EntityExportTabInfo tabInfo : tabInfos) {
            ArrayList list = Lists.newArrayList();
            sheet.put(tabInfo, list);
        }
    }

    public static <K, M> Function<K, Object> ifNotNull(final String field, final Function<M, Object> realFunction) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull(realFunction);
        return new Function<K, Object>(){

            public Object apply(K input) {
                Object value;
                try {
                    value = PropertyUtils.getProperty(input, (String)field);
                }
                catch (Exception eee) {
                    throw new AgrosystTechnicalException("Invalid attribute", (Throwable)eee);
                }
                Object result = null;
                if (value != null) {
                    result = realFunction.apply(value);
                }
                return result;
            }
        };
    }

    public static <E extends Enum<E>> Iterable<String> allStringOf(Class<E> enumClazz) {
        return Iterables.transform(EnumSet.allOf(enumClazz), (Function)new Function<E, String>(){

            public String apply(E input) {
                return ((Enum)input).name();
            }
        });
    }

    public static <E extends Enum<E>> Iterable<String> typeDephyToString() {
        return Iterables.transform(EnumSet.allOf(TypeDEPHY.class), (Function)new Function<TypeDEPHY, String>(){

            public String apply(TypeDEPHY input) {
                String result = null;
                switch (input) {
                    case DEPHY_EXPE: {
                        result = "DEPHY-EXPE";
                        break;
                    }
                    case DEPHY_FERME: {
                        result = "DEPHY-FERME";
                        break;
                    }
                    case NOT_DEPHY: {
                        result = "Hors DEPHY";
                        break;
                    }
                }
                return result;
            }
        });
    }
}

