/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common.export;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class EntityImporter {
    private static final Log log = LogFactory.getLog(EntityImporter.class);

    public <T extends EntityExportExtra> Map<EntityExportTabInfo, List<T>> importFromStream(InputStream is, Class<T> entityClass, EntityExportTabInfo ... tabInfos) {
        HashMap result = Maps.newHashMap();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(is);
            for (EntityExportTabInfo tabInfo : tabInfos) {
                HSSFSheet sheet = workbook.getSheet(tabInfo.getBeanTitle());
                HSSFRow rowHeader = sheet.getRow(0);
                ArrayList headers = Lists.newArrayList();
                for (int cellIndex = 0; cellIndex < rowHeader.getLastCellNum(); ++cellIndex) {
                    HSSFCell cell = rowHeader.getCell(cellIndex);
                    String name = cell.getStringCellValue();
                    headers.add(name);
                }
                ArrayList entities = Lists.newArrayList();
                for (int rowIndex = 1; rowIndex < sheet.getPhysicalNumberOfRows(); ++rowIndex) {
                    HSSFRow row = sheet.getRow(rowIndex);
                    EntityExportExtra entity = (EntityExportExtra)entityClass.newInstance();
                    HashMap extras = Maps.newHashMap();
                    for (int cellIndex = 0; cellIndex < row.getLastCellNum(); ++cellIndex) {
                        String headerName = (String)headers.get(cellIndex);
                        HSSFCell cell = row.getCell(cellIndex);
                        String value = cell.getStringCellValue();
                        if (Strings.isNullOrEmpty((String)value)) continue;
                        if (tabInfo.getCommonColumns().containsValue((Object)headerName)) {
                            String property = (String)tabInfo.getCommonColumns().getKey((Object)headerName);
                            Class type = PropertyUtils.getPropertyType((Object)entity, (String)property);
                            Object objectValue = value;
                            if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
                                objectValue = "oui".equalsIgnoreCase(value);
                            } else if (Date.class.isAssignableFrom(type)) {
                                objectValue = dateFormat.parse(value);
                            } else if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
                                objectValue = Double.parseDouble(value.replace(',', '.'));
                            } else if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
                                objectValue = Integer.parseInt(value);
                            } else if (type.isEnum()) {
                                objectValue = Enum.valueOf(type, value);
                            }
                            PropertyUtils.setProperty((Object)entity, (String)property, (Object)objectValue);
                            continue;
                        }
                        if (tabInfo.getExtraColumns().containsValue((Object)headerName)) {
                            String key = (String)tabInfo.getExtraColumns().getKey((Object)headerName);
                            extras.put(key, value);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown column " + headerName);
                    }
                    entity.setExtras(extras);
                    entities.add(entity);
                }
                result.put(tabInfo, entities);
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't read spread sheet from stream", (Throwable)ex);
        }
        return result;
    }
}

