/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common.export;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.WorkbookUtil;
import org.nuiton.util.beans.BeanUtil;

public class EntityExporter {
    public InputStream exportAsXlsStream(Map<EntityExportTabInfo, List<? extends EntityExportExtra>> sheetData) {
        ByteArrayInputStream inputStream;
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFCellStyle boldStyle = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setBoldweight((short)700);
            boldStyle.setFont((Font)font);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            for (Map.Entry<EntityExportTabInfo, List<? extends EntityExportExtra>> sheetDatum : sheetData.entrySet()) {
                EntityExportTabInfo info = sheetDatum.getKey();
                HSSFSheet sheet = workbook.createSheet(info.getBeanTitle());
                List<? extends EntityExportExtra> values = sheetDatum.getValue();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                ImmutableMap declaredColumns = builder.putAll(info.getCommonColumns()).putAll(info.getExtraColumns()).build();
                Map<String, Iterable<String>> customDropDownList = info.getCustomDropDownList();
                HSSFRow headerRow = sheet.createRow(0);
                int column = 0;
                for (Map.Entry displayEntry : declaredColumns.entrySet()) {
                    String key = (String)displayEntry.getKey();
                    Cell headerCell = headerRow.createCell(column);
                    headerCell.setCellValue((String)displayEntry.getValue());
                    headerCell.setCellStyle((CellStyle)boldStyle);
                    Iterable<String> dropDownList = customDropDownList.get(key);
                    if (dropDownList != null) {
                        int rowIndex = 0;
                        String sheetName = "_" + key;
                        if (workbook.getSheet(sheetName = WorkbookUtil.createSafeSheetName((String)sheetName)) == null) {
                            HSSFSheet sheetZonage = workbook.createSheet(sheetName);
                            int index = workbook.getSheetIndex(sheetName);
                            workbook.setSheetHidden(index, 1);
                            for (String value : dropDownList) {
                                HSSFRow valueRow = sheetZonage.createRow(rowIndex);
                                Cell valueCell = valueRow.createCell(0);
                                valueCell.setCellValue(value);
                                ++rowIndex;
                            }
                        } else {
                            rowIndex = Iterables.size(dropDownList);
                        }
                        if (rowIndex >= 1) {
                            String range = sheetName + "!$A$1:$A$" + rowIndex;
                            DVConstraint dvConstraint = DVConstraint.createFormulaListConstraint((String)range);
                            CellRangeAddressList list = new CellRangeAddressList(1, -1, column, column);
                            HSSFDataValidation dataValidation = new HSSFDataValidation(list, (DataValidationConstraint)dvConstraint);
                            sheet.addValidationData((DataValidation)dataValidation);
                        }
                    }
                    ++column;
                }
                for (int i = 0; i < values.size(); ++i) {
                    EntityExportExtra entity = values.get(i);
                    HSSFRow row = sheet.createRow(i + 1);
                    int column2 = 0;
                    for (final String columnName : declaredColumns.keySet()) {
                        Cell cell = row.createCell(column2++);
                        Set descriptors = BeanUtil.getDescriptors(entity.getClass(), (Predicate)Predicates.and((Predicate)BeanUtil.IS_READ_DESCRIPTOR, (Predicate)new Predicate<PropertyDescriptor>(){

                            public boolean apply(PropertyDescriptor input) {
                                return columnName.equals(input.getName());
                            }
                        }));
                        Object value = null;
                        if (!descriptors.isEmpty()) {
                            Preconditions.checkState((descriptors.size() == 1 ? 1 : 0) != 0, (Object)("Unexpected size for field " + entity.getClass().getName() + "#" + columnName + "; size=" + descriptors.size()));
                            PropertyDescriptor descriptor = (PropertyDescriptor)descriptors.iterator().next();
                            value = descriptor.getReadMethod().invoke((Object)entity, new Object[0]);
                        } else if (entity.getExtras() != null) {
                            value = entity.getExtras().get(columnName);
                        }
                        if (value == null) continue;
                        if (value instanceof Boolean) {
                            if (((Boolean)value).booleanValue()) {
                                cell.setCellValue("Oui");
                                continue;
                            }
                            cell.setCellValue("Non");
                            continue;
                        }
                        if (value instanceof Date) {
                            cell.setCellValue(dateFormat.format(value));
                            continue;
                        }
                        cell.setCellValue(value.toString());
                    }
                }
                for (int column3 = 0; column3 < declaredColumns.size(); ++column3) {
                    sheet.autoSizeColumn(column3);
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            workbook.write((OutputStream)out);
            out.close();
            inputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException ex) {
            throw new AgrosystTechnicalException("Can't write XLS file", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't generate file content", (Throwable)ex);
        }
        return inputStream;
    }
}

