/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystTopiaDaoSupplier;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.common.CacheService;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;

public class ProjectionHelper {
    private static final Log log = LogFactory.getLog(ProjectionHelper.class);
    protected static final String PROPERTY_GROWING_PLAN_ACTIVE = "growingPlan.active";
    protected static final String PROPERTY_GROWING_PLAN_DOMAIN_ACTIVE = "growingPlan.domain.active";
    protected static final String PROPERTY_GROWING_PLAN_CODE = "growingPlan.code";
    protected static final String PROPERTY_GROWING_PLAN_DOMAIN_CODE = "growingPlan.domain.code";
    protected AgrosystTopiaDaoSupplier topiaDaoSupplier;
    protected TopiaJpaSupport topiaJpaSupport;
    protected CacheService cacheService;

    public static void GET_NETWORK_SUB_QUERY(StringBuilder query, Map<String, Object> args, Set<Network> networks) {
        int index = 0;
        for (Network network : networks) {
            String key = "network" + index++;
            query.append(String.format(" OR :%s IN ELEMENTS ( gs.%s ) ", key, "networks"));
            args.put(key, network);
        }
    }

    public ProjectionHelper(AgrosystTopiaDaoSupplier topiaDaoSupplier, TopiaJpaSupport topiaJpaSupport, CacheService cacheService) {
        this.topiaDaoSupplier = topiaDaoSupplier;
        this.topiaJpaSupport = topiaJpaSupport;
        this.cacheService = cacheService;
    }

    protected Set<String> networksProjection(Set<String> networkIds, String projection) {
        return this.networksProjection(networkIds, projection, null, null);
    }

    protected Set<String> networksProjection(final Set<String> networkIds, final String projection, final String filterProperty, final Object filterValue) {
        Callable<LinkedHashSet<String>> loader = new Callable<LinkedHashSet<String>>(){

            @Override
            public LinkedHashSet<String> call() throws Exception {
                StringBuilder query = new StringBuilder(String.format("SELECT DISTINCT gs.%s FROM %s gs", projection, GrowingSystem.class.getName()));
                query.append(" WHERE ( 1 = 0");
                LinkedHashMap args = Maps.newLinkedHashMap();
                NetworkTopiaDao networkDAO = (NetworkTopiaDao)ProjectionHelper.this.topiaDaoSupplier.getDao(Network.class, NetworkTopiaDao.class);
                Set<Network> networks = networkDAO.loadNetworksWithDescendantHierarchy(networkIds);
                ProjectionHelper.GET_NETWORK_SUB_QUERY(query, args, networks);
                query.append(")");
                query.append(DaoUtils.andAttributeEquals("gs", filterProperty, args, filterValue));
                List projectedList = ProjectionHelper.this.topiaJpaSupport.findAll(query.toString(), (Map)args);
                LinkedHashSet result = Sets.newLinkedHashSet((Iterable)projectedList);
                return result;
            }
        };
        String key = String.format("%s_%s_%s_%s", networkIds, projection, filterProperty, filterValue);
        Set result = this.cacheService.get("networksProjection", key, loader);
        return result;
    }

    public Set<String> networksToGrowingSystems(Set<String> networkIds) {
        Set<String> result = this.networksProjection(networkIds, "topiaId");
        return result;
    }

    public Set<String> networksToGrowingSystemsCode(Set<String> networkIds) {
        Set<String> result = this.networksProjection(networkIds, "code");
        return result;
    }

    public Set<String> networksToGrowingPlans(Set<String> networkIds) {
        Set<String> result = this.networksProjection(networkIds, "growingPlan.topiaId");
        return result;
    }

    public Set<String> networksToGrowingPlans(Set<String> networkIds, boolean active) {
        Set<String> result = this.networksProjection(networkIds, "growingPlan.topiaId", PROPERTY_GROWING_PLAN_ACTIVE, active);
        return result;
    }

    public Set<String> networksToGrowingPlansCode(Set<String> networkIds) {
        Set<String> result = this.networksProjection(networkIds, PROPERTY_GROWING_PLAN_CODE);
        return result;
    }

    public Set<String> networksToGrowingPlansCode(Set<String> networkIds, boolean active) {
        Set<String> result = this.networksProjection(networkIds, PROPERTY_GROWING_PLAN_CODE, PROPERTY_GROWING_PLAN_ACTIVE, active);
        return result;
    }

    public Set<String> networksToDomains(Set<String> networkIds) {
        Set<String> result = this.networksProjection(networkIds, "growingPlan.domain.topiaId");
        return result;
    }

    public Set<String> networksToDomains(Set<String> networkIds, boolean active) {
        Set<String> result = this.networksProjection(networkIds, "growingPlan.domain.topiaId", PROPERTY_GROWING_PLAN_DOMAIN_ACTIVE, active);
        return result;
    }

    public Set<String> networksToDomainsCode(Set<String> networkIds, boolean active) {
        Set<String> result = this.networksProjection(networkIds, PROPERTY_GROWING_PLAN_DOMAIN_CODE, PROPERTY_GROWING_PLAN_DOMAIN_ACTIVE, true);
        return result;
    }

    public Set<String> networksToDomainsCode(Set<String> networkIds) {
        Set<String> result = this.networksProjection(networkIds, PROPERTY_GROWING_PLAN_DOMAIN_CODE);
        return result;
    }

    public LinkedHashSet<String> domainsToGrowingSystemsCode(Set<String> domainCodes) {
        Preconditions.checkArgument((domainCodes != null && !domainCodes.isEmpty() ? 1 : 0) != 0);
        String domainCodeProperty = PROPERTY_GROWING_PLAN_DOMAIN_CODE;
        StringBuilder query = new StringBuilder(String.format("SELECT distinct gs.%s FROM %s gs", "code", GrowingSystem.class.getName()));
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (domainCodes.size() == 1) {
            query.append(DaoUtils.andAttributeEquals("gs", domainCodeProperty, args, domainCodes.iterator().next()));
        } else {
            query.append(DaoUtils.andAttributeIn("gs", domainCodeProperty, args, domainCodes));
        }
        List growingSystemCodes = this.topiaJpaSupport.findAll(query.toString(), (Map)args);
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)growingSystemCodes);
        return result;
    }

    public LinkedHashSet<String> growingPlansToGrowingSystemsCode(Set<String> growingPlanCodes) {
        Preconditions.checkArgument((growingPlanCodes != null && !growingPlanCodes.isEmpty() ? 1 : 0) != 0);
        String growingPlanCodeProperty = PROPERTY_GROWING_PLAN_CODE;
        StringBuilder query = new StringBuilder(String.format("SELECT distinct gs.%s FROM %s gs", "code", GrowingSystem.class.getName()));
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (growingPlanCodes.size() == 1) {
            query.append(DaoUtils.andAttributeEquals("gs", growingPlanCodeProperty, args, growingPlanCodes.iterator().next()));
        } else {
            query.append(DaoUtils.andAttributeIn("gs", growingPlanCodeProperty, args, growingPlanCodes));
        }
        List growingSystemCodes = this.topiaJpaSupport.findAll(query.toString(), (Map)args);
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)growingSystemCodes);
        return result;
    }

    public Set<String> domainsToDomainCodes(final Set<String> domainIds, final boolean active) {
        Set result;
        Callable<LinkedHashSet<String>> loader = new Callable<LinkedHashSet<String>>(){

            @Override
            public LinkedHashSet<String> call() throws Exception {
                StringBuilder query = new StringBuilder("SELECT DISTINCT d.code FROM " + Domain.class.getName() + " d WHERE 1 = 1");
                LinkedHashMap args = Maps.newLinkedHashMap();
                if (domainIds != null) {
                    if (domainIds.size() == 1) {
                        query.append(DaoUtils.andAttributeEquals("d", "topiaId", args, domainIds));
                    } else {
                        query.append(DaoUtils.andAttributeIn("d", "topiaId", args, domainIds));
                    }
                }
                query.append(DaoUtils.andAttributeEquals("d", "active", args, active));
                List domainCodes = ProjectionHelper.this.topiaJpaSupport.findAll(query.toString(), (Map)args);
                LinkedHashSet result = Sets.newLinkedHashSet((Iterable)domainCodes);
                return result;
            }
        };
        if (domainIds == null) {
            try {
                result = (Set)loader.call();
            }
            catch (Exception ex) {
                throw new AgrosystTechnicalException("Unable to load domain's code", (Throwable)ex);
            }
        } else {
            String key = String.format("%s_%s_%s_%s", domainIds, "code", "topiaId", active);
            result = this.cacheService.get("domainsToDomainCodesProjection", key, loader);
        }
        return result;
    }

    public Set<String> growingPlansToDomainCodes(final Set<String> growingPlanTopiaIds, final boolean active) {
        Preconditions.checkArgument((growingPlanTopiaIds != null && !growingPlanTopiaIds.isEmpty() ? 1 : 0) != 0);
        String growingPlanToDomainCodeProperty = "domain.code";
        Callable<LinkedHashSet<String>> loader = new Callable<LinkedHashSet<String>>(){

            @Override
            public LinkedHashSet<String> call() throws Exception {
                StringBuilder query = new StringBuilder(String.format("SELECT distinct gp.%s FROM %s gp", "domain.code", GrowingPlan.class.getName()));
                query.append(" WHERE 1 = 1");
                LinkedHashMap args = Maps.newLinkedHashMap();
                if (growingPlanTopiaIds.size() == 1) {
                    query.append(DaoUtils.andAttributeEquals("gp", "topiaId", args, growingPlanTopiaIds.iterator().next()));
                } else {
                    query.append(DaoUtils.andAttributeIn("gp", "topiaId", args, growingPlanTopiaIds));
                }
                query.append(DaoUtils.andAttributeEquals("gp", "domain.active", args, active));
                List domainCodes = ProjectionHelper.this.topiaJpaSupport.findAll(query.toString(), (Map)args);
                LinkedHashSet result = Sets.newLinkedHashSet((Iterable)domainCodes);
                return result;
            }
        };
        String key = String.format("%s_%s_%s_%s", growingPlanTopiaIds, "domain.code", "topiaId", active);
        Set result = this.cacheService.get("growingPlansToDomainCodes", key, loader);
        return result;
    }

    public Set<String> growingSystemsToDomainCodes(final Set<String> growingSystemsIds, final boolean active) {
        Preconditions.checkArgument((growingSystemsIds != null && !growingSystemsIds.isEmpty() ? 1 : 0) != 0);
        String growingSystemToDomainCodeProperty = PROPERTY_GROWING_PLAN_DOMAIN_CODE;
        Callable<LinkedHashSet<String>> loader = new Callable<LinkedHashSet<String>>(){

            @Override
            public LinkedHashSet<String> call() throws Exception {
                StringBuilder query = new StringBuilder(String.format("SELECT distinct gs.%s FROM %s gs", ProjectionHelper.PROPERTY_GROWING_PLAN_DOMAIN_CODE, GrowingSystem.class.getName()));
                query.append(" WHERE 1 = 1");
                LinkedHashMap args = Maps.newLinkedHashMap();
                if (growingSystemsIds.size() == 1) {
                    query.append(DaoUtils.andAttributeEquals("gs", "topiaId", args, growingSystemsIds.iterator().next()));
                } else {
                    query.append(DaoUtils.andAttributeIn("gs", "topiaId", args, growingSystemsIds));
                }
                query.append(DaoUtils.andAttributeEquals("gs", ProjectionHelper.PROPERTY_GROWING_PLAN_DOMAIN_ACTIVE, args, active));
                List domainCodes = ProjectionHelper.this.topiaJpaSupport.findAll(query.toString(), (Map)args);
                LinkedHashSet result = Sets.newLinkedHashSet((Iterable)domainCodes);
                return result;
            }
        };
        String key = String.format("%s_%s_%s_%s", growingSystemsIds, PROPERTY_GROWING_PLAN_DOMAIN_CODE, "topiaId", active);
        Set result = this.cacheService.get("networksProjection", key, loader);
        return result;
    }

    public Set<String> campaignsToDomainCodes(final Set<Integer> campaigns, final boolean active) {
        Preconditions.checkArgument((campaigns != null && !campaigns.isEmpty() ? 1 : 0) != 0);
        Callable<LinkedHashSet<String>> loader = new Callable<LinkedHashSet<String>>(){

            @Override
            public LinkedHashSet<String> call() throws Exception {
                StringBuilder query = new StringBuilder(String.format("SELECT distinct d.%s FROM %s d", "code", Domain.class.getName()));
                query.append(" WHERE 1 = 1");
                LinkedHashMap args = Maps.newLinkedHashMap();
                if (campaigns.size() == 1) {
                    query.append(DaoUtils.andAttributeEquals("d", "campaign", args, campaigns.iterator().next()));
                } else {
                    query.append(DaoUtils.andAttributeIn("d", "campaign", args, campaigns));
                }
                query.append(DaoUtils.andAttributeEquals("d", "active", args, active));
                List domainCodes = ProjectionHelper.this.topiaJpaSupport.findAll(query.toString(), (Map)args);
                LinkedHashSet result = Sets.newLinkedHashSet((Iterable)domainCodes);
                return result;
            }
        };
        String key = String.format("%s_%s_%s_%s", campaigns, "code", "topiaId", active);
        Set result = this.cacheService.get("networksProjection", key, loader);
        return result;
    }
}

