/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.PriceImpl;
import fr.inra.agrosyst.api.entities.PriceTopiaDao;
import fr.inra.agrosyst.api.entities.PriceType;
import fr.inra.agrosyst.api.entities.PriceUnit;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.Referentials;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.common.ProductPrices;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.common.Prices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class PricesServiceImpl
extends AbstractAgrosystService
implements PricesService {
    protected PriceTopiaDao priceTopiaDao;
    protected ZoneTopiaDao zoneTopiaDao;

    public void setPriceTopiaDao(PriceTopiaDao priceTopiaDao) {
        this.priceTopiaDao = priceTopiaDao;
    }

    public void setZoneTopiaDao(ZoneTopiaDao zoneTopiaDao) {
        this.zoneTopiaDao = zoneTopiaDao;
    }

    public ProductPrices computePricesIndication(Price filter, String campaigns, String excludeDomainIdRaw, String excludeZoneId, String excludePracticedSystemId) {
        Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"Requires a filter");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)campaigns) ? 1 : 0) != 0, (Object)"Requires a list of campaigns");
        LinkedHashSet campaignsSet = Sets.newLinkedHashSet();
        Iterables.addAll((Collection)campaignsSet, (Iterable)((Iterable)CommonService.GET_CAMPAIGNS_SET.apply((Object)campaigns)));
        Preconditions.checkArgument((!campaignsSet.isEmpty() ? 1 : 0) != 0, (Object)"At least one campaign must be set");
        String excludeDomainId = excludeDomainIdRaw;
        if (!Strings.isNullOrEmpty((String)excludeZoneId)) {
            Zone zone = (Zone)this.zoneTopiaDao.forTopiaIdEquals(excludeZoneId).findAny();
            Domain domain = zone.getPlot().getDomain();
            excludeDomainId = domain.getTopiaId();
        }
        return this.priceTopiaDao.computePriceIndication(filter, campaignsSet, excludeDomainId, excludePracticedSystemId);
    }

    public void updatePrices(List<Price> prices, Domain domain, PracticedSystem practicedSystem) {
        if (prices == null) {
            prices = Collections.emptyList();
        }
        List<Price> existingPrices = this.getPrices0((String)Entities.GET_TOPIA_ID.apply((Object)domain), (String)Entities.GET_TOPIA_ID.apply((Object)practicedSystem), null);
        ImmutableMap existingPricesIndex = Maps.uniqueIndex(existingPrices, Prices.GET_PRICE_KEY);
        for (Price price : prices) {
            String priceKey = (String)Prices.GET_PRICE_KEY.apply((Object)price);
            Price priceEntity = (Price)existingPricesIndex.get(priceKey);
            if (priceEntity == null) {
                priceEntity = (Price)this.priceTopiaDao.newInstance();
                existingPrices.add(priceEntity);
                priceEntity.setType(price.getType());
                priceEntity.setObjectId(StringUtils.stripAccents((String)price.getObjectId()));
            }
            priceEntity.setCategory(price.getCategory());
            priceEntity.setDisplayName(price.getDisplayName());
            priceEntity.setPrice(price.getPrice());
            priceEntity.setPriceUnit(price.getPriceUnit());
            priceEntity.setSourceUnit(price.getSourceUnit());
            priceEntity.setSourceUnitLabel(price.getSourceUnitLabel());
        }
        for (Price price : existingPrices) {
            price.setDomain(domain);
            price.setPracticedSystem(practicedSystem);
            if (price.isPersisted()) {
                this.priceTopiaDao.update((TopiaEntity)price);
                continue;
            }
            this.priceTopiaDao.create((TopiaEntity)price);
        }
    }

    public List<Price> getDomainPrices(String domainId, List<String> objectIds) {
        List<Price> result = this.getPrices0(domainId, null, objectIds);
        if (result.isEmpty()) {
            Iterables.addAll(result, this.newDefaultPrices());
        }
        return result;
    }

    public List<Price> getPracticedSystemPrices(String practicedSystemId) {
        List<Price> result = this.getPrices0(null, practicedSystemId, null);
        if (result.isEmpty()) {
            Iterables.addAll(result, this.newDefaultPrices());
        }
        return result;
    }

    protected List<Price> getPrices0(String domainTopiaId, String practicedSystemId, List<String> objectIds) {
        List<Object> result = Strings.isNullOrEmpty((String)domainTopiaId) && Strings.isNullOrEmpty((String)practicedSystemId) ? Lists.newLinkedList() : this.priceTopiaDao.getPrices0(domainTopiaId, practicedSystemId, objectIds);
        return result;
    }

    protected List<Price> newDefaultPrices() {
        ArrayList result = Lists.newArrayListWithCapacity((int)1);
        PriceImpl price = new PriceImpl();
        price.setPrice(null);
        price.setCategory("NONE");
        price.setPriceUnit(PriceUnit.EURO_L);
        price.setDisplayName("Carburant");
        price.setType(PriceType.FUEL);
        result.add(price);
        return result;
    }

    public void duplicatePracticedSystemPrices(DuplicateCropCyclesContext duplicateContext) {
        List prices = this.priceTopiaDao.forPracticedSystemEquals(duplicateContext.getPracticedSystem()).findAll();
        Binder binder = BinderFactory.newBinder(Price.class);
        for (Price price : prices) {
            Price priceClone = (Price)this.priceTopiaDao.newInstance();
            binder.copyExcluding((Object)price, (Object)priceClone, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "practicedSystem"});
            priceClone.setPracticedSystem(duplicateContext.getPracticedSystemClone());
            this.priceTopiaDao.create((TopiaEntity)priceClone);
        }
    }

    public String getPriceFertiMinUnifaNaturalId(RefFertiMinUNIFA input) {
        String result = StringUtils.stripAccents((String)((String)Referentials.GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL.apply((Object)input)));
        return result;
    }
}

