/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.services.common.UsageList;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityUsageService
extends AbstractAgrosystService {
    private static final Log log = LogFactory.getLog(EntityUsageService.class);
    protected DomainTopiaDao domainTopiaDao;
    protected ZoneTopiaDao zoneTopiaDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesTopiaDao;
    protected PracticedCropCycleNodeTopiaDao practicedCropCycleNodeTopiaDao;
    protected PracticedSpeciesStadeTopiaDao practicedSpeciesStadeTopiaDao;

    public void setPracticedSpeciesStadeTopiaDao(PracticedSpeciesStadeTopiaDao practicedSpeciesStadeTopiaDao) {
        this.practicedSpeciesStadeTopiaDao = practicedSpeciesStadeTopiaDao;
    }

    public void setPracticedCropCycleNodeTopiaDao(PracticedCropCycleNodeTopiaDao practicedCropCycleNodeTopiaDao) {
        this.practicedCropCycleNodeTopiaDao = practicedCropCycleNodeTopiaDao;
    }

    public void setCroppingPlanSpeciesTopiaDao(CroppingPlanSpeciesTopiaDao croppingPlanSpeciesTopiaDao) {
        this.croppingPlanSpeciesTopiaDao = croppingPlanSpeciesTopiaDao;
    }

    public void setZoneTopiaDao(ZoneTopiaDao zoneTopiaDao) {
        this.zoneTopiaDao = zoneTopiaDao;
    }

    public void setCroppingPlanEntryTopiaDao(CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao) {
        this.croppingPlanEntryTopiaDao = croppingPlanEntryTopiaDao;
    }

    public void setDomainTopiaDao(DomainTopiaDao domainTopiaDao) {
        this.domainTopiaDao = domainTopiaDao;
    }

    public UsageList<ToolsCoupling> getToolsCouplingUsageList(List<ToolsCoupling> toolsCouplings, Integer campaign) {
        Map<Object, Object> map;
        if (toolsCouplings != null && !toolsCouplings.isEmpty()) {
            Iterable ids = Iterables.transform(toolsCouplings, (Function)Entities.GET_TOPIA_ID);
            String stCampaign = "%" + campaign + "%";
            map = this.getToolsCouplingUsageMap(ids, stCampaign);
        } else {
            map = Maps.newHashMap();
        }
        UsageList result = UsageList.of(toolsCouplings, (Map)map);
        return result;
    }

    public Map<String, Boolean> getToolsCouplingUsageMap(Iterable<String> toolsCouplingIds, String campaign) {
        HashMap result = Maps.newHashMap();
        Boolean forTCUsedForEffectiveInterventions = true;
        Boolean forTCUsedForPracticedCropCycleNodesAndConnections = true;
        Boolean forTCUsedForPracticedInterventionPhases = true;
        Map<String, Long> forTCUsedForEffectiveInterventionResult = forTCUsedForEffectiveInterventions != false ? this.domainTopiaDao.getTCUsedForEffectiveInterventions(toolsCouplingIds) : null;
        Map<String, Long> forTCUsedForPracticedCropCycleNodesAndConnectionsResult = forTCUsedForPracticedCropCycleNodesAndConnections != false ? this.domainTopiaDao.getTCUsedForPracticedInterventionNodesAndConnections(toolsCouplingIds, campaign) : null;
        Map<String, Long> forTCUsedForPracticedInterventionPhasesResult = forTCUsedForPracticedInterventionPhases != false ? this.domainTopiaDao.getTCUsedForPracticedInterventionPhases(toolsCouplingIds, campaign) : null;
        for (String id : toolsCouplingIds) {
            Long affected = 0L;
            affected = affected + (forTCUsedForEffectiveInterventionResult != null && forTCUsedForEffectiveInterventionResult.get(id) != null ? forTCUsedForEffectiveInterventionResult.get(id) : 0L);
            affected = affected + (forTCUsedForPracticedCropCycleNodesAndConnectionsResult != null && forTCUsedForPracticedCropCycleNodesAndConnectionsResult.get(id) != null ? forTCUsedForPracticedCropCycleNodesAndConnectionsResult.get(id) : 0L);
            affected = affected + (forTCUsedForPracticedInterventionPhasesResult != null && forTCUsedForPracticedInterventionPhasesResult.get(id) != null ? forTCUsedForPracticedInterventionPhasesResult.get(id) : 0L);
            result.put(id, affected > 0L);
        }
        return result;
    }

    public UsageList<Zone> getZonesUsageList(List<Zone> zones) {
        Map<Object, Object> map;
        if (!zones.isEmpty()) {
            Iterable ids = Iterables.transform(zones, (Function)Entities.GET_TOPIA_ID);
            map = this.getZonesUsageMap(ids);
        } else {
            map = Maps.newHashMap();
        }
        UsageList result = UsageList.of(zones, (Map)map);
        return result;
    }

    public Map<String, Boolean> getZonesUsageMap(Iterable<String> zonesIds) {
        HashMap result = Maps.newHashMap();
        Boolean forZonesUsedForPerformances = true;
        Boolean forZonesUsedForMeasurementSessions = true;
        Boolean forZonesUsedForEffectivePerennialCropCycles = true;
        Boolean forZonesUsedForEffectiveSeasonalCropCycles = true;
        Map<String, Long> getZonesUsedForPerformancesResult = forZonesUsedForPerformances != false ? this.zoneTopiaDao.getZonesUsedForPerformances(zonesIds) : null;
        Map<String, Long> getZonesUsedForMeasurementSessionsResult = forZonesUsedForMeasurementSessions != false ? this.zoneTopiaDao.getZonesUsedForMesurementSessions(zonesIds) : null;
        Map<String, Long> getZonesUsedForEffectivePerennialCropCyclesResult = forZonesUsedForEffectivePerennialCropCycles != false ? this.zoneTopiaDao.getZonesUsedForEffectivePerennialCropCycles(zonesIds) : null;
        Map<String, Long> getZonesUsedForEffectiveSeasonalCropCyclesResult = forZonesUsedForEffectiveSeasonalCropCycles != false ? this.zoneTopiaDao.getZonesUsedForEffectiveSeasonalCropCycles(zonesIds) : null;
        for (String id : zonesIds) {
            Long affected = 0L;
            affected = affected + (getZonesUsedForPerformancesResult != null && getZonesUsedForPerformancesResult.get(id) != null ? getZonesUsedForPerformancesResult.get(id) : 0L);
            affected = affected + (getZonesUsedForMeasurementSessionsResult != null && getZonesUsedForMeasurementSessionsResult.get(id) != null ? getZonesUsedForMeasurementSessionsResult.get(id) : 0L);
            affected = affected + (getZonesUsedForEffectivePerennialCropCyclesResult != null && getZonesUsedForEffectivePerennialCropCyclesResult.get(id) != null ? getZonesUsedForEffectivePerennialCropCyclesResult.get(id) : 0L);
            affected = affected + (getZonesUsedForEffectiveSeasonalCropCyclesResult != null && getZonesUsedForEffectiveSeasonalCropCyclesResult.get(id) != null ? getZonesUsedForEffectiveSeasonalCropCyclesResult.get(id) : 0L);
            result.put(id, affected > 0L);
        }
        return result;
    }

    public UsageList<CroppingPlanEntryDto> getCroppingPlanEntryDtoAndUsage(List<CroppingPlanEntry> croppingPlanEntries, Integer campaign) {
        List croppingPlanEntryDtos;
        Map<Object, Object> map;
        if (croppingPlanEntries != null && !croppingPlanEntries.isEmpty()) {
            Iterable ids = Iterables.transform(croppingPlanEntries, (Function)Entities.GET_TOPIA_ID);
            String stCampaign = "%" + campaign + "%";
            map = this.getCroppingPlanEntryUsageMap(ids, stCampaign);
            croppingPlanEntryDtos = Lists.transform(croppingPlanEntries, (Function)CroppingPlans.CROPPING_PLAN_ENTRY_TO_DTO);
        } else {
            map = Maps.newHashMap();
            croppingPlanEntryDtos = Lists.newArrayList();
        }
        UsageList result = UsageList.of((List)croppingPlanEntryDtos, (Map)map);
        return result;
    }

    public Map<String, Boolean> getCroppingPlanEntryUsageMap(Iterable<String> croppingPlanEntriesIds, String campaign) {
        HashMap result = Maps.newHashMap();
        Boolean forStrategies = true;
        Boolean forMeasurementSessions = true;
        Boolean forCPEUsedForEffectiveCropCycleNode = true;
        Boolean forEffectiveCropCycleConnections = true;
        Boolean forPracticedCropCycleConnections = true;
        Boolean forPracticedCropCycleNodes = true;
        Boolean forEffectivePerennialCropCycles = true;
        Boolean forPracticedPerennialCropCycles = true;
        Map<String, Long> forStrategiesResult = forStrategies != false ? this.croppingPlanEntryTopiaDao.getCPEUsedForStrategies(croppingPlanEntriesIds) : null;
        Map<String, Long> forMeasurementSessionsResult = forMeasurementSessions != false ? this.croppingPlanEntryTopiaDao.getCPEUsedForMesurementSessions(croppingPlanEntriesIds) : null;
        Map<String, Long> forCPEUsedForEffectiveCropCycleNodeResult = forCPEUsedForEffectiveCropCycleNode != false ? this.croppingPlanEntryTopiaDao.getCPEUsedForEffectiveCropCycleNode(croppingPlanEntriesIds) : null;
        Map<String, Long> forEffectiveCropCycleConnectionsResult = forEffectiveCropCycleConnections != false ? this.croppingPlanEntryTopiaDao.getCPEUsedForEffectiveCropCycleConnections(croppingPlanEntriesIds) : null;
        Map<String, Long> forPracticedCropCycleConnectionsResult = forPracticedCropCycleConnections != false ? this.croppingPlanEntryTopiaDao.getCPEUsedForPracticedCropCycleConnections(croppingPlanEntriesIds, campaign) : null;
        Map<String, Long> forPracticedCropCycleNodesResult = forPracticedCropCycleNodes != false ? this.croppingPlanEntryTopiaDao.getCPEUsedForPracticedCropCycleNodes(croppingPlanEntriesIds, campaign) : null;
        Map<String, Long> forEffectivePerennialCropCyclesResult = forEffectivePerennialCropCycles != false ? this.croppingPlanEntryTopiaDao.getCPEUsedForEffectivePerenialCropCycles(croppingPlanEntriesIds) : null;
        Map<String, Long> forPracticedPerenialCropCyclesResult = forPracticedPerennialCropCycles != false ? this.croppingPlanEntryTopiaDao.getCPEUsedPracticedPerenialCropCycles(croppingPlanEntriesIds, campaign) : null;
        for (String id : croppingPlanEntriesIds) {
            Long affected = 0L;
            affected = affected + (forStrategiesResult != null && forStrategiesResult.get(id) != null ? forStrategiesResult.get(id) : 0L);
            affected = affected + (forCPEUsedForEffectiveCropCycleNodeResult != null && forCPEUsedForEffectiveCropCycleNodeResult.get(id) != null ? forCPEUsedForEffectiveCropCycleNodeResult.get(id) : 0L);
            affected = affected + (forMeasurementSessionsResult != null && forMeasurementSessionsResult.get(id) != null ? forMeasurementSessionsResult.get(id) : 0L);
            affected = affected + (forEffectiveCropCycleConnectionsResult != null && forEffectiveCropCycleConnectionsResult.get(id) != null ? forEffectiveCropCycleConnectionsResult.get(id) : 0L);
            affected = affected + (forPracticedCropCycleConnectionsResult != null && forPracticedCropCycleConnectionsResult.get(id) != null ? forPracticedCropCycleConnectionsResult.get(id) : 0L);
            affected = affected + (forPracticedCropCycleNodesResult != null && forPracticedCropCycleNodesResult.get(id) != null ? forPracticedCropCycleNodesResult.get(id) : 0L);
            affected = affected + (forEffectivePerennialCropCyclesResult != null && forEffectivePerennialCropCyclesResult.get(id) != null ? forEffectivePerennialCropCyclesResult.get(id) : 0L);
            affected = affected + (forPracticedPerenialCropCyclesResult != null && forPracticedPerenialCropCyclesResult.get(id) != null ? forPracticedPerenialCropCyclesResult.get(id) : 0L);
            result.put(id, affected > 0L);
        }
        return result;
    }

    public Map<String, Boolean> getCroppingPlanSpeciesUsageMap(List<CroppingPlanSpecies> croppingPlanSpecies, Integer campaign, String domainCode) {
        HashMap map;
        if (croppingPlanSpecies != null && !croppingPlanSpecies.isEmpty()) {
            map = Maps.newHashMapWithExpectedSize((int)croppingPlanSpecies.size());
            Iterable croppingPlanSpeciesIds = Iterables.transform(croppingPlanSpecies, (Function)Entities.GET_TOPIA_ID);
            String stCampaign = "%" + campaign + "%";
            Boolean forPracticedPerennialCropCycleStades = true;
            Boolean forPracticedCropCycleNodesAndConnections = true;
            Boolean forPracticedCropCycleSpecies = true;
            Boolean forEffectiveSpeciesStades = true;
            Boolean forEffectiveCropCycleSpecies = true;
            Boolean forMeasures = true;
            Map<String, Long> forPracticedPerennialCropCycleStadesResults = forPracticedPerennialCropCycleStades != false ? this.croppingPlanSpeciesTopiaDao.getCPSpeciesUsedForPracticedPerennialCropCycleStades(croppingPlanSpeciesIds, stCampaign) : null;
            Map<String, Long> forPracticedCropCycleNodesAndConnectionsResults = forPracticedCropCycleNodesAndConnections != false ? this.getCPSpeciesUsedForPracticedCropCycleNodesAndConnections(croppingPlanSpeciesIds, domainCode, stCampaign) : null;
            Map<String, Long> forPracticedCropCycleSpeciesResults = forPracticedCropCycleSpecies != false ? this.croppingPlanSpeciesTopiaDao.getCPSpeciesUsedForPracticedCropCycleSpecies(croppingPlanSpeciesIds, stCampaign) : null;
            Map<String, Long> forEffectiveSpeciesStadesResults = forEffectiveSpeciesStades != false ? this.croppingPlanSpeciesTopiaDao.getCPSpeciesUsedForEffectiveSpeciesStades(croppingPlanSpeciesIds) : null;
            Map<String, Long> forEffectiveCropCycleSpeciesResults = forEffectiveCropCycleSpecies != false ? this.croppingPlanSpeciesTopiaDao.getCPSpeciesUsedForEffectiveCropCycleSpecies(croppingPlanSpeciesIds) : null;
            Map<String, Long> forMeasuresResults = forMeasures != false ? this.croppingPlanSpeciesTopiaDao.getCPSpeciesUsedForMeasures(croppingPlanSpeciesIds) : null;
            for (String id : croppingPlanSpeciesIds) {
                Long affected = 0L;
                affected = affected + (forPracticedPerennialCropCycleStadesResults != null && forPracticedPerennialCropCycleStadesResults.get(id) != null ? forPracticedPerennialCropCycleStadesResults.get(id) : 0L);
                affected = affected + (forPracticedCropCycleNodesAndConnectionsResults != null && forPracticedCropCycleNodesAndConnectionsResults.get(id) != null ? forPracticedCropCycleNodesAndConnectionsResults.get(id) : 0L);
                affected = affected + (forPracticedCropCycleSpeciesResults != null && forPracticedCropCycleSpeciesResults.get(id) != null ? forPracticedCropCycleSpeciesResults.get(id) : 0L);
                affected = affected + (forEffectiveSpeciesStadesResults != null && forEffectiveSpeciesStadesResults.get(id) != null ? forEffectiveSpeciesStadesResults.get(id) : 0L);
                affected = affected + (forEffectiveCropCycleSpeciesResults != null && forEffectiveCropCycleSpeciesResults.get(id) != null ? forEffectiveCropCycleSpeciesResults.get(id) : 0L);
                affected = affected + (forMeasuresResults != null && forMeasuresResults.get(id) != null ? forMeasuresResults.get(id) : 0L);
                map.put(id, affected > 0L);
            }
        } else {
            map = Maps.newHashMap();
        }
        return map;
    }

    protected Map<String, Long> getCPSpeciesUsedForPracticedCropCycleNodesAndConnections(Iterable<String> croppingPlanSpeciesIds, String domainCode, String campaign) {
        HashMap result;
        block6: {
            block5: {
                result = Maps.newHashMap();
                List<PracticedCropCycleNode> practicedCropCycleNodes = this.croppingPlanSpeciesTopiaDao.getPracticedCropCycleNodeForCampaignAndDomainCode(domainCode, campaign);
                if (practicedCropCycleNodes == null || practicedCropCycleNodes.size() <= 0) break block5;
                Map<PracticedSpeciesStade, String> speciesStades = this.croppingPlanSpeciesTopiaDao.getSpeciesPracticedSpeciesStades(croppingPlanSpeciesIds);
                if (speciesStades == null || speciesStades.size() <= 0) break block6;
                List<PracticedIntervention> practicedInterventions = this.croppingPlanSpeciesTopiaDao.practicedInterventionsForSources(practicedCropCycleNodes);
                practicedInterventions.addAll(this.croppingPlanSpeciesTopiaDao.practicedInterventionsForTargets(practicedCropCycleNodes));
                HashSet practicedInterventionSet = Sets.newHashSet(practicedInterventions);
                HashSet speciesStadesForGivenCampaign = Sets.newHashSet();
                if (practicedInterventionSet != null) {
                    for (PracticedIntervention practicedIntervention : practicedInterventionSet) {
                        if (practicedIntervention.getSpeciesStades() == null) continue;
                        speciesStadesForGivenCampaign.addAll(ListUtils.removeAll((Collection)practicedIntervention.getSpeciesStades(), speciesStades.values()));
                    }
                }
                for (PracticedSpeciesStade practicedSpeciesStade : speciesStadesForGivenCampaign) {
                    result.put(speciesStades.get(practicedSpeciesStade), 1L);
                }
                for (String speciesId : croppingPlanSpeciesIds) {
                    if (result.get(speciesId) != null) continue;
                    result.put(speciesId, 0L);
                }
                break block6;
            }
            for (String speciesId : croppingPlanSpeciesIds) {
                result.put(speciesId, 0L);
            }
        }
        return result;
    }
}

