/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

public class EmailService
extends AbstractAgrosystService
implements AgrosystService {
    private static final Log log = LogFactory.getLog(EmailService.class);

    protected HtmlEmail newEmptyEmail() {
        HtmlEmail newEmptyEmail = new HtmlEmail();
        newEmptyEmail.setHostName(this.getConfig().getSmtpHost());
        newEmptyEmail.setSmtpPort(this.getConfig().getSmtpPort());
        newEmptyEmail.setCharset(Charsets.UTF_8.name());
        try {
            newEmptyEmail.setFrom(this.getConfig().getEmailFrom());
        }
        catch (EmailException e) {
            throw new AgrosystTechnicalException("Unable to initialize email template", (Throwable)e);
        }
        return newEmptyEmail;
    }

    protected void sendEmail(String subject, String to, List<String> ccs, List<String> bccs, String plainBody, String htmlBody, byte[] screenshotData) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subject) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)to) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)plainBody) || !Strings.isNullOrEmpty((String)htmlBody) ? 1 : 0) != 0);
        HtmlEmail email = this.newEmptyEmail();
        email.setSubject(subject);
        try {
            InternetAddress internetAddress;
            InternetAddress internetAddressTo = new InternetAddress(to);
            email.setTo(Arrays.asList(internetAddressTo));
            if (ccs != null) {
                ArrayList ccList = Lists.newArrayList();
                for (String cc : ccs) {
                    internetAddress = new InternetAddress(cc);
                    ccList.add(internetAddress);
                }
                email.setCc((Collection)ccList);
            }
            if (bccs != null) {
                ArrayList bccList = Lists.newArrayList();
                for (String cc : bccs) {
                    internetAddress = new InternetAddress(cc);
                    bccList.add(internetAddress);
                }
                email.setBcc((Collection)bccList);
            }
            if (plainBody != null) {
                email.setTextMsg(plainBody);
            }
            if (htmlBody != null) {
                email.setHtmlMsg(htmlBody);
            }
            if (screenshotData != null) {
                ByteArrayDataSource ds = new ByteArrayDataSource(screenshotData, "image/jpeg");
                email.attach((DataSource)ds, "screenshot.jpg", null, "attachment");
            }
            if (log.isInfoEnabled()) {
                String format = "Will send e-mail to '%s' with subject '%s'";
                log.info((Object)String.format(format, email.getToAddresses(), email.getSubject()));
            }
            email.send();
        }
        catch (AddressException ae) {
            throw new AgrosystTechnicalException("Configured address is not usable: " + to, (Throwable)ae);
        }
        catch (EmailException ee) {
            throw new AgrosystTechnicalException("Unable to send email", (Throwable)ee);
        }
    }

    public void sendPasswordReminder(AgrosystUser user, String token) {
        String applicationBaseUrl = this.getConfig().getApplicationBaseUrl();
        String reminderUrl = String.format("%s/auth/retrieve-password-input.action?userId=%s&token=%s", applicationBaseUrl, user.getTopiaId(), token);
        StringBuilder body = new StringBuilder(String.format("Bonjour %s,\n", user.getFirstName()));
        body.append('\n');
        body.append("Une demande de reg\u00e9n\u00e9ration du mot de passe a \u00e9t\u00e9 faite sur Agrosyst.\n\n");
        body.append("Pour reg\u00e9n\u00e9rer votre mot de passe, il vous suffit de vous rendre \u00e0 l'adresse suivante :\n");
        body.append(reminderUrl);
        body.append("\n\n");
        body.append("Cordialement,\n");
        body.append("L'\u00e9quipe Agrosyst.\n");
        body.append('\n');
        body.append(applicationBaseUrl);
        this.sendEmail("Agrosyst - Mot de passe oubli\u00e9", user.getEmail(), null, null, body.toString(), null, null);
    }

    public void sendFeedback(String user, String env, String location, String locationTitle, String category, String feedback, String requested, String referer, byte[] screenshotData) {
        String feedbackEmail = this.getConfig().getFeedbackEmail();
        StringBuilder body = new StringBuilder("Le ");
        body.append(new SimpleDateFormat("dd MMMM yyyy \u00e0 HH:mm").format(this.context.getCurrentDate()));
        body.append(",\n\n");
        body.append("Description\n");
        body.append("-----------\n\n");
        body.append(feedback);
        body.append("\n\n");
        body.append("Emplacement\n");
        body.append("-----------\n");
        body.append("Titre de la page : " + locationTitle + "\n");
        body.append("URL              : " + location + "\n");
        body.append("URL demand\u00e9e     : " + requested + "\n");
        body.append("URL pr\u00e9c\u00e9dente   : " + referer + "\n");
        body.append("\n");
        body.append("Environnement\n");
        body.append("-------------\n");
        body.append(env);
        body.append("Version services : ");
        body.append(this.getConfig().getApplicationVersion());
        this.sendEmail("Feedback Agrosyst - " + category + " - " + user, feedbackEmail, null, null, body.toString(), null, screenshotData);
    }

    public void sendCreatedAccountNotification(AgrosystUser user, String token) {
        String applicationBaseUrl = this.getConfig().getApplicationBaseUrl();
        String supportEmail = this.getConfig().getSupportEmail();
        String reminderUrl = String.format("%s/auth/retrieve-password-input.action?userId=%s&token=%s", applicationBaseUrl, user.getTopiaId(), token);
        StringBuilder body = new StringBuilder("Bonjour,\n");
        body.append('\n');
        body.append("Quelqu'un - sans doute vous ou un administrateur Agrosyst - a demand\u00e9 d'allouer ou de renouveler votre mot de passe associ\u00e9 \u00e0 votre compte sur le site " + applicationBaseUrl + "\n\n");
        body.append("Vous pouvez ignorer cette requ\u00eate ou bien cliquer sur le lien suivant pour choisir votre mot de passe :\n");
        body.append(reminderUrl);
        body.append("\n\n");
        body.append("Si vous avez des questions par rapport \u00e0 ce message vous pouvez contacter : " + supportEmail);
        body.append("\n\n");
        body.append("Cordialement,\n");
        body.append("L'\u00e9quipe Agrosyst.\n");
        this.sendEmail("Agrosyst - Mise \u00e0 jour de votre profil", user.getEmail(), null, null, body.toString(), null, null);
    }
}

