/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonService {
    protected static final int LOWER_CAMPAIGN_BOUND = 2000;
    protected static final int UPPER_CAMPAIGN_BOUND = 2999;
    protected static final Pair<Integer, Integer> CAMPAIGNS_BOUNDS = Pair.of((Object)2000, (Object)2999);
    protected static final Function<String, Integer> STRING_TO_INTEGER = new Function<String, Integer>(){

        public Integer apply(String input) {
            Integer result = Integer.valueOf(input);
            return result;
        }
    };
    public static final Function<String, Set<Integer>> GET_CAMPAIGNS_SET = new Function<String, Set<Integer>>(){

        public Set<Integer> apply(String input) {
            Preconditions.checkNotNull((Object)input);
            LinkedHashSet result = Sets.newLinkedHashSet();
            input = input.replaceAll("\\D+", " ");
            Iterable split = Splitter.on((String)" ").trimResults().omitEmptyStrings().split((CharSequence)input);
            Iterable splitIntegers = Iterables.transform((Iterable)split, STRING_TO_INTEGER);
            Iterables.addAll((Collection)result, (Iterable)splitIntegers);
            return result;
        }
    };
    public static final Function<Set<Integer>, String> ARRANGE_CAMPAIGNS_SET = new Function<Set<Integer>, String>(){

        public String apply(Set<Integer> input) {
            Preconditions.checkNotNull(input);
            ArrayList campaignsList = Lists.newArrayList(input);
            Collections.sort(campaignsList);
            String result = Joiner.on((String)", ").join((Iterable)campaignsList);
            return result;
        }
    };
    public static final Function<String, String> ARRANGE_CAMPAIGNS = Functions.compose(ARRANGE_CAMPAIGNS_SET, GET_CAMPAIGNS_SET);

    public static Pair<Integer, Integer> GET_CAMPAIGNS_BOUNDS() {
        return CAMPAIGNS_BOUNDS;
    }

    public static boolean ARE_CAMPAIGNS_VALIDS(String campaigns) {
        boolean result;
        block5: {
            Log log = LogFactory.getLog(CommonService.class);
            result = false;
            try {
                Set set = (Set)GET_CAMPAIGNS_SET.apply((Object)campaigns);
                boolean bl = result = set != null && !set.isEmpty();
                if (result) {
                    for (Integer integer : set) {
                        if (integer >= 2000 && integer <= 2999) continue;
                        if (log.isWarnEnabled()) {
                            String format = "Invalid campaign: %d. Must be contained between %d and %d. ";
                            String message = String.format(format, integer, 2000, 2999);
                            log.warn((Object)message);
                        }
                        result = false;
                    }
                }
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)("Invalid campaigns: " + campaigns), (Throwable)eee);
            }
        }
        return result;
    }
}

