/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class CacheService
extends AbstractAgrosystService {
    public static final String CACHE_HAS_ROLE = "hasRole";
    protected static Cache<String, Serializable> cache;
    protected static Cache<String, Serializable> shortCache;
    protected static final Set<String> shortCacheDiscriminators;

    protected Cache<String, Serializable> getCacheInstance(String discriminator) {
        Cache<String, Serializable> result;
        if (shortCacheDiscriminators.contains(discriminator)) {
            if (shortCache == null && this.getConfig().isBusinessCachingEnabled()) {
                long duration = this.getConfig().getBusinessCachingShortDuration();
                shortCache = CacheBuilder.newBuilder().expireAfterWrite(duration, TimeUnit.SECONDS).build();
            }
            result = shortCache;
        } else {
            if (cache == null && this.getConfig().isBusinessCachingEnabled()) {
                long duration = this.getConfig().getBusinessCachingDuration();
                cache = CacheBuilder.newBuilder().expireAfterWrite(duration, TimeUnit.MINUTES).build();
            }
            result = cache;
        }
        return result;
    }

    public <V extends Serializable> V get(String discriminator, Callable<? extends V> loader) {
        V result = this.get(discriminator, null, loader);
        return result;
    }

    public <K, V extends Serializable> V get(String discriminator, K key, Callable<? extends V> loader) {
        try {
            Serializable result;
            if (this.getConfig().isBusinessCachingEnabled()) {
                String cacheKey = String.format("%s#%s", discriminator, key);
                result = (Serializable)this.getCacheInstance(discriminator).get((Object)cacheKey, loader);
            } else {
                result = (Serializable)loader.call();
            }
            return (V)result;
        }
        catch (Exception eee) {
            if (eee instanceof RuntimeException) {
                throw (RuntimeException)eee;
            }
            throw new AgrosystTechnicalException("Unable to load type from cache", (Throwable)eee);
        }
    }

    public void clear() {
        if (cache != null) {
            cache.invalidateAll();
        }
        if (shortCache != null) {
            shortCache.invalidateAll();
        }
    }

    public void clear(String discriminator) {
        Cache<String, Serializable> instance = this.getCacheInstance(discriminator);
        if (instance != null) {
            instance.invalidateAll();
        }
    }

    static {
        shortCacheDiscriminators = Sets.newHashSet((Object[])new String[]{CACHE_HAS_ROLE});
    }
}

