/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.common;

import fr.inra.agrosyst.api.entities.AttachmentContent;
import fr.inra.agrosyst.api.entities.AttachmentContentTopiaDao;
import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.entities.AttachmentMetadataTopiaDao;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaEntity;

public class AttachmentServiceImpl
extends AbstractAgrosystService
implements AttachmentService {
    protected BusinessAuthorizationService authorizationService;
    protected AgrosystUserTopiaDao userDao;
    protected AttachmentMetadataTopiaDao attachmentMetadataDao;
    protected AttachmentContentTopiaDao attachmentContentDao;

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setUserDao(AgrosystUserTopiaDao userDao) {
        this.userDao = userDao;
    }

    public void setAttachmentMetadataDao(AttachmentMetadataTopiaDao attachmentMetadataDao) {
        this.attachmentMetadataDao = attachmentMetadataDao;
    }

    public void setAttachmentContentDao(AttachmentContentTopiaDao attachmentContentDao) {
        this.attachmentContentDao = attachmentContentDao;
    }

    public AttachmentMetadata addAttachment(String objectReferenceId, InputStream inputStream, String fileName, String fileContentType) {
        this.authorizationService.checkAddAttachment(objectReferenceId);
        AgrosystUser author = (AgrosystUser)this.userDao.forTopiaIdEquals(this.getSecurityContext().getUserId()).findUnique();
        AttachmentMetadata attachmentMetadata = (AttachmentMetadata)this.attachmentMetadataDao.newInstance();
        attachmentMetadata.setObjectReferenceId(objectReferenceId);
        attachmentMetadata.setAuthor(author);
        attachmentMetadata.setName(fileName);
        attachmentMetadata.setContentType(fileContentType);
        try {
            AttachmentContent attachmentContent = (AttachmentContent)this.attachmentContentDao.newInstance();
            Session hibernateSession = this.getPersistenceContext().getHibernateSupport().getHibernateSession();
            Blob blob = Hibernate.getLobCreator((Session)hibernateSession).createBlob(inputStream, (long)inputStream.available());
            attachmentContent.setContent(blob);
            attachmentMetadata.setSize(blob.length());
            attachmentMetadata = (AttachmentMetadata)this.attachmentMetadataDao.create((TopiaEntity)attachmentMetadata);
            attachmentContent.setAttachmentMetadata(attachmentMetadata);
            this.attachmentContentDao.create((TopiaEntity)attachmentContent);
        }
        catch (IOException ex) {
            throw new AgrosystTechnicalException("Can't upload file in database", (Throwable)ex);
        }
        catch (SQLException ex) {
            throw new AgrosystTechnicalException("Can't upload file in database", (Throwable)ex);
        }
        this.getTransaction().commit();
        return attachmentMetadata;
    }

    public void delete(String attachmentMetadataId) {
        this.authorizationService.checkDeleteAttachment(attachmentMetadataId);
        AttachmentMetadata attachmentMetadata = (AttachmentMetadata)this.attachmentMetadataDao.forTopiaIdEquals(attachmentMetadataId).findUnique();
        AttachmentContent attachmentContent = (AttachmentContent)this.attachmentContentDao.forAttachmentMetadataEquals(attachmentMetadata).findUnique();
        this.attachmentContentDao.delete(attachmentContent);
        this.attachmentMetadataDao.delete(attachmentMetadata);
        this.getTransaction().commit();
    }

    public InputStream getAttachmentContent(String attachmentMetadataId) {
        InputStream is;
        this.authorizationService.checkReadAttachment(attachmentMetadataId);
        AttachmentMetadata attachmentMetadata = (AttachmentMetadata)this.attachmentMetadataDao.forTopiaIdEquals(attachmentMetadataId).findUnique();
        AttachmentContent attachmentContents = (AttachmentContent)this.attachmentContentDao.forAttachmentMetadataEquals(attachmentMetadata).findUnique();
        try {
            is = attachmentContents.getContent().getBinaryStream();
        }
        catch (SQLException ex) {
            throw new AgrosystTechnicalException("Can't get file content from database", (Throwable)ex);
        }
        return is;
    }

    public List<AttachmentMetadata> getAttachmentMetadatas(String objectReferenceId) {
        List result = this.attachmentMetadataDao.forObjectReferenceIdEquals(objectReferenceId).findAll();
        return result;
    }

    public long getAttachmentMetadatasCount(String objectReferenceId) {
        long result = this.attachmentMetadataDao.forObjectReferenceIdEquals(objectReferenceId).count();
        return result;
    }

    public AttachmentMetadata getAttachmentMetadata(String attachmentTopiaId) {
        AttachmentMetadata result = (AttachmentMetadata)this.attachmentMetadataDao.forTopiaIdEquals(attachmentTopiaId).findUnique();
        return result;
    }
}

