/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.action;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.BiologicalControlAction;
import fr.inra.agrosyst.api.entities.action.BiologicalControlActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.CarriageAction;
import fr.inra.agrosyst.api.entities.action.CarriageActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.HarvestingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.HarvestingYeald;
import fr.inra.agrosyst.api.entities.action.HarvestingYealdTopiaDao;
import fr.inra.agrosyst.api.entities.action.IrrigationAction;
import fr.inra.agrosyst.api.entities.action.IrrigationActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesAction;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OtherAction;
import fr.inra.agrosyst.api.entities.action.OtherActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingAction;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.action.SeedingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.TillageAction;
import fr.inra.agrosyst.api.entities.action.TillageActionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.services.action.ActionService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.input.InputService;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ActionServiceImpl
extends AbstractAgrosystService
implements ActionService {
    protected InputService inputService;
    protected ReferentialService referentialService;
    protected AbstractActionTopiaDao abstractActionDao;
    protected HarvestingActionTopiaDao harvestingActionDao;
    protected SeedingActionTopiaDao seedingActionDao;
    protected OtherActionTopiaDao otherActionDao;
    protected IrrigationActionTopiaDao irrigationActionDao;
    protected TillageActionTopiaDao tillageActionDao;
    protected OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionDao;
    protected MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionDao;
    protected PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionDao;
    protected MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionDao;
    protected BiologicalControlActionTopiaDao biologicalControlActionDao;
    protected HarvestingYealdTopiaDao harvestingYealdDao;
    protected SeedingActionSpeciesTopiaDao seedingActionSpeciesDao;
    protected CarriageActionTopiaDao carriageActionDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionDao;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setInputService(InputService inputService) {
        this.inputService = inputService;
    }

    public void setAbstractActionDao(AbstractActionTopiaDao abstractActionDao) {
        this.abstractActionDao = abstractActionDao;
    }

    public void setHarvestingActionDao(HarvestingActionTopiaDao harvestingActionDao) {
        this.harvestingActionDao = harvestingActionDao;
    }

    public void setSeedingActionDao(SeedingActionTopiaDao seedingActionDao) {
        this.seedingActionDao = seedingActionDao;
    }

    public void setOtherActionDao(OtherActionTopiaDao otherActionDao) {
        this.otherActionDao = otherActionDao;
    }

    public void setIrrigationActionDao(IrrigationActionTopiaDao irrigationActionDao) {
        this.irrigationActionDao = irrigationActionDao;
    }

    public void setTillageActionDao(TillageActionTopiaDao tillageActionDao) {
        this.tillageActionDao = tillageActionDao;
    }

    public void setOrganicFertilizersSpreadingActionDao(OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionDao) {
        this.organicFertilizersSpreadingActionDao = organicFertilizersSpreadingActionDao;
    }

    public void setMaintenancePruningVinesActionDao(MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionDao) {
        this.maintenancePruningVinesActionDao = maintenancePruningVinesActionDao;
    }

    public void setPesticidesSpreadingActionDao(PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionDao) {
        this.pesticidesSpreadingActionDao = pesticidesSpreadingActionDao;
    }

    public void setMineralFertilizersSpreadingActionDao(MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionDao) {
        this.mineralFertilizersSpreadingActionDao = mineralFertilizersSpreadingActionDao;
    }

    public void setBiologicalControlActionDao(BiologicalControlActionTopiaDao biologicalControlActionDao) {
        this.biologicalControlActionDao = biologicalControlActionDao;
    }

    public void setHarvestingYealdDao(HarvestingYealdTopiaDao harvestingYealdDao) {
        this.harvestingYealdDao = harvestingYealdDao;
    }

    public void setSeedingActionSpeciesDao(SeedingActionSpeciesTopiaDao seedingActionSpeciesDao) {
        this.seedingActionSpeciesDao = seedingActionSpeciesDao;
    }

    public void setCarriageActionDao(CarriageActionTopiaDao carriageActionDao) {
        this.carriageActionDao = carriageActionDao;
    }

    public void setEffectiveCropCycleConnectionDao(EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionDao) {
        this.effectiveCropCycleConnectionDao = effectiveCropCycleConnectionDao;
    }

    public void setEffectivePerennialCropCycleDao(EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleDao) {
        this.effectivePerennialCropCycleDao = effectivePerennialCropCycleDao;
    }

    public Map<String, AbstractAction> createPracticedInterventionActions(PracticedIntervention intervention, List<AbstractAction> actions, Set<String> speciesCodes) {
        Map<String, AbstractAction> result = this.createOrUpdateActions(actions, null, intervention, null, speciesCodes);
        return result;
    }

    public Map<String, AbstractAction> updatePracticedInterventionActions(PracticedIntervention intervention, List<AbstractAction> actions, Set<String> speciesCodes) {
        List originalActions = this.abstractActionDao.forPracticedInterventionEquals(intervention).findAll();
        Map<String, AbstractAction> result = this.createOrUpdateActions(actions, originalActions, intervention, null, speciesCodes);
        return result;
    }

    public Map<String, AbstractAction> createEffectiveInterventionActions(EffectiveIntervention intervention, Collection<AbstractAction> actions, Set<String> speciesCodes) {
        Map<String, AbstractAction> result = this.createOrUpdateActions(actions, null, null, intervention, speciesCodes);
        return result;
    }

    public Map<String, AbstractAction> updateEffectiveInterventionActions(EffectiveIntervention intervention, Collection<AbstractAction> actions, Set<String> speciesCodes) {
        List originalActions = this.abstractActionDao.forEffectiveInterventionEquals(intervention).findAll();
        Map<String, AbstractAction> result = this.createOrUpdateActions(actions, originalActions, null, intervention, speciesCodes);
        return result;
    }

    protected Map<String, AbstractAction> createOrUpdateActions(Collection<AbstractAction> actions, Collection<AbstractAction> originalActions, PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention, Set<String> speciesCodes) {
        HashMap resultByIds = Maps.newHashMap();
        Map<String, AbstractAction> originalActionsByIds = this.getOriginalActionsByIds(originalActions);
        if (actions != null) {
            Preconditions.checkArgument((boolean)(effectiveIntervention == null ^ practicedIntervention == null));
            Collection<String> toolsCouplingCodes = this.getCropCycleToolsCouplingCodes(practicedIntervention, effectiveIntervention);
            for (AbstractAction action : actions) {
                String actionId = action.getTopiaId();
                action.setToolsCouplingCode(this.getActionToolsCouplingCode(toolsCouplingCodes, action));
                this.setCropCycleToAction(practicedIntervention, effectiveIntervention, action);
                AbstractAction savedAction = this.saveAction(speciesCodes, originalActionsByIds, action);
                resultByIds.put(actionId, savedAction);
            }
        }
        this.inputService.deleteInputForActions(originalActionsByIds.values());
        this.abstractActionDao.deleteAll(originalActionsByIds.values());
        return resultByIds;
    }

    protected AbstractAction saveAction(Set<String> speciesCodes, Map<String, AbstractAction> originalActionsByIds, AbstractAction action) {
        AbstractAction originalAction = this.getOriginalActionIfExists(originalActionsByIds, action);
        AbstractAction savedAction = originalAction == null ? this.saveNewAction(speciesCodes, action) : this.saveUpdatedAction(speciesCodes, action, originalAction);
        return savedAction;
    }

    protected Map<String, AbstractAction> getOriginalActionsByIds(Collection<AbstractAction> originalActions) {
        HashMap originalActionsByIds;
        if (originalActions == null) {
            originalActionsByIds = Maps.newHashMap();
        } else {
            ImmutableMap immutOriginalActionsMap = Maps.uniqueIndex(originalActions, (Function)Entities.GET_TOPIA_ID);
            originalActionsByIds = Maps.newHashMap((Map)immutOriginalActionsMap);
        }
        return originalActionsByIds;
    }

    protected AbstractAction saveUpdatedAction(Set<String> speciesCodes, AbstractAction action, AbstractAction originalAction) {
        AbstractAction currentAction;
        if (!originalAction.getClass().equals(action.getClass())) {
            throw new UnsupportedOperationException("Uncompatible action classes : " + originalAction.getClass().getName() + " VS " + action.getClass().getName());
        }
        if (originalAction instanceof HarvestingAction) {
            Collection originalHarvestingYealds = ((HarvestingAction)originalAction).getHarvestingYealds();
            ArrayList nonDeletedHarvestingYealds = Lists.newArrayList();
            if (originalHarvestingYealds == null) {
                originalHarvestingYealds = Lists.newArrayList();
                ((HarvestingAction)originalAction).setHarvestingYealds(originalHarvestingYealds);
            }
            Collection harvestingYealds = ((HarvestingAction)action).getHarvestingYealds();
            ImmutableMap indexedHarvestingYealds = Maps.uniqueIndex((Iterable)originalHarvestingYealds, (Function)Entities.GET_TOPIA_ID);
            for (HarvestingYeald harvestingYeald : harvestingYealds) {
                String topiaId = harvestingYeald.getTopiaId();
                HarvestingYeald originalHarvestingYeald = (HarvestingYeald)indexedHarvestingYealds.get(topiaId);
                if (originalHarvestingYeald != null) {
                    Binder binder = BinderFactory.newBinder(HarvestingYeald.class);
                    binder.copyExcluding((Object)harvestingYeald, (Object)originalHarvestingYeald, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
                    nonDeletedHarvestingYealds.add(originalHarvestingYeald);
                    continue;
                }
                originalHarvestingYealds.add(harvestingYeald);
                nonDeletedHarvestingYealds.add(harvestingYeald);
            }
            originalHarvestingYealds.retainAll(nonDeletedHarvestingYealds);
            Binder binder = BinderFactory.newBinder(HarvestingAction.class);
            binder.copyExcluding((Object)((HarvestingAction)action), (Object)((HarvestingAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "harvestingYealds"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof SeedingAction) {
            Collection originalSeedingActionSpeciess = ((SeedingAction)originalAction).getSeedingSpecies();
            ArrayList nonDeletedSeedingActionSpeciess = Lists.newArrayList();
            if (originalSeedingActionSpeciess == null) {
                originalSeedingActionSpeciess = Lists.newArrayList();
                ((SeedingAction)originalAction).setSeedingSpecies(originalSeedingActionSpeciess);
            }
            Collection seedingSpeciesActions = ((SeedingAction)action).getSeedingSpecies();
            ImmutableMap indexedSeedingActionSpeciess = Maps.uniqueIndex((Iterable)originalSeedingActionSpeciess, (Function)Entities.GET_TOPIA_ID);
            if (seedingSpeciesActions != null) {
                for (SeedingActionSpecies seedingSpeciesAction : seedingSpeciesActions) {
                    String topiaId = seedingSpeciesAction.getTopiaId();
                    SeedingActionSpecies originalSeedingActionSpecies = (SeedingActionSpecies)indexedSeedingActionSpeciess.get(topiaId);
                    if (!speciesCodes.contains(seedingSpeciesAction.getSpeciesCode())) continue;
                    if (originalSeedingActionSpecies != null) {
                        Binder binder = BinderFactory.newBinder(SeedingActionSpecies.class);
                        binder.copyExcluding((Object)seedingSpeciesAction, (Object)originalSeedingActionSpecies, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
                        nonDeletedSeedingActionSpeciess.add(originalSeedingActionSpecies);
                        continue;
                    }
                    originalSeedingActionSpeciess.add(seedingSpeciesAction);
                    nonDeletedSeedingActionSpeciess.add(seedingSpeciesAction);
                }
            }
            originalSeedingActionSpeciess.retainAll(nonDeletedSeedingActionSpeciess);
            Binder binder = BinderFactory.newBinder(SeedingAction.class);
            binder.copyExcluding((Object)((SeedingAction)action), (Object)((SeedingAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "seedingSpecies"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof OtherAction) {
            OtherAction otherAction = (OtherAction)action;
            Binder binder = BinderFactory.newBinder(OtherAction.class);
            binder.copyExcluding((Object)otherAction, (Object)((OtherAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof IrrigationAction) {
            Binder binder = BinderFactory.newBinder(IrrigationAction.class);
            binder.copyExcluding((Object)((IrrigationAction)action), (Object)((IrrigationAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof TillageAction) {
            Binder binder = BinderFactory.newBinder(TillageAction.class);
            binder.copyExcluding((Object)((TillageAction)action), (Object)((TillageAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof MineralFertilizersSpreadingAction) {
            MineralFertilizersSpreadingAction mineralFertilizersSpreadingAction = (MineralFertilizersSpreadingAction)action;
            Binder binder = BinderFactory.newBinder(MineralFertilizersSpreadingAction.class);
            binder.copyExcluding((Object)mineralFertilizersSpreadingAction, (Object)((MineralFertilizersSpreadingAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof OrganicFertilizersSpreadingAction) {
            OrganicFertilizersSpreadingAction organicFertilizersSpreadingAction = (OrganicFertilizersSpreadingAction)action;
            Binder binder = BinderFactory.newBinder(OrganicFertilizersSpreadingAction.class);
            binder.copyExcluding((Object)organicFertilizersSpreadingAction, (Object)((OrganicFertilizersSpreadingAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof MaintenancePruningVinesAction) {
            Binder binder = BinderFactory.newBinder(MaintenancePruningVinesAction.class);
            binder.copyExcluding((Object)((MaintenancePruningVinesAction)action), (Object)((MaintenancePruningVinesAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof BiologicalControlAction) {
            BiologicalControlAction biologicalControlAction = (BiologicalControlAction)action;
            Binder binder = BinderFactory.newBinder(BiologicalControlAction.class);
            binder.copyExcluding((Object)biologicalControlAction, (Object)((BiologicalControlAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof PesticidesSpreadingAction) {
            PesticidesSpreadingAction pesticidesSpreadingAction = (PesticidesSpreadingAction)action;
            Binder binder = BinderFactory.newBinder(PesticidesSpreadingAction.class);
            binder.copyExcluding((Object)pesticidesSpreadingAction, (Object)((PesticidesSpreadingAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else if (originalAction instanceof CarriageAction) {
            CarriageAction carriageAction = (CarriageAction)action;
            Binder binder = BinderFactory.newBinder(CarriageAction.class);
            binder.copyExcluding((Object)carriageAction, (Object)((CarriageAction)originalAction), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            currentAction = (AbstractAction)this.abstractActionDao.update((TopiaEntity)originalAction);
        } else {
            throw new UnsupportedOperationException("Unsupported action type");
        }
        return currentAction;
    }

    protected AbstractAction saveNewAction(Set<String> speciesCodes, AbstractAction action) {
        AbstractAction currentAction = this.getClonedAbstractAction(action);
        currentAction.setTopiaId(null);
        if (currentAction instanceof SeedingAction) {
            Collection seedingActionSpecieses = ((SeedingAction)currentAction).getSeedingSpecies();
            ArrayList validSeedingActionSpecieses = Lists.newArrayList();
            if (seedingActionSpecieses != null) {
                for (SeedingActionSpecies seedingActionSpeciese : seedingActionSpecieses) {
                    if (!speciesCodes.contains(seedingActionSpeciese.getSpeciesCode())) continue;
                    validSeedingActionSpecieses.add(seedingActionSpeciese);
                }
            }
            ((SeedingAction)currentAction).setSeedingSpecies((Collection)validSeedingActionSpecieses);
        }
        currentAction = (AbstractAction)this.abstractActionDao.create((TopiaEntity)currentAction);
        return currentAction;
    }

    protected AbstractAction getOriginalActionIfExists(Map<String, AbstractAction> currentOriginalActionsMap, AbstractAction action) {
        AbstractAction originalAction = null;
        if (StringUtils.isNotBlank((CharSequence)action.getTopiaId()) && !action.getTopiaId().contains("NEW-ACTION-")) {
            originalAction = currentOriginalActionsMap.remove(action.getTopiaId());
        }
        return originalAction;
    }

    protected void setCropCycleToAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention, AbstractAction action) {
        if (practicedIntervention != null) {
            action.setPracticedIntervention(practicedIntervention);
        } else {
            action.setEffectiveIntervention(effectiveIntervention);
        }
    }

    protected String getActionToolsCouplingCode(Collection<String> toolsCouplingCodes, AbstractAction action) {
        String toolsCouplingCode = null;
        if (action.getToolsCouplingCode() != null && toolsCouplingCodes.contains(action.getToolsCouplingCode())) {
            toolsCouplingCode = action.getToolsCouplingCode();
        }
        return toolsCouplingCode;
    }

    protected Collection<String> getCropCycleToolsCouplingCodes(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        Collection toolsCouplingCodes;
        if (practicedIntervention != null) {
            toolsCouplingCodes = practicedIntervention.getToolsCouplingCodes();
        } else if (effectiveIntervention.getToolCouplings() != null) {
            ArrayList toolsCouplings = Lists.newArrayList((Iterable)effectiveIntervention.getToolCouplings());
            toolsCouplingCodes = Lists.transform((List)toolsCouplings, (Function)EffectiveCropCycleService.GET_TOOLS_COUPLING_BY_CODE);
        } else {
            toolsCouplingCodes = Lists.newArrayList();
        }
        return toolsCouplingCodes;
    }

    public void duplicatePracticedActions(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention, PracticedIntervention practicedInterventionClone) {
        Preconditions.checkArgument((practicedIntervention != null ? 1 : 0) != 0);
        Preconditions.checkArgument((practicedInterventionClone != null ? 1 : 0) != 0);
        List actions = this.abstractActionDao.forPracticedInterventionEquals(practicedIntervention).findAll();
        for (AbstractAction originalAction : actions) {
            if (!this.isValidateAction(duplicateContext, originalAction).booleanValue()) continue;
            AbstractAction actionClone = this.getClonedAbstractAction(originalAction);
            this.migrateAction(duplicateContext, practicedInterventionClone, originalAction, actionClone);
            actionClone = (AbstractAction)this.abstractActionDao.create((TopiaEntity)actionClone);
            duplicateContext.getActionCache().put(originalAction, actionClone);
        }
        this.inputService.duplicateInputs(duplicateContext, practicedIntervention, null);
    }

    protected void migrateAction(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedInterventionClone, AbstractAction originalAction, AbstractAction actionClone) {
        if (!duplicateContext.getToolsCouplingsCode().contains(originalAction.getToolsCouplingCode())) {
            actionClone.setToolsCouplingCode(null);
        }
        actionClone.setPracticedIntervention(practicedInterventionClone);
        actionClone.setTopiaId(null);
    }

    protected Boolean isValidateAction(DuplicateCropCyclesContext duplicateContext, AbstractAction originalAction) {
        Pair pair;
        SeedingAction seedingAction;
        Collection seedingSpeciesActions;
        Boolean isValidAction = true;
        if (originalAction instanceof SeedingAction && (seedingSpeciesActions = (seedingAction = (SeedingAction)originalAction).getSeedingSpecies()) != null && (pair = (Pair)duplicateContext.getSpeciesByCropCode().get(duplicateContext.getTargetedCropCode())) != null) {
            Map speciesByCode = (Map)pair.getValue();
            for (SeedingActionSpecies seedingSpeciesAction : seedingSpeciesActions) {
                if (speciesByCode != null && speciesByCode.containsKey(seedingSpeciesAction.getSpeciesCode())) continue;
                isValidAction = false;
            }
        }
        return isValidAction;
    }

    public AbstractAction getClonedAbstractAction(AbstractAction originalAction) {
        AbstractAction actionClone;
        if (originalAction instanceof HarvestingAction) {
            HarvestingAction harvestingAction = (HarvestingAction)originalAction;
            actionClone = (AbstractAction)this.harvestingActionDao.newInstance();
            Collection originalHarvestingYealds = harvestingAction.getHarvestingYealds();
            if (originalHarvestingYealds != null) {
                for (HarvestingYeald harvestingYeald : originalHarvestingYealds) {
                    HarvestingYeald harvestingYealdClone = (HarvestingYeald)this.harvestingYealdDao.newInstance();
                    Binder binder = BinderFactory.newBinder(HarvestingYeald.class);
                    binder.copyExcluding((Object)harvestingYeald, (Object)harvestingYealdClone, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
                    ((HarvestingAction)actionClone).addHarvestingYealds(harvestingYealdClone);
                }
            }
            Binder binder = BinderFactory.newBinder(HarvestingAction.class);
            binder.copyExcluding((Object)harvestingAction, (Object)((HarvestingAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "harvestingYealds"});
        } else if (originalAction instanceof SeedingAction) {
            SeedingAction seedingAction = (SeedingAction)originalAction;
            actionClone = (AbstractAction)this.seedingActionDao.newInstance();
            Collection seedingSpeciesActions = seedingAction.getSeedingSpecies();
            if (seedingSpeciesActions != null) {
                for (SeedingActionSpecies seedingSpeciesAction : seedingSpeciesActions) {
                    SeedingActionSpecies seedingActionSpeciesClone = (SeedingActionSpecies)this.seedingActionSpeciesDao.newInstance();
                    Binder binder = BinderFactory.newBinder(SeedingActionSpecies.class);
                    binder.copyExcluding((Object)seedingSpeciesAction, (Object)seedingActionSpeciesClone, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
                    ((SeedingAction)actionClone).addSeedingSpecies(seedingActionSpeciesClone);
                }
            }
            Binder binder = BinderFactory.newBinder(SeedingAction.class);
            binder.copyExcluding((Object)seedingAction, (Object)((SeedingAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "seedingSpecies"});
        } else if (originalAction instanceof OtherAction) {
            actionClone = (AbstractAction)this.otherActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(OtherAction.class);
            binder.copyExcluding((Object)((OtherAction)originalAction), (Object)((OtherAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else if (originalAction instanceof IrrigationAction) {
            actionClone = (AbstractAction)this.irrigationActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(IrrigationAction.class);
            binder.copyExcluding((Object)((IrrigationAction)originalAction), (Object)((IrrigationAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else if (originalAction instanceof TillageAction) {
            actionClone = (AbstractAction)this.tillageActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(TillageAction.class);
            binder.copyExcluding((Object)((TillageAction)originalAction), (Object)((TillageAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else if (originalAction instanceof MineralFertilizersSpreadingAction) {
            actionClone = (AbstractAction)this.mineralFertilizersSpreadingActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(MineralFertilizersSpreadingAction.class);
            binder.copyExcluding((Object)((MineralFertilizersSpreadingAction)originalAction), (Object)((MineralFertilizersSpreadingAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else if (originalAction instanceof OrganicFertilizersSpreadingAction) {
            actionClone = (AbstractAction)this.organicFertilizersSpreadingActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(OrganicFertilizersSpreadingAction.class);
            binder.copyExcluding((Object)((OrganicFertilizersSpreadingAction)originalAction), (Object)((OrganicFertilizersSpreadingAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else if (originalAction instanceof MaintenancePruningVinesAction) {
            actionClone = (AbstractAction)this.maintenancePruningVinesActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(MaintenancePruningVinesAction.class);
            binder.copyExcluding((Object)((MaintenancePruningVinesAction)originalAction), (Object)((MaintenancePruningVinesAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else if (originalAction instanceof BiologicalControlAction) {
            actionClone = (AbstractAction)this.biologicalControlActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(BiologicalControlAction.class);
            binder.copyExcluding((Object)((BiologicalControlAction)originalAction), (Object)((BiologicalControlAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else if (originalAction instanceof PesticidesSpreadingAction) {
            actionClone = (AbstractAction)this.pesticidesSpreadingActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(PesticidesSpreadingAction.class);
            binder.copyExcluding((Object)((PesticidesSpreadingAction)originalAction), (Object)((PesticidesSpreadingAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else if (originalAction instanceof CarriageAction) {
            actionClone = (AbstractAction)this.carriageActionDao.newInstance();
            Binder binder = BinderFactory.newBinder(CarriageAction.class);
            binder.copyExcluding((Object)((CarriageAction)originalAction), (Object)((CarriageAction)actionClone), new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
        } else {
            throw new UnsupportedOperationException("Unsupported action type");
        }
        actionClone.setTopiaId("NEW-ACTION-" + UUID.randomUUID());
        return actionClone;
    }

    public void migrateActionsSpeciesToTargetedSpecies(Collection<AbstractAction> actions, Map<String, CroppingPlanSpecies> speciesByCode, Map<String, String> fromSpeciesCodeToSpeciesCode) {
        for (AbstractAction action : actions) {
            Collection seedingActionSpecieses;
            if (!(action instanceof SeedingAction) || (seedingActionSpecieses = ((SeedingAction)action).getSeedingSpecies()) == null) continue;
            ArrayList newSeedingActionSpecies = Lists.newArrayList();
            for (SeedingActionSpecies seedingActionSpecies : seedingActionSpecieses) {
                CroppingPlanSpecies species = speciesByCode.get(seedingActionSpecies.getSpeciesCode());
                if (species != null) {
                    newSeedingActionSpecies.add(seedingActionSpecies);
                    continue;
                }
                String toSpeciesCode = fromSpeciesCodeToSpeciesCode.get(seedingActionSpecies.getSpeciesCode());
                if (!StringUtils.isNotBlank((CharSequence)toSpeciesCode)) continue;
                seedingActionSpecies.setSpeciesCode(toSpeciesCode);
                newSeedingActionSpecies.add(seedingActionSpecies);
            }
            ((SeedingAction)action).setSeedingSpecies((Collection)newSeedingActionSpecies);
        }
    }
}

