/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystTopiaDaoSupplier;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.api.services.action.ActionService;
import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.context.NavigationContextService;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.edaplos.EdaplosService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.history.MessageService;
import fr.inra.agrosyst.api.services.input.InputService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.referential.ExportService;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.security.AuthorizationService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.api.services.security.TrackerService;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.action.ActionServiceImpl;
import fr.inra.agrosyst.services.common.AttachmentServiceImpl;
import fr.inra.agrosyst.services.common.CacheAware;
import fr.inra.agrosyst.services.common.CacheService;
import fr.inra.agrosyst.services.common.EmailService;
import fr.inra.agrosyst.services.common.EntityUsageService;
import fr.inra.agrosyst.services.common.PricesServiceImpl;
import fr.inra.agrosyst.services.context.NavigationContextServiceImpl;
import fr.inra.agrosyst.services.demo.DemoDatas;
import fr.inra.agrosyst.services.domain.DomainServiceImpl;
import fr.inra.agrosyst.services.edaplos.EdaplosServiceImpl;
import fr.inra.agrosyst.services.effective.EffectiveCropCycleServiceImpl;
import fr.inra.agrosyst.services.generic.GenericEntityServiceImpl;
import fr.inra.agrosyst.services.growingplan.GrowingPlanServiceImpl;
import fr.inra.agrosyst.services.growingsystem.GrowingSystemServiceImpl;
import fr.inra.agrosyst.services.history.MessageServiceImpl;
import fr.inra.agrosyst.services.input.InputServiceImpl;
import fr.inra.agrosyst.services.managementmode.ManagementModeServiceImpl;
import fr.inra.agrosyst.services.measurement.MeasurementServiceImpl;
import fr.inra.agrosyst.services.network.NetworkServiceImpl;
import fr.inra.agrosyst.services.performance.PerformanceServiceImpl;
import fr.inra.agrosyst.services.plot.PlotServiceImpl;
import fr.inra.agrosyst.services.practiced.PracticedPlotServiceImpl;
import fr.inra.agrosyst.services.practiced.PracticedSystemServiceImpl;
import fr.inra.agrosyst.services.referential.ExportServiceImpl;
import fr.inra.agrosyst.services.referential.ImportServiceImpl;
import fr.inra.agrosyst.services.referential.ReferentialServiceImpl;
import fr.inra.agrosyst.services.security.AnonymizeServiceImpl;
import fr.inra.agrosyst.services.security.AuthenticationServiceImpl;
import fr.inra.agrosyst.services.security.AuthorizationServiceImpl;
import fr.inra.agrosyst.services.security.BusinessAuthorizationServiceImpl;
import fr.inra.agrosyst.services.security.TrackerServiceImpl;
import fr.inra.agrosyst.services.users.UserServiceImpl;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.util.beans.BeanUtil;

public class DefaultServiceFactory
implements ServiceFactory {
    private static final Log log = LogFactory.getLog(DefaultServiceFactory.class);
    protected static final Map<Class<? extends AgrosystService>, Class<? extends AgrosystService>> INTERFACE_TO_IMPL = Maps.newHashMap();
    protected static final String LEGACY_DAO_SUFFIX = "DAO";
    protected static final String DAO_SUFFIX = "TopiaDao";
    protected Map<Class<? extends AgrosystService>, AgrosystService> servicesCache = Maps.newConcurrentMap();
    protected Map<Class<? extends TopiaDao>, TopiaDao> daoCache = Maps.newConcurrentMap();
    protected ServiceContext serviceContext;

    public DefaultServiceFactory(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public <E extends AgrosystService> E newService(Class<E> clazz) {
        Preconditions.checkNotNull(clazz);
        long start = System.currentTimeMillis();
        int nbServicesBefore = this.servicesCache.size();
        int nbDaoBefore = this.daoCache.size();
        E service = this.findOrCreateService(clazz);
        if (log.isTraceEnabled()) {
            long duration = System.currentTimeMillis() - start;
            int nbServicesCreated = this.servicesCache.size() - nbServicesBefore;
            int nbDaoCreated = this.daoCache.size() - nbDaoBefore;
            String format = "Service '%s' created in %dms. %d new services and %d new dao has been instantiated";
            String message = String.format(format, clazz.getSimpleName(), duration, nbServicesCreated, nbDaoCreated);
            log.trace((Object)message);
        }
        return service;
    }

    protected <E extends AgrosystService> E findOrCreateService(Class<E> clazz) {
        AgrosystService service = this.servicesCache.get(clazz);
        if (service == null) {
            try {
                Class<? extends AgrosystService> implClazz = INTERFACE_TO_IMPL.get(clazz);
                Preconditions.checkNotNull(implClazz, (Object)("Unable to find implementation class for service: " + clazz));
                service = implClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException ie) {
                throw new AgrosystTechnicalException("Unable to instantiate service for class " + clazz.getName(), (Throwable)ie);
            }
            catch (InvocationTargetException ite) {
                throw new AgrosystTechnicalException("Unable to instantiate service for class " + clazz.getName(), (Throwable)ite);
            }
            catch (NoSuchMethodException nsme) {
                throw new AgrosystTechnicalException("Unable to instantiate service for class " + clazz.getName(), (Throwable)nsme);
            }
            catch (IllegalAccessException iae) {
                throw new AgrosystTechnicalException("Unable to instantiate service for class " + clazz.getName(), (Throwable)iae);
            }
            this.servicesCache.put(clazz, service);
            this.injectProperties(service);
            if (service instanceof AbstractAgrosystService) {
                ((AbstractAgrosystService)service).setContext(this.serviceContext);
            }
        }
        return (E)service;
    }

    protected <E> void injectProperties(E instance) {
        Set descriptors = BeanUtil.getDescriptors(instance.getClass(), (Predicate)BeanUtil.IS_WRITE_DESCRIPTOR);
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            AgrosystServiceConfig toInject = null;
            if (AgrosystService.class.isAssignableFrom(propertyType)) {
                Class<?> serviceClass = propertyType;
                toInject = (AgrosystServiceConfig)this.findOrCreateService(serviceClass);
            } else if (AgrosystServiceConfig.class.isAssignableFrom(propertyType)) {
                toInject = this.serviceContext.getConfig();
            } else if (TopiaDao.class.isAssignableFrom(propertyType)) {
                Class<?> daoType = propertyType;
                toInject = this.getDaoInstance(daoType);
            }
            if (toInject == null) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("injecting " + toInject + " in instance " + instance));
            }
            try {
                propertyDescriptor.getWriteMethod().invoke(instance, toInject);
            }
            catch (IllegalAccessException iae) {
                String message = String.format("Unable to inject '%s' in instance '%s'", toInject.getClass().getName(), instance.getClass().getName());
                throw new AgrosystTechnicalException(message, (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                String message = String.format("Unable to inject '%s' in instance '%s'", toInject.getClass().getName(), instance.getClass().getName());
                throw new AgrosystTechnicalException(message, (Throwable)ite);
            }
        }
    }

    protected <D extends TopiaDao> D getDaoInstance(Class<D> daoClass) {
        TopiaDao toInject = this.daoCache.get(daoClass);
        if (toInject == null) {
            String daoName = daoClass.getName();
            if (daoName.endsWith(LEGACY_DAO_SUFFIX) || daoName.endsWith(DAO_SUFFIX)) {
                AgrosystTopiaDaoSupplier daoSupplier = this.serviceContext.getDaoSupplier();
                try {
                    String className = daoName.substring(0, daoName.length() - DAO_SUFFIX.length());
                    if (daoName.endsWith(LEGACY_DAO_SUFFIX)) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Legacy DAO detected: " + daoName));
                        }
                        className = daoName.substring(0, daoName.length() - LEGACY_DAO_SUFFIX.length());
                    }
                    Class<?> aClass = Class.forName(className);
                    toInject = daoSupplier.getDao(aClass);
                    this.daoCache.put(daoClass, toInject);
                }
                catch (ClassNotFoundException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"An exception occurred", (Throwable)e);
                    }
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Unable to guess entity name : " + daoClass));
            }
        }
        if (toInject != null && toInject instanceof CacheAware) {
            ((CacheAware)toInject).setCacheServiceSupplier(new Supplier<CacheService>(){
                protected CacheService cacheService;

                public CacheService get() {
                    if (this.cacheService == null) {
                        this.cacheService = DefaultServiceFactory.this.newService(CacheService.class);
                    }
                    return this.cacheService;
                }
            });
        }
        return (D)toInject;
    }

    public <I> I newInstance(Class<I> clazz) {
        I instance;
        try {
            instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new AgrosystTechnicalException("Unable to instantiate object for class " + clazz.getName(), (Throwable)ie);
        }
        catch (InvocationTargetException ite) {
            throw new AgrosystTechnicalException("Unable to instantiate object for class " + clazz.getName(), (Throwable)ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new AgrosystTechnicalException("Unable to instantiate object for class " + clazz.getName(), (Throwable)nsme);
        }
        catch (IllegalAccessException iae) {
            throw new AgrosystTechnicalException("Unable to instantiate object for class " + clazz.getName(), (Throwable)iae);
        }
        this.injectProperties(instance);
        return instance;
    }

    static {
        INTERFACE_TO_IMPL.put(DomainService.class, DomainServiceImpl.class);
        INTERFACE_TO_IMPL.put(GrowingPlanService.class, GrowingPlanServiceImpl.class);
        INTERFACE_TO_IMPL.put(GrowingSystemService.class, GrowingSystemServiceImpl.class);
        INTERFACE_TO_IMPL.put(NavigationContextService.class, NavigationContextServiceImpl.class);
        INTERFACE_TO_IMPL.put(ReferentialService.class, ReferentialServiceImpl.class);
        INTERFACE_TO_IMPL.put(ImportService.class, ImportServiceImpl.class);
        INTERFACE_TO_IMPL.put(ExportService.class, ExportServiceImpl.class);
        INTERFACE_TO_IMPL.put(EdaplosService.class, EdaplosServiceImpl.class);
        INTERFACE_TO_IMPL.put(UserService.class, UserServiceImpl.class);
        INTERFACE_TO_IMPL.put(PlotService.class, PlotServiceImpl.class);
        INTERFACE_TO_IMPL.put(PracticedSystemService.class, PracticedSystemServiceImpl.class);
        INTERFACE_TO_IMPL.put(PracticedPlotService.class, PracticedPlotServiceImpl.class);
        INTERFACE_TO_IMPL.put(GenericEntityService.class, GenericEntityServiceImpl.class);
        INTERFACE_TO_IMPL.put(NetworkService.class, NetworkServiceImpl.class);
        INTERFACE_TO_IMPL.put(AuthenticationService.class, AuthenticationServiceImpl.class);
        INTERFACE_TO_IMPL.put(AuthorizationService.class, AuthorizationServiceImpl.class);
        INTERFACE_TO_IMPL.put(BusinessAuthorizationService.class, BusinessAuthorizationServiceImpl.class);
        INTERFACE_TO_IMPL.put(AnonymizeService.class, AnonymizeServiceImpl.class);
        INTERFACE_TO_IMPL.put(ManagementModeService.class, ManagementModeServiceImpl.class);
        INTERFACE_TO_IMPL.put(EffectiveCropCycleService.class, EffectiveCropCycleServiceImpl.class);
        INTERFACE_TO_IMPL.put(AttachmentService.class, AttachmentServiceImpl.class);
        INTERFACE_TO_IMPL.put(MeasurementService.class, MeasurementServiceImpl.class);
        INTERFACE_TO_IMPL.put(PerformanceService.class, PerformanceServiceImpl.class);
        INTERFACE_TO_IMPL.put(PricesService.class, PricesServiceImpl.class);
        INTERFACE_TO_IMPL.put(ActionService.class, ActionServiceImpl.class);
        INTERFACE_TO_IMPL.put(InputService.class, InputServiceImpl.class);
        INTERFACE_TO_IMPL.put(TrackerService.class, TrackerServiceImpl.class);
        INTERFACE_TO_IMPL.put(MessageService.class, MessageServiceImpl.class);
        INTERFACE_TO_IMPL.put(TrackerServiceImpl.class, TrackerServiceImpl.class);
        INTERFACE_TO_IMPL.put(EmailService.class, EmailService.class);
        INTERFACE_TO_IMPL.put(DemoDatas.class, DemoDatas.class);
        INTERFACE_TO_IMPL.put(EntityUsageService.class, EntityUsageService.class);
        INTERFACE_TO_IMPL.put(CacheService.class, CacheService.class);
    }
}

