/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import com.google.common.base.Supplier;
import com.google.gson.Gson;
import fr.inra.agrosyst.api.entities.AgrosystTopiaDaoSupplier;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.commons.gson.AgrosystGsonSupplier;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.DefaultServiceFactory;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.util.Date;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaTransaction;

public class DefaultServiceContext
implements ServiceContext {
    protected ServiceFactory serviceFactory;
    protected Supplier<AgrosystTopiaPersistenceContext> transactionSupplier;
    protected AgrosystTopiaPersistenceContext persistenceContext;
    protected AgrosystServiceConfig config;
    private String authenticationToken;
    private SecurityContext securityContext;

    public DefaultServiceContext(AgrosystServiceConfig config, Supplier<AgrosystTopiaPersistenceContext> transactionSupplier) {
        this.config = config;
        this.transactionSupplier = transactionSupplier;
    }

    public DefaultServiceContext(AgrosystServiceConfig config, Supplier<AgrosystTopiaPersistenceContext> transactionSupplier, String authenticationToken) {
        this(config, transactionSupplier);
        this.authenticationToken = authenticationToken;
    }

    @Override
    public ServiceContext newServiceContext() {
        DefaultServiceContext serviceContext = new DefaultServiceContext(this.config, this.transactionSupplier, this.authenticationToken);
        return serviceContext;
    }

    @Override
    public Date getCurrentDate() {
        return new Date();
    }

    @Override
    public TopiaTransaction getTransaction() {
        TopiaTransaction result = this.getTransaction(true);
        return result;
    }

    @Override
    public TopiaTransaction getTransaction(boolean create) {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(create);
        return result;
    }

    @Override
    public AgrosystTopiaDaoSupplier getDaoSupplier() {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(true);
        return result;
    }

    @Override
    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(true);
        return result;
    }

    @Override
    public AgrosystTopiaPersistenceContext getPersistenceContext(boolean create) {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(create);
        return result;
    }

    @Override
    public void close() {
        AgrosystTopiaPersistenceContext context = this.getPersistenceContext(false);
        if (context != null) {
            context.close();
        }
    }

    protected AgrosystTopiaPersistenceContext getTransaction0(boolean create) {
        if (this.persistenceContext == null && create) {
            try {
                this.persistenceContext = (AgrosystTopiaPersistenceContext)this.transactionSupplier.get();
            }
            catch (TopiaException ex) {
                throw new AgrosystTechnicalException("Can't begin new transaction", (Throwable)ex);
            }
        }
        return this.persistenceContext;
    }

    public ServiceFactory getServiceFactory() {
        if (this.serviceFactory == null) {
            this.serviceFactory = new DefaultServiceFactory(this);
        }
        return this.serviceFactory;
    }

    @Override
    public <E extends AgrosystService> E newService(Class<E> clazz) {
        AgrosystService result = this.getServiceFactory().newService(clazz);
        return (E)result;
    }

    @Override
    public AgrosystServiceConfig getConfig() {
        return this.config;
    }

    @Override
    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = new SecurityContext(this.getServiceFactory(), this.authenticationToken);
        }
        return this.securityContext;
    }

    @Override
    public SecurityContext getSecurityContextAsUser(String userId) {
        SecurityContext securityContext = new SecurityContext(this.getServiceFactory(), this.authenticationToken, userId);
        return securityContext;
    }

    @Override
    public <I> I newInstance(Class<I> clazz) {
        return (I)this.getServiceFactory().newInstance(clazz);
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
        this.securityContext = null;
    }

    @Override
    public Gson getGson() {
        return new AgrosystGsonSupplier().get();
    }
}

