/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;

public class AgrosystServiceConfig {
    private static final Log log = LogFactory.getLog(AgrosystServiceConfig.class);
    protected static final String AGROSYST_DEFAULT_CONF_FILENAME = "agrosyst-default.properties";
    protected ApplicationConfig config;

    public AgrosystServiceConfig(String configFileName) {
        try {
            ApplicationConfig defaultConfig = new ApplicationConfig(AGROSYST_DEFAULT_CONF_FILENAME);
            defaultConfig.loadDefaultOptions((ConfigOptionDef[])ServiceConfigOption.values());
            defaultConfig.parse(new String[0]);
            if (StringUtils.isNotBlank((CharSequence)configFileName)) {
                Properties flatOptions = defaultConfig.getFlatOptions(false);
                this.config = new ApplicationConfig(flatOptions, configFileName);
                this.config.parse(new String[0]);
            } else {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No specific configuration provided, using the default one");
                }
                this.config = defaultConfig;
            }
        }
        catch (ArgumentsParserException ex) {
            throw new AgrosystTechnicalException("Can't read configuration", (Throwable)ex);
        }
    }

    public Properties getFlatOptions() {
        return this.config.getFlatOptions();
    }

    public String getApplicationVersion() {
        return this.config.getOption(ServiceConfigOption.APPLICATION_VERSION.key);
    }

    public String getApplicationBaseUrl() {
        String result = this.config.getOption(ServiceConfigOption.APPLICATION_BASE_URL.key).trim();
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public boolean isDemoModeEnabled() {
        return this.config.getOptionAsBoolean(ServiceConfigOption.DEMO_MODE.key);
    }

    public boolean isGenerateBuiltinReferentials() {
        return this.config.getOptionAsBoolean(ServiceConfigOption.GENERATE_BUILTIN_REFERENTIALS.key);
    }

    public boolean isGenerateBuiltinUsers() {
        return this.config.getOptionAsBoolean(ServiceConfigOption.GENERATE_BUILTIN_USERS.key);
    }

    public int getSpeciesGraftSupportCodeSection() {
        return this.config.getOptionAsInt(ServiceConfigOption.SPECIES_GRAFTSUPPORT_CODESECTION.key);
    }

    public String getSpeciesGraftSupportUtilisation() {
        return this.config.getOption(ServiceConfigOption.SPECIES_GRAFTSUPPORT_UTILISATION.key);
    }

    public String getSpeciesGraftCloneTypeVarietal() {
        return this.config.getOption(ServiceConfigOption.SPECIES_GRAFTCLONE_TYPEVARIETAL.key);
    }

    public boolean isTokenStorageEnabled() {
        return this.config.getOptionAsBoolean(ServiceConfigOption.TOKEN_STORAGE_ENABLED.key);
    }

    public boolean isBusinessCachingEnabled() {
        return this.config.getOptionAsBoolean(ServiceConfigOption.BUSINESS_CACHING_ENABLED.key);
    }

    public void setBusinessCachingEnabled(boolean value) {
        this.config.setOption(ServiceConfigOption.BUSINESS_CACHING_ENABLED.key, String.valueOf(value));
    }

    public long getBusinessCachingDuration() {
        return this.config.getOptionAsLong(ServiceConfigOption.BUSINESS_CACHING_DURATION.key);
    }

    public long getBusinessCachingShortDuration() {
        return this.config.getOptionAsLong(ServiceConfigOption.BUSINESS_CACHING_SHORT_DURATION.key);
    }

    public int getActaDosageSpcCroppingZonesGroupId() {
        return this.config.getOptionAsInt(ServiceConfigOption.ACTA_DOSAGE_SPC_CROPPING_ZONES_GROUP_ID.key);
    }

    public String getFileEncoding() {
        return this.config.getOption(ServiceConfigOption.FILE_ENCODING.key);
    }

    public String getSmtpHost() {
        return this.config.getOption(ServiceConfigOption.EMAIL_SMPT_HOST.key);
    }

    public int getSmtpPort() {
        return this.config.getOptionAsInt(ServiceConfigOption.EMAIL_SMPT_PORT.key);
    }

    public String getEmailFrom() {
        return this.config.getOption(ServiceConfigOption.EMAIL_FROM.key);
    }

    public String getFeedbackEmail() {
        return this.config.getOption(ServiceConfigOption.USER_FEEDBACK_EMAIL.key);
    }

    public String getSupportEmail() {
        return this.config.getOption(ServiceConfigOption.USER_SUPPORT_EMAIL.key);
    }

    public String getLogFileLocation() {
        return this.config.getOption(ServiceConfigOption.LOG_FILE_LOCATION.key);
    }

    static enum ServiceConfigOption implements ConfigOptionDef
    {
        APPLICATION_VERSION("agrosyst.services.application.version", null),
        APPLICATION_BASE_URL("agrosyst.services.application.base_url", "http://demo.codelutin.com/agrosyst-stable"),
        DATABASE_HBM2DLL_AUTO("hibernate.hbm2ddl.auto", "none"),
        DATABASE_DIALECT("hibernate.dialect", "org.hibernate.dialect.H2Dialect"),
        DATABASE_DRIVER("hibernate.connection.driver_class", "org.h2.Driver"),
        DATABASE_URL("hibernate.connection.url", "jdbc:h2:file:/tmp/agrosyst/h2data-web"),
        DATABASE_USER("hibernate.connection.username", "sa"),
        DATABASE_PASS("hibernate.connection.password", ""),
        DATABASE_C3P0_MIN_SIZE("hibernate.c3p0.min_size", "5"),
        DATABASE_C3P0_MAX_SIZE("hibernate.c3p0.max_size", "20"),
        DATABASE_C3P0_TIMEOUT("hibernate.c3p0.timeout", "300"),
        DATABASE_C3P0_MAX_STATEMENTS("hibernate.c3p0.max_statements", "50"),
        EMAIL_SMPT_HOST("agrosyst.services.email.smtp_host", "localhost"),
        EMAIL_SMPT_PORT("agrosyst.services.email.smtp_port", "25"),
        EMAIL_FROM("agrosyst.services.email.from", "no-reply+agrosyst@inra.fr"),
        USER_FEEDBACK_EMAIL("agrosyst.services.email.feedback", "agrosyst-commits@list.forge.codelutin.com"),
        USER_SUPPORT_EMAIL("agrosyst.services.email.support", "agrosyst-users@listes.inra.fr"),
        DEMO_MODE("agrosyst.services.demoMode", "false"),
        GENERATE_BUILTIN_REFERENTIALS("agrosyst.services.generateBuiltinReferentials", "true"),
        GENERATE_BUILTIN_USERS("agrosyst.services.generateBuiltinUsers", "true"),
        SPECIES_GRAFTSUPPORT_CODESECTION("agrosyst.services.species.graftsupport.codesection", "26"),
        SPECIES_GRAFTSUPPORT_UTILISATION("agrosyst.services.species.graftsupport.utilisation", "PG"),
        SPECIES_GRAFTCLONE_TYPEVARIETAL("agrosyst.services.species.graftslone.typevarietal", "CLO"),
        TOKEN_STORAGE_ENABLED("agrosyst.services.security.tokenStorageEnabled", "false"),
        FILE_ENCODING("agrosyst.services.file.encoding", "utf-8"),
        LOG_FILE_LOCATION("agrosyst.services.log.file.location", null),
        BUSINESS_CACHING_ENABLED("agrosyst.services.businessCaching.enabled", "true"),
        BUSINESS_CACHING_DURATION("agrosyst.services.businessCaching.duration", "5"),
        BUSINESS_CACHING_SHORT_DURATION("agrosyst.services.businessCaching.shortDuration", "30"),
        ACTA_DOSAGE_SPC_CROPPING_ZONES_GROUP_ID("agrosyst.services.referential.acta_dosage_spc_complet.id_groupe_culture_zones_cultivees", "428");

        private String key;
        private String defaultValue;

        private ServiceConfigOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Class<?> getType() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean isFinal() {
            return false;
        }

        public void setDefaultValue(String defaultValue) {
        }

        public void setTransient(boolean isTransient) {
        }

        public void setFinal(boolean isFinal) {
        }
    }
}

