/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.nuiton.topia.flyway.TopiaFlywayServiceImpl;

public class AgrosystConfigurationHelper {
    public static Function<Properties, AgrosystTopiaApplicationContext> getCreateTopiaContextFunction(final AgrosystServiceConfig config) {
        return new Function<Properties, AgrosystTopiaApplicationContext>(){

            public AgrosystTopiaApplicationContext apply(Properties input) {
                AgrosystTopiaApplicationContext result = new AgrosystTopiaApplicationContext(config, input);
                return result;
            }
        };
    }

    public static Properties getRootContextProperties(AgrosystServiceConfig serviceConfig) {
        Properties result = serviceConfig.getFlatOptions();
        result.setProperty("topia.persistence.classes", AgrosystEntityEnum.getImplementationClassesAsString());
        LinkedHashMap toAddIfNotPresent = Maps.newLinkedHashMap();
        toAddIfNotPresent.put("topia.service.migration", TopiaFlywayServiceImpl.class.getName());
        toAddIfNotPresent.put("topia.service.migration.useModelVersion", "false");
        toAddIfNotPresent.put("topia.persistence.initSchema", "true");
        for (Map.Entry entry : toAddIfNotPresent.entrySet()) {
            if (result.containsKey(entry.getKey())) continue;
            result.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }
}

