/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaTransaction;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public abstract class AbstractAgrosystService
implements AgrosystService {
    private static final Log log = LogFactory.getLog(AbstractAgrosystService.class);
    protected ServiceContext context;

    public ServiceContext getContext() {
        return this.context;
    }

    public void setContext(ServiceContext context) {
        this.context = context;
    }

    public TopiaTransaction getTransaction() {
        return this.context.getTransaction();
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        return this.context.getPersistenceContext();
    }

    protected AgrosystServiceConfig getConfig() {
        return this.context.getConfig();
    }

    public SecurityContext getSecurityContext() {
        return this.context.getSecurityContext();
    }

    protected SecurityContext getSecurityContextAsUser(String userId) {
        return this.context.getSecurityContextAsUser(userId);
    }

    public <I> I newInstance(Class<I> clazz) {
        return this.context.newInstance(clazz);
    }

    protected void finalize() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug((Object)("FINALIZE " + this.getClass().getName()));
        }
        super.finalize();
    }

    public <K extends TopiaEntity> void easyBind(TopiaDao<K> dao, List<K> existingRaw, List<K> newItemsRaw, Function<K, Void> onNewItem, String ... exclusions) {
        this.easyBind(dao, existingRaw, newItemsRaw, onNewItem, (Function<K, Void>)null, exclusions);
    }

    public <K extends TopiaEntity> void easyBind(TopiaDao<K> dao, List<K> existingRaw, List<K> newItemsRaw, Function<K, Void> onNewItem, Function<K, Void> afterBind, String ... exclusions) {
        List<K> toDelete = this.easyBindNoDelete(dao, existingRaw, newItemsRaw, onNewItem, afterBind, exclusions);
        dao.deleteAll(toDelete);
    }

    public <K extends TopiaEntity> List<K> easyBindNoDelete(TopiaDao<K> dao, List<K> existingRaw, List<K> newItemsRaw, Function<K, Void> onNewItem, Function<K, Void> afterBind, String ... exclusions) {
        ArrayList emptyList = Lists.newArrayList();
        List existing = (List)MoreObjects.firstNonNull(existingRaw, (Object)emptyList);
        List newItems = (List)MoreObjects.firstNonNull(newItemsRaw, (Object)emptyList);
        HashSet exclusionsSet = Sets.newHashSet((Object[])new String[]{"topiaCreateDate"});
        if (exclusions != null) {
            Iterables.addAll((Collection)exclusionsSet, (Iterable)Sets.newHashSet((Object[])exclusions));
        }
        String[] exclusionsArray = (String[])Iterables.toArray((Iterable)exclusionsSet, String.class);
        ArrayList toDelete = Lists.newArrayList((Iterable)existing);
        ImmutableMap existingIndex = Maps.uniqueIndex((Iterable)existing, (Function)Entities.GET_TOPIA_ID);
        for (TopiaEntity item : newItems) {
            String topiaId = item.getTopiaId();
            TopiaEntity entityEntry = (TopiaEntity)existingIndex.get(topiaId);
            if (entityEntry == null) {
                entityEntry = dao.newInstance();
            } else {
                toDelete.remove(entityEntry);
            }
            Class<?> clazz = item.getClass();
            Binder binder = BinderFactory.newBinder(clazz);
            binder.copyExcluding((Object)item, (Object)entityEntry, exclusionsArray);
            if (afterBind != null) {
                afterBind.apply((Object)entityEntry);
            }
            if (entityEntry.isPersisted()) {
                dao.update(entityEntry);
                continue;
            }
            if (onNewItem != null) {
                onNewItem.apply((Object)entityEntry);
            }
            dao.create(entityEntry);
        }
        return toDelete;
    }
}

