/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.utils;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;

public class DaoUtils {
    protected static final String LIKE = "TRANSLATE(LOWER( %s ),'\u00e1\u00e0\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u00e8\u00e9\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u00ec\u00ed\u00ee\u00ef\u00ec\u0129\u012b\u012d\u1e29\u00f3\u00f4\u00f5\u00f6\u014d\u014f\u0151\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u00e4\u00e0\u00e1\u00e2\u00e3\u00e5\u00e6\u00e7\u0107\u0109\u010d\u00f6\u00f2\u00f3\u00f4\u00f5\u00f8\u00fc\u00f9\u00fa\u00fb\u00df\u00e9\u00e8\u00ea\u00eb\u00fd\u00f1\u00ee\u00ec\u00ed\u00ef\u015f','aaaaaaaaaeeeeeeeeeeiiiiiiiihooooooouuuuuuuuaaaaaaeccccoooooouuuuseeeeyniiiis')like LOWER( %s )";

    public static String getFieldLikeInsensitive(String field1, String field2) {
        String query = String.format(LIKE, field1, field2);
        return query;
    }

    public static PagerBean getPager(int page, int itemPerPage, long totalCount) {
        PagerBean bean = new PagerBean();
        bean.setPageIndex(page);
        bean.setPageSize(itemPerPage);
        bean.setPagesNumber(PagerBeanUtil.getTotalPage((long)((int)totalCount), (int)itemPerPage));
        bean.setRecords(totalCount);
        return bean;
    }

    public static String addQueryAttribute(Map<String, Object> args, String entityAttributeName, Object value) {
        String queryAttributeName;
        String baseAttributeName = entityAttributeName.replaceAll("[.]", "_");
        int index = 0;
        do {
            queryAttributeName = baseAttributeName + index;
            ++index;
        } while (args.containsKey(queryAttributeName));
        args.put(queryAttributeName, value);
        return queryAttributeName;
    }

    protected static String getQueryForAttributeLike(String entityAlias, String entityAttributeName, Map<String, Object> args, String likeValue, String operator) {
        String alias = StringUtils.isBlank((CharSequence)entityAlias) ? "" : entityAlias + ".";
        String queryAttributeName = DaoUtils.addQueryAttribute(args, entityAttributeName, StringUtils.stripAccents((String)likeValue));
        String result = " " + operator + " " + DaoUtils.getFieldLikeInsensitive(alias + entityAttributeName, ":" + queryAttributeName);
        return result;
    }

    public static String andAttributeLike(String entityAlias, String entityAttributeName, Map<String, Object> args, String value) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            result = DaoUtils.getQueryForAttributeLike(entityAlias, entityAttributeName, args, "%" + value + "%", "AND");
        }
        return result;
    }

    public static String orAttributeLike(String entityAlias, String entityAttributeName, Map<String, Object> args, String value) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            result = DaoUtils.getQueryForAttributeLike(entityAlias, entityAttributeName, args, "%" + value + "%", "OR");
        }
        return result;
    }

    public static String andAttributeStartLike(String entityAlias, String entityAttributeName, Map<String, Object> args, String value) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            result = DaoUtils.getQueryForAttributeLike(entityAlias, entityAttributeName, args, value + "%", "AND");
        }
        return result;
    }

    public static String orAttributeStartLike(String entityAlias, String entityAttributeName, Map<String, Object> args, String value) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            result = DaoUtils.getQueryForAttributeLike(entityAlias, entityAttributeName, args, value + "%", "OR");
        }
        return result;
    }

    public static String orAttributeEquals(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value) {
        String result = DaoUtils.getQueryForAttributeEquals(entityAlias, entityAttributeName, args, value, "OR");
        return result;
    }

    protected static String getQueryForAttributeEquals(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value, String operator) {
        String result = "";
        if (value != null) {
            String alias = StringUtils.isBlank((CharSequence)entityAlias) ? "" : entityAlias + ".";
            String queryAttributeName = DaoUtils.addQueryAttribute(args, entityAttributeName, value);
            result = result + String.format(" %s %s = :%s", operator, alias + entityAttributeName, queryAttributeName);
        }
        return result;
    }

    protected static String getQueryForAttributeNotEquals(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value, String operator) {
        String result = "";
        if (value != null) {
            String alias = StringUtils.isBlank((CharSequence)entityAlias) ? "" : entityAlias + ".";
            String queryAttributeName = DaoUtils.addQueryAttribute(args, entityAttributeName, value);
            result = result + String.format(" %s %s != :%s", operator, alias + entityAttributeName, queryAttributeName);
        }
        return result;
    }

    public static String andAttributeEquals(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value) {
        String result = DaoUtils.getQueryForAttributeEquals(entityAlias, entityAttributeName, args, value, "AND");
        return result;
    }

    public static String andAttributeNotEquals(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value) {
        String result = DaoUtils.getQueryForAttributeNotEquals(entityAlias, entityAttributeName, args, value, "AND");
        return result;
    }

    protected static String getQueryForAttributeIn(String entityAlias, String entityAttributeName, Map<String, Object> args, Set<?> values, String operator) {
        String result = "";
        if (values != null) {
            if (values.isEmpty()) {
                result = result + String.format(" %s 1 = 0 ", operator);
            } else {
                String alias = StringUtils.isBlank((CharSequence)entityAlias) ? "" : entityAlias + ".";
                String queryAttributeName = DaoUtils.addQueryAttribute(args, entityAttributeName, values);
                result = result + String.format(" %s %s in ( :%s )", operator, alias + entityAttributeName, queryAttributeName);
            }
        }
        return result;
    }

    public static String andAttributeInIfNotEmpty(String entityAlias, String entityAttributeName, Map<String, Object> args, Set<?> values) {
        if (values != null && !values.isEmpty()) {
            String result = DaoUtils.getQueryForAttributeIn(entityAlias, entityAttributeName, args, values, "AND");
            return result;
        }
        return "";
    }

    public static String andAttributeIn(String entityAlias, String entityAttributeName, Map<String, Object> args, Set<?> values) {
        String result = DaoUtils.getQueryForAttributeIn(entityAlias, entityAttributeName, args, values, "AND");
        return result;
    }

    protected static String getQueryForAttributeNotIn(String entityAlias, String entityAttributeName, Map<String, Object> args, Set<?> values, String operator) {
        String result = "";
        if (values != null) {
            if (values.isEmpty()) {
                result = result + String.format(" %s 1 = 1 ", operator);
            } else {
                String alias = StringUtils.isBlank((CharSequence)entityAlias) ? "" : entityAlias + ".";
                String queryAttributeName = DaoUtils.addQueryAttribute(args, entityAttributeName, values);
                result = result + String.format(" %s %s not in ( :%s )", operator, alias + entityAttributeName, queryAttributeName);
            }
        }
        return result;
    }

    public static String andAttributeNotIn(String entityAlias, String entityAttributeName, Map<String, Object> args, Set<?> values) {
        String result = DaoUtils.getQueryForAttributeNotIn(entityAlias, entityAttributeName, args, values, "AND");
        return result;
    }

    public static Map<String, Object> asArgsMap() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        return result;
    }

    public static Map<String, Object> asArgsMap(String key1, Object value1) {
        Map<String, Object> result = DaoUtils.asArgsMap();
        result.put(key1, value1);
        return result;
    }

    public static Map<String, Object> asArgsMap(String key1, Object value1, String key2, Object value2) {
        Map<String, Object> result = DaoUtils.asArgsMap(key1, value1);
        result.put(key2, value2);
        return result;
    }

    public static Map<String, Object> asArgsMap(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Map<String, Object> result = DaoUtils.asArgsMap(key1, value1, key2, value2);
        result.put(key3, value3);
        return result;
    }

    public static Map<String, Object> asArgsMap(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Map<String, Object> result = DaoUtils.asArgsMap(key1, value1, key2, value2, key3, value3);
        result.put(key4, value4);
        return result;
    }

    public static Object[] toArgsArray(Map<String, Object> args) {
        Object[] result = new Object[args.size() * 2];
        int index = 0;
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            result[index++] = entry.getKey();
            result[index++] = entry.getValue();
        }
        return result;
    }

    public static LinkedHashMap<Integer, String> toRelatedMap(List<Object[]> input) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (input != null) {
            for (Object[] entry : input) {
                Integer campaign = (Integer)entry[0];
                String topiaId = (String)entry[1];
                result.put(campaign, topiaId);
            }
        }
        return result;
    }

    public static Double median(List<Double> list) {
        Double result = null;
        if (list != null && !list.isEmpty()) {
            int middle = list.size() / 2;
            if (list.size() % 2 == 1) {
                result = list.get(middle);
            } else {
                Double valInf = list.get(middle - 1);
                Double valSup = list.get(middle);
                if (valInf != null && valSup != null) {
                    result = (valInf + valSup) / 2.0;
                }
            }
        }
        return result;
    }
}

