/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.security;

import com.google.common.base.MoreObjects;
import fr.inra.agrosyst.api.entities.security.AbstractComputedUserPermissionTopiaDao;
import fr.inra.agrosyst.api.entities.security.ComputedUserPermission;
import fr.inra.agrosyst.api.entities.security.PermissionObjectType;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.Map;

public class ComputedUserPermissionTopiaDao
extends AbstractComputedUserPermissionTopiaDao<ComputedUserPermission> {
    public long getUsersPermissionCount(String userId) {
        String hql = "SELECT COUNT(cup.topiaId) FROM " + this.getEntityClass().getName() + " cup" + " WHERE cup." + "userId" + " = :userId";
        long result = this.count(hql, DaoUtils.asArgsMap("userId", userId));
        return result;
    }

    public long getUsersDirtyCount(String userId) {
        String hql = "SELECT COUNT(cup.topiaId) FROM " + this.getEntityClass().getName() + " cup" + " WHERE cup." + "userId" + " = :userId" + " AND cup." + "dirty" + " = :dirty";
        long result = this.count(hql, DaoUtils.asArgsMap("userId", userId, "dirty", true));
        return result;
    }

    public int getMaxAction(String userId, String object, PermissionObjectType type) {
        String hql = "SELECT MAX(cup.action) FROM " + this.getEntityClass().getName() + " cup" + " WHERE cup." + "userId" + " = :userId" + " AND cup." + "object" + " = :obj";
        Map<String, Object> argsMap = DaoUtils.asArgsMap("userId", userId, "obj", object);
        hql = hql + DaoUtils.andAttributeEquals("cup", "type", argsMap, type);
        Integer result = (Integer)this.findAnyOrNull(hql, argsMap);
        return (Integer)MoreObjects.firstNonNull((Object)result, (Object)0);
    }

    protected ComputedUserPermission newPermission(String userId, PermissionObjectType type, String object, int action) {
        ComputedUserPermission result = (ComputedUserPermission)this.newInstance();
        result.setUserId(userId);
        result.setType(type);
        result.setObject(object);
        result.setAction(action);
        result.setDirty(false);
        return result;
    }

    protected ComputedUserPermission newReadValidatedPermission(String userId, PermissionObjectType type, String object) {
        ComputedUserPermission result = this.newPermission(userId, type, object, 1);
        return result;
    }

    protected ComputedUserPermission newReadPermission(String userId, PermissionObjectType type, String object) {
        ComputedUserPermission result = this.newPermission(userId, type, object, 3);
        return result;
    }

    protected ComputedUserPermission newWritePermission(String userId, PermissionObjectType type, String object) {
        ComputedUserPermission result = this.newPermission(userId, type, object, 7);
        return result;
    }

    protected ComputedUserPermission newAdminPermission(String userId, PermissionObjectType type, String object) {
        ComputedUserPermission result = this.newPermission(userId, type, object, 15);
        return result;
    }

    public ComputedUserPermission newDomainAdminPermission(String userId, String domainCode) {
        ComputedUserPermission result = this.newAdminPermission(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
        return result;
    }

    public ComputedUserPermission newDomainReadPermission(String userId, String domainCode) {
        ComputedUserPermission result = this.newReadPermission(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
        return result;
    }

    public ComputedUserPermission newDomainReadValidatedPermission(String userId, String domainCode) {
        ComputedUserPermission result = this.newReadValidatedPermission(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
        return result;
    }

    public ComputedUserPermission newSpecificDomainReadPermission(String userId, String domainId) {
        ComputedUserPermission result = this.newReadPermission(userId, PermissionObjectType.DOMAIN_ID, domainId);
        return result;
    }

    public ComputedUserPermission newSpecificDomainReadValidatedPermission(String userId, String domainId) {
        ComputedUserPermission result = this.newReadValidatedPermission(userId, PermissionObjectType.DOMAIN_ID, domainId);
        return result;
    }

    public ComputedUserPermission newGrowingPlanAdminPermission(String userId, String growingPlanCode) {
        ComputedUserPermission result = this.newAdminPermission(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlanCode);
        return result;
    }

    public ComputedUserPermission newGrowingPlanReadPermission(String userId, String growingPlanCode) {
        ComputedUserPermission result = this.newReadPermission(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlanCode);
        return result;
    }

    public ComputedUserPermission newGrowingPlanReadValidatedPermission(String userId, String growingPlanCode) {
        ComputedUserPermission result = this.newReadValidatedPermission(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlanCode);
        return result;
    }

    public ComputedUserPermission newSpecificGrowingPlanReadPermission(String userId, String growingPlanId) {
        ComputedUserPermission result = this.newReadPermission(userId, PermissionObjectType.GROWING_PLAN_ID, growingPlanId);
        return result;
    }

    public ComputedUserPermission newSpecificGrowingPlanReadValidatedPermission(String userId, String growingPlanId) {
        ComputedUserPermission result = this.newReadValidatedPermission(userId, PermissionObjectType.GROWING_PLAN_ID, growingPlanId);
        return result;
    }

    public ComputedUserPermission newNetworkAdminPermission(String userId, String networkId) {
        ComputedUserPermission result = this.newAdminPermission(userId, PermissionObjectType.NETWORK_ID, networkId);
        return result;
    }

    public ComputedUserPermission newGrowingSystemReadValidatedPermission(String userId, String growingSystemCode) {
        ComputedUserPermission result = this.newReadValidatedPermission(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystemCode);
        return result;
    }

    public ComputedUserPermission newGrowingSystemReadPermission(String userId, String growingSystemCode) {
        ComputedUserPermission result = this.newReadPermission(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystemCode);
        return result;
    }

    public ComputedUserPermission newGrowingSystemAdminPermission(String userId, String growingSystemCode) {
        ComputedUserPermission result = this.newAdminPermission(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystemCode);
        return result;
    }

    public ComputedUserPermission newSpecificGrowingSystemReadPermission(String userId, String growingSystemId) {
        ComputedUserPermission result = this.newReadPermission(userId, PermissionObjectType.GROWING_SYSTEM_ID, growingSystemId);
        return result;
    }

    public ComputedUserPermission newSpecificGrowingSystemReadValidatedPermission(String userId, String growingSystemId) {
        ComputedUserPermission result = this.newReadValidatedPermission(userId, PermissionObjectType.GROWING_SYSTEM_ID, growingSystemId);
        return result;
    }
}

