/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.security;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.security.AbstractAgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.UserRole;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.PagerBean;

public class AgrosystUserTopiaDao
extends AbstractAgrosystUserTopiaDao<AgrosystUser> {
    public ResultList<AgrosystUser> getFilteredUsers(UserFilter filter) {
        String query = "FROM " + this.getEntityClass().getName() + " u ";
        query = query + " WHERE 1 = 1";
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            query = query + DaoUtils.andAttributeLike("u", "firstName", args, filter.getFirstName());
            query = query + DaoUtils.andAttributeLike("u", "lastName", args, filter.getLastName());
            query = query + DaoUtils.andAttributeLike("u", "email", args, filter.getEmail());
            query = query + DaoUtils.andAttributeLike("u", "organisation", args, filter.getOrganisation());
            if (filter.getRoleType() != null) {
                String subQuery = " SELECT DISTINCT ur.agrosystUser FROM " + UserRole.class.getName() + " ur ";
                subQuery = subQuery + " WHERE 1=1 ";
                subQuery = subQuery + DaoUtils.andAttributeEquals("ur", "type", args, filter.getRoleType());
                query = query + " AND u IN ( " + subQuery + " ) ";
            }
            query = query + DaoUtils.andAttributeEquals("u", "active", args, filter.getActive());
        }
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List users = this.find(query + " ORDER BY lower (u." + "lastName" + "), u." + "firstName", args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + query, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)users, (PagerBean)pager);
        return result;
    }

    public List<AgrosystUser> getNameFilteredActiveUsers(String name, Integer size) {
        String query = "FROM " + this.getEntityClass().getName() + " U";
        query = query + " WHERE 1 = 0";
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (!StringUtils.isBlank((CharSequence)name)) {
            query = query + DaoUtils.orAttributeLike("U", "firstName", args, name);
            query = query + DaoUtils.orAttributeLike("U", "lastName", args, name);
            query = query + DaoUtils.andAttributeEquals("U", "active", args, true);
        }
        int nbResult = size != null ? size : 10;
        List users = this.find(query + " ORDER BY lower (U." + "lastName" + "), U." + "firstName", args, 0, nbResult);
        return users;
    }
}

