/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.referential;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.referential.AbstractRefVarietePlantGrapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RefVarietePlantGrapeTopiaDao
extends AbstractRefVarietePlantGrapeTopiaDao<RefVarietePlantGrape> {
    public List<RefVarietePlantGrape> findAllVarietes(Set<String> varietesPlantGrapeIds, String filter, int maxResults) {
        ArrayList result = Lists.newArrayList();
        if (varietesPlantGrapeIds != null && !varietesPlantGrapeIds.isEmpty()) {
            String query = "FROM " + RefVarietePlantGrape.class.getName() + " vpg ";
            query = query + " WHERE 1 = 1 ";
            LinkedHashMap args = Maps.newLinkedHashMap();
            query = query + DaoUtils.andAttributeLike("vpg", "variete", args, filter);
            query = query + DaoUtils.andAttributeEquals("vpg", "active", args, true);
            List entities = this.find(query = query + " ORDER BY vpg.variete", args, 0, maxResults - 1);
            if (entities != null) {
                result.addAll(entities);
            }
        }
        return result;
    }

    public List<RefVarietePlantGrape> findGraftSupport(String filter, String utilisation, int maxResults) {
        String query = "FROM " + RefVarietePlantGrape.class.getName() + " vpg ";
        query = query + " WHERE 1 = 1 ";
        LinkedHashMap args = Maps.newLinkedHashMap();
        query = query + DaoUtils.andAttributeEquals("vpg", "utilisation", args, utilisation);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            query = query + DaoUtils.andAttributeLike("vpg", "variete", args, filter);
        }
        query = query + DaoUtils.andAttributeEquals("vpg", "active", args, true);
        query = query + " ORDER BY vpg.variete";
        List result = this.find(query, args, 0, maxResults - 1);
        return result;
    }
}

