/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.referential;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.referential.AbstractRefVarieteGevesTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class RefVarieteGevesTopiaDao
extends AbstractRefVarieteGevesTopiaDao<RefVarieteGeves> {
    public List<RefVarieteGeves> findAllActiveVarietes(Set<Integer> varietesGevesIds, String filter, int maxResults) {
        ArrayList result = Lists.newArrayList();
        if (varietesGevesIds != null && !varietesGevesIds.isEmpty()) {
            String query = "FROM " + RefVarieteGeves.class.getName() + " vg";
            query = query + " WHERE vg.active = true";
            LinkedHashMap args = Maps.newLinkedHashMap();
            query = query + DaoUtils.andAttributeIn("vg", "num_Espece_Botanique", args, varietesGevesIds);
            query = query + DaoUtils.andAttributeLike("vg", "denomination", args, filter);
            List entities = this.find(query = query + " ORDER BY vg.denomination", args, 0, maxResults - 1);
            if (entities != null) {
                result.addAll(entities);
            }
        }
        return result;
    }

    public List<RefVarieteGeves> findActiveGraftSupport(String filter, int codeSection, int maxResults) {
        String query = "FROM " + RefVarieteGeves.class.getName() + " vg";
        query = query + " WHERE vg.active = true";
        LinkedHashMap args = Maps.newLinkedHashMap();
        query = query + DaoUtils.andAttributeEquals("vg", "code_Section", args, codeSection);
        query = query + DaoUtils.andAttributeLike("vg", "denomination", args, filter);
        query = query + " ORDER BY vg.denomination";
        List result = this.find(query, args, 0, maxResults - 1);
        return result;
    }
}

