/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.referential;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.referential.AbstractRefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaException;

public class RefLocationTopiaDao
extends AbstractRefLocationTopiaDao<RefLocation> {
    public static final Function<String, String> NORMALIZE_COMMUNE_FOR_SEARCH = new Function<String, String>(){

        public String apply(String input) {
            String result = null;
            if (input != null) {
                result = input.toLowerCase().trim();
                Iterable parts = Splitter.onPattern((String)"[\\s-_,.]").trimResults().omitEmptyStrings().split((CharSequence)result);
                result = Joiner.on((String)"-").join(parts);
                if (result.startsWith("la-") || result.startsWith("le-") || result.startsWith("les-") || result.startsWith("los-")) {
                    result = result.replaceFirst("-", " ");
                }
                result = result.replaceAll("-d-", "-d'");
            }
            return result;
        }
    };

    public List<RefLocation> findActiveLocations(String filter, int maxResults) throws TopiaException {
        String escapedFilter;
        String query = "FROM " + this.getEntityClass().getName() + " rl";
        query = query + " WHERE 1 = 1";
        HashMap args = Maps.newHashMap();
        if (filter != null && StringUtils.isNotBlank((CharSequence)(escapedFilter = (String)NORMALIZE_COMMUNE_FOR_SEARCH.apply((Object)filter)))) {
            query = query + DaoUtils.andAttributeStartLike("rl", "codePostal", args, escapedFilter);
            query = query + DaoUtils.orAttributeLike("rl", "commune", args, escapedFilter);
        }
        query = query + DaoUtils.andAttributeEquals("rl", "active", args, true);
        query = query + " ORDER BY rl.commune";
        List result = this.find(query, args, 0, maxResults);
        return result;
    }
}

