/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.referential;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.referential.AbstractRefFertiMinUNIFATopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.services.referential.MineralProductType;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RefFertiMinUNIFATopiaDao
extends AbstractRefFertiMinUNIFATopiaDao<RefFertiMinUNIFA> {
    public static final StringBuilder ORDER_BY_BUILDER = new StringBuilder();
    public static final String FERTI_ORDER_BY;

    public List<MineralProductType> findAllActiveFertiMinProductType() {
        ArrayList result = Lists.newArrayList();
        String hql = "SELECT ferti.categ, ferti.type_produit, ferti.forme FROM " + this.getEntityClass().getName() + " ferti " + " WHERE ferti." + "active" + " = true" + " GROUP BY ferti." + "categ" + ", ferti." + "type_produit" + ", ferti." + "forme" + " ORDER BY ferti." + "type_produit" + ", ferti." + "forme";
        HashMap args = Maps.newHashMap();
        List mineralProducts = this.findAll(hql, args);
        HashMap typesIndex = Maps.newHashMap();
        for (Object[] tuple : mineralProducts) {
            Integer key = (Integer)tuple[0];
            String value = (String)tuple[1];
            String shape = (String)tuple[2];
            MineralProductType type = (MineralProductType)typesIndex.get(key);
            if (type == null) {
                type = new MineralProductType(key, value, shape);
                result.add(type);
                typesIndex.put(key, type);
                continue;
            }
            type.getShapes().add(shape);
        }
        return result;
    }

    public List<String> findAllActiveFertiMinShape(Integer categ) {
        HashMap args = Maps.newHashMap();
        String hql = "SELECT f.forme FROM " + this.getEntityClass().getName() + " f" + " WHERE 1=1 ";
        hql = hql + DaoUtils.andAttributeEquals("f", "categ", args, categ);
        hql = hql + DaoUtils.andAttributeEquals("f", "active", args, true);
        hql = hql + " GROUP BY f.forme";
        List result = this.findAll(hql, args);
        return result;
    }

    public List<RefFertiMinUNIFA> findAllActiveRefFertiMinUnifaByCategAndShape(Integer categ, String fertilizerShape, String productId) {
        HashMap args = Maps.newHashMap();
        String query = "FROM " + RefFertiMinUNIFA.class.getName() + " f";
        query = query + " WHERE 1=1 ";
        query = query + DaoUtils.andAttributeEquals("f", "categ", args, categ);
        query = query + DaoUtils.andAttributeEquals("f", "forme", args, fertilizerShape);
        if (Strings.isNullOrEmpty((String)productId)) {
            query = query + DaoUtils.andAttributeEquals("f", "active", args, true);
        } else {
            args.put("productId", productId);
            query = query + " AND ( f.topiaId LIKE :productId ";
            query = query + "       OR f.active = true )";
        }
        List result = this.findAll(query + FERTI_ORDER_BY, args);
        return result;
    }

    static {
        ArrayList properties = Lists.newArrayList((Object[])new String[]{"n", "p2O5", "k2O", "bore", "fer", "calcium", "manganese", "molybdene", "mgO", "oxyde_de_sodium", "sO3", "cuivre", "zinc"});
        for (String prop : properties) {
            if (ORDER_BY_BUILDER.length() == 0) {
                ORDER_BY_BUILDER.append(" ORDER BY ");
            } else {
                ORDER_BY_BUILDER.append(", ");
            }
            ORDER_BY_BUILDER.append("f.");
            ORDER_BY_BUILDER.append(prop);
            ORDER_BY_BUILDER.append(" ASC ");
        }
        FERTI_ORDER_BY = ORDER_BY_BUILDER.toString();
    }
}

