/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.referential;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referential.AbstractRefActaTraitementsProduitTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCateg;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RefActaTraitementsProduitTopiaDao
extends AbstractRefActaTraitementsProduitTopiaDao<RefActaTraitementsProduit> {
    public Map<String, String> findAllTreatementCodesAndNames() {
        LinkedHashMap treatementCodesAndNames = Maps.newLinkedHashMap();
        String hql = "SELECT DISTINCT atp.code_traitement, atp.nom_traitement FROM " + this.getEntityClass().getName() + " atp" + " where atp." + "active" + " = true" + " GROUP BY atp." + "code_traitement" + "," + " atp." + "nom_traitement" + " ORDER BY atp." + "nom_traitement";
        HashMap map = Maps.newHashMap();
        List allByQuery = this.findAll(hql, map);
        for (Object[] treatment : allByQuery) {
            String key = (String)treatment[0];
            String value = (String)treatment[1];
            treatementCodesAndNames.put(key, value);
        }
        return treatementCodesAndNames;
    }

    public List<RefActaTraitementsProduit> findAllActiveTreatmentTypesForProductType(AgrosystInterventionType agrosystInterventionType, String productType) {
        Map<String, Object> args = DaoUtils.asArgsMap("productType", productType, "acta_tpc_active", true, "acta_tp_active", true, "agrosystInterventionType", agrosystInterventionType);
        String query = " FROM " + this.getEntityClass().getName() + " acta_tp " + " WHERE acta_tp." + "id_traitement" + " IN (" + "   SELECT acta_tpc." + "id_traitement" + " FROM " + RefActaTraitementsProduitsCateg.class.getName() + " acta_tpc " + "   WHERE acta_tpc." + "type_produit" + " = :productType " + "   AND acta_tpc." + "active" + " = :acta_tpc_active" + "   AND acta_tpc." + "action" + " = :agrosystInterventionType)" + " AND acta_tp." + "active" + " = :acta_tp_active " + " ORDER BY acta_tp." + "nom_produit";
        List result = this.findAll(query, args);
        return result;
    }
}

