/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.practiced;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.practiced.AbstractPracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import fr.inra.agrosyst.services.security.SecurityHelper;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.util.PagerBean;

public class PracticedSystemTopiaDao
extends AbstractPracticedSystemTopiaDao<PracticedSystem> {
    protected static final String PROPERTY_GROWING_SYSTEM_ID = "growingSystem.topiaId";
    protected static final String PROPERTY_GROWING_SYSTEM_NAME = "growingSystem.name";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN = "growingSystem.growingPlan";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_ID = "growingSystem.growingPlan.topiaId";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_NAME = "growingSystem.growingPlan.name";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN = "growingSystem.growingPlan.domain";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_ID = "growingSystem.growingPlan.domain.topiaId";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_NAME = "growingSystem.growingPlan.domain.name";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_CAMPAIGN = "growingSystem.growingPlan.domain.campaign";

    public ResultList<PracticedSystem> getFilteredPracticedSystems(PracticedSystemFilter filter, SecurityContext securityContext) {
        StringBuilder query = new StringBuilder(" FROM " + this.getEntityClass().getName() + " ps ");
        query.append(" WHERE 1 = 1");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            query.append(DaoUtils.andAttributeLike("ps", "name", args, filter.getPracticedSystemName()));
            query.append(DaoUtils.andAttributeLike("ps", PROPERTY_GROWING_SYSTEM_NAME, args, filter.getGrowingSystemName()));
            query.append(DaoUtils.andAttributeLike("ps", "campaigns", args, filter.getPracticedSystemCampaign()));
            query.append(DaoUtils.andAttributeEquals("ps", "active", args, filter.getActive()));
            query.append(DaoUtils.andAttributeEquals("ps", "validated", args, filter.getValidated()));
            query.append(DaoUtils.andAttributeLike("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_NAME, args, filter.getDomainName()));
            query.append(DaoUtils.andAttributeLike("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_NAME, args, filter.getGrowingPlanName()));
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {
                query.append(DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns()));
                if (navigationContext.getNetworksCount() > 0) {
                    Set<String> growingSystemIds = this.getProjectionHelper().networksToGrowingSystems(navigationContext.getNetworks());
                    query.append(DaoUtils.andAttributeIn("ps", PROPERTY_GROWING_SYSTEM_ID, args, growingSystemIds));
                }
                query.append(DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_ID, args, navigationContext.getDomains()));
                query.append(DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_ID, args, navigationContext.getGrowingPlans()));
                query.append(DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_ID, args, navigationContext.getGrowingSystems()));
            }
        }
        SecurityHelper.addPracticedSystemFilter(query, args, securityContext, "ps");
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List practicedSystems = this.find(query.toString() + " ORDER BY lower (ps." + "name" + ")", args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + query, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)practicedSystems, (PagerBean)pager);
        return result;
    }

    public List<PracticedSystem> getPracticedSystemsWithoutPlot(NavigationContext navigationContext, SecurityContext securityContext) {
        StringBuilder query = new StringBuilder(" FROM " + this.getEntityClass().getName() + " ps ");
        query.append(" WHERE ps not in (SELECT pp.practicedSystem FROM " + PracticedPlot.class.getName() + " pp) ");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (navigationContext != null) {
            query.append(DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns()));
            if (navigationContext.getNetworksCount() > 0) {
                Set<String> growingSystemIds = this.getProjectionHelper().networksToGrowingSystems(navigationContext.getNetworks());
                query.append(DaoUtils.andAttributeIn("ps", PROPERTY_GROWING_SYSTEM_ID, args, growingSystemIds));
            }
            query.append(DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_ID, args, navigationContext.getDomains()));
            query.append(DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_ID, args, navigationContext.getGrowingPlans()));
            query.append(DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_ID, args, navigationContext.getGrowingSystems()));
        }
        SecurityHelper.addPracticedSystemFilter(query, args, securityContext, "ps");
        List practicedSystems = this.findAll(query + " ORDER BY lower (ps." + "name" + ")", args);
        return practicedSystems;
    }

    public List<PracticedSystem> getPracticedSystemsWithoutCropCycle(NavigationContext navigationContext) {
        String query = "FROM " + this.getEntityClass().getName() + " ps";
        query = query + " WHERE ps.topiaId NOT IN (SELECT pcc.practicedSystem.topiaId FROM " + PracticedCropCycle.class.getName() + " pcc" + ") ";
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (navigationContext != null) {
            query = query + DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns());
            if (navigationContext.getNetworksCount() > 0) {
                Set<String> growingSystemIds = this.getProjectionHelper().networksToGrowingSystems(navigationContext.getNetworks());
                query = query + DaoUtils.andAttributeIn("ps", PROPERTY_GROWING_SYSTEM_ID, args, growingSystemIds);
            }
            query = query + DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_ID, args, navigationContext.getDomains());
            query = query + DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_ID, args, navigationContext.getGrowingPlans());
            query = query + DaoUtils.andAttributeInIfNotEmpty("ps", PROPERTY_GROWING_SYSTEM_ID, args, navigationContext.getGrowingSystems());
        }
        List result = this.findAll(query, args);
        return result;
    }

    public void validatePracticedSystem(String practicedSystemId, Date now) {
        Map<String, Object> args = DaoUtils.asArgsMap("practicedSystemId", practicedSystemId, "now", now);
        this.topiaJpaSupport.execute("UPDATE " + this.getEntityClass().getName() + " ps" + " SET ps.validated=true, ps.validationDate=:now, ps.updateDate=:now" + " WHERE ps." + "topiaId" + "=:practicedSystemId", args);
    }
}

