/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.api.entities.practiced;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.practiced.AbstractPracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import fr.inra.agrosyst.services.security.SecurityHelper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.nuiton.util.PagerBean;

public class PracticedPlotTopiaDao
extends AbstractPracticedPlotTopiaDao<PracticedPlot> {
    protected static final String PROPERTY_PRACTICED_SYSTEM_NAME = "practicedSystem.name";
    protected static final String PROPERTY_PRACTICED_SYSTEM_CAMPAIGNS = "practicedSystem.campaigns";
    protected static final String PROPERTY_GROWING_SYSTEM = "practicedSystem.growingSystem";
    protected static final String PROPERTY_GROWING_SYSTEM_ID = "practicedSystem.growingSystem.topiaId";
    protected static final String PROPERTY_GROWING_SYSTEM_NAME = "practicedSystem.growingSystem.name";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN = "practicedSystem.growingSystem.growingPlan";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_ID = "practicedSystem.growingSystem.growingPlan.topiaId";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_NAME = "practicedSystem.growingSystem.growingPlan.name";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN = "practicedSystem.growingSystem.growingPlan.domain";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_ID = "practicedSystem.growingSystem.growingPlan.domain.topiaId";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_NAME = "practicedSystem.growingSystem.growingPlan.domain.name";
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_CAMPAIGN = "practicedSystem.growingSystem.growingPlan.domain.campaign";

    public ResultList<PracticedPlot> getFilteredPracticedPlots(PracticedPlotFilter filter, SecurityContext securityContext) {
        StringBuilder query = new StringBuilder(" FROM " + this.getEntityClass().getName() + " pp ");
        query.append(" WHERE 1 = 1 ");
        LinkedHashMap args = Maps.newLinkedHashMap();
        if (filter != null) {
            query.append(DaoUtils.andAttributeLike("pp", "name", args, filter.getPracticedPlotName()));
            query.append(DaoUtils.andAttributeLike("pp", PROPERTY_PRACTICED_SYSTEM_NAME, args, filter.getPracticedSystemName()));
            query.append(DaoUtils.andAttributeLike("pp", PROPERTY_GROWING_SYSTEM_NAME, args, filter.getGrowingSystemName()));
            query.append(DaoUtils.andAttributeLike("pp", "campaigns", args, filter.getPracticedSystemCampaign()));
            query.append(DaoUtils.andAttributeLike("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_NAME, args, filter.getDomainName()));
            query.append(DaoUtils.andAttributeLike("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_NAME, args, filter.getGrowingPlanName()));
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {
                query.append(DaoUtils.andAttributeInIfNotEmpty("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns()));
                if (navigationContext.getNetworksCount() > 0) {
                    Set<String> growingSystemIds = this.getProjectionHelper().networksToGrowingSystems(navigationContext.getNetworks());
                    query.append(DaoUtils.andAttributeIn("pp", PROPERTY_GROWING_SYSTEM_ID, args, growingSystemIds));
                }
                query.append(DaoUtils.andAttributeInIfNotEmpty("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_ID, args, navigationContext.getDomains()));
                query.append(DaoUtils.andAttributeInIfNotEmpty("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_ID, args, navigationContext.getGrowingPlans()));
                query.append(DaoUtils.andAttributeInIfNotEmpty("pp", PROPERTY_GROWING_SYSTEM_ID, args, navigationContext.getGrowingSystems()));
            }
        }
        SecurityHelper.addPracticedPlotFilter(query, args, securityContext, "pp");
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List practicedPlots = this.find(query + " ORDER BY lower (pp." + "name" + ")", args, startIndex, endIndex);
        long totalCount = (Long)this.findUnique("SELECT count(*) " + query, args);
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList result = ResultList.of((List)practicedPlots, (PagerBean)pager);
        return result;
    }

    public PracticedPlot getPlotForPracticedCropCyclePhase(PracticedCropCyclePhase phase) {
        String query = "FROM " + this.getEntityClass().getName() + " pp" + " WHERE pp." + "practicedSystem" + " in (" + " SELECT ppcc." + "practicedSystem" + " FROM " + PracticedPerennialCropCycle.class.getName() + " ppcc" + "  WHERE :phase in elements(ppcc." + "cropCyclePhases" + "))";
        PracticedPlot result = (PracticedPlot)this.findUniqueOrNull(query, DaoUtils.asArgsMap("phase", phase));
        return result;
    }
}

